/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.custom;

import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.string.StringUtil;
import java.io.File;
import org.w3c.dom.Node;

public class CustomLink {
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_DEPTH = "depth";
    private static final String ATTR_EXPANDED = "expanded";
    private static final String ATTR_ROLLOVER = "rollover";
    private static final String ATTR_URI = "uri";
    private static final String ATTR_ICON = "icon";
    private Node mNode;
    private String mTitle;
    private String mDepth;
    private String mExpanded;
    private String mRollover;
    private String mUri;
    private String mIcon;

    public CustomLink(Node node) {
        this.mNode = node;
        this.mTitle = node.getAttributes().getNamedItem(ATTR_TITLE).getNodeValue();
        this.mDepth = node.getAttributes().getNamedItem(ATTR_DEPTH).getNodeValue();
        Node expanded = node.getAttributes().getNamedItem(ATTR_EXPANDED);
        this.mExpanded = expanded == null ? "false" : expanded.getNodeValue();
        Node rollover = node.getAttributes().getNamedItem(ATTR_ROLLOVER);
        this.mRollover = rollover == null ? "" : rollover.getNodeValue();
        this.mUri = node.getAttributes().getNamedItem(ATTR_URI).getNodeValue();
        Node icon = node.getAttributes().getNamedItem(ATTR_ICON);
        this.mIcon = icon == null ? "" : icon.getNodeValue();
    }

    public CustomLink(Plugin p) {
        this.mNode = null;
        this.mTitle = Util.escapeHTML(p.getMenuItem());
        this.mDepth = "1";
        this.mExpanded = "false";
        this.mRollover = Util.escapeHTML(p.getMenuItem());
        if (p.getToolTip() != null) {
            this.mRollover = Util.escapeHTML(p.getToolTip());
        }
        this.mUri = UriUtil.customPageURI(p.getID() + File.separator + p.getVersionNumber().getAsString() + File.separator + "shortcuts.html", Util.encodeURL(p.getMenuItem()));
        this.mIcon = "images/" + p.getID().toString() + "/" + p.getVersionNumber().getAsString() + "/" + "icon.gif";
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getDepth() {
        return this.mDepth;
    }

    public String getExpanded() {
        return this.mExpanded;
    }

    public String getRollover() {
        return this.mRollover;
    }

    public String getUri() {
        return this.mUri;
    }

    public String getIcon() {
        return this.mIcon;
    }

    public int getDepthAsInt() {
        int depth = 0;
        try {
            depth = Integer.parseInt(this.mDepth);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return depth;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Title: " + this.mTitle);
        buffer.append(" Depth: " + this.mDepth);
        buffer.append(" Expanded: " + this.mExpanded);
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("Rollover: " + this.mRollover);
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("Uri: " + this.mUri);
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append("Icon: " + this.mIcon);
        buffer.append(StringUtil.LINE_SEPARATOR);
        return buffer.toString();
    }
}

