/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx.types;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.hierarchies.compexport.ComponentExportServices;
import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.persist.query.MultiObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.VersionRange;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefOrder;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentTypeRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemService;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.util.regex.GlobPattern;
import com.sun.n1.sps.plugin.browse.BrowserInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;

public class ComponentTypesListBean
extends ServletListBean {
    public static final ComponentExportServices sComponentExportServices = ComponentExportServices.INSTANCE;
    public static final String UNTYPED_COMPONENT_TYPE_NAME = "untyped";
    public static final String ANY_COMPONENT_TYPE = ApplicationResources.getMessage("componentTypes.any.name");
    public static final String DEFAULT_COMPONENT_TYPE = "system#container";
    public static final String FILE_COMPONENT_TYPE = "system#file";
    public static final String DIRECTORY_COMPONENT_TYPE = "system#directory";
    public static final String SYSTEM_SERVICE_COMPONENT_TYPE = SystemService.TYPE_NAME;
    private static final ComponentTypeRefOrder DEFAULT_SORT_ORDER = ComponentTypeRefOrder.BY_NAME_ASC;
    public static final String[] HIDDEN_GROUPS = new String[]{"hidden"};
    private static final String FILTER_ONLY_LABEL = " *";
    private String[] mComponentTypeIDs = new String[0];
    private String[] mComponentTypeNames = new String[0];
    private String[] mComponentTypeGroupNames = new String[0];
    private String[] mComponentTypeOrderNames = new String[0];
    private String[] mComponentTypeIndentLevels = new String[0];
    private String[] mComponentTypeDescriptions = new String[0];
    private String[] mComponentIDs = new String[0];
    private String[] mComponentNames = new String[0];
    private String[] mComponentVersions = new String[0];
    private String[] mComponentTypeLabels = new String[0];
    private String[] mComponentTypeFamilies = new String[0];
    private boolean mIncludeUntyped = true;
    private String mFindComponentRef = "";
    private String mFindGroup = "";
    private String mFindOrder = "";
    private String mFindVersionNumber = "";
    private boolean mWriteOnComponentType = true;
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);

    public String[] getComponentTypeNames() {
        return this.mComponentTypeNames;
    }

    public String[] getComponentTypeIDs() {
        return this.mComponentTypeIDs;
    }

    public String[] getComponentTypeGroupNames() {
        return this.mComponentTypeGroupNames;
    }

    public String[] getComponentTypeOrderNames() {
        return this.mComponentTypeOrderNames;
    }

    public String[] getComponentTypeIndentLevels() {
        return this.mComponentTypeIndentLevels;
    }

    public String[] getComponentTypeDescriptions() {
        return this.mComponentTypeDescriptions;
    }

    public String[] getComponentIDs() {
        return this.mComponentIDs;
    }

    public String[] getComponentNames() {
        return this.mComponentNames;
    }

    public String[] getComponentVersions() {
        return this.mComponentVersions;
    }

    public String[] getComponentTypeLabels() {
        return this.mComponentTypeLabels;
    }

    public String[] getComponentTypeFamilies() {
        return this.mComponentTypeFamilies;
    }

    public String getFindComponentRef() {
        return this.mFindComponentRef;
    }

    public String getFindGroup() {
        return this.mFindGroup;
    }

    public String getFindOrder() {
        return this.mFindOrder;
    }

    public String getFindVersionNumber() {
        return this.mFindVersionNumber;
    }

    public void setFindComponentRef(String inFindComponentRef) {
        this.mFindComponentRef = inFindComponentRef;
    }

    public void setFindGroup(String inFindGroup) {
        this.mFindGroup = inFindGroup;
    }

    public void setFindOrder(String inFindOrder) {
        this.mFindOrder = inFindOrder;
    }

    public void setFindVersionNumber(String inFindVersionNumber) {
        this.mFindVersionNumber = inFindVersionNumber;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public boolean getWriteOnComponentType() {
        return this.mWriteOnComponentType;
    }

    public void generateList() throws RaplixException {
        MultiComponentTypeRefQuery query = MultiComponentTypeRefQuery.all();
        this.prepQuery(query, this.getSortOrderByName(this.getSortName()));
        this.generateOutputArrays(query.select());
    }

    private void generateOutputArrays(ComponentTypeRef[] types) throws RaplixException {
        int numTypes = types.length;
        this.mComponentTypeIDs = new String[numTypes];
        this.mComponentTypeNames = new String[numTypes];
        this.mComponentTypeGroupNames = new String[numTypes];
        this.mComponentTypeOrderNames = new String[numTypes];
        this.mComponentTypeIndentLevels = new String[numTypes];
        this.mComponentTypeDescriptions = new String[numTypes];
        this.mComponentIDs = new String[numTypes];
        this.mComponentNames = new String[numTypes];
        this.mComponentVersions = new String[numTypes];
        for (int i = 0; i < numTypes; ++i) {
            ComponentTypeRef componentType = types[i];
            this.mComponentTypeIDs[i] = componentType.getID().toString();
            this.mComponentTypeNames[i] = componentType.getName();
            this.mComponentTypeGroupNames[i] = componentType.getGroup();
            this.mComponentTypeOrderNames[i] = componentType.getOrder();
            this.mComponentTypeIndentLevels[i] = Integer.toString(componentType.getIndentLevel());
            this.mComponentTypeDescriptions[i] = componentType.getDescription();
            SummaryComponent sc = SingleComponentQuery.byRef(componentType.getComponentRef()).selectSummaryView();
            this.mComponentIDs[i] = sc.getID().toString();
            this.mComponentNames[i] = sc.getFullName();
            this.mComponentVersions[i] = sc.getVersionNumber().getAsString();
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mComponentTypeIDs);
        this.mWriteOnComponentType = PermissionChecker.hasWriteOnComponentType();
    }

    public void loadComponentTypes() throws RaplixException {
        MultiComponentTypeRefQuery mctrq = MultiComponentTypeRefQuery.all();
        mctrq.setNotInGroupsFilter(HIDDEN_GROUPS);
        mctrq.setObjectOrder(ComponentTypeRefOrder.BY_PLUGIN_ORDER_ASC);
        ComponentTypeRef[] types = mctrq.select();
        this.loadComponentTypesHelper(types, false);
    }

    public void loadComponentTypesWithGroups() throws RaplixException {
        MultiComponentTypeRefQuery mctrq = MultiComponentTypeRefQuery.all();
        mctrq.setNotInGroupsFilter(HIDDEN_GROUPS);
        mctrq.setObjectOrder(ComponentTypeRefOrder.BY_PLUGIN_ORDER_ASC);
        ComponentTypeRef[] types = mctrq.select();
        this.loadComponentTypesHelper(types, true);
    }

    public void loadComponentTypes(HostSetID platformID) throws RaplixException {
        MultiComponentTypeRefQuery mctrq = MultiComponentTypeRefQuery.byPlatform(platformID);
        mctrq.setNotInGroupsFilter(HIDDEN_GROUPS);
        mctrq.setObjectOrder(ComponentTypeRefOrder.BY_PLUGIN_ORDER_ASC);
        ComponentTypeRef[] types = mctrq.select();
        this.loadComponentTypesHelper(types, false);
    }

    public void loadDirectlyBrowseableComponentTypes(boolean filterNonBrowseables) throws RaplixException {
        MultiComponentTypeRefQuery mctrq = MultiComponentTypeRefQuery.all();
        mctrq.setNotInGroupsFilter(HIDDEN_GROUPS);
        mctrq.setObjectOrder(ComponentTypeRefOrder.BY_PLUGIN_ORDER_ASC);
        ComponentTypeRef[] types = mctrq.select();
        ArrayList<ComponentTypeRef> typeList = new ArrayList<ComponentTypeRef>(Arrays.asList(types));
        if (filterNonBrowseables) {
            for (int i = 0; i < types.length; ++i) {
                String typeName = types[i].getName();
                if (ComponentTypesListBean.isDirectlyBrowsableComponentType(typeName)) continue;
                typeList.remove(types[i]);
            }
            this.mIncludeUntyped = false;
        }
        types = typeList.toArray(new ComponentTypeRef[0]);
        this.loadComponentTypesHelper(types, false);
    }

    private void loadComponentTypesHelper(ComponentTypeRef[] types, boolean withGroups) {
        int numTypes = types.length;
        this.mComponentTypeNames = new String[numTypes];
        PluginID lastSeenPlugin = null;
        HashSet<String> hs = new HashSet<String>();
        String group = null;
        Vector<String> typeNames = new Vector<String>();
        Vector<String> typeLabels = new Vector<String>();
        Vector<String> typeFamilies = new Vector<String>();
        for (int i = 0; i < numTypes; ++i) {
            ComponentTypeRef type = types[i];
            if (type.getPluginID() != null && !type.getPluginID().equals(lastSeenPlugin) || type.getPluginID() == null && lastSeenPlugin != null) {
                lastSeenPlugin = type.getPluginID();
                hs.clear();
            }
            if (!hs.contains(group = type.getGroup())) {
                typeNames.add("");
                typeLabels.add("");
                typeFamilies.add("1");
                if (withGroups && !"".equals(type.getGroup().trim())) {
                    typeNames.add(type.getGroup());
                    typeLabels.add(type.getGroup());
                    typeFamilies.add("2");
                }
                hs.add(group);
            }
            typeNames.add(type.getName());
            typeLabels.add(this.returnLabel(type));
            typeFamilies.add("3");
        }
        if (this.mIncludeUntyped) {
            typeNames.add("");
            typeLabels.add("");
            typeFamilies.add("1");
            typeNames.add(UNTYPED_COMPONENT_TYPE_NAME);
            typeLabels.add(UNTYPED_COMPONENT_TYPE_NAME);
            typeFamilies.add("0");
        }
        this.mComponentTypeNames = new String[typeNames.size()];
        typeNames.toArray(this.mComponentTypeNames);
        this.mComponentTypeLabels = new String[typeLabels.size()];
        typeLabels.toArray(this.mComponentTypeLabels);
        this.mComponentTypeFamilies = new String[typeFamilies.size()];
        typeFamilies.toArray(this.mComponentTypeFamilies);
    }

    private String returnLabel(ComponentTypeRef ctr) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < ctr.getIndentLevel(); ++i) {
            sb.append("&nbsp;&nbsp;");
        }
        String compType = ctr.getName();
        if (ComponentTypesListBean.isBrowsableComponentType(compType) && !ComponentTypesListBean.isDirectlyBrowsableComponentType(compType)) {
            compType = compType + FILTER_ONLY_LABEL;
        }
        sb.append(compType);
        return sb.toString();
    }

    public static String normalizeName(String compTypeName) {
        if (compTypeName == null) {
            return UNTYPED_COMPONENT_TYPE_NAME;
        }
        return compTypeName;
    }

    public static String normalizeName(ComponentType compType) {
        if (compType == null || compType.equals(ComponentType.ROOT)) {
            return UNTYPED_COMPONENT_TYPE_NAME;
        }
        return compType.getTypeName();
    }

    public static boolean isBrowsableComponentType(String componentTypeName) {
        boolean returnVal = false;
        try {
            BrowserInfo[] bia = sComponentExportServices.getAvailableBrowsers(componentTypeName);
            if (bia != null && bia.length > 0) {
                returnVal = true;
            }
        }
        catch (RaplixException raplixException) {
            // empty catch block
        }
        return returnVal;
    }

    private static boolean isDirectlyBrowsableComponentType(String componentTypeName) {
        boolean returnVal = false;
        try {
            BrowserInfo[] bia = sComponentExportServices.getAvailableBrowsers(componentTypeName);
            if (bia != null && bia.length > 0 && bia[0].getComponentType().equals(componentTypeName)) {
                returnVal = true;
            }
        }
        catch (RaplixException raplixException) {
            // empty catch block
        }
        return returnVal;
    }

    public static boolean hasCheckinCurrentCapability(String componentTypeName, SourceInfo si) {
        boolean returnVal = false;
        if (SourceInfo.containsCheckinCurrentData(si) && componentTypeName != null && !componentTypeName.equals(UNTYPED_COMPONENT_TYPE_NAME)) {
            try {
                BrowserInfo[] bia = sComponentExportServices.getAvailableBrowsers(componentTypeName);
                if (bia != null) {
                    returnVal = true;
                }
            }
            catch (RaplixException raplixException) {
                // empty catch block
            }
        }
        return returnVal;
    }

    public static boolean hasCreateNewVersionCapability(String componentTypeName) {
        boolean returnVal;
        block4: {
            returnVal = false;
            if (componentTypeName != null && !componentTypeName.equals(UNTYPED_COMPONENT_TYPE_NAME)) {
                try {
                    BrowserInfo[] bia = sComponentExportServices.getAvailableBrowsers(componentTypeName);
                    if (bia == null) break block4;
                    for (int i = 0; i < bia.length; ++i) {
                        if (!componentTypeName.equals(bia[i].getComponentType())) continue;
                        returnVal = true;
                        break;
                    }
                }
                catch (RaplixException raplixException) {
                    // empty catch block
                }
            }
        }
        return returnVal;
    }

    public ObjectOrder getDefaultSortOrder() {
        return DEFAULT_SORT_ORDER;
    }

    protected ObjectOrder getSortOrderByName(String sortName) {
        return this.getSortOrderByName(ComponentTypeRefOrder.FACTORY, sortName);
    }

    protected void loadAdditionalFindFilters(MultiObjectQuery query) throws RaplixException {
        MultiComponentTypeRefQuery mcq = (MultiComponentTypeRefQuery)query;
        if (!this.getFindName().equals("")) {
            mcq.setNameFilter(GlobPattern.create("*" + this.getFindName() + "*"));
        }
        if (!this.getFindDescription().equals("")) {
            mcq.setDescriptionFilter(GlobPattern.create("*" + this.getFindDescription() + "*"));
        }
        if (!this.mFindGroup.equals("")) {
            mcq.setGroupFilter(GlobPattern.create("*" + this.mFindGroup + "*"));
        }
        if (!this.mFindOrder.equals("")) {
            mcq.setOrderFilter(GlobPattern.create("*" + this.mFindOrder + "*"));
        }
        if (!this.mFindComponentRef.equals("")) {
            mcq.setComponentRefFullNameFilter(GlobPattern.create("*" + this.mFindComponentRef + "*"));
        }
        if (!this.mFindVersionNumber.equals("")) {
            VersionRange range = ServletListBean.constructVersionRangeForFilter(this.mFindVersionNumber);
            mcq.setComponentRefVersionFilter(range);
        }
    }
}

