/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx.types;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypeDetailsBean;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class ComponentTypesHandleAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_CANCEL = "error.componentTypes.cancel";
    public static final String MSG_ERROR_CREATE = "error.componentTypes.create";
    public static final String MSG_ERROR_DETAILS = "error.componentTypes.details";
    public static final String MSG_ERROR_EDIT = "error.componentTypes.edit";
    public static final String MSG_ERROR_PICK = "error.componentTypes.pick";
    public static final String MSG_ERROR_SAVE_MAJOR = "error.componentTypes.save.major";
    public static final String MSG_ERROR_SAVE_BAD_INDENT_LEVEL = "error.componentTypes.save.badIndentLevel";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = ComponentTypesHandleAction.assertGetParam(request, "mode");
        Logger.debug("Coming through ComponentTypesHandleAction: " + mode, this);
        if (mode.equals("add")) {
            this.handleAdd(request, servletInfo);
        } else if (mode.equals("details")) {
            this.handleDetails(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("pick")) {
            this.handlePick(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode passed to ComponentTypesHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        ComponentTypeDetailsBean ctdb = new ComponentTypeDetailsBean();
        return ctdb;
    }

    public String getDefaultPage() {
        return "/compx/types/componentTypeDetails.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = ComponentTypesHandleAction.assertGetParam(inRequest, "mode");
        if (mode.equals("add")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("details")) {
            return MSG_ERROR_DETAILS;
        }
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("pick")) {
            return MSG_ERROR_PICK;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        throw new IllegalArgumentException("Unknown mode passed to ComponentTypesHandleAction.");
    }

    private void handleAdd(HttpServletRequest request, ServletInfo servletInfo) {
        ComponentTypeDetailsBean ctdb = (ComponentTypeDetailsBean)servletInfo.getBean();
        String name = ComponentTypesHandleAction.assertGetParam(request, "name");
        String group = ComponentTypesHandleAction.assertGetParam(request, "group");
        String order = ComponentTypesHandleAction.assertGetParam(request, "order");
        String description = ComponentTypesHandleAction.assertGetParam(request, "description");
        ctdb.createComponentType(name, group, order, description);
        ctdb.setIsNew(true);
        ctdb.setMode("edit");
        servletInfo.setDestPage("/compx/types/componentTypeDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentTypeDetailsBean ctdb = (ComponentTypeDetailsBean)servletInfo.getBean();
        this.saveRequestValues(ctdb, request);
        try {
            ctdb.persist();
        }
        catch (NumberFormatException nfe) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_SAVE_BAD_INDENT_LEVEL);
            ctdb.setMode("edit");
            servletInfo.setDestPage("/compx/types/componentTypeDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (PersistenceManagerException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(re.getMessage());
            ctdb.setMode("edit");
            servletInfo.setDestPage("/compx/types/componentTypeDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/ComponentTypes");
        servletInfo.setShouldRedirect(true);
    }

    private void handleDetails(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentTypeDetailsBean ctdb = (ComponentTypeDetailsBean)servletInfo.getBean();
        String id = ComponentTypesHandleAction.assertGetParam(request, "id");
        ctdb.loadComponentType(id);
        ctdb.setMode("details");
        servletInfo.setDestPage("/compx/types/componentTypeDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentTypeDetailsBean ctdb = (ComponentTypeDetailsBean)servletInfo.getBean();
        String id = ComponentTypesHandleAction.assertGetParam(request, "id");
        ctdb.loadComponentType(id);
        ctdb.setMode("edit");
        servletInfo.setDestPage("/compx/types/componentTypeDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handlePick(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentTypeDetailsBean ctdb = (ComponentTypeDetailsBean)servletInfo.getBean();
        this.saveRequestValues(ctdb, request);
        ctdb.resolveComponent();
        ctdb.setMode("edit");
        servletInfo.setDestPage("/compx/types/componentTypeDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCancel(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.setDestPage("/ComponentTypes");
        servletInfo.setShouldRedirect(true);
    }

    private void saveRequestValues(ComponentTypeDetailsBean ctdb, HttpServletRequest request) {
        String id = ComponentTypesHandleAction.assertGetParam(request, "id");
        String name = ComponentTypesHandleAction.assertGetParam(request, "name");
        String group = ComponentTypesHandleAction.assertGetParam(request, "group");
        String order = ComponentTypesHandleAction.assertGetParam(request, "order");
        String indentLevel = ComponentTypesHandleAction.assertGetParam(request, "indentLevel");
        String desc = ComponentTypesHandleAction.assertGetParam(request, "description");
        String compID = ComponentTypesHandleAction.assertGetParam(request, "componentID");
        String compName = ComponentTypesHandleAction.assertGetParam(request, "componentName");
        String compFolderID = ComponentTypesHandleAction.assertGetParam(request, "componentFolderID");
        String compVersion = ComponentTypesHandleAction.assertGetParam(request, "componentVersion");
        String updateCount = ComponentTypesHandleAction.assertGetParam(request, "updateCount");
        String isNewStr = ComponentTypesHandleAction.assertGetParam(request, "isNew");
        boolean isNew = isNewStr != null && isNewStr.equals("true");
        ctdb.setID(id);
        ctdb.setName(name);
        ctdb.setGroup(group);
        ctdb.setOrder(order);
        ctdb.setIndentLevel(indentLevel);
        ctdb.setDescription(desc);
        ctdb.setComponentID(compID);
        ctdb.setComponentName(compName);
        ctdb.setComponentFolderID(compFolderID);
        ctdb.setComponentVersion(compVersion);
        ctdb.setUpdateCount(Integer.parseInt(updateCount));
        ctdb.setIsNew(isNew);
    }
}

