/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx.types;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.ui.web.LoggedOnServlet;
import com.raplix.rolloutexpress.ui.web.ParameterConstants;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypesListBean;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComponentTypeRouterAction
extends LoggedOnServlet
implements ParameterConstants {
    public void executeServlet(HttpServletRequest request, HttpServletResponse response) throws RaplixException, IOException {
        String type = ComponentTypeRouterAction.assertGetParam(request, "componentType");
        int typeFamily = Integer.parseInt(ComponentTypeRouterAction.assertGetParam(request, "family"));
        String encodedName = Util.encodeURL(ComponentTypeRouterAction.assertGetParam(request, "name"));
        String encodedLabel = Util.encodeURL(ComponentTypeRouterAction.assertGetParam(request, "label"));
        String encodedDescription = Util.encodeURL(ComponentTypeRouterAction.assertGetParam(request, "description"));
        String uri = null;
        switch (typeFamily) {
            case 0: {
                uri = UriUtil.componentAdvancedEditCreateURI(encodedName, Util.encodeURL(type), encodedLabel, encodedDescription);
                break;
            }
            case 1: 
            case 2: {
                type = "system#container";
            }
            case 3: {
                ComponentType ct;
                Component c;
                uri = ComponentTypesListBean.isBrowsableComponentType(type) ? UriUtil.componentBrowseCreateURI(encodedName, Util.encodeURL(type), encodedLabel, encodedDescription) : ((c = (ct = ComponentType.create(type)).getComponent()).isSimpleComponent() ? UriUtil.componentAdvancedEditCreateURI(encodedName, Util.encodeURL(type), encodedLabel, encodedDescription) : UriUtil.componentCompositeCreateURI(encodedName, Util.encodeURL(type), encodedLabel, encodedDescription));
            }
        }
        response.sendRedirect(uri);
    }
}

