/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx.types;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;

public class ComponentTypeDetailsBean
extends ServletBean {
    private String mMode = "";
    private String mID = "";
    private String mName = "";
    private String mGroup = "";
    private String mOrder = "";
    private String mIndentLevel = "0";
    private String mDescription = "";
    private String mPluginName = null;
    private String mPluginID = null;
    private boolean mWriteOnPlugin = true;
    private boolean mWriteOnComponentType = true;
    private String mComponentID = "";
    private String mComponentName = "";
    private String mComponentFolderID = "";
    private String mComponentVersion = "";
    private boolean mIsNew = false;
    private int mUpdateCount = 0;

    public String getID() {
        if (!this.mID.equals("")) {
            return this.mID;
        }
        return super.getID();
    }

    public String getMode() {
        return this.mMode;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public String getName() {
        return this.mName;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public String getOrder() {
        return this.mOrder;
    }

    public String getIndentLevel() {
        return this.mIndentLevel;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getPluginName() {
        return this.mPluginName;
    }

    public String getPluginID() {
        return this.mPluginID;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public boolean getWriteOnComponentType() {
        return this.mWriteOnComponentType;
    }

    public String getComponentID() {
        return this.mComponentID;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public String getComponentFolderID() {
        return this.mComponentFolderID;
    }

    public String getComponentVersion() {
        return this.mComponentVersion;
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    public void setMode(String inValue) {
        this.mMode = inValue;
    }

    public void setIsNew(boolean inValue) {
        this.mIsNew = inValue;
    }

    public void setName(String inValue) {
        this.mName = inValue;
    }

    public void setGroup(String inValue) {
        this.mGroup = inValue;
    }

    public void setOrder(String inValue) {
        this.mOrder = inValue;
    }

    public void setIndentLevel(String inValue) {
        this.mIndentLevel = inValue;
    }

    public void setDescription(String inValue) {
        this.mDescription = inValue;
    }

    public void setComponentID(String inValue) {
        this.mComponentID = inValue;
    }

    public void setComponentName(String inValue) {
        this.mComponentName = inValue;
    }

    public void setComponentFolderID(String inValue) {
        this.mComponentFolderID = inValue;
    }

    public void setComponentVersion(String inValue) {
        this.mComponentVersion = inValue;
    }

    public void setUpdateCount(int inValue) {
        this.mUpdateCount = inValue;
    }

    public void setID(String inValue) {
        this.mID = inValue;
    }

    public void createComponentType(String name, String group, String order, String description) {
        this.mName = name;
        this.mGroup = group;
        this.mOrder = order;
        this.mDescription = description;
        this.mComponentID = "";
        this.mComponentName = "";
        this.mComponentFolderID = "";
        this.mComponentVersion = "";
        this.mIsNew = true;
        this.mID = "";
    }

    public void loadComponentType(String id) throws RaplixException {
        ComponentTypeRef ctr = new ComponentTypeRefID(id).getByIDQuery().select();
        this.mID = id;
        this.mIsNew = false;
        this.mName = ctr.getName();
        this.mGroup = ctr.getGroup();
        this.mOrder = ctr.getOrder();
        this.mIndentLevel = "" + ctr.getIndentLevel();
        this.mDescription = ctr.getDescription();
        PluginID pluginID = ctr.getPluginID();
        if (pluginID != null) {
            this.mPluginID = pluginID.toString();
            this.mPluginName = pluginID.getByIDQuery().selectSummaryView().getName();
        }
        this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin(ctr);
        this.mWriteOnComponentType = PermissionChecker.hasWriteOnComponentType();
        SummaryComponent sc = SingleComponentQuery.byRef(ctr.getComponentRef()).selectSummaryView();
        this.mComponentID = sc.getID().toString();
        this.mComponentName = sc.getFullName();
        this.mComponentFolderID = sc.getPath().toString();
        this.mComponentVersion = sc.getVersionNumber().getAsString();
        this.mUpdateCount = ctr.getUpdateCount();
    }

    public void resolveComponent() throws RaplixException {
        SummaryComponent sc = new ComponentID(this.mComponentID).getByIDQuery().selectSummaryView();
        this.mComponentName = sc.getFullName();
        this.mComponentFolderID = sc.getPath().toString();
        this.mComponentVersion = sc.getVersionNumber().getAsString();
    }

    public void persist() throws RaplixException {
        ComponentTypeRef ctr = this.mIsNew ? new ComponentTypeRef() : new ComponentTypeRefID(this.mID).getByIDQuery().select();
        ctr.setSimpleName(this.mName);
        ctr.setGroup(this.mGroup);
        ctr.setOrder(this.mOrder);
        ctr.setIndentLevel(Integer.parseInt(this.mIndentLevel));
        ctr.setDescription(this.mDescription);
        if (this.mIsNew && this.mComponentName.length() == 0) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("comp ref unset", this);
            }
        } else {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Creating comp ref: folderID: " + this.mComponentFolderID + " name: " + Util.fullNameToShortName(this.mComponentName) + " version: " + this.mComponentVersion, this);
            }
            ComponentRef cr = new ComponentRef(new FolderID(this.mComponentFolderID), Util.fullNameToShortName(this.mComponentName), this.mComponentVersion);
            ctr.setComponentRef(cr);
        }
        ctr.setUpdateCount(this.mUpdateCount);
        ctr.save();
    }
}

