/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx.types;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidateStatus;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.ui.web.DeleteConfirmNode;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;

public class ComponentTypeDeleteNode
extends UITreeNode {
    private static final int DELETE_CONFIRM_COLSPAN = 7;
    private ComponentTypeRefID mComponentTypeRefID = null;
    private String mName = "";
    private String mMenuGroup = "";
    private String mMenuOrder = "";
    private String mIndent = "";
    private String mDescription = "";
    private String mComponentName = "";
    private String mComponentID = "";
    private String mVersion = "";
    private boolean mIsUndeletable = false;
    private int mRowLevel = 0;
    private String mPrologue = "";
    private String mContents = "";

    public ComponentTypeDeleteNode(DeleteSessionCandidate candidate) throws RaplixException {
        this.mType = UITreeNodeType.LEAF;
        DeleteSessionCandidateStatus status = candidate.getStatus();
        this.mIsUndeletable = status.equals(DeleteSessionCandidateStatus.IN_USE) || status.equals(DeleteSessionCandidateStatus.NOT_DELETABLE);
        ComponentTypeRefID componentTypeRefID = (ComponentTypeRefID)candidate.getParent().getObjectID();
        ComponentTypeRef componentTypeRef = componentTypeRefID.getByIDQuery().select();
        this.mComponentTypeRefID = componentTypeRefID;
        this.mName = componentTypeRef.getName();
        this.mMenuGroup = componentTypeRef.getGroup();
        this.mMenuOrder = componentTypeRef.getOrder();
        this.mIndent = Integer.toString(componentTypeRef.getIndentLevel());
        this.mDescription = componentTypeRef.getDescription();
        SummaryComponent sc = SingleComponentQuery.byRef(componentTypeRef.getComponentRef()).selectSummaryView();
        this.mComponentID = sc.getID().toString();
        this.mComponentName = sc.getFullName();
        this.mVersion = sc.getVersionNumber().getAsString();
        this.preRender();
    }

    public void getDescendents(DeleteSessionCandidate candidate) {
        if (this.mIsUndeletable) {
            PersistenceManagerException pme = (PersistenceManagerException)candidate.getException();
            String errMsg = pme.getMessage();
            DeleteConfirmNode confirmNode = new DeleteConfirmNode(errMsg, 2, 7);
            this.addChild(confirmNode);
            if (pme instanceof ObjectInUseException) {
                UsingObject[] blockers = ((ObjectInUseException)pme).getUsingObjects();
                for (int j = 0; j < blockers.length; ++j) {
                    DeleteConfirmNode blockerNode = new DeleteConfirmNode(blockers[j], 2, 7);
                    confirmNode.addChild(blockerNode);
                }
            }
        }
    }

    public void preRender() {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String compTypeDetailsURI = UriUtil.componentTypeDetailsURI(this.mComponentTypeRefID.toString());
        String compDetailsURI = UriUtil.componentDetailsURI(this.mComponentID);
        String versionURI = UriUtil.componentVersionHistoryURI(this.mComponentID);
        String toolTip = "Show component type details";
        String nameLink = Util.standardLink(compTypeDetailsURI, toolTip, this.mName, "name=\"nameLink-" + this.mComponentTypeRefID + "\"");
        String descLink = Util.standardLink(compTypeDetailsURI, toolTip, Util.escapeHTML(this.mDescription));
        String componentnameLink = Util.standardLink(compDetailsURI, "Show component details", "<img src=\"raplixPouch/text.gif\" width=\"16\" height=\"16\" border=\"0\">") + this.mComponentName;
        String versionLink = Util.standardLink(versionURI, "Show version history", this.mVersion);
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(Util.escapeHTML(this.mMenuGroup));
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(Util.escapeHTML(this.mMenuOrder));
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(this.mIndent);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(descLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(componentnameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(versionLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }

    public void addChild(UITreeNode node) {
        this.mChildren.add(node);
        node.setTree(this.mTree);
        this.mType = UITreeNodeType.BRANCH_CLOSED;
    }

    public String finishRender(StringBuffer sb, String path) {
        String rowspanStr = "rowspan=\"" + this.getVisibleChildCount() + "\"";
        this.mPrologue = "<tr>\n" + Util.introStandardCell(rowspanStr, this.mRowLevel) + Util.standardCellStart(0, "nowrap", this.mRowLevel);
        return this.mPrologue + sb + this.mContents;
    }

    public void finishOpen() {
    }

    public void finishClose() {
    }

    protected String getJavascriptFunction() {
        return "sendTree";
    }
}

