/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx.services;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiSystemServiceRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefOrder;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletListBean;

public class ServicesListBean
extends ServletListBean {
    private String[] mServiceIDs = new String[0];
    private String[] mServiceNames = new String[0];
    private String[] mServiceDescs = new String[0];
    private String[] mComponentIDs = new String[0];
    private String[] mComponentNames = new String[0];
    private String[] mComponentVersions = new String[0];
    private boolean mWriteOnSystemService = true;
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);

    public String[] getServiceIDs() {
        return this.mServiceIDs;
    }

    public String[] getServiceNames() {
        return this.mServiceNames;
    }

    public String[] getServiceDescs() {
        return this.mServiceDescs;
    }

    public String[] getComponentIDs() {
        return this.mComponentIDs;
    }

    public String[] getComponentNames() {
        return this.mComponentNames;
    }

    public String[] getComponentVersions() {
        return this.mComponentVersions;
    }

    public boolean getWriteOnSystemService() {
        return this.mWriteOnSystemService;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public void generateList() throws RaplixException {
        MultiSystemServiceRefQuery mssrq = MultiSystemServiceRefQuery.all();
        this.prepQuery(mssrq, SystemServiceRefOrder.BY_NAME_ASC);
        this.generateOutputArrays(mssrq.select());
    }

    private void generateOutputArrays(SystemServiceRef[] ssrs) throws RaplixException {
        int numServices = ssrs.length;
        this.mServiceIDs = new String[numServices];
        this.mServiceNames = new String[numServices];
        this.mServiceDescs = new String[numServices];
        this.mComponentIDs = new String[numServices];
        this.mComponentNames = new String[numServices];
        this.mComponentVersions = new String[numServices];
        for (int i = 0; i < numServices; ++i) {
            SystemServiceRef ssr = ssrs[i];
            SystemServiceRefID ssrID = ssr.getID();
            this.mServiceIDs[i] = ssrID.toString();
            this.mServiceNames[i] = ssr.getName();
            this.mServiceDescs[i] = ssr.getDescription();
            InstalledComponentRef icr = ssr.getInstalledComponentRef();
            this.mComponentNames[i] = icr.getComponentFullName();
            this.mComponentVersions[i] = icr.getComponentVersion();
            this.mComponentIDs[i] = SingleComponentQuery.byRef(icr).selectSummaryView().getID().toString();
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mServiceIDs);
        this.mWriteOnSystemService = PermissionChecker.hasWriteOnSystemService();
    }
}

