/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx.services;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.compx.services.ServiceDetailsBean;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class ServicesHandleAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_CANCEL = "error.services.cancel";
    public static final String MSG_ERROR_CREATE = "error.services.create";
    public static final String MSG_ERROR_DETAILS = "error.services.details";
    public static final String MSG_ERROR_EDIT = "error.services.edit";
    public static final String MSG_ERROR_PICK = "error.services.pick";
    public static final String MSG_ERROR_SAVE_MAJOR = "error.services.save.major";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = ServicesHandleAction.assertGetParam(request, "mode");
        Logger.debug("Coming through ServicesHandleAction: " + mode, this);
        if (mode.equals("add")) {
            this.handleAdd(request, servletInfo);
        } else if (mode.equals("details")) {
            this.handleDetails(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("pick")) {
            this.handlePick(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode passed to ServicesHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        ServiceDetailsBean sb = new ServiceDetailsBean();
        return sb;
    }

    public String getDefaultPage() {
        return "/compx/services/serviceDetails.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = ServicesHandleAction.assertGetParam(inRequest, "mode");
        if (mode.equals("add")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("details")) {
            return MSG_ERROR_DETAILS;
        }
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("pick")) {
            return MSG_ERROR_PICK;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        throw new IllegalArgumentException("Unknown mode passed to ServicesHandleAction.");
    }

    private void handleAdd(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ServiceDetailsBean sb = (ServiceDetailsBean)servletInfo.getBean();
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        sb.createService(name, description);
        sb.setIsNew(true);
        sb.setMode("edit");
        servletInfo.setDestPage("/compx/services/serviceDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ServiceDetailsBean sb = (ServiceDetailsBean)servletInfo.getBean();
        this.saveRequestValues(sb, request);
        try {
            sb.persist();
        }
        catch (PersistenceManagerException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(re.getMessage());
            sb.setMode("edit");
            servletInfo.setDestPage("/compx/services/serviceDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/Services");
        servletInfo.setShouldRedirect(true);
    }

    private void handleDetails(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ServiceDetailsBean sb = (ServiceDetailsBean)servletInfo.getBean();
        String id = ServicesHandleAction.assertGetParam(request, "id");
        sb.loadService(id);
        sb.setMode("details");
        servletInfo.setDestPage("/compx/services/serviceDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ServiceDetailsBean sb = (ServiceDetailsBean)servletInfo.getBean();
        String id = ServicesHandleAction.assertGetParam(request, "id");
        sb.loadService(id);
        sb.setMode("edit");
        servletInfo.setDestPage("/compx/services/serviceDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handlePick(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ServiceDetailsBean sb = (ServiceDetailsBean)servletInfo.getBean();
        this.saveRequestValues(sb, request);
        sb.resolveComponent();
        sb.setMode("edit");
        servletInfo.setDestPage("/compx/services/serviceDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCancel(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.setDestPage("/Services");
        servletInfo.setShouldRedirect(true);
    }

    private void saveRequestValues(ServiceDetailsBean sb, HttpServletRequest request) throws RaplixException {
        String id = ServicesHandleAction.assertGetParam(request, "id");
        String name = ServicesHandleAction.assertGetParam(request, "name");
        String desc = ServicesHandleAction.assertGetParam(request, "description");
        String compID = ServicesHandleAction.assertGetParam(request, "componentID");
        String compName = ServicesHandleAction.assertGetParam(request, "componentName");
        String compFolderID = ServicesHandleAction.assertGetParam(request, "componentFolderID");
        String compVersion = ServicesHandleAction.assertGetParam(request, "componentVersion");
        String compInstallPath = ServicesHandleAction.assertGetParam(request, "componentInstallPath");
        String updateCount = ServicesHandleAction.assertGetParam(request, "updateCount");
        String isNewStr = ServicesHandleAction.assertGetParam(request, "isNew");
        boolean isNew = isNewStr != null && isNewStr.equals("true");
        sb.setID(id);
        sb.setName(name);
        sb.setDescription(desc);
        sb.setComponentID(compID);
        sb.setComponentName(compName);
        sb.setComponentFolderID(compFolderID);
        sb.setComponentVersion(compVersion);
        sb.setComponentInstallPath(compInstallPath);
        sb.setUpdateCount(Integer.parseInt(updateCount));
        sb.setIsNew(isNew);
    }
}

