/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx.services;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidateStatus;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefID;
import com.raplix.rolloutexpress.ui.web.DeleteConfirmNode;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;

public class ServicesDeleteNode
extends UITreeNode {
    private static final int DELETE_CONFIRM_COLSPAN = 4;
    private SystemServiceRefID mSystemServiceRefID = null;
    private String mName = "";
    private String mDescription = "";
    private String mComponentName = "";
    private String mComponentID = "";
    private String mVersion = "";
    private boolean mIsUndeletable = false;
    private int mRowLevel = 0;
    private String mPrologue = "";
    private String mContents = "";

    public ServicesDeleteNode(DeleteSessionCandidate candidate) throws RaplixException {
        this.mType = UITreeNodeType.LEAF;
        DeleteSessionCandidateStatus status = candidate.getStatus();
        this.mIsUndeletable = status.equals(DeleteSessionCandidateStatus.IN_USE) || status.equals(DeleteSessionCandidateStatus.NOT_DELETABLE);
        SystemServiceRefID systemServiceRefID = (SystemServiceRefID)candidate.getParent().getObjectID();
        SystemServiceRef systemServiceRef = systemServiceRefID.getByIDQuery().select();
        this.mSystemServiceRefID = systemServiceRefID;
        this.mName = systemServiceRef.getName();
        this.mDescription = systemServiceRef.getDescription();
        this.mComponentID = SingleComponentQuery.byRef(systemServiceRef.getInstalledComponentRef()).selectSummaryView().getID().toString();
        this.mComponentName = systemServiceRef.getInstalledComponentRef().getComponentFullName();
        this.mVersion = systemServiceRef.getInstalledComponentRef().getComponentVersion();
        this.preRender();
    }

    public void getDescendents(DeleteSessionCandidate candidate) {
        if (this.mIsUndeletable) {
            PersistenceManagerException pme = (PersistenceManagerException)candidate.getException();
            String errMsg = pme.getMessage();
            DeleteConfirmNode confirmNode = new DeleteConfirmNode(errMsg, 2, 4);
            this.addChild(confirmNode);
            if (pme instanceof ObjectInUseException) {
                UsingObject[] blockers = ((ObjectInUseException)pme).getUsingObjects();
                for (int j = 0; j < blockers.length; ++j) {
                    DeleteConfirmNode blockerNode = new DeleteConfirmNode(blockers[j], 2, 4);
                    confirmNode.addChild(blockerNode);
                }
            }
        }
    }

    public void preRender() {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String serviceDetailsURI = UriUtil.serviceDetailsURI(this.mSystemServiceRefID.toString());
        String componentDetailsURI = UriUtil.componentDetailsURI(this.mComponentID);
        String versionURI = UriUtil.componentVersionHistoryURI(this.mComponentID);
        String toolTip = "Show system service details";
        String nameLink = Util.standardLink(serviceDetailsURI, toolTip, this.mName, "name=\"nameLink-" + this.mSystemServiceRefID + "\"");
        String descLink = Util.standardLink(serviceDetailsURI, toolTip, Util.escapeHTML(this.mDescription));
        String componentLink = Util.standardLink(componentDetailsURI, "Show component details", "<img src=\"raplixPouch/text.gif\" width=\"16\" height=\"16\" border=\"0\">") + this.mComponentName;
        String versionLink = Util.standardLink(versionURI, "Show version history", this.mVersion);
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(descLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(componentLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(versionLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }

    public void addChild(UITreeNode node) {
        this.mChildren.add(node);
        node.setTree(this.mTree);
        this.mType = UITreeNodeType.BRANCH_CLOSED;
    }

    public String finishRender(StringBuffer sb, String path) {
        String rowspanStr = "rowspan=\"" + this.getVisibleChildCount() + "\"";
        this.mPrologue = "<tr>\n" + Util.introStandardCell(rowspanStr, this.mRowLevel) + Util.standardCellStart(0, "nowrap", this.mRowLevel);
        return this.mPrologue + sb + this.mContents;
    }

    public void finishOpen() {
    }

    public void finishClose() {
    }

    protected String getJavascriptFunction() {
        return "sendTree";
    }
}

