/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx.services;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionListServlet;
import com.raplix.rolloutexpress.ui.web.compx.services.ServicesListBean;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class ServicesAction
extends UIActionListServlet
implements ActionModeConstants {
    private static final String MSG_ERROR = "error.services.load";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "list";
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through ServicesAction: " + mode, this);
        }
        if (!mode.equals("list")) {
            throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to " + "ServicesAction.");
        }
        this.handleList(request, servletInfo);
    }

    public ServletBean createBean(HttpServletRequest request) {
        return new ServicesListBean();
    }

    public String getDefaultPage() {
        return "/compx/services/services.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        return MSG_ERROR;
    }

    private void handleList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String minorErrorKey;
        ServicesListBean slb = (ServicesListBean)servletInfo.getBean();
        String majorErrorKey = request.getParameter("majorErrorKey");
        if (majorErrorKey != null) {
            servletInfo.getErrors().setMajorErrorKey(majorErrorKey);
        }
        if ((minorErrorKey = request.getParameter("minorErrorKey")) != null) {
            servletInfo.getErrors().addMinorErrorKey(minorErrorKey);
        }
        this.loadListParameters(request, slb);
        slb.generateList();
        servletInfo.setDestPage("/compx/services/services.jsp");
    }
}

