/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx.services;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;

public class ServiceDetailsBean
extends ServletBean {
    private String mMode = "";
    private String mID = "";
    private String mName = "";
    private String mDescription = "";
    private String mPluginName = null;
    private String mPluginID = null;
    private boolean mWriteOnPlugin = true;
    private boolean mWriteOnSystemService = true;
    private String mComponentID = "";
    private String mComponentName = "";
    private String mComponentFolderID = "";
    private String mComponentVersion = "";
    private String mComponentInstallPath = "";
    private boolean mIsNew = false;
    private int mUpdateCount = 0;

    public void setMode(String inValue) {
        this.mMode = inValue;
    }

    public void setIsNew(boolean inValue) {
        this.mIsNew = inValue;
    }

    public void setName(String inValue) {
        this.mName = inValue;
    }

    public void setDescription(String inValue) {
        this.mDescription = inValue;
    }

    public void setComponentID(String inValue) {
        this.mComponentID = inValue;
    }

    public void setComponentName(String inValue) {
        this.mComponentName = inValue;
    }

    public void setComponentFolderID(String inValue) {
        this.mComponentFolderID = inValue;
    }

    public void setComponentVersion(String inValue) {
        this.mComponentVersion = inValue;
    }

    public void setComponentInstallPath(String inValue) {
        this.mComponentInstallPath = inValue;
    }

    public void setUpdateCount(int inValue) {
        this.mUpdateCount = inValue;
    }

    public void setID(String inValue) {
        this.mID = inValue;
    }

    public String getID() {
        if (!this.mID.equals("")) {
            return this.mID;
        }
        return super.getID();
    }

    public String getMode() {
        return this.mMode;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getPluginName() {
        return this.mPluginName;
    }

    public String getPluginID() {
        return this.mPluginID;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public boolean getWriteOnSystemService() {
        return this.mWriteOnSystemService;
    }

    public String getComponentID() {
        return this.mComponentID;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public String getComponentFolderID() {
        return this.mComponentFolderID;
    }

    public String getComponentVersion() {
        return this.mComponentVersion;
    }

    public String getComponentInstallPath() {
        return this.mComponentInstallPath;
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    public void createService(String name, String description) throws RaplixException {
        this.mName = name;
        this.mDescription = description;
        this.mComponentID = "";
        this.mComponentName = "";
        this.mComponentFolderID = "";
        this.mComponentVersion = "";
        this.mComponentInstallPath = "";
        this.mIsNew = true;
        this.mID = "";
    }

    public void loadService(String id) throws RaplixException {
        SystemServiceRef ssr = new SystemServiceRefID(id).getByIDQuery().select();
        this.mID = id;
        this.mIsNew = false;
        this.mName = ssr.getName();
        this.mDescription = ssr.getDescription();
        PluginID pluginID = ssr.getPluginID();
        if (pluginID != null) {
            this.mPluginID = pluginID.toString();
            this.mPluginName = pluginID.getByIDQuery().selectSummaryView().getName();
        }
        this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin(ssr);
        this.mWriteOnSystemService = PermissionChecker.hasWriteOnSystemService();
        InstalledComponentRef icr = ssr.getInstalledComponentRef();
        this.mComponentID = SingleComponentQuery.byRef(icr).selectSummaryView().getID().toString();
        this.mComponentName = icr.getComponentFullName();
        this.mComponentFolderID = icr.getPath().toString();
        this.mComponentVersion = icr.getComponentVersion();
        this.mComponentInstallPath = icr.getInstallPath();
        if (this.mComponentInstallPath == null) {
            this.mComponentInstallPath = "";
        }
        this.mUpdateCount = ssr.getUpdateCount();
    }

    public void resolveComponent() throws RaplixException {
        SummaryComponent sc = new ComponentID(this.mComponentID).getByIDQuery().selectSummaryView();
        this.mComponentName = sc.getFullName();
        this.mComponentFolderID = sc.getPath().toString();
        this.mComponentVersion = sc.getVersionNumber().getAsString();
    }

    public void persist() throws RaplixException {
        SystemServiceRef ssr = this.mIsNew ? new SystemServiceRef() : new SystemServiceRefID(this.mID).getByIDQuery().select();
        ssr.setSimpleName(this.mName);
        ssr.setDescription(this.mDescription);
        if (this.mIsNew && this.mComponentName.length() == 0) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("comp ref unset", this);
            }
        } else {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Creating ref: folderID: " + this.mComponentFolderID + " name: " + Util.fullNameToShortName(this.mComponentName) + " version: " + this.mComponentVersion + " install path: " + this.mComponentInstallPath, this);
            }
            InstalledComponentRef icr = new InstalledComponentRef(new FolderID(this.mComponentFolderID), Util.fullNameToShortName(this.mComponentName), this.mComponentVersion, Comparator.EQUAL, false, this.mComponentInstallPath, false);
            ssr.setInstalledComponentRef(icr);
        }
        ssr.setUpdateCount(this.mUpdateCount);
        ssr.save();
    }
}

