/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.GeneratedVariableSettings;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.config.VariableSettingsManager;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.ui.web.ServletBean;

public class VariableSettingsBean
extends ServletBean {
    private String mMode = "";
    private String mVariableSetName = "";
    private String mHostName = "";
    private String mComponentName = "";
    private String mVersion = "";
    private String mLabel = "";
    private String[] mNames = new String[0];
    private String[] mValues = new String[0];
    private String[] mPrompts = new String[0];
    private boolean[] mHighlights = new boolean[0];
    private GeneratedVariableSettings mGvs = null;
    private VariableSettingsSource mVss = null;
    private VariableSettingsManager mVariableSettingsMgr;

    public VariableSettingsBean(VariableSettingsManager variableSettingsMgr) {
        this.mVariableSettingsMgr = variableSettingsMgr;
    }

    public String getID() {
        if (this.mGvs != null) {
            return this.mGvs.getID().toString();
        }
        return super.getID();
    }

    public String getMode() {
        return this.mMode;
    }

    public String getVariableSetName() {
        return this.mVariableSetName;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public String[] getNames() {
        return this.mNames;
    }

    public String[] getValues() {
        return this.mValues;
    }

    public String[] getPrompts() {
        return this.mPrompts;
    }

    public boolean[] getHighlights() {
        return this.mHighlights;
    }

    public void setMode(String str) {
        this.mMode = str;
    }

    public void setHostName(String str) {
        this.mHostName = str;
    }

    protected void loadDataFromGVS(String componentID, String gvsID, boolean fColorCode) throws RaplixException {
        ComponentID cid = new ComponentID(componentID);
        SingleComponentQuery scq = cid.getByIDQuery();
        Component comp = scq.select();
        if ("".equals(gvsID)) {
            this.mGvs = null;
            this.mVariableSetName = "default";
        } else {
            this.mGvs = this.mVariableSettingsMgr.getVariableSettings(new GeneratedVariableSettingsID(gvsID));
            this.mVariableSetName = this.mGvs.getName();
            this.mVss = fColorCode ? this.mGvs : ComponentConfigManager.getComponentVars(this.mGvs, comp);
        }
        this.mComponentName = comp.getFullName();
        this.mVersion = "" + comp.getVersionNumber().getAsString();
        this.mLabel = comp.getLabel();
        VarDecl[] compVars = comp.getVarList(CallSpec.PUBLIC);
        this.mNames = new String[compVars.length];
        this.mValues = new String[this.mNames.length];
        this.mPrompts = new String[this.mNames.length];
        this.mHighlights = new boolean[this.mNames.length];
        for (int i = 0; i < this.mNames.length; ++i) {
            this.mNames[i] = compVars[i].getName();
            this.mPrompts[i] = compVars[i].getPrompt();
            if (this.mVss != null && (!fColorCode || this.mVss.containsVarValue(this.mNames[i]))) {
                this.mValues[i] = this.mVss.getVarValue(this.mNames[i]);
                this.mHighlights[i] = fColorCode;
                continue;
            }
            this.mValues[i] = compVars[i].getDefaultValue();
            this.mHighlights[i] = false;
        }
    }
}

