/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.config.VariableSettingsManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.compx.VariableSettingsBean;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class VariableSettingsAction
extends UIActionServlet
implements ActionModeConstants {
    private static final String MSG_ERROR = "error.components.loadgeneratedset";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = VariableSettingsAction.assertGetParam(request, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through VariableSettingsAction: " + mode, this);
        }
        if (mode.equals("asinstalled")) {
            this.handleAsInstalled(request, servletInfo);
        } else if (mode.equals("planrunview")) {
            this.handlePlanRunView(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to " + "VariableSettingsAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        VariableSettingsManager varSetMgr = VariableSettingsAction.getApplication().getVariableSettingsManager();
        VariableSettingsBean bean = new VariableSettingsBean(varSetMgr);
        return bean;
    }

    public String getDefaultPage() {
        return "/compx/variableSettingsPopup.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = VariableSettingsAction.assertGetParam(inRequest, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through VariableSettingsAction: " + mode, this);
        }
        if (mode.equals("asinstalled")) {
            return MSG_ERROR;
        }
        if (mode.equals("planrunview")) {
            return MSG_ERROR;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to " + "VariableSettingsAction.");
    }

    private void handlePlanRunView(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        VariableSettingsBean bean = (VariableSettingsBean)servletInfo.getBean();
        String componentID = VariableSettingsAction.assertGetParam(request, "componentID");
        String genVarSetID = VariableSettingsAction.assertGetParam(request, "gvsID");
        bean.loadDataFromGVS(componentID, genVarSetID, true);
        bean.setMode("planrunview");
        servletInfo.setDestPage("/compx/variableSettingsPopup.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleAsInstalled(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        VariableSettingsBean bean = (VariableSettingsBean)servletInfo.getBean();
        String componentID = VariableSettingsAction.assertGetParam(request, "id");
        String genVarSetID = VariableSettingsAction.assertGetParam(request, "gvsID");
        String hostName = VariableSettingsAction.assertGetParam(request, "hostname");
        bean.loadDataFromGVS(componentID, genVarSetID, false);
        bean.setMode("asinstalled");
        bean.setHostName(hostName);
        servletInfo.setDestPage("/compx/variableSettingsPopup.jsp");
        servletInfo.setShouldRedirect(false);
    }
}

