/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.HttpMultipartRequestWrapper;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.Preference;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletPreferenceBroker;
import com.raplix.rolloutexpress.ui.web.ServletSessionBroker;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.compx.ComponentDetailsBean;
import com.raplix.rolloutexpress.ui.web.compx.ComponentEditBean;
import com.raplix.rolloutexpress.ui.web.compx.ComponentVersionHistoryBean;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.CSVUtil;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class ComponentsHandleAction
extends UIActionServlet
implements ActionModeConstants {
    private static final String MSG_ERROR_DETAILS = "error.components.loaddetails";
    private static final String MSG_ERROR_VERSION = "error.components.loadversion";
    private static final String MSG_ERROR_CANCEL = "error.components.cancel";
    private static final String MSG_ERROR_VISIBILITY = "error.components.visibility";
    private static final String MSG_ERROR_CATEGORIES = "error.components.categories";
    private static final String MSG_ERROR_CREATE = "error.components.auth.create";
    private static final String MSG_ERROR_EDIT = "error.components.auth.edit";
    private static final String MSG_ERROR_ADVANCED_EDIT = "error.components.auth.advancededit";
    private static final String MSG_ERROR_ADVANCED_EDIT_CREATE = "error.components.auth.advancededitcreate";
    private static final String MSG_ERROR_REPLACE_XML = "error.components.auth.replacexml";
    private static final String MSG_ERROR_UNSUPPORTED_ENCODING_MAJOR = "error.HttpMultipartRequestWrapper.UnsupportedEncoding.major";
    private static final String MSG_ERROR_UNSUPPORTED_ENCODING_MINOR = "error.HttpMultipartRequestWrapper.UnsupportedEncoding.minor";
    private static final String MSG_ERROR_CHECKIN = "error.components.auth.checkin";
    private static final String MSG_ERROR_MOVE_CHECKIN = "error.components.auth.move.checkin";
    private static final String MSG_ERROR_CHECKIN_CONFIRMED = "error.components.auth.checkinconfirmed";
    private static final String MSG_ERROR_XML_NOT_FOUND = "error.components.auth.xmlnotfound";
    private static final String MSG_ERROR_FILE_TOO_BIG = "error.components.auth.filetoobig";
    private static final String MSG_ERROR_BAD_XML = "error.components.auth.invalidxml";
    private static final String MSG_ERROR_NAMES_DIFFER = "error.components.auth.namesdiffer";
    private static final String MSG_ERROR_NO_PROCEDURES = "error.components.details.noprocedure";
    private static final String MSG_ERROR_GENERATION_FAILED = "error.components.generateplan";
    private static final String MSG_ERROR_COMPONENT_BROWSER_MAJOR = "error.components.auth.compbrowser.major";
    private static final String MSG_ERROR_MOVE = "error.components.move.major";
    private static final String MSG_ERROR_RENAME = "error.components.rename.major";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HttpMultipartRequestWrapper wrapper = null;
        try {
            wrapper = HttpMultipartRequestWrapper.wrapRequest(request);
        }
        catch (IOException e) {
            Logger.debug("IOException in doUIAction", e, this);
            throw new RaplixException(e);
        }
        String mode = wrapper.assertGetParameter("mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through ComponentsHandleAction: '" + mode + "'", this);
        }
        if (mode.equals("details")) {
            this.handleDetails(request, servletInfo);
        } else if (mode.equals("errors")) {
            this.handleDetailsErrors(request, servletInfo);
        } else if (mode.equals("refreshDetails")) {
            this.handleDetailsRefresh(request, servletInfo);
        } else if (mode.equals("rename")) {
            this.handleRename(request, servletInfo);
        } else if (mode.equals("move")) {
            this.handleMove(request, servletInfo);
        } else if (mode.equals("versionhistory")) {
            this.handleVersionHistory(request, servletInfo);
        } else if (mode.equals("updatevisibility")) {
            this.handleUpdateVisibility(request, servletInfo);
        } else if (mode.equals("updatevisibilityofall")) {
            this.handleUpdateVisibilityAll(request, servletInfo);
        } else if (mode.equals("create")) {
            this.handleEditCreate(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("refresh")) {
            this.handleEditRefresh(request, servletInfo);
        } else if (mode.equals("updateVersions")) {
            this.handleEditUpdateVersions(request, servletInfo);
        } else if (mode.equals("add")) {
            this.handleEditAdd(request, servletInfo);
        } else if (mode.equals("addfrombrowse")) {
            this.handleEditAddFromBrowse(request, servletInfo);
        } else if (mode.equals("addtoslot")) {
            this.handleEditAddToSlot(request, servletInfo);
        } else if (mode.equals("remove")) {
            this.handleEditRemove(request, servletInfo);
        } else if (mode.equals("moveRef")) {
            this.handleEditMove(request, servletInfo);
        } else if (mode.equals("settomostrecent")) {
            this.handleEditMostRecent(request, servletInfo);
        } else if (mode.equals("redirect")) {
            this.handleEditRedirect(request, servletInfo);
        } else if (mode.equals("return")) {
            this.handleEditReturn(request, servletInfo);
        } else if (mode.equals("addVariables")) {
            this.handleEditAddVariables(request, servletInfo);
        } else if (mode.equals("componentcheckinnewversion")) {
            this.handleEditCheckInNewVersion(request, servletInfo);
        } else if (mode.equals("createVariable")) {
            this.handleEditCreateVariable(request, servletInfo);
        } else if (mode.equals("moveVariables")) {
            this.handleEditMoveVariables(request, servletInfo);
        } else if (mode.equals("deleteVariables")) {
            this.handleEditDeleteVariables(request, servletInfo);
        } else if (mode.equals("browseError")) {
            this.handleEditBrowseError(request, servletInfo);
        } else if (mode.equals("advancedEditCreate")) {
            this.handleAdvancedEditCreate(request, servletInfo);
        } else if (mode.equals("advancededit")) {
            this.handleAdvancedEdit(request, servletInfo);
        } else if (mode.equals("replace")) {
            this.handleAdvancedEditReplace(wrapper, servletInfo);
        } else if (mode.equals("checkin") || mode.equals("checkinx") || mode.equals("checkinas") || mode.equals("checkinasx")) {
            this.handleCheckInAndAs(wrapper, servletInfo);
        } else if (mode.equals("movecheckin")) {
            this.handleMoveCheckin(request, servletInfo);
        } else if (mode.equals("checkinconfirmed")) {
            this.handleCheckInConfirmed(request, servletInfo);
        } else if (mode.equals("checkincancel")) {
            this.handleCheckInCancel(wrapper, servletInfo);
        } else if (mode.equals("applycategories")) {
            this.handleApplyCategories(request, servletInfo);
        } else if (mode.equals("updatecategories")) {
            this.handleUpdateCategories(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to doUIAction in ComponentsHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        HttpMultipartRequestWrapper wrapper = null;
        try {
            wrapper = HttpMultipartRequestWrapper.wrapRequest(request);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException in createBean");
        }
        UserManager um = ComponentsHandleAction.getApplication().getUserManager();
        ResourceSubsystem rs = ComponentsHandleAction.getApplication().getResourceSubsystem();
        PlanInterface pi = ComponentsHandleAction.getApplication().getPlanInterface();
        ComponentDetailsBean bean = null;
        String mode = wrapper.assertGetParameter("mode");
        if (mode.equals("details") || mode.equals("rename") || mode.equals("move") || mode.equals("versionhistory") || mode.equals("updatevisibilityofall") || mode.equals("create") || mode.equals("edit") || mode.equals("advancedEditCreate") || mode.equals("advancededit")) {
            bean = new ComponentDetailsBean(um, rs, pi);
        } else {
            String id = wrapper.getParameter("id");
            bean = (ComponentDetailsBean)request.getSession().getAttribute(id);
            if (bean == null) {
                throw new IllegalArgumentException("Expected ComponentDetailsBean not found.");
            }
        }
        return bean;
    }

    public String getDefaultPage() {
        return "/compx/componentDetails.jsp";
    }

    public String getMajorError(HttpServletRequest request) {
        HttpMultipartRequestWrapper wrapper = null;
        try {
            wrapper = HttpMultipartRequestWrapper.wrapRequest(request);
        }
        catch (IOException e) {
            throw new IllegalStateException("got IOException and can't throw it");
        }
        String mode = wrapper.assertGetParameter("mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through getMajorError in ComponentsHandleAction with mode: " + mode, this);
        }
        if (mode.equals("details") || mode.equals("errors") || mode.equals("refreshDetails")) {
            return MSG_ERROR_DETAILS;
        }
        if (mode.equals("rename")) {
            return MSG_ERROR_RENAME;
        }
        if (mode.equals("move")) {
            return MSG_ERROR_MOVE;
        }
        if (mode.equals("versionhistory")) {
            return MSG_ERROR_VERSION;
        }
        if (mode.equals("updatevisibility") || mode.equals("updatevisibilityofall")) {
            return MSG_ERROR_VISIBILITY;
        }
        if (mode.equals("updatecategories") || mode.equals("applycategories")) {
            return MSG_ERROR_CATEGORIES;
        }
        if (mode.equals("create")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("edit") || mode.equals("refresh") || mode.equals("updateVersions") || mode.equals("add") || mode.equals("addfrombrowse") || mode.equals("addtoslot") || mode.equals("remove") || mode.equals("moveRef") || mode.equals("settomostrecent") || mode.equals("redirect") || mode.equals("return") || mode.equals("addVariables") || mode.equals("componentcheckinnewversion") || mode.equals("createVariable") || mode.equals("moveVariables") || mode.equals("deleteVariables") || mode.equals("browseError")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("advancedEditCreate")) {
            return MSG_ERROR_ADVANCED_EDIT_CREATE;
        }
        if (mode.equals("advancededit")) {
            return MSG_ERROR_ADVANCED_EDIT;
        }
        if (mode.equals("replace")) {
            return MSG_ERROR_REPLACE_XML;
        }
        if (mode.equals("checkin") || mode.equals("checkinx") || mode.equals("checkinas") || mode.equals("checkinasx")) {
            return MSG_ERROR_CHECKIN;
        }
        if (mode.equals("movecheckin")) {
            return MSG_ERROR_MOVE_CHECKIN;
        }
        if (mode.equals("checkinconfirmed")) {
            return MSG_ERROR_CHECKIN_CONFIRMED;
        }
        if (mode.equals("checkincancel")) {
            return MSG_ERROR_CANCEL;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to getMajorError in ComponentsHandleAction.");
    }

    private void handleDetails(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        String id = ComponentsHandleAction.assertGetParam(request, "id");
        cdb.loadDetails(id);
        this.updateFilePath(request, servletInfo);
        servletInfo.setDestPage("/compx/componentDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleDetailsErrors(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_GENERATION_FAILED);
        servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NO_PROCEDURES);
        servletInfo.setDestPage("/compx/componentDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleDetailsRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        String isTreeShowing = request.getParameter("showingTree");
        if (!isTreeShowing.equals("")) {
            boolean isTreeShowingVal = isTreeShowing.equals("true");
            cdb.setIsTreeShowing(isTreeShowingVal);
        } else {
            String treeID = ComponentsHandleAction.assertGetParam(request, "treeID");
            for (int i = 0; i < cdb.getResourceTrees().length; ++i) {
                if (!treeID.equals(cdb.getResourceTrees()[i].getID().toString())) continue;
                cdb.getResourceTrees()[i].handleRequest(request);
            }
            cdb.setIsTreeShowing(true);
        }
    }

    private void handleRename(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean bean = (ComponentDetailsBean)servletInfo.getBean();
        String id = ComponentsHandleAction.assertGetParam(request, "id");
        String newName = ComponentsHandleAction.assertGetParam(request, "newName");
        bean.loadDetails(id);
        try {
            bean.renameComponent(newName);
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_RENAME);
            servletInfo.getErrors().addMinorError(re.getMessage());
            servletInfo.setDestPage("/compx/componentDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        bean.loadDetails(id);
        servletInfo.setDestPage("/compx/componentDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleMove(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean bean = (ComponentDetailsBean)servletInfo.getBean();
        String id = ComponentsHandleAction.assertGetParam(request, "id");
        String newPathID = ComponentsHandleAction.assertGetParam(request, "movePath");
        bean.loadDetails(id);
        try {
            bean.moveComponent(newPathID);
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_MOVE);
            servletInfo.getErrors().addMinorError(re.getMessage());
            servletInfo.setDestPage("/compx/componentDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        bean.loadDetails(id);
        this.updateFilePath(request, servletInfo);
        servletInfo.setDestPage("/compx/componentDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleVersionHistory(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        String id = ComponentsHandleAction.assertGetParam(request, "id");
        cdb.loadMinimalDetails(id);
        cdb.getVersionHistoryBean().loadVersionHistory(id);
        servletInfo.setDestPage("/compx/componentVersionHistory.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleUpdateVisibility(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        String updateID = request.getParameter("updateID");
        if (updateID == null) {
            updateID = request.getParameter("id");
        }
        String isHidden = ComponentsHandleAction.assertGetParam(request, "isHidden");
        String destination = ComponentsHandleAction.assertGetParam(request, "destination");
        boolean isHiddenVal = isHidden.equals("true");
        try {
            cdb.updateVisibility(updateID, isHiddenVal);
        }
        catch (AccessControlException ex) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_VISIBILITY);
            servletInfo.getErrors().addMinorError(this.ACExToString(ex));
        }
        if (destination.equals("/compx/componentVersionHistory.jsp")) {
            cdb.getVersionHistoryBean().loadVersionHistory(updateID);
        }
        int doneCount = Integer.parseInt(request.getParameter("doneCount")) + 1;
        cdb.setDoneCount(doneCount);
        servletInfo.setDestPage(destination);
        servletInfo.setShouldRedirect(false);
    }

    private void handleUpdateVisibilityAll(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        String id = ComponentsHandleAction.assertGetParam(request, "id");
        String isHidden = ComponentsHandleAction.assertGetParam(request, "isHidden");
        boolean isHiddenVal = isHidden.equals("true");
        cdb.loadMinimalDetails(id);
        ComponentVersionHistoryBean cvhb = cdb.getVersionHistoryBean();
        cvhb.loadVersionHistory(id);
        try {
            cvhb.updateVisibilityAll(id, isHiddenVal);
            if (cdb.getID().equals(id)) {
                cdb.setIsHiddenComponent(isHiddenVal);
            }
        }
        catch (AccessControlException ex) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_VISIBILITY);
            servletInfo.getErrors().addMinorError(this.ACExToString(ex));
        }
        int doneCount = Integer.parseInt(ComponentsHandleAction.assertGetParam(request, "doneCount")) + 1;
        cdb.setDoneCount(doneCount);
        servletInfo.setDestPage("/compx/componentVersionHistory.jsp");
        servletInfo.setShouldRedirect(false);
    }

    public void handleApplyCategories(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        String componentID = ComponentsHandleAction.assertGetParam(request, "id");
        String redirectURI = ComponentsHandleAction.assertGetParam(request, "redirecturi");
        String[] categoryIDs = new String[]{};
        CategoryIDSet idSet = cdb.getCategoryIDSet();
        if (idSet != null) {
            CategoryID[] catIDs = idSet.toIDArray();
            int numCatIDs = catIDs.length;
            categoryIDs = new String[numCatIDs];
            for (int i = 0; i < numCatIDs; ++i) {
                categoryIDs[i] = catIDs[i].toString();
            }
        }
        MultiCheckbox sharedCategoryMC = new MultiCheckbox("", categoryIDs);
        sharedCategoryMC.setSelectedAll();
        String sharedCategoryMCID = sharedCategoryMC.getID();
        ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
        ssb.put(sharedCategoryMCID, sharedCategoryMC);
        String destPage = "/CategoriesPicker?mode=list&redirecturi=" + Util.encodeURL(redirectURI) + "&" + "categoryItemID" + "=" + componentID + "&" + "categoryID" + "=" + sharedCategoryMCID;
        servletInfo.setDestPage(destPage);
        servletInfo.setShouldRedirect(false);
    }

    public void handleUpdateCategories(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        String componentID = ComponentsHandleAction.assertGetParam(request, "id");
        String categoryMCID = ComponentsHandleAction.assertGetParam(request, "categoryID");
        String selected = ComponentsHandleAction.assertGetParam(request, "selected");
        boolean replaceExisting = "true".equals(ComponentsHandleAction.assertGetParam(request, "replaceExisting"));
        boolean allVersions = request.getParameter("allVersions") != null;
        MultiCheckbox categoryMC = (MultiCheckbox)request.getSession().getAttribute(categoryMCID);
        categoryMC.setSelected(selected);
        String[] categoryIDs = categoryMC.getSelected();
        cdb.updateCategories(componentID, categoryIDs, replaceExisting, allVersions);
        String destPage = UriUtil.componentDetailsURI(componentID);
        int doneCount = cdb.getDoneCount() + 1;
        cdb.setDoneCount(doneCount);
        servletInfo.setDestPage(destPage);
        servletInfo.setShouldRedirect(true);
    }

    private void handleEditCreate(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        cdb.setIsNew(true);
        ComponentEditBean ceb = cdb.getEditBean();
        String name = ComponentsHandleAction.assertGetParam(request, "name");
        String type = request.getParameter("componentType");
        String label = ComponentsHandleAction.assertGetParam(request, "label");
        String description = ComponentsHandleAction.assertGetParam(request, "description");
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String folderID = spb.trackString(Preference.FILE_PATH, request);
        ceb.setIsNewComponent(true);
        ceb.setComponentName(name);
        ceb.setComponentFolderID(folderID);
        ceb.setComponentLabel(label);
        ceb.setComponentDescription(description);
        if (type != null) {
            ceb.setComponentType(type);
        }
        ceb.createNewComponent();
        if (!ceb.isSimpleComponent()) {
            MultiCheckbox rmc = ceb.getResourcesMCB();
            ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
            ssb.put(rmc.getID(), rmc);
        }
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        String id = ComponentsHandleAction.assertGetParam(request, "id");
        cdb.loadMinimalDetails(id);
        ComponentEditBean ceb = cdb.getEditBean();
        ceb.setIsNewComponent(false);
        ceb.setComponentID(id);
        ceb.loadEdit();
        if (!ceb.isSimpleComponent()) {
            MultiCheckbox rmc = ceb.getResourcesMCB();
            ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
            ssb.put(rmc.getID(), rmc);
        }
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        this.processStandardParams(request, servletInfo);
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        if (!ceb.isSimpleComponent()) {
            cdb.setIncrComponentUpdateCount();
        }
        servletInfo.setBean(cdb);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditUpdateVersions(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        this.processStandardParams(request, servletInfo);
        int numResources = ceb.getResourceFullNames().length;
        String[] newVersions = ComponentsHandleAction.readParams(request, "selectedResource", numResources);
        ceb.updateVersions(newVersions);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        ceb.updateChangedResources();
        if (ceb.getIsAddVariablesPopupCase()) {
            MultiCheckbox nvmc = ceb.getNewVersionsMCB();
            ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
            ssb.put(nvmc.getID(), nvmc);
        }
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void processStandardParams(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        String name = ComponentsHandleAction.assertGetParam(request, "name");
        String selectedPlatform = ComponentsHandleAction.assertGetParam(request, "selectedplatform");
        String label = ComponentsHandleAction.assertGetParam(request, "label");
        String description = ComponentsHandleAction.assertGetParam(request, "description");
        String showDetails = null;
        ceb.setComponentName(name);
        ceb.setComponentPlatform(selectedPlatform);
        ceb.setComponentLabel(label);
        ceb.setComponentDescription(description);
        if (!ceb.isSimpleComponent()) {
            int i;
            String treeID;
            int numResources = ceb.getResourceFullNames().length;
            String[] newLocalNames = ComponentsHandleAction.readParams(request, "localName", numResources);
            ceb.setResourceLocalNames(newLocalNames);
            String[] newInstallModes = ComponentsHandleAction.readParams(request, "installMode", numResources);
            ceb.setResourceInstallModes(newInstallModes);
            showDetails = request.getParameter("showInstalled");
            String isTreeShowing = ComponentsHandleAction.assertGetParam(request, "showingTree");
            if (ceb.isTreeShowing() && isTreeShowing.equals("") && !(treeID = ComponentsHandleAction.assertGetParam(request, "treeID")).equals("")) {
                for (i = 0; i < ceb.getResourceTrees().length; ++i) {
                    if (!treeID.equals(ceb.getResourceTrees()[i].getID().toString())) continue;
                    ceb.getResourceTrees()[i].handleRequest(request);
                }
            }
            if (!isTreeShowing.equals("")) {
                boolean isTreeShowingVal = isTreeShowing.equals("true");
                ceb.setIsTreeShowing(isTreeShowingVal);
            }
            if (ceb.isDetailedView()) {
                Vector<String[]> vovv = new Vector<String[]>();
                for (i = 0; i < numResources; ++i) {
                    MultiCheckbox existingMC = ceb.getResourceVarsMCBs()[i];
                    MultiCheckbox checkedMC = new MultiCheckbox(i + "varOverrideName", request);
                    existingMC.setSelected(checkedMC);
                    vovv.add(ComponentsHandleAction.readParams(request, i + "varOverrideValue", existingMC.getSize()));
                }
                String[][] overrides = new String[numResources][];
                vovv.toArray((T[])overrides);
                ceb.setResourceVarOvrVals(overrides);
            }
        }
        int numVariables = ceb.getComponentVarName().length;
        String[] newComponentVarOvrValChecks = ComponentsHandleAction.readParams(request, "componentVariableOverrideChecks", numVariables);
        ceb.setComponentVarOvrValChecked(newComponentVarOvrValChecks);
        String[] newVariableValues = ComponentsHandleAction.readParams(request, "variableValue", numVariables);
        this.clearUncheckedValues(newVariableValues, newComponentVarOvrValChecks, ceb);
        ceb.setComponentVarOvrVal(newVariableValues);
        String[] newVariablePrompts = ComponentsHandleAction.readParams(request, "variablePrompt", numVariables);
        this.clearUncheckedValues(newVariablePrompts, newComponentVarOvrValChecks, ceb);
        ceb.setComponentPromptOvrs(newVariablePrompts);
        ceb.updateDescriptor();
        ceb.setIsDetailedView(showDetails != null);
    }

    private void clearUncheckedValues(String[] values, String[] checkboxes, ComponentEditBean ceb) {
        for (int ndx = 0; ndx < checkboxes.length; ++ndx) {
            if (checkboxes[ndx] != null || !ceb.isComponentVarInherited()[ndx]) continue;
            values[ndx] = null;
        }
    }

    private static void updateComponentInfo(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        ceb.setIsAddVariablesPopupCase(false);
        ceb.generateOutput();
        if (!ceb.isSimpleComponent()) {
            MultiCheckbox rmc = ceb.getResourcesMCB();
            ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
            ssb.put(rmc.getID(), rmc);
        }
    }

    private void addReferencedVariables(HttpServletRequest request, ServletInfo servletInfo) {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        String[] varNames = CSVUtil.splitCSV(ComponentsHandleAction.assertGetParam(request, "variableName"));
        String[] varDefaults = CSVUtil.splitCSV(ComponentsHandleAction.assertGetParam(request, "variableValue"));
        String[] varPrompts = new String[varNames.length];
        for (int i = 0; i < varNames.length; ++i) {
            varPrompts[i] = "";
        }
        ceb.addVariables(varNames, varDefaults, varPrompts);
    }

    private void handleEditAdd(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        this.processStandardParams(request, servletInfo);
        String resourceList = ComponentsHandleAction.assertGetParam(request, "selected");
        String[] resourceIDs = CSVUtil.splitCSV(resourceList);
        ceb.addResources(resourceIDs);
        this.addReferencedVariables(request, servletInfo);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditAddFromBrowse(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        String[] resourceIDs = new String[]{ComponentsHandleAction.assertGetParam(request, "selected")};
        ceb.addResources(resourceIDs);
        this.addReferencedVariables(request, servletInfo);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        this.updateFilePath(request, servletInfo);
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditCheckInNewVersion(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        String component = ComponentsHandleAction.assertGetParam(request, "selected");
        String slot = ComponentsHandleAction.assertGetParam(request, "index");
        ComponentID cid = new ComponentID(component);
        int index = new Integer(slot);
        ceb.addResource(cid, index);
        this.addReferencedVariables(request, servletInfo);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditAddVariables(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        this.processStandardParams(request, servletInfo);
        this.addReferencedVariables(request, servletInfo);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditAddToSlot(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        this.processStandardParams(request, servletInfo);
        String component = ComponentsHandleAction.assertGetParam(request, "selected");
        String slot = ComponentsHandleAction.assertGetParam(request, "index");
        ComponentID cid = new ComponentID(component);
        int index = new Integer(slot);
        ceb.addResource(cid, index);
        this.addReferencedVariables(request, servletInfo);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditRemove(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        this.processStandardParams(request, servletInfo);
        String indexes = ComponentsHandleAction.assertGetParam(request, "selected");
        String[] positions = CSVUtil.splitCSV(indexes);
        ceb.removeResources(positions);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditMove(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        this.processStandardParams(request, servletInfo);
        String direction = ComponentsHandleAction.assertGetParam(request, "direction");
        String indexes = ComponentsHandleAction.assertGetParam(request, "selected");
        String[] positions = CSVUtil.splitCSV(indexes);
        ceb.moveResources(positions, direction);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditMostRecent(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        this.processStandardParams(request, servletInfo);
        String indexes = ComponentsHandleAction.assertGetParam(request, "selected");
        String[] positions = CSVUtil.splitCSV(indexes);
        ceb.setResourcesToMostRecent(positions);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        ceb.updateChangedResources();
        if (ceb.getIsAddVariablesPopupCase()) {
            MultiCheckbox nvmc = ceb.getNewVersionsMCB();
            ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
            ssb.put(nvmc.getID(), nvmc);
        }
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditRedirect(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String redirectURI = ComponentsHandleAction.assertGetParam(request, "redirecturi");
        this.processStandardParams(request, servletInfo);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        servletInfo.setDestPage(redirectURI);
        servletInfo.setShouldRedirect(true);
    }

    private void handleEditReturn(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditCreateVariable(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        this.processStandardParams(request, servletInfo);
        String newVariableName = ComponentsHandleAction.assertGetParam(request, "newVariableName");
        String newVariableValue = ComponentsHandleAction.assertGetParam(request, "newVariableValue");
        String newVariableOvrPrompt = ComponentsHandleAction.assertGetParam(request, "newVariableOveridePrompt");
        ceb.addVariable(newVariableName, newVariableValue, newVariableOvrPrompt);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditMoveVariables(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        this.processStandardParams(request, servletInfo);
        String direction = ComponentsHandleAction.assertGetParam(request, "direction");
        String indexes = ComponentsHandleAction.assertGetParam(request, "selected");
        String[] positions = CSVUtil.splitCSV(indexes);
        ceb.moveVariables(positions, direction);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditDeleteVariables(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        this.processStandardParams(request, servletInfo);
        String indexes = ComponentsHandleAction.assertGetParam(request, "selected");
        String[] positions = CSVUtil.splitCSV(indexes);
        ceb.deleteVariables(positions);
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEditBrowseError(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String minorKey = ComponentsHandleAction.assertGetParam(request, "minorErrorKey");
        String arg1 = ComponentsHandleAction.assertGetParam(request, "argument1");
        ComponentsHandleAction.updateComponentInfo(request, servletInfo);
        servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_COMPONENT_BROWSER_MAJOR);
        servletInfo.getErrors().addMinorErrorKey(minorKey, arg1);
        servletInfo.setDestPage("/compx/componentEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleAdvancedEditCreate(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        String name = ComponentsHandleAction.assertGetParam(request, "name");
        String type = ComponentsHandleAction.assertGetParam(request, "componentType");
        String label = ComponentsHandleAction.assertGetParam(request, "label");
        String description = ComponentsHandleAction.assertGetParam(request, "description");
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String folderID = spb.trackString(Preference.FILE_PATH, request);
        cdb.setComponentName(name);
        cdb.setComponentFolderID(folderID);
        cdb.setComponentType(type);
        cdb.setComponentLabel(label);
        cdb.setComponentDescription(description);
        cdb.setIsNew(true);
        cdb.createComponentXML();
        servletInfo.setDestPage("/compx/componentAdvancedEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleAdvancedEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean bean = (ComponentDetailsBean)servletInfo.getBean();
        String id = ComponentsHandleAction.assertGetParam(request, "id");
        bean.loadMinimalDetails(id);
        servletInfo.setDestPage("/compx/componentAdvancedEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleAdvancedEditReplace(HttpMultipartRequestWrapper wrapper, ServletInfo servletInfo) {
        ComponentDetailsBean bean = (ComponentDetailsBean)servletInfo.getBean();
        String xml = null;
        try {
            xml = wrapper.getParameter("uploadxml");
        }
        catch (OutOfMemoryError er) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_REPLACE_XML);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_FILE_TOO_BIG);
            servletInfo.setDestPage("/compx/componentAdvancedEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        String backupXML = wrapper.assertGetParameter("definition");
        if (xml == null || xml.equals("")) {
            bean.setXML(backupXML);
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_REPLACE_XML);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_XML_NOT_FOUND);
        } else if (xml.equals(MSG_ERROR_UNSUPPORTED_ENCODING_MAJOR)) {
            bean.setXML(backupXML);
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_UNSUPPORTED_ENCODING_MAJOR);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_UNSUPPORTED_ENCODING_MINOR, wrapper.getCharacterEncoding());
        } else {
            bean.setXML(xml);
        }
        servletInfo.setDestPage("/compx/componentAdvancedEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCheckInAndAs(HttpMultipartRequestWrapper wrapper, ServletInfo servletInfo) {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ComponentEditBean ceb = cdb.getEditBean();
        String mode = wrapper.assertGetParameter("mode");
        String destination = wrapper.assertGetParameter("destination");
        String xml = "";
        String name = "";
        String folderID = "";
        boolean isNew = false;
        String xmlName = null;
        try {
            if (mode.equals("checkin") || mode.equals("checkinas")) {
                isNew = new Boolean(wrapper.assertGetParameter("isNew"));
                xml = wrapper.assertGetParameter("definition");
                name = wrapper.assertGetParameter("name");
                ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(wrapper.getRequest().getSession());
                folderID = spb.trackString(Preference.FILE_PATH, wrapper.getRequest());
                cdb.setIsEditOperation(false);
            } else {
                isNew = new Boolean(wrapper.assertGetParameter("isNew"));
                if (mode.equals("checkinx")) {
                    mode = "checkin";
                } else if (mode.equals("checkinasx")) {
                    mode = "checkinas";
                }
                xml = ceb.getXML();
                name = ceb.getComponentName();
                folderID = ceb.getComponentFolderID();
                cdb.setIsEditOperation(true);
            }
            cdb.setComponentName(name);
            cdb.setComponentFolderID(folderID);
            cdb.setXML(xml);
            cdb.setDestination(destination);
            cdb.setMode(mode);
            cdb.setIsNew(isNew);
            xmlName = cdb.verifyComponentXML();
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_BAD_XML);
            servletInfo.getErrors().addMinorError(re.toString());
            servletInfo.setDestPage(destination);
            servletInfo.setShouldRedirect(false);
            return;
        }
        if (xmlName != null && !cdb.getComponentName().equals(xmlName)) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_NAMES_DIFFER);
        }
        if (mode.equals("checkinas")) {
            cdb.checkpointState();
        }
        servletInfo.setDestPage("/compx/componentCheckin.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleMoveCheckin(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean bean = (ComponentDetailsBean)servletInfo.getBean();
        String name = ComponentsHandleAction.assertGetParam(request, "name");
        String folderID = ComponentsHandleAction.assertGetParam(request, "componentPath");
        bean.setComponentName(name);
        bean.setComponentFolderID(folderID);
        FolderID id = new FolderID(folderID);
        bean.setWriteOnPlugin(PermissionChecker.hasWriteOnPlugin(id.getByIDQuery().selectSummaryView()));
        bean.setWriteOnFolder(PermissionChecker.hasWriteOnFolder(id));
        servletInfo.setDestPage("/compx/componentCheckin.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCheckInConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean bean = (ComponentDetailsBean)servletInfo.getBean();
        String name = request.getParameter("name");
        String folderID = request.getParameter("componentPath");
        String majorVersion = request.getParameter("isMajorVersion");
        String isHidingPrevious = request.getParameter("isHidingPrevious");
        if (name != null) {
            bean.setComponentName(name);
        }
        if (folderID != null) {
            bean.setComponentFolderID(folderID);
        }
        bean.setIsMajorVersion("true".equals(majorVersion));
        bean.setIsHidingPrevious(isHidingPrevious != null);
        try {
            bean.checkinComponent();
        }
        catch (PersistenceManagerException e) {
            this.handleExceptionInCheckIn(servletInfo, e);
            return;
        }
        catch (AccessControlException e) {
            this.handleExceptionInCheckIn(servletInfo, e);
            return;
        }
        this.updateFilePath(request, servletInfo);
        servletInfo.setDestPage("/Components");
        servletInfo.setShouldRedirect(true);
    }

    private void handleCheckInCancel(HttpMultipartRequestWrapper wrapper, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean bean = (ComponentDetailsBean)servletInfo.getBean();
        if (bean.getMode().equals("checkinas")) {
            bean.rollbackState();
        }
        String destination = wrapper.assertGetParameter("destination");
        servletInfo.setDestPage(destination);
        servletInfo.setShouldRedirect(false);
    }

    private static String[] readParams(HttpServletRequest request, String paramName, int numFields) {
        Vector<String> paramValues = new Vector<String>();
        for (int i = 0; i < numFields; ++i) {
            String tmp = request.getParameter(paramName + i);
            paramValues.add(tmp);
        }
        Object[] params = new String[paramValues.size()];
        paramValues.copyInto(params);
        return params;
    }

    private void handleExceptionInCheckIn(ServletInfo servletInfo, Exception ex) {
        servletInfo.setDestPage("/compx/componentCheckin.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_CHECKIN_CONFIRMED);
        if (!(ex instanceof AccessControlException)) {
            servletInfo.getErrors().addMinorError(ex.getMessage());
        } else {
            servletInfo.getErrors().addMinorError(this.ACExToString((AccessControlException)ex));
        }
    }

    private void updateFilePath(HttpServletRequest request, ServletInfo servletInfo) {
        ComponentDetailsBean cdb = (ComponentDetailsBean)servletInfo.getBean();
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String filePath = ChangePathBean.verifyFolderID(cdb.getComponentFolderID());
        spb.setString(Preference.FILE_PATH, filePath);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("updateFilePath:  path is now " + filePath, this);
        }
    }
}

