/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.query.MultiObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.VersionRange;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentOrder;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FullPathFilter;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.UserFolderPermissions;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypesListBean;
import com.raplix.rolloutexpress.ui.web.folders.FoldersListBean;
import com.raplix.util.regex.GlobPattern;
import java.util.Arrays;
import java.util.Vector;

public class ComponentsBean
extends ServletListBean {
    private static final String MSG_LABEL_UNIVERSALSET = "label.universalhostset";
    private static final ComponentOrder DEFAULT_SORT_ORDER = ComponentOrder.BY_NAME_ASC;
    private String[] mComponentIDs = new String[0];
    private String[] mParentFolderNames = new String[0];
    private String[] mComponentNames = new String[0];
    private String[] mComponentTypes = new String[0];
    private String[] mComponentVersions = new String[0];
    private String[] mComponentLabels = new String[0];
    private String[] mComponentDescs = new String[0];
    private boolean[] mIsHidden = new boolean[0];
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private String mFindFolderID = null;
    private String mFindParentName = "";
    private String mFindComponentType = "";
    private String mFindVersion = "";
    private String mFindLabel = "";
    private String[] mPathFolderNames = new String[0];
    private String[] mPathFolderIDs = new String[0];
    private boolean mWriteOnPlugin = true;
    private boolean mWriteOnFolder = true;
    private boolean mCheckinCurrentOnFolder = true;
    private String mMode = "";
    private int mFamily = 1;
    private boolean mIsTypeFixed = false;
    private String mSlot = null;
    private String mComponentID = null;
    private boolean mIsNameFixed = false;
    private String[][] mAllCompVersions = null;
    private String[][] mAllCompIDs = null;
    private SummaryComponent[] mComponents = null;
    private ComponentTypesListBean mComponentTypesListBean = null;
    private boolean mPermWriteOnFolder = false;
    private boolean mAutoRunOnFolder = false;
    private boolean mCheckInCurrentOnFolder = false;
    private String mExecuteHostSetsOnFolder = "";
    private String mDeleteHistoryHostSetsOnFolder = "";

    public String[] getComponentIDs() {
        return this.mComponentIDs;
    }

    public String[] getParentFolderNames() {
        return this.mParentFolderNames;
    }

    public String[] getComponentNames() {
        return this.mComponentNames;
    }

    public String[] getComponentTypes() {
        return this.mComponentTypes;
    }

    public String[] getVersions() {
        return this.mComponentVersions;
    }

    public String[] getLabels() {
        return this.mComponentLabels;
    }

    public String[] getDescriptions() {
        return this.mComponentDescs;
    }

    public boolean[] getIsHidden() {
        return this.mIsHidden;
    }

    public String[] getAllIDs(int index) {
        return this.mAllCompIDs[index];
    }

    public String[] getAllVersions(int index) {
        return this.mAllCompVersions[index];
    }

    public String getFindParentName() {
        return this.mFindParentName;
    }

    public String getFindComponentType() {
        return this.mFindComponentType;
    }

    public String getFindLabel() {
        return this.mFindLabel;
    }

    public String getFindVersion() {
        return this.mFindVersion;
    }

    public String getMode() {
        return this.mMode;
    }

    public void setFindParentName(String parentName) {
        this.mFindParentName = parentName;
    }

    public void setFindComponentType(String findCompType) {
        this.mFindComponentType = findCompType;
    }

    public void setFindLabel(String findLabel) {
        this.mFindLabel = findLabel;
    }

    public void setFindVersion(String findVersion) {
        this.mFindVersion = findVersion;
    }

    public String[] getPathFolderNames() {
        return this.mPathFolderNames;
    }

    public String[] getPathFolderIDs() {
        return this.mPathFolderIDs;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public boolean getWriteOnFolder() {
        return this.mWriteOnFolder;
    }

    public boolean getCheckinCurrentOnFolder() {
        return this.mCheckinCurrentOnFolder;
    }

    public int getFamily() {
        return this.mFamily;
    }

    public void setFamily(int inFamily) {
        this.mFamily = inFamily;
    }

    public boolean getIsTypeFixed() {
        return this.mIsTypeFixed;
    }

    public void setIsTypeFixed(boolean inIsFixed) {
        this.mIsTypeFixed = inIsFixed;
    }

    public String getSlot() {
        return this.mSlot;
    }

    public void setSlot(String inSlot) {
        this.mSlot = inSlot;
    }

    public String getComponentID() {
        return this.mComponentID;
    }

    public void setComponentID(String inContainerID) {
        this.mComponentID = inContainerID;
    }

    public String getFindFolderID() {
        return this.mFindFolderID;
    }

    public void setFindFolderID(String inFindFolderID) {
        this.mFindFolderID = inFindFolderID;
    }

    public boolean getIsNameFixed() {
        return this.mIsNameFixed;
    }

    public void setIsNameFixed(boolean inIsFixed) {
        this.mIsNameFixed = inIsFixed;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public ComponentTypesListBean getComponentTypesListBean() {
        return this.mComponentTypesListBean;
    }

    public boolean getUserHasWriteOnFolder() {
        return this.mPermWriteOnFolder;
    }

    public boolean getAutoRunOnFolder() {
        return this.mAutoRunOnFolder;
    }

    public boolean getCheckInCurrentOnFolder() {
        return this.mCheckInCurrentOnFolder;
    }

    public String getExecuteHostSetsOnFolder() {
        return this.mExecuteHostSetsOnFolder;
    }

    public String getDeleteHistoryHostSetsOnFolder() {
        return this.mDeleteHistoryHostSetsOnFolder;
    }

    public void generateList() throws RaplixException {
        MultiComponentQuery mcq = MultiComponentQuery.all();
        this.finishGenerateList(mcq);
        this.loadBreadCrumbArrays();
    }

    public void generateListForPicker() throws RaplixException {
        MultiComponentQuery mcq = MultiComponentQuery.all();
        mcq.setNotModifierFilter(Modifier.ABSTRACT);
        this.finishGenerateList(mcq);
    }

    public void generateListForPickerByName() throws RaplixException {
        MultiComponentQuery mcq = MultiComponentQuery.all();
        this.finishGenerateList(mcq);
    }

    public void generateListForPickerForServices() throws RaplixException {
        MultiComponentQuery mcq = MultiComponentQuery.all();
        mcq.setInstanceOfTypeFilter(ComponentTypesListBean.SYSTEM_SERVICE_COMPONENT_TYPE);
        this.finishGenerateList(mcq);
    }

    private void finishGenerateList(MultiComponentQuery mcq) throws RaplixException {
        mcq.setCategoryFilter(this.getCategoryFilter());
        this.prepQuery(mcq, this.getSortOrderByName(this.getSortName()));
        this.generateOutputArrays(mcq.selectSummaryView());
        this.generatePermissions();
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mComponentIDs);
        this.mComponentTypesListBean = new ComponentTypesListBean();
        this.mComponentTypesListBean.loadComponentTypesWithGroups();
        FolderID folderID = new FolderID(this.getFilePathFilter());
        this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin(folderID.getByIDQuery().selectSummaryView());
        this.mWriteOnFolder = PermissionChecker.hasWriteOnFolder(folderID);
        this.mCheckinCurrentOnFolder = PermissionChecker.hasCheckinCurrentOnFolder(folderID);
    }

    private void generatePermissions() throws RaplixException {
        HostSetIDSet hostsetIDs;
        FolderID id = new FolderID(this.getFilePathFilter());
        UserFolderPermissions ufp = id.getUserPermissions();
        this.mPermWriteOnFolder = ufp.isWrite();
        this.mAutoRunOnFolder = ufp.isAutorun();
        this.mCheckInCurrentOnFolder = ufp.isCheckin();
        if (ufp.isExecuteAllHosts()) {
            this.mExecuteHostSetsOnFolder = ApplicationResources.getMessage(MSG_LABEL_UNIVERSALSET);
        } else {
            hostsetIDs = ufp.getExecuteHostSets();
            this.mExecuteHostSetsOnFolder = Util.hostSets2String(hostsetIDs);
        }
        if (ufp.isDeleteHistoryAllHosts()) {
            this.mDeleteHistoryHostSetsOnFolder = ApplicationResources.getMessage(MSG_LABEL_UNIVERSALSET);
        } else {
            hostsetIDs = ufp.getDeleteHistoryHostSets();
            this.mDeleteHistoryHostSetsOnFolder = Util.hostSets2String(hostsetIDs);
        }
    }

    private void loadBreadCrumbArrays() throws RaplixException {
        FolderID folderID = new FolderID(this.getFilePathFilter());
        this.mPathFolderNames = ChangePathBean.getFolderPathNames(folderID);
        this.mPathFolderIDs = ChangePathBean.getFolderPathIDs(folderID);
    }

    public void loadComponentsForImportPopup() throws RaplixException {
        MultiComponentQuery mcq = MultiComponentQuery.all();
        mcq.setCategoryFilter(this.getCategoryFilter());
        this.prepQuery(mcq, this.getSortOrderByName(this.getSortName()));
        SummaryComponent[] all = mcq.selectSummaryView();
        String currentName = "";
        Vector<SummaryComponent> mainPile = new Vector<SummaryComponent>();
        Vector<SummaryComponent[]> versionsPile = new Vector<SummaryComponent[]>();
        int startIndex = -1;
        for (int i = 0; i <= all.length; ++i) {
            if (i != all.length && all[i].getFullName().equals(currentName)) continue;
            if (startIndex >= 0) {
                SummaryComponent[] versions = new SummaryComponent[i - startIndex];
                for (int j = startIndex; j < i; ++j) {
                    versions[j - startIndex] = all[j];
                }
                versionsPile.add(versions);
            }
            if (i >= all.length) continue;
            currentName = all[i].getFullName();
            mainPile.add(all[i]);
            startIndex = i;
        }
        this.generateOutputArrays(mainPile.toArray(new SummaryComponent[0]));
        this.loadAllComponentVersions(versionsPile);
    }

    private void generateOutputArrays(SummaryComponent[] comps) throws RaplixException {
        this.mComponents = comps;
        int numComponents = comps.length;
        this.mComponentIDs = new String[numComponents];
        this.mParentFolderNames = new String[numComponents];
        this.mComponentNames = new String[numComponents];
        this.mComponentTypes = new String[numComponents];
        this.mComponentVersions = new String[numComponents];
        this.mComponentLabels = new String[numComponents];
        this.mComponentDescs = new String[numComponents];
        this.mIsHidden = new boolean[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            SummaryComponent sc = this.mComponents[i];
            ComponentID compID = sc.getID();
            this.mComponentIDs[i] = compID.toString();
            this.mParentFolderNames[i] = FoldersListBean.generateFlatViewPath(sc.getPath().getByIDQuery().selectSummaryView().getFullPathString(), this.getFilePathFilter());
            this.mComponentNames[i] = sc.getName();
            this.mComponentTypes[i] = ComponentTypesListBean.normalizeName(sc.getExtendsTypeName());
            this.mComponentVersions[i] = sc.getVersionNumber().getAsString();
            this.mComponentLabels[i] = sc.getLabel();
            this.mComponentDescs[i] = sc.getDescription();
            this.mIsHidden[i] = sc.getVisibility().equals(Visibility.HIDDEN);
        }
    }

    private void loadAllComponentVersions(Vector versionsPile) {
        SummaryComponent[] oneVersionPile = null;
        int numComponents = this.mComponentNames.length;
        this.mAllCompVersions = new String[numComponents][];
        this.mAllCompIDs = new String[numComponents][];
        for (int i = 0; i < numComponents; ++i) {
            oneVersionPile = (SummaryComponent[])versionsPile.get(i);
            this.mAllCompVersions[i] = new String[oneVersionPile.length];
            this.mAllCompIDs[i] = new String[oneVersionPile.length];
            for (int j = 0; j < oneVersionPile.length; ++j) {
                this.mAllCompVersions[i][j] = oneVersionPile[j].getVersionNumber().getAsString();
                this.mAllCompIDs[i][j] = oneVersionPile[j].getID().toString();
            }
            this.mComponentIDs[i] = oneVersionPile[0].getID().toString();
            this.mComponentDescs[i] = oneVersionPile[0].getDescription();
            this.mComponentVersions[i] = oneVersionPile[0].getVersionNumber().getAsString();
        }
    }

    public void changeVersion(int index, String componentID) throws RaplixException {
        this.mComponentIDs[index] = componentID;
        ComponentID cid = new ComponentID(componentID);
        MultiComponentQuery mcq = cid.getAllVersionsQuery();
        SummaryComponent[] allComponents = mcq.selectSummaryView();
        for (int j = 0; j < allComponents.length; ++j) {
            if (!allComponents[j].getID().toString().equals(componentID)) continue;
            this.mComponentDescs[index] = allComponents[j].getDescription();
        }
    }

    public void updateCategories(String[] ids, String[] catIDs, boolean replaceExisting, boolean allVersions) throws RaplixException {
        int numComponents = ids.length;
        ComponentID[] componentIDs = new ComponentID[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            componentIDs[i] = new ComponentID(ids[i]);
        }
        int numCatIDS = catIDs.length;
        CategoryID[] categoryIDs = new CategoryID[numCatIDS];
        for (int i = 0; i < numCatIDS; ++i) {
            categoryIDs[i] = new CategoryID(catIDs[i]);
        }
        CategoryIDSet catIDSet = new CategoryIDSet(Arrays.asList(categoryIDs));
        CategoryUpdateContext ctx = new CategoryUpdateContext(catIDSet);
        ctx.setReplaceExisting(replaceExisting);
        ctx.setAllVersions(allVersions);
        ComponentIDSet idSet = new ComponentIDSet(Arrays.asList(componentIDs));
        idSet.getByIDsQuery().updateCategories(ctx);
    }

    public void move(String[] ids, String movePath) throws RaplixException {
        ComponentID[] compIDs = new ComponentID[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            compIDs[i] = new ComponentID(ids[i]);
        }
        ComponentIDSet idSet = new ComponentIDSet(Arrays.asList(compIDs));
        idSet.getByIDsQuery().move(new FolderID(movePath));
    }

    protected void loadAdditionalFindFilters(MultiObjectQuery query) throws RaplixException {
        MultiComponentQuery mcq = (MultiComponentQuery)query;
        if (!this.mFindParentName.equals("")) {
            FullPathFilter pathFilter = mcq.getFullPathFilter();
            if (pathFilter == null) {
                pathFilter = new FullPathFilter();
            }
            pathFilter.setPathFilter(GlobPattern.create("*" + this.mFindParentName + "*"));
            mcq.setFullPathFilter(pathFilter);
        }
        if (!this.mFindVersion.equals("")) {
            VersionRange range = ServletListBean.constructVersionRangeForFilter(this.mFindVersion);
            mcq.setVersionFilter(range);
        }
        if (!this.mFindLabel.equals("")) {
            mcq.setLabelFilter(GlobPattern.create("*" + this.mFindLabel + "*"));
        }
        switch (this.mFamily) {
            case 0: {
                mcq.setExtendsTypeFilter("$root$");
                break;
            }
            case 3: {
                mcq.setExtendsTypeFilter(this.mFindComponentType);
                break;
            }
            case 2: {
                mcq.setInstanceOfTypeGroupFilter(this.mFindComponentType);
                break;
            }
            case 1: {
                this.mFindComponentType = "";
            }
        }
    }

    protected void loadAdditionalFilters(MultiObjectQuery query) throws RaplixException {
        MultiComponentQuery mcq = (MultiComponentQuery)query;
        FolderID folderID = new FolderID(this.getFilePathFilter());
        boolean isRecursive = this.getFlatView();
        FullPathFilter pathFilter = mcq.getFullPathFilter();
        if (pathFilter == null) {
            pathFilter = new FullPathFilter();
        }
        if (this.getIsNameFixed()) {
            mcq.setNameFilter(GlobPattern.create(this.getFindName()));
            isRecursive = false;
            folderID = new FolderID(this.mFindFolderID);
        }
        pathFilter.setSearchRoot(folderID);
        pathFilter.setRecursiveMode(isRecursive);
        mcq.setFullPathFilter(pathFilter);
    }

    public ObjectOrder getDefaultSortOrder() {
        return DEFAULT_SORT_ORDER;
    }

    protected ObjectOrder getSortOrderByName(String sortName) {
        return this.getSortOrderByName(ComponentOrder.FACTORY, sortName);
    }

    public boolean getCanBeHidden() {
        return true;
    }

    public void clearFindFilters() {
        this.mFindFolderID = null;
        this.setFindName("");
        this.setFindDescription("");
        this.mFindParentName = "";
        this.mFindComponentType = "";
        this.mFindVersion = "";
        this.mFindLabel = "";
        this.mIsTypeFixed = false;
        this.mIsNameFixed = false;
    }
}

