/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.catdb.Category;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.Preference;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.ServletPreferenceBroker;
import com.raplix.rolloutexpress.ui.web.ServletSessionBroker;
import com.raplix.rolloutexpress.ui.web.UIActionListServlet;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.compx.ComponentsBean;
import com.raplix.util.logger.Logger;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class ComponentsAction
extends UIActionListServlet
implements ActionModeConstants {
    private static final String MSG_ERROR_LIST = "error.components.load";
    private static final String MSG_ERROR_CATEGORIES = "error.components.categories";
    private static final String MSG_ERROR_DELETE_MAJOR = "error.components.delete.major";
    private static final String MSG_ERROR_NO_SELECTION = "error.components.noselection";
    private static final String MSG_ERROR_MOVE_MAJOR = "error.components.move.major";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through ComponentsAction: " + mode, this);
        }
        if ((mode = this.normalizeMode(mode)).equals("list")) {
            this.handleList(request, servletInfo);
        } else if (mode.equals("picker")) {
            this.handlePicker(request, servletInfo);
        } else if (mode.equals("pickerByName")) {
            this.handlePickerByName(request, servletInfo);
        } else if (mode.equals("pickerForServices")) {
            this.handlePickerForServices(request, servletInfo);
        } else if (mode.equals("importpopup")) {
            this.handleImportPopup(request, servletInfo);
        } else if (mode.equals("importpopuprefresh")) {
            this.handleImportPopupRefresh(request, servletInfo);
        } else if (mode.equals("changeversion")) {
            this.handleChangeVersion(request, servletInfo);
        } else if (mode.equals("applycategories")) {
            this.handleApplyCategories(request, servletInfo);
        } else if (mode.equals("updatecategories")) {
            this.handleUpdateCategories(request, servletInfo);
        } else if (mode.equals("errors")) {
            this.handleCategoriesErrors(request, servletInfo);
        } else if (mode.equals("deleteerrors")) {
            this.handleDeleteErrors(request, servletInfo);
        } else if (mode.equals("moveErrors")) {
            this.handleMoveErrors(request, servletInfo);
        } else if (mode.equals("move")) {
            this.handleMove(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to " + "ComponentsAction.");
        }
    }

    private String normalizeMode(String mode) {
        if (mode == null || mode.equals("")) {
            mode = "list";
        }
        return mode;
    }

    public ServletBean createBean(HttpServletRequest request) {
        ComponentsBean bean;
        String mode = request.getParameter("mode");
        if (mode == null || mode.equals("")) {
            mode = "list";
        }
        if (mode.equals("list") || mode.equals("picker") || mode.equals("pickerByName") || mode.equals("pickerForServices") || mode.equals("applycategories") || mode.equals("updatecategories") || mode.equals("errors") || mode.equals("deleteerrors") || mode.equals("importpopup") || mode.equals("moveErrors") || mode.equals("move")) {
            bean = new ComponentsBean();
        } else {
            String id = request.getParameter("id");
            bean = (ComponentsBean)request.getSession().getAttribute(id);
            if (bean == null) {
                throw new IllegalArgumentException("Expected 'ComponentsBean' not found.");
            }
        }
        return bean;
    }

    public String getDefaultPage() {
        return "/compx/components.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = ComponentsAction.assertGetParam(inRequest, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("ComponentsAction::getMajorError with mode: " + mode, this);
        }
        if (mode.equals("list") || mode.equals("picker") || mode.equals("pickerByName") || mode.equals("pickerForServices") || mode.equals("importpopup") || mode.equals("changeversion") || mode.equals("importpopuprefresh")) {
            return MSG_ERROR_LIST;
        }
        if (mode.equals("applycategories") || mode.equals("updatecategories") || mode.equals("errors")) {
            return MSG_ERROR_CATEGORIES;
        }
        if (mode.equals("moveErrors") || mode.equals("move")) {
            return MSG_ERROR_MOVE_MAJOR;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to ComponentsAction.");
    }

    private void handleList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String minorErrorKey;
        ComponentsBean cb = (ComponentsBean)servletInfo.getBean();
        String majorErrorKey = request.getParameter("majorErrorKey");
        if (majorErrorKey != null) {
            servletInfo.getErrors().setMajorErrorKey(majorErrorKey);
        }
        if ((minorErrorKey = request.getParameter("minorErrorKey")) != null) {
            servletInfo.getErrors().addMinorErrorKey(minorErrorKey);
        }
        cb.loadCategoryFilters();
        this.loadListParameters(request, cb);
        cb.generateList();
        MultiCheckbox mc = cb.getMultiCheckbox();
        if (mc != null) {
            ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
            ssb.put(mc.getID(), mc);
        }
        servletInfo.setDestPage("/compx/components.jsp");
    }

    private void handlePicker(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentsBean cb = (ComponentsBean)servletInfo.getBean();
        String mode = ComponentsAction.assertGetParam(request, "mode");
        String fixedType = ComponentsAction.assertGetParam(request, "typeFixed");
        String componentID = ComponentsAction.assertGetParam(request, "componentID");
        String slot = request.getParameter("index");
        cb.setMode(mode);
        cb.setSlot(slot);
        cb.setComponentID(componentID);
        cb.setReadFiltersFromSession(false);
        if (fixedType.equals("true")) {
            cb.setIsTypeFixed(true);
        }
        cb.loadCategoryFilters();
        this.loadListParameters(request, cb);
        cb.generateListForPicker();
        servletInfo.setDestPage("/compx/componentPicker.jsp");
        servletInfo.setSaveInSession(false);
    }

    private void handlePickerByName(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentsBean cb = (ComponentsBean)servletInfo.getBean();
        String mode = ComponentsAction.assertGetParam(request, "mode");
        String findFolder = request.getParameter("filePath");
        String findName = request.getParameter("name");
        String fixedName = ComponentsAction.assertGetParam(request, "nameFixed");
        cb.setMode(mode);
        cb.setReadFiltersFromSession(false);
        cb.loadCategoryFilters();
        this.loadListParameters(request, cb);
        if (fixedName.equals("true")) {
            cb.setIsNameFixed(true);
            cb.setIsTypeFixed(true);
            cb.setFindFolderID(findFolder);
            cb.setFindName(findName);
            cb.setFlatView(false);
            cb.setFindComponentType("");
            cb.setFamily(1);
        }
        cb.setSlot("");
        cb.generateListForPickerByName();
        servletInfo.setDestPage("/compx/componentPicker.jsp");
        servletInfo.setSaveInSession(false);
    }

    private void handlePickerForServices(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentsBean cb = (ComponentsBean)servletInfo.getBean();
        String mode = ComponentsAction.assertGetParam(request, "mode");
        cb.setMode(mode);
        cb.setIsTypeFixed(true);
        cb.setSlot("");
        cb.setReadFiltersFromSession(false);
        cb.loadCategoryFilters();
        this.loadListParameters(request, cb);
        cb.generateListForPickerForServices();
        servletInfo.setDestPage("/compx/componentPicker.jsp");
        servletInfo.setSaveInSession(false);
    }

    private void handleImportPopup(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentsBean bean = (ComponentsBean)servletInfo.getBean();
        bean.setReadFiltersFromSession(false);
        bean.loadCategoryFilters();
        this.loadListParameters(request, bean);
        bean.loadComponentsForImportPopup();
        servletInfo.setDestPage("/compx/componentImportPopup.jsp");
    }

    private void handleImportPopupRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentsBean bean = (ComponentsBean)servletInfo.getBean();
        bean.setReadFiltersFromSession(false);
        bean.loadCategoryFilters();
        this.loadListParameters(request, bean);
        if (bean.getIsFindFiltered().equals("false")) {
            bean.clearFindFilters();
        }
        bean.loadComponentsForImportPopup();
        servletInfo.setDestPage("/compx/componentImportPopup.jsp");
        servletInfo.setSaveInSession(false);
    }

    private void handleChangeVersion(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentsBean cb = (ComponentsBean)servletInfo.getBean();
        String indexStr = ComponentsAction.assertGetParam(request, "editIndex");
        int index = new Integer(indexStr);
        String newID = ComponentsAction.assertGetParam(request, "id" + index);
        cb.setReadFiltersFromSession(false);
        cb.changeVersion(index, newID);
        servletInfo.setDestPage("/compx/componentImportPopup.jsp");
        servletInfo.setSaveInSession(false);
    }

    public void handleApplyCategories(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String componentMCID = ComponentsAction.assertGetParam(request, "multiLocation");
        String selected = ComponentsAction.assertGetParam(request, "selected");
        String redirectURI = ComponentsAction.assertGetParam(request, "redirecturi");
        MultiCheckbox componentMC = (MultiCheckbox)request.getSession().getAttribute(componentMCID);
        componentMC.setSelected(selected);
        String[] componentIDs = componentMC.getSelected();
        Vector<ComponentID> componentList = new Vector<ComponentID>();
        for (int i = 0; i < componentIDs.length; ++i) {
            componentList.addElement(new ComponentID(componentIDs[i]));
        }
        ComponentIDSet idSet = new ComponentIDSet(componentList);
        CategoryID[] catIDs = idSet.getByIDsQuery().selectSharedCategories().toIDArray();
        int numCatIDs = catIDs.length;
        String[] categoryIDs = new String[numCatIDs];
        for (int i = 0; i < numCatIDs; ++i) {
            categoryIDs[i] = catIDs[i].toString();
        }
        MultiCheckbox sharedCategoryMC = new MultiCheckbox("", categoryIDs);
        sharedCategoryMC.setSelectedAll();
        String sharedCategoryMCID = sharedCategoryMC.getID();
        ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
        ssb.put(sharedCategoryMCID, sharedCategoryMC);
        String destPage = "/CategoriesPicker?mode=list&redirecturi=" + Util.encodeURL(redirectURI) + "&" + "categoryItemID" + "=" + componentMCID + "&" + "categoryID" + "=" + sharedCategoryMCID;
        servletInfo.setDestPage(destPage);
        servletInfo.setShouldRedirect(false);
    }

    public void handleUpdateCategories(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentsBean cb = (ComponentsBean)servletInfo.getBean();
        String componentMCID = ComponentsAction.assertGetParam(request, "categoryItemID");
        String categoryMCID = ComponentsAction.assertGetParam(request, "categoryID");
        String selected = ComponentsAction.assertGetParam(request, "selected");
        boolean replaceExisting = "true".equals(ComponentsAction.assertGetParam(request, "replaceExisting"));
        boolean allVersions = request.getParameter("allVersions") != null;
        MultiCheckbox componentMC = (MultiCheckbox)request.getSession().getAttribute(componentMCID);
        String[] componentIDs = componentMC.getSelected();
        MultiCheckbox categoryMC = (MultiCheckbox)request.getSession().getAttribute(categoryMCID);
        categoryMC.setSelected(selected);
        String[] categoryIDs = categoryMC.getSelected();
        try {
            cb.updateCategories(componentIDs, categoryIDs, replaceExisting, allVersions);
        }
        catch (PersistenceManagerException pme) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_CATEGORIES);
            servletInfo.getErrors().addMinorError(pme.getMessage());
        }
        this.handleList(request, servletInfo);
    }

    public void handleCategoriesErrors(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_CATEGORIES);
        servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NO_SELECTION);
        this.handleList(request, servletInfo);
    }

    private void handleDeleteErrors(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_DELETE_MAJOR);
        servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NO_SELECTION);
        this.handleList(request, servletInfo);
    }

    private void handleMoveErrors(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_MOVE_MAJOR);
        servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NO_SELECTION);
        this.handleList(request, servletInfo);
    }

    private void handleMove(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentsBean bean = (ComponentsBean)servletInfo.getBean();
        String movePath = ComponentsAction.assertGetParam(request, "movePath");
        MultiCheckbox in = new MultiCheckbox("bulk", request);
        String[] ids = in.getSelected();
        if (ids.length == 0) {
            this.handleMoveErrors(request, servletInfo);
            return;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Calling move on " + Util.commaSeparated(ids) + " to " + movePath, this);
        }
        try {
            bean.move(ids, movePath);
        }
        catch (PersistenceManagerException pme) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_MOVE_MAJOR);
            servletInfo.getErrors().addMinorError(pme.getMessage());
        }
        this.handleList(request, servletInfo);
    }

    protected void setAdditionalFindFilters(HttpServletRequest request, ServletListBean bean) {
        String findParentName = request.getParameter("parentName");
        String findLabel = request.getParameter("label");
        String findComponentType = request.getParameter("componentType");
        String findVersion = request.getParameter("versionNumber");
        String family = request.getParameter("family");
        ComponentsBean cb = (ComponentsBean)bean;
        if (findParentName != null) {
            cb.setFindParentName(findParentName);
        }
        if (findLabel != null) {
            cb.setFindLabel(findLabel);
        }
        if (findComponentType != null) {
            cb.setFindComponentType(findComponentType);
        }
        if (findVersion != null) {
            cb.setFindVersion(findVersion);
        }
        if (family != null) {
            int typeFamily = Integer.parseInt(family);
            cb.setFamily(typeFamily);
        }
    }

    protected void setDefaultFilters(HttpServletRequest request, ServletListBean bean) {
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        boolean showHidden = spb.trackBoolean(Preference.SHOW_HIDDEN_GLOBAL, request);
        bean.setShowHidden(showHidden);
        boolean fromSession = request.getParameter("readfromsession") != null;
        String catID = "";
        catID = fromSession ? spb.trackString(Preference.CATEGORY, request) : (bean.getReadFiltersFromSession() ? spb.trackString(Preference.CATEGORY, request) : request.getParameter("category"));
        CategoryID filterID = new CategoryID(catID);
        if (!catID.equals(Category.NO_CATEGORY_ID.toString()) && !catID.equals(Category.ANY_CATEGORY_ID.toString())) {
            try {
                filterID.getByIDQuery().select();
            }
            catch (RaplixException re) {
                filterID = ServletListBean.DEFAULT_CATEGORY_FILTER;
                spb.setString(Preference.CATEGORY, filterID.toString());
            }
        }
        bean.setCategoryFilter(filterID);
    }

    protected void setAdditionalFilters(HttpServletRequest request, ServletListBean bean) {
        boolean flatView;
        boolean fromSession = request.getParameter("readfromsession") != null;
        boolean fromRequest = request.getParameter("readfromrequest") != null;
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String filePathFilter = "";
        if (fromSession) {
            filePathFilter = spb.trackString(Preference.FILE_PATH, request);
            flatView = spb.trackBoolean(Preference.FLAT_VIEW, request);
        } else if (fromRequest) {
            filePathFilter = spb.trackString(Preference.FILE_PATH, request);
            flatView = request.getParameter("flatView") != null && request.getParameter("flatView").equals("true");
            spb.setBoolean(Preference.FLAT_VIEW, new Boolean(flatView));
        } else if (bean.getReadFiltersFromSession()) {
            filePathFilter = spb.trackString(Preference.FILE_PATH, request);
            flatView = spb.trackBoolean(Preference.FLAT_VIEW, request);
        } else {
            filePathFilter = request.getParameter("filePath");
            flatView = request.getParameter("flatView") != null;
        }
        filePathFilter = ChangePathBean.verifyFolderID(filePathFilter);
        if (bean.getReadFiltersFromSession()) {
            spb.setString(Preference.FILE_PATH, filePathFilter);
        }
        bean.setFilePathFilter(filePathFilter);
        bean.setFlatView(flatView);
    }
}

