/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentOrder;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.string.StringUtil;

public class ComponentWhereInstalledBean
extends ServletListBean {
    private String mComponentID = "";
    private String mComponentFullName = "";
    private String[] mComponentIDs = new String[0];
    private String[] mCurrentHostNames = new String[0];
    private String[] mCurrentHostIDs = new String[0];
    private String[] mPhysicalHostNames = new String[0];
    private String[] mInstallPaths = new String[0];
    private String[] mVarSettings = new String[0];
    private String[] mVarSettingIDs = new String[0];
    private String[] mVersions = new String[0];
    private String[] mLabels = new String[0];
    private String[] mInstalledDates = new String[0];
    private String[] mTaskIDs = new String[0];
    private String[] mInstalledByPlans = new String[0];
    private String[] mInstalledByUsers = new String[0];
    private String[] mInstalledByUserIDs = new String[0];
    private String[] mInstalledComponentIDs = new String[0];
    private String[] mPlanIDs = new String[0];
    private boolean[] mIsSentinelTaskIDs = new boolean[0];
    private boolean[] mIsSentinelUserIDs = new boolean[0];
    private boolean mFootnoteEnabled = false;

    public void generateList() throws RaplixException {
        ComponentID cid = new ComponentID(this.mComponentID);
        SingleComponentQuery scq = cid.getByIDQuery();
        SummaryComponent sc = scq.selectSummaryView();
        this.mComponentFullName = sc.getFullName();
        MultiInstalledComponentQuery micq = MultiInstalledComponentQuery.byComp(cid);
        InstalledComponentOrder sortOrder = InstalledComponentOrder.BY_DATE_DESC;
        this.prepQuery(micq, sortOrder);
        InstalledComponentBean[] installedComponents = micq.select();
        int installedComponentsSize = installedComponents.length;
        this.mComponentIDs = new String[installedComponentsSize];
        this.mCurrentHostNames = new String[installedComponentsSize];
        this.mCurrentHostIDs = new String[installedComponentsSize];
        this.mPhysicalHostNames = new String[installedComponentsSize];
        this.mInstallPaths = new String[installedComponentsSize];
        this.mVarSettings = new String[installedComponentsSize];
        this.mVarSettingIDs = new String[installedComponentsSize];
        this.mVersions = new String[installedComponentsSize];
        this.mLabels = new String[installedComponentsSize];
        this.mTaskIDs = new String[installedComponentsSize];
        this.mInstalledDates = new String[installedComponentsSize];
        this.mInstalledByPlans = new String[installedComponentsSize];
        this.mInstalledByUsers = new String[installedComponentsSize];
        this.mPlanIDs = new String[installedComponentsSize];
        this.mInstalledByUserIDs = new String[installedComponentsSize];
        this.mInstalledComponentIDs = new String[installedComponentsSize];
        this.mIsSentinelTaskIDs = new boolean[installedComponentsSize];
        this.mIsSentinelUserIDs = new boolean[installedComponentsSize];
        for (int i = 0; i < installedComponentsSize; ++i) {
            InstalledComponentBean icb = installedComponents[i];
            this.mComponentIDs[i] = icb.getComponentID().toString();
            Target target = icb.getTarget();
            if (target != null) {
                this.mCurrentHostNames[i] = target.getCurrentHost().getName();
                this.mCurrentHostIDs[i] = target.getCurrentHostID().toString();
            } else {
                this.mCurrentHostNames[i] = "";
                this.mCurrentHostIDs[i] = "";
            }
            if (target.getCurrentHostID().equals(target.getPhysicalHostID())) {
                this.mPhysicalHostNames[i] = "";
            } else {
                this.mPhysicalHostNames[i] = target.getPhysicalHost().getName();
                this.mFootnoteEnabled = true;
            }
            this.mInstallPaths[i] = StringUtil.normalizeEmpty(icb.getComponentRAInstallPath());
            this.mVarSettings[i] = icb.getGeneratedVariableSettings().getName();
            this.mVarSettingIDs[i] = icb.getGeneratedVariableSettingsID().toString();
            this.mVersions[i] = "" + icb.getComponent().getVersionNumber().getAsString();
            this.mLabels[i] = icb.getComponent().getLabel();
            this.mTaskIDs[i] = icb.getTaskID().toString();
            this.mInstalledDates[i] = Util.formatDate(icb.getDate());
            this.mInstalledByPlans[i] = icb.getExecutionPlan().getFullName();
            this.mInstalledByUsers[i] = icb.getUsername();
            this.mInstalledByUserIDs[i] = icb.getUserID().toString();
            this.mInstalledComponentIDs[i] = icb.getInstalledComponentID().toString();
            this.mPlanIDs[i] = icb.getExecutionPlanID().toString();
            this.mIsSentinelTaskIDs[i] = TaskID.TASK_SENTINEL_ID.equals(icb.getTaskID());
            this.mIsSentinelUserIDs[i] = UserID.USER_SENTINEL_ID.equals(icb.getUserID());
        }
    }

    public String getComponentID() {
        return this.mComponentID;
    }

    public void setComponentID(String id) {
        this.mComponentID = id;
    }

    public String getComponentFullName() {
        return this.mComponentFullName;
    }

    public String[] getComponentIDs() {
        return this.mComponentIDs;
    }

    public String[] getCurrentHostNames() {
        return this.mCurrentHostNames;
    }

    public String[] getCurrentHostIDs() {
        return this.mCurrentHostIDs;
    }

    public String[] getPhysicalHostNames() {
        return this.mPhysicalHostNames;
    }

    public String[] getInstallPaths() {
        return this.mInstallPaths;
    }

    public String[] getVarSettings() {
        return this.mVarSettings;
    }

    public String[] getVarSettingIDs() {
        return this.mVarSettingIDs;
    }

    public String[] getVersions() {
        return this.mVersions;
    }

    public String[] getLabels() {
        return this.mLabels;
    }

    public String[] getInstalledDates() {
        return this.mInstalledDates;
    }

    public String[] getTaskIDs() {
        return this.mTaskIDs;
    }

    public String[] getInstalledByPlans() {
        return this.mInstalledByPlans;
    }

    public String[] getInstalledByUsers() {
        return this.mInstalledByUsers;
    }

    public String[] getPlanIDs() {
        return this.mPlanIDs;
    }

    public String[] getUserIDs() {
        return this.mInstalledByUserIDs;
    }

    public String[] getInstalledComponentIDs() {
        return this.mInstalledComponentIDs;
    }

    public boolean[] getIsSentinelTaskIDs() {
        return this.mIsSentinelTaskIDs;
    }

    public boolean[] getIsSentinelUserIDs() {
        return this.mIsSentinelUserIDs;
    }

    public boolean getFootnoteEnabled() {
        return this.mFootnoteEnabled;
    }
}

