/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.Util;

public class ComponentVersionHistoryBean {
    private String[] mComponentIDs = new String[0];
    private String[] mVersions = new String[0];
    private String[] mLabels = new String[0];
    private String[] mCheckInDates = new String[0];
    private String[] mCheckInUsers = new String[0];
    private String[] mUserIDs = new String[0];
    private boolean[] mIsHidden = new boolean[0];
    private final UserManager mUserDBInterface;

    public ComponentVersionHistoryBean(UserManager userDBInterface) {
        this.mUserDBInterface = userDBInterface;
    }

    public String[] getComponentIDs() {
        return this.mComponentIDs;
    }

    public String[] getVersions() {
        return this.mVersions;
    }

    public String[] getLabels() {
        return this.mLabels;
    }

    public String[] getCheckedInDates() {
        return this.mCheckInDates;
    }

    public String[] getCheckedInBys() {
        return this.mCheckInUsers;
    }

    public String[] getUserIDs() {
        return this.mUserIDs;
    }

    public boolean[] getIsHidden() {
        return this.mIsHidden;
    }

    public void loadVersionHistory(String stringComponentID) throws RaplixException {
        ComponentID cid = new ComponentID(stringComponentID);
        MultiComponentQuery mcq = cid.getAllVersionsQuery();
        SummaryComponent[] componentVersions = mcq.select();
        this.generateOutputFields(componentVersions);
    }

    private void generateOutputFields(SummaryComponent[] componentVersions) throws RaplixException {
        int numComponents = componentVersions.length;
        this.mComponentIDs = new String[numComponents];
        this.mVersions = new String[numComponents];
        this.mLabels = new String[numComponents];
        this.mCheckInDates = new String[numComponents];
        this.mCheckInUsers = new String[numComponents];
        this.mUserIDs = new String[numComponents];
        this.mIsHidden = new boolean[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            this.mComponentIDs[i] = componentVersions[i].getID().toString();
            this.mVersions[i] = componentVersions[i].getVersionNumber().getAsString();
            this.mLabels[i] = componentVersions[i].getLabel();
            this.mCheckInDates[i] = Util.formatDate(componentVersions[i].getTimeStamp());
            this.mCheckInUsers[i] = this.mUserDBInterface.getUser(componentVersions[i].getUserID()).getUsername();
            this.mUserIDs[i] = componentVersions[i].getUserID().toString();
            this.mIsHidden[i] = componentVersions[i].getVisibility().equals(Visibility.HIDDEN);
        }
    }

    public void updateVisibilityAll(String stringComponentID, boolean isHiddenVal) throws RaplixException {
        ComponentID cid = new ComponentID(stringComponentID);
        MultiComponentQuery mcq = cid.getAllVersionsQuery();
        Visibility v = isHiddenVal ? Visibility.HIDDEN : Visibility.VISIBLE;
        mcq.updateVisibility(v);
        SummaryComponent[] componentVersions = mcq.select();
        this.generateOutputFields(componentVersions);
    }
}

