/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDescriptor;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceSelectorList;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDescriptor;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDescriptorList;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.UITree;
import com.raplix.rolloutexpress.ui.web.compx.ComponentDetailsBean;
import com.raplix.rolloutexpress.ui.web.compx.ComponentNameNode;
import com.raplix.rolloutexpress.ui.web.compx.VariableNode;
import com.raplix.util.string.CSVUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;

public class ComponentVariablesBean
extends ServletBean {
    private static final String MSG_REQUIRING_COMPS = "component.variables.required.comps";
    private String mContainerMode = "add";
    private String[] mResourceIDs = new String[0];
    private String[] mVariableNames = new String[0];
    private String[] mVariablePrompts = new String[0];
    private String[] mVariableDefaults = new String[0];
    private UITree[] mVariableTrees = new UITree[0];
    private HashMap mVariableComponentMap = new LinkedHashMap();
    private static Vector mVariablePromptList = new Vector();
    private int[] mSlotIndices = new int[0];
    private boolean mIsPopup = false;
    private ComponentDetailsBean mComponentDetailsBean;

    public String[] getResourceIDs() {
        return this.mResourceIDs;
    }

    public String[] getVariableNames() {
        return this.mVariableNames;
    }

    public String[] getVariablePrompts() {
        return this.mVariablePrompts;
    }

    public String[] getVariableDefaults() {
        return this.mVariableDefaults;
    }

    public UITree[] getVariableTrees() {
        return this.mVariableTrees;
    }

    public int[] getSlotIndices() {
        return this.mSlotIndices;
    }

    public String getContainerMode() {
        return this.mContainerMode;
    }

    public String getComponentDetailsBeanID() {
        return this.mComponentDetailsBean.getID();
    }

    public String getSingleResourceID() {
        if (this.mResourceIDs != null && this.mResourceIDs.length > 0) {
            return this.mResourceIDs[0];
        }
        return "";
    }

    public String getVariableNamesCSVString() {
        return CSVUtil.composeCSV(this.mVariableNames);
    }

    public String getIsPopup() {
        return this.mIsPopup ? "true" : "false";
    }

    public void setSlotIndices(int[] inVal) {
        this.mSlotIndices = inVal;
    }

    public void setContainerMode(String mode) {
        this.mContainerMode = mode;
    }

    public void setComponentDetailsBean(ComponentDetailsBean inVal) {
        this.mComponentDetailsBean = inVal;
    }

    public void setIsPopup(String boolStr) {
        this.mIsPopup = boolStr != null && boolStr.equals("true");
    }

    public void loadVariables(String[] resourceIDs) throws RaplixException {
        this.mResourceIDs = resourceIDs;
        this.mVariableComponentMap = ComponentVariablesBean.extractVariables(this.mComponentDetailsBean.getEditBean().getComponentDescriptor(), this.mResourceIDs, this.mSlotIndices);
        this.mVariableNames = this.mVariableComponentMap.keySet().toArray(new String[0]);
        this.mVariablePrompts = mVariablePromptList.toArray(new String[0]);
    }

    public String[] extractComponentIDs(int[] slotIndices) {
        String[] resourceIDs = new String[slotIndices.length];
        ResourceSelectorList rsl = this.mComponentDetailsBean.getEditBean().getComponentDescriptor().getResourceSelectors();
        for (int i = 0; i < slotIndices.length; ++i) {
            resourceIDs[i] = rsl.getSelector(slotIndices[i]).getCurrent().getID().toString();
        }
        return resourceIDs;
    }

    public static HashMap extractVariables(ComponentDescriptor inCD, String[] resourceIDs, int[] slotIndices) throws RPCException, PersistenceManagerException {
        LinkedHashMap<String, ArrayList<String>> variableComponentMap = new LinkedHashMap<String, ArrayList<String>>();
        VarDescriptorList varList = inCD.getVarList();
        Iterator containedVars = varList.iterator();
        Vector<String> containerVarsList = new Vector<String>();
        while (containedVars.hasNext()) {
            VarDescriptor var = (VarDescriptor)containedVars.next();
            containerVarsList.addElement(var.getName());
            mVariablePromptList.addElement(var.getDefaultPrompt());
        }
        for (int i = 0; i < resourceIDs.length; ++i) {
            ComponentID compID = new ComponentID(resourceIDs[i]);
            SummaryComponent c = compID.getByIDQuery().selectSummaryView();
            ResourceSelector rs = null;
            if (slotIndices != null && slotIndices.length == resourceIDs.length) {
                rs = inCD.getResourceSelectors().getSelector(slotIndices[i]);
            }
            Iterator vars = ResourceSelector.getContainerVars(compID, rs).iterator();
            while (vars.hasNext()) {
                String varName = (String)vars.next();
                if (containerVarsList.contains(varName)) continue;
                ArrayList<String> compList = (ArrayList<String>)((HashMap)variableComponentMap).get(varName);
                if (null == compList) {
                    compList = new ArrayList<String>();
                }
                compList.add(c.getFullName());
                variableComponentMap.put(varName, compList);
            }
        }
        return variableComponentMap;
    }

    public void generateVariableTree() {
        int numVars = this.mVariableComponentMap.size();
        this.mVariableTrees = new UITree[numVars];
        Iterator vars = this.mVariableComponentMap.keySet().iterator();
        int i = 0;
        while (vars.hasNext()) {
            String varName = (String)vars.next();
            ArrayList comps = (ArrayList)this.mVariableComponentMap.get(varName);
            String[] compNames = comps.toArray(new String[0]);
            UITree tree = new UITree();
            VariableNode node = new VariableNode(varName, i);
            tree.setRoot(node);
            this.mVariableTrees[i] = tree;
            String helpText = ApplicationResources.getMessage(MSG_REQUIRING_COMPS);
            ComponentNameNode helpTextNode = new ComponentNameNode(helpText);
            node.addChild(helpTextNode);
            for (int j = 0; j < compNames.length; ++j) {
                String compName = compNames[j];
                ComponentNameNode nameNode = new ComponentNameNode(compName);
                node.addChild(nameNode);
            }
            ++i;
        }
    }
}

