/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import [Ljava.lang.Integer;;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDescriptor;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.UITree;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.compx.ComponentDetailsBean;
import com.raplix.rolloutexpress.ui.web.compx.ComponentVariablesBean;
import com.raplix.rolloutexpress.ui.web.compx.VariableNode;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.collections.Mapper;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.CSVUtil;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class ComponentVariablesAction
extends UIActionServlet
implements ActionModeConstants {
    private static final String MSG_ERROR_VARIABLES = "error.components.auth.variables.major";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = ComponentVariablesAction.assertGetParam(request, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through ComponentVariablesAction: '" + mode + "'", this);
        }
        if (mode.equals("list")) {
            this.handleList(request, servletInfo);
        } else if (mode.equals("lookahead")) {
            this.handleLookAhead(request, servletInfo);
        } else if (mode.equals("componentcheckinnew")) {
            this.handleAddFromBrowse(request, servletInfo);
        } else if (mode.equals("componentcheckinnewversion")) {
            this.handleComponentCheckInNewVersion(request, servletInfo);
        } else if (mode.equals("refreshDetails")) {
            this.handleRefreshDetails(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to " + "ComponentVariablesAction");
        }
    }

    private void handleList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String[] resourceIDs;
        ComponentVariablesBean cvb = (ComponentVariablesBean)servletInfo.getBean();
        String componentID = ComponentVariablesAction.assertGetParam(request, "componentID");
        String isPopup = request.getParameter("isPopup");
        String componentMode = request.getParameter("componentMode");
        String slotIndex = request.getParameter("index");
        String resourceList = request.getParameter("selected");
        int[] slotIndices = new int[]{};
        ComponentDetailsBean cdb = (ComponentDetailsBean)request.getSession().getAttribute(componentID);
        cvb.setComponentDetailsBean(cdb);
        if (resourceList != null) {
            resourceIDs = CSVUtil.splitCSV(resourceList);
        } else {
            MultiCheckbox indicesMCB = (MultiCheckbox)request.getSession().getAttribute(ComponentVariablesAction.assertGetParam(request, "multiLocation"));
            String[] slots = indicesMCB.getValues();
            try {
                slotIndices = (int[])CollectionUtil.toPrimitiveArray(CollectionUtil.mapClass(slots, Integer;.class, new Mapper(){

                    public void setMappedClass(Class cls) {
                    }

                    public Object map(Object element) throws Exception {
                        return new Integer((String)element);
                    }
                }));
            }
            catch (Exception e) {
                // empty catch block
            }
            resourceIDs = cvb.extractComponentIDs(slotIndices);
        }
        if (slotIndex != null && !slotIndex.equals("")) {
            slotIndices = new int[]{Integer.parseInt(slotIndex)};
        }
        if (componentMode == null) {
            componentMode = "add";
        }
        cvb.setSlotIndices(slotIndices);
        cvb.setIsPopup(isPopup);
        cvb.setContainerMode(componentMode);
        cvb.loadVariables(resourceIDs);
        cvb.generateVariableTree();
        servletInfo.setDestPage(this.getDestPage(cvb));
        servletInfo.setSaveInSession(true);
    }

    private void handleLookAhead(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HashMap variableComponentMap;
        String componentID = ComponentVariablesAction.assertGetParam(request, "componentID");
        String componentMode = request.getParameter("componentMode");
        String resourceList = ComponentVariablesAction.assertGetParam(request, "selected");
        String slotIndex = request.getParameter("index");
        String[] resourceIDs = CSVUtil.splitCSV(resourceList);
        ComponentDescriptor cd = ((ComponentDetailsBean)request.getSession().getAttribute(componentID)).getEditBean().getComponentDescriptor();
        int[] slotIndices = new int[]{};
        if (slotIndex != null && !slotIndex.equals("")) {
            slotIndices = new int[]{Integer.parseInt(slotIndex)};
        }
        if ((variableComponentMap = ComponentVariablesBean.extractVariables(cd, resourceIDs, slotIndices)).keySet().size() > 0) {
            this.handleList(request, servletInfo);
        } else {
            String destPage = componentMode.equals("componentcheckinnew") ? UriUtil.componentAddFromBrowseURI(componentID, resourceIDs[0], "", "") : UriUtil.componentEditCheckinNewVersion(componentID, resourceIDs[0], slotIndex, "", "");
            servletInfo.setDestPage(destPage);
            servletInfo.setShouldRedirect(true);
        }
    }

    private void handleAddFromBrowse(HttpServletRequest request, ServletInfo servletInfo) {
        String componentID = ComponentVariablesAction.assertGetParam(request, "componentID");
        String resourceID = ComponentVariablesAction.assertGetParam(request, "resourceID");
        String varNames = ComponentVariablesAction.assertGetParam(request, "variableName");
        String varValues = ComponentVariablesAction.assertGetParam(request, "variableValue");
        String destPage = UriUtil.componentAddFromBrowseURI(componentID, resourceID, Util.encodeURL(varNames), Util.encodeURL(varValues));
        servletInfo.setDestPage(destPage);
        servletInfo.setShouldRedirect(true);
    }

    private void handleComponentCheckInNewVersion(HttpServletRequest request, ServletInfo servletInfo) {
        String containerID = ComponentVariablesAction.assertGetParam(request, "componentID");
        String resourceID = ComponentVariablesAction.assertGetParam(request, "resourceID");
        String slot = ComponentVariablesAction.assertGetParam(request, "index");
        String varNames = ComponentVariablesAction.assertGetParam(request, "variableName");
        String varValues = ComponentVariablesAction.assertGetParam(request, "variableValue");
        String destPage = UriUtil.componentEditCheckinNewVersion(containerID, resourceID, slot, Util.encodeURL(varNames), Util.encodeURL(varValues));
        servletInfo.setDestPage(destPage);
        servletInfo.setShouldRedirect(true);
    }

    private void handleCancel(HttpServletRequest request, ServletInfo servletInfo) {
        String componentID = ComponentVariablesAction.assertGetParam(request, "componentID");
        String destPage = UriUtil.componentReturnURI(componentID);
        servletInfo.setDestPage(destPage);
        servletInfo.setShouldRedirect(true);
    }

    private void handleRefreshDetails(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentVariablesBean bean = (ComponentVariablesBean)servletInfo.getBean();
        String[] varDefaults = CSVUtil.splitCSV(ComponentVariablesAction.assertGetParam(request, "variableValue"));
        UITree[] trees = bean.getVariableTrees();
        String treeID = ComponentVariablesAction.assertGetParam(request, "treeID");
        for (int i = 0; i < trees.length; ++i) {
            VariableNode node = (VariableNode)trees[i].getRoot();
            node.setValue(varDefaults[i]);
            if (!treeID.equals(trees[i].getID())) continue;
            trees[i].handleRequest(request);
        }
        servletInfo.setDestPage(this.getDestPage(bean));
        servletInfo.setSaveInSession(true);
    }

    public ServletBean createBean(HttpServletRequest request) {
        ComponentVariablesBean bean;
        String mode = ComponentVariablesAction.assertGetParam(request, "mode");
        if (mode.equals("refreshDetails")) {
            String id = request.getParameter("id");
            bean = (ComponentVariablesBean)request.getSession().getAttribute(id);
            if (bean == null) {
                throw new IllegalArgumentException("Expected bean not found in session");
            }
        } else {
            bean = new ComponentVariablesBean();
        }
        return bean;
    }

    public String getDefaultPage() {
        return "/compx/componentVariables.jsp";
    }

    private String getDestPage(ComponentVariablesBean cvb) {
        if (cvb.getIsPopup().equals("true")) {
            return "/compx/componentVariablesPopup.jsp";
        }
        return "/compx/componentVariables.jsp";
    }

    public String getMajorError(HttpServletRequest request) {
        String mode = ComponentVariablesAction.assertGetParam(request, "mode");
        if (mode.equals("list") || mode.equals("lookahead") || mode.equals("cancel") || mode.equals("componentcheckinnew") || mode.equals("componentcheckinnewversion") || mode.equals("refreshDetails")) {
            return MSG_ERROR_VARIABLES;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to " + "ComponentVariablesAction");
    }
}

