/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.message.Severity;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.HttpMultipartRequestWrapper;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.compx.ComponentDetailsBean;
import com.raplix.rolloutexpress.ui.web.compx.ComponentSettingsBean;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public class ComponentSettingsHandleAction
extends UIActionServlet
implements ActionModeConstants {
    private static final String MSG_ERROR_VIEW = "error.components.settings.load";
    private static final String MSG_ERROR_CREATE = "error.components.settings.create";
    private static final String MSG_ERROR_CREATECOPY = "error.components.settings.createcopy";
    private static final String MSG_ERROR_EDIT = "error.components.settings.edit";
    private static final String MSG_ERROR_DELETE = "error.components.settings.delete";
    private static final String MSG_ERROR_SAVE = "error.components.settings.save";
    private static final String MSG_ERROR_IMPORT = "error.components.settings.import";
    private static final String MSG_ERROR_CANCEL = "error.components.settings.cancel";
    private static final String MSG_INFO_IMPORTED_NONE = "info.components.settings.imported.none";
    private static final String MSG_INFO_IMPORTED_ONE = "info.components.settings.imported.one";
    private static final String MSG_INFO_IMPORTED_MULTIPLE = "info.components.settings.imported.multiple";
    private static final String MSG_ERROR_IMPORT_FILE_NOT_FOUND = "error.components.settings.import.filenotfound";
    private static final String MSG_ERROR_IMPORT_INVALID_FILE = "error.components.settings.import.invalidfile";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HttpMultipartRequestWrapper wrapper = this.getMultipartRequestWrapper(request);
        String mode = ComponentSettingsHandleAction.assertGetParam(wrapper, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through ComponentSettingsHandleAction: " + mode, this);
        }
        String isPopupStr = wrapper.getParameter("isPopup");
        ComponentDetailsBean detailsBean = (ComponentDetailsBean)servletInfo.getBean();
        ComponentSettingsBean settingsBean = detailsBean.getSettingsBean();
        settingsBean.setIsPopup(isPopupStr);
        servletInfo.setDestPage(this.getDestPage(settingsBean));
        if (mode.equals("view")) {
            this.handleView(request, servletInfo);
        } else if (mode.equals("create")) {
            this.handleCreate(request, servletInfo);
        } else if (mode.equals("createcopy")) {
            this.handleCreateCopy(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("savenotconfirmed")) {
            this.handleSaveNotConfirmed(request, servletInfo);
        } else if (mode.equals("delete")) {
            this.handleDelete(request, servletInfo);
        } else if (mode.equals("deletenotconfirmed")) {
            this.handleDeleteNotConfirmed(request, servletInfo);
        } else if (mode.equals("deleteconfirmed")) {
            this.handleDeleteConfirmed(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else if (mode.equals("importconfirmed")) {
            this.handleImportFromComponent(request, servletInfo);
        } else if (mode.equals("import")) {
            this.handleImportFromFile(wrapper, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to " + "ComponentSettingsHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        try {
            HttpMultipartRequestWrapper wrapper = this.getMultipartRequestWrapper(request);
            String mode = ComponentSettingsHandleAction.assertGetParam(wrapper, "mode");
            String selectID = wrapper.getParameter("selectID");
            UserManager um = ComponentSettingsHandleAction.getApplication().getUserManager();
            ResourceSubsystem rs = ComponentSettingsHandleAction.getApplication().getResourceSubsystem();
            PlanInterface pi = ComponentSettingsHandleAction.getApplication().getPlanInterface();
            ComponentDetailsBean bean = null;
            if (mode.equals("view") && selectID == null) {
                bean = new ComponentDetailsBean(um, rs, pi);
            } else {
                String id = wrapper.getParameter("componentID");
                bean = (ComponentDetailsBean)request.getSession().getAttribute(id);
                if (bean == null) {
                    throw new IllegalArgumentException("Expected ComponentDetailsBean not found.");
                }
            }
            return bean;
        }
        catch (RaplixException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getDefaultPage() {
        return "/compx/componentSettings.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode;
        try {
            HttpMultipartRequestWrapper wrapper = this.getMultipartRequestWrapper(inRequest);
            mode = ComponentSettingsHandleAction.assertGetParam(wrapper, "mode");
        }
        catch (RaplixException ex) {
            throw new RuntimeException(ex);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through with errors on ComponentSettingsHandleAction: " + mode, this);
        }
        if (mode.equals("view")) {
            return MSG_ERROR_VIEW;
        }
        if (mode.equals("create")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("createcopy")) {
            return MSG_ERROR_CREATECOPY;
        }
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("savenotconfirmed")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("delete")) {
            return MSG_ERROR_DELETE;
        }
        if (mode.equals("deletenotconfirmed")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("deleteconfirmed")) {
            return MSG_ERROR_DELETE;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("importconfirmed")) {
            return MSG_ERROR_IMPORT;
        }
        if (mode.equals("import")) {
            return MSG_ERROR_IMPORT;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to " + "ComponentSettingsHandleAction.");
    }

    private HttpMultipartRequestWrapper getMultipartRequestWrapper(HttpServletRequest request) throws RaplixException {
        HttpMultipartRequestWrapper wrapper;
        try {
            wrapper = HttpMultipartRequestWrapper.wrapRequest(request);
        }
        catch (IOException ioe) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("wrapRequest throwing IOException in ComponentSettingsHandleAction's doUIAction", ioe, this);
            }
            throw new RaplixException(ioe);
        }
        return wrapper;
    }

    private void handleView(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean detailsBean = (ComponentDetailsBean)servletInfo.getBean();
        String isPopupStr = request.getParameter("isPopup");
        String componentID = ComponentSettingsHandleAction.assertGetParam(request, "componentID");
        String selectID = request.getParameter("selectID");
        if (selectID == null) {
            detailsBean.loadMinimalDetails(componentID);
        }
        ComponentSettingsBean settingsBean = detailsBean.getSettingsBean();
        if (selectID == null) {
            settingsBean.loadSettings(componentID);
            settingsBean.setSelectID("");
        } else {
            settingsBean.setSelectID(selectID);
        }
        settingsBean.setIsEditing(false);
        settingsBean.setMode("display");
        settingsBean.setIsPopup(isPopupStr);
        servletInfo.setDestPage(this.getDestPage(settingsBean));
        servletInfo.setShouldRedirect(false);
    }

    private void handleCreate(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean detailsBean = (ComponentDetailsBean)servletInfo.getBean();
        ComponentSettingsBean settingsBean = detailsBean.getSettingsBean();
        if (settingsBean.getIsEditing()) {
            settingsBean.cancelSettingChanges(settingsBean.getSelectID());
        }
        settingsBean.addNewSetting();
        settingsBean.setSelectID("");
        settingsBean.setIsEditing(true);
        settingsBean.setMode("display");
        servletInfo.setDestPage(this.getDestPage(settingsBean));
        servletInfo.setShouldRedirect(false);
    }

    private void handleCreateCopy(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean detailsBean = (ComponentDetailsBean)servletInfo.getBean();
        ComponentSettingsBean settingsBean = detailsBean.getSettingsBean();
        if (settingsBean.getIsEditing()) {
            settingsBean.cancelSettingChanges(settingsBean.getSelectID());
        }
        String selectID = ComponentSettingsHandleAction.assertGetParam(request, "selectID");
        settingsBean.checkEditExistence(selectID);
        settingsBean.addNewSettingCopy(selectID);
        settingsBean.setSelectID("");
        settingsBean.setIsEditing(true);
        settingsBean.setMode("display");
        servletInfo.setDestPage(this.getDestPage(settingsBean));
        servletInfo.setShouldRedirect(false);
    }

    private void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean detailsBean = (ComponentDetailsBean)servletInfo.getBean();
        ComponentSettingsBean settingsBean = detailsBean.getSettingsBean();
        if (settingsBean.getIsEditing()) {
            settingsBean.cancelSettingChanges(settingsBean.getSelectID());
        }
        String selectID = ComponentSettingsHandleAction.assertGetParam(request, "selectID");
        settingsBean.checkEditExistence(selectID);
        settingsBean.saveUpdateCount(selectID);
        settingsBean.setSelectID(selectID);
        settingsBean.setIsEditing(true);
        settingsBean.setMode("display");
        servletInfo.setDestPage(this.getDestPage(settingsBean));
        servletInfo.setShouldRedirect(false);
    }

    private void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean detailsBean = (ComponentDetailsBean)servletInfo.getBean();
        ComponentSettingsBean settingsBean = detailsBean.getSettingsBean();
        String selectID = ComponentSettingsHandleAction.assertGetParam(request, "selectID");
        String name = ComponentSettingsHandleAction.assertGetParam(request, "name");
        String updateCount = ComponentSettingsHandleAction.assertGetParam(request, "updateCount");
        settingsBean.setSelectID(selectID);
        settingsBean.setIsEditing(true);
        String[] values = this.getUserValues(request, settingsBean);
        settingsBean.updateVarSetting(selectID, name, values);
        servletInfo.setDestPage(this.getDestPage(settingsBean));
        servletInfo.setShouldRedirect(false);
        try {
            settingsBean.saveVarSetting(selectID, updateCount);
        }
        catch (ComponentDBException e) {
            if (selectID.equals("")) {
                this.revertUnsavedNewSet(settingsBean, name, values);
            }
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE);
            servletInfo.getErrors().addMinorError(e.getMessage());
            return;
        }
        settingsBean.setSelectID(selectID);
        settingsBean.setIsEditing(false);
    }

    private void handleSaveNotConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean detailsBean = (ComponentDetailsBean)servletInfo.getBean();
        ComponentSettingsBean settingsBean = detailsBean.getSettingsBean();
        String selectID = ComponentSettingsHandleAction.assertGetParam(request, "selectID");
        settingsBean.cancelSettingChanges(selectID);
        settingsBean.setSelectID(selectID);
        settingsBean.setIsEditing(false);
        servletInfo.setDestPage(this.getDestPage(settingsBean));
        servletInfo.setShouldRedirect(false);
    }

    private void handleDelete(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean detailsBean = (ComponentDetailsBean)servletInfo.getBean();
        ComponentSettingsBean settingsBean = detailsBean.getSettingsBean();
        if (settingsBean.getIsEditing()) {
            settingsBean.cancelSettingChanges(settingsBean.getSelectID());
        }
        String selectID = ComponentSettingsHandleAction.assertGetParam(request, "selectID");
        settingsBean.checkDeleteExistence(selectID);
        settingsBean.setSelectID(selectID);
        settingsBean.setIsEditing(true);
        settingsBean.setMode("delete");
        servletInfo.setDestPage(this.getDestPage(settingsBean));
        servletInfo.setShouldRedirect(false);
    }

    private void handleDeleteConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean detailsBean = (ComponentDetailsBean)servletInfo.getBean();
        ComponentSettingsBean settingsBean = detailsBean.getSettingsBean();
        String selectID = ComponentSettingsHandleAction.assertGetParam(request, "selectID");
        settingsBean.deleteVarSetting(selectID);
        settingsBean.setSelectID("");
        settingsBean.setIsEditing(false);
        settingsBean.setMode("display");
        servletInfo.setDestPage(this.getDestPage(settingsBean));
        servletInfo.setShouldRedirect(false);
    }

    private void handleDeleteNotConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean detailsBean = (ComponentDetailsBean)servletInfo.getBean();
        ComponentSettingsBean settingsBean = detailsBean.getSettingsBean();
        String selectID = ComponentSettingsHandleAction.assertGetParam(request, "selectID");
        settingsBean.cancelSettingChanges(selectID);
        settingsBean.setSelectID(selectID);
        settingsBean.setIsEditing(false);
        settingsBean.setMode("display");
        servletInfo.setDestPage(this.getDestPage(settingsBean));
        servletInfo.setShouldRedirect(false);
    }

    private void handleCancel(HttpServletRequest request, ServletInfo servletInfo) {
        ComponentDetailsBean detailsBean = (ComponentDetailsBean)servletInfo.getBean();
        servletInfo.setDestPage(UriUtil.componentDetailsURI(detailsBean.getID()));
        servletInfo.setShouldRedirect(true);
    }

    private void handleImportFromComponent(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean detailsBean = (ComponentDetailsBean)servletInfo.getBean();
        ComponentSettingsBean settingsBean = detailsBean.getSettingsBean();
        String importID = ComponentSettingsHandleAction.assertGetParam(request, "importID");
        String[] importedSettingNames = settingsBean.importSettings(importID);
        this.addImportMessage(servletInfo, importedSettingNames);
        if (importedSettingNames != null && importedSettingNames.length > 0) {
            settingsBean.setSelectForName(importedSettingNames[0]);
        } else {
            settingsBean.setSelectID("");
        }
        settingsBean.setIsEditing(false);
        settingsBean.setMode("display");
        servletInfo.setDestPage(this.getDestPage(settingsBean));
        servletInfo.setShouldRedirect(false);
    }

    private void handleImportFromFile(HttpMultipartRequestWrapper wrapper, ServletInfo servletInfo) throws RaplixException {
        ComponentDetailsBean detailsBean = (ComponentDetailsBean)servletInfo.getBean();
        ComponentSettingsBean settingsBean = detailsBean.getSettingsBean();
        File importFile = wrapper.getParameterLocalFile("importFilePath");
        if (importFile == null) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_IMPORT);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_IMPORT_FILE_NOT_FOUND);
        } else {
            String[] importedSettingNames = settingsBean.importSettings(importFile);
            if (importedSettingNames != null && importedSettingNames.length > 0) {
                this.addImportMessage(servletInfo, importedSettingNames);
                settingsBean.setSelectForName(importedSettingNames[0]);
            } else {
                servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_IMPORT);
                servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_IMPORT_INVALID_FILE);
                settingsBean.setSelectID("");
            }
        }
        settingsBean.setIsEditing(false);
        settingsBean.setMode("display");
        servletInfo.setDestPage(this.getDestPage(settingsBean));
        servletInfo.setShouldRedirect(false);
    }

    private String[] getUserValues(HttpServletRequest request, ComponentSettingsBean settingsBean) {
        MultiCheckbox mc = new MultiCheckbox("bulk", request);
        int length = settingsBean.getVariableNames().length;
        String[] values = new String[length];
        for (int i = 0; i < length; ++i) {
            if (!mc.getChecked(i)) continue;
            values[i] = request.getParameter("value" + i);
        }
        return values;
    }

    private String getDestPage(ComponentSettingsBean settingsBean) {
        if (settingsBean.getIsPopup().equals("true")) {
            return "/compx/componentSettingsPopup.jsp";
        }
        return "/compx/componentSettings.jsp";
    }

    private void revertUnsavedNewSet(ComponentSettingsBean settingsBean, String name, String[] values) throws RaplixException {
        settingsBean.removeUnsavedNewSet();
        settingsBean.addNewSetting();
        settingsBean.updateVarSetting("", name, values);
    }

    private void addImportMessage(ServletInfo servletInfo, String[] importedSettingNames) {
        if (importedSettingNames == null || importedSettingNames.length == 0) {
            servletInfo.getErrors().addMinorErrorKey(MSG_INFO_IMPORTED_NONE, Severity.INFO);
        } else if (importedSettingNames.length == 1) {
            servletInfo.getErrors().addMinorErrorKey(MSG_INFO_IMPORTED_ONE, (Object)("\"" + importedSettingNames[0] + "\""), Severity.INFO);
        } else {
            StringBuffer nameList = new StringBuffer("\"" + importedSettingNames[0] + "\"");
            for (int i = 1; i < importedSettingNames.length; ++i) {
                nameList.append(", ");
                nameList.append("\"" + importedSettingNames[i] + "\"");
            }
            servletInfo.getErrors().addMinorErrorKey(MSG_INFO_IMPORTED_MULTIPLE, (Object)nameList.toString(), Severity.INFO);
        }
    }
}

