/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsID;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentVariableSettingsQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentVariableSettingsQuery;
import com.raplix.rolloutexpress.ui.componentdb.converters.ComponentVariableSettingsMap;
import com.raplix.rolloutexpress.ui.componentdb.converters.ComponentVariableSettingsMap2String;
import com.raplix.rolloutexpress.ui.web.LoggedOnServlet;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.HTMLEscape;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComponentSettingsDownloadAction
extends LoggedOnServlet {
    private static final String MSG_ERROR_MAJOR = "error.components.settings.download";

    public void executeServlet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            ComponentVariableSettingsMap exportTable;
            PrintWriter out;
            String mode = request.getParameter("mode");
            String id = request.getParameter("id");
            String compId = null;
            if (id == null) {
                compId = ComponentSettingsDownloadAction.assertGetParam(request, "componentID");
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Trying to retrieve all component variable settings for component with id:" + compId, this);
                }
            } else if (Logger.isDebugEnabled(this)) {
                Logger.debug("Trying to retrieve component variable settings with id:" + id, this);
            }
            if (mode != null && mode.equals("filenameaddeddownload")) {
                ComponentVariableSettings[] vss;
                if (id == null) {
                    ComponentID cid = new ComponentID(compId);
                    MultiComponentVariableSettingsQuery mcvsq = cid.getVariableSettingsQuery();
                    vss = mcvsq.select();
                } else {
                    ComponentVariableSettingsID sid = new ComponentVariableSettingsID(id);
                    SingleComponentVariableSettingsQuery scvsq = sid.getByIDQuery();
                    ComponentVariableSettings vs = scvsq.select();
                    vss = new ComponentVariableSettings[]{vs};
                }
                response.setContentType("application/octet-stream; charset=UTF-8");
                out = response.getWriter();
                exportTable = new ComponentVariableSettingsMap();
                for (int i = 0; i < vss.length; ++i) {
                    Hashtable<String, String> varTable = new Hashtable<String, String>();
                    String[] varNames = vss[i].getOverrideVarNames();
                    if (varNames != null) {
                        for (int j = 0; j < varNames.length; ++j) {
                            String value = vss[i].getOverrideVarValue(varNames[j]);
                            if (value == null) continue;
                            varTable.put(varNames[j], value);
                        }
                    }
                    exportTable.put(vss[i].getName(), varTable);
                }
            } else {
                String idParam;
                String filename;
                if (id == null) {
                    ComponentID cid = new ComponentID(compId);
                    SingleComponentQuery scq = cid.getByIDQuery();
                    Component comp = scq.select();
                    filename = comp.getName() + '-' + comp.getVersionNumber().getAsString() + "-all";
                    idParam = "componentID=" + compId;
                } else {
                    ComponentVariableSettingsID sid = new ComponentVariableSettingsID(id);
                    SingleComponentVariableSettingsQuery scvsq = sid.getByIDQuery();
                    ComponentVariableSettings vs = scvsq.select();
                    String componentName = vs.getComponent().getName() + '-' + vs.getComponent().getVersionNumber().getAsString();
                    String componentVariableSettingsName = vs.getName();
                    filename = componentName + '-' + componentVariableSettingsName;
                    idParam = "id=" + id;
                }
                String redirectAddress = "/VariableSettingsDownload/" + HTMLEscape.getGlobalInstance().escape(filename) + ".txt?" + idParam + "&" + "mode" + "=" + "filenameaddeddownload";
                response.sendRedirect(redirectAddress);
                return;
            }
            out.println(ComponentSettingsDownloadAction.formatOutput(ComponentVariableSettingsMap2String.convert(exportTable)));
        }
        catch (RaplixException e) {
            ServletErrors errors = new ServletErrors();
            Logger.debug("Exception caught in ComponentSettingsDownloadAction: " + e.getMessage(), e, this);
            errors.setMajorErrorKey(MSG_ERROR_MAJOR);
            errors.addMinorError(e.getMessage());
            request.setAttribute("error.location", (Object)errors);
            this.forwardRequest(request, response, "/errorhome.jsp");
        }
    }

    private static String formatOutput(String str) {
        StringBuffer result = new StringBuffer();
        int next = 0;
        while (next < str.length()) {
            int index1 = str.indexOf(123, next);
            int index2 = str.indexOf(125, index1 + 1);
            if (result.length() > 0) {
                result.append(";\n");
            }
            result.append(str.substring(next, index1));
            result.append("{\n");
            String varList = str.substring(index1 + 1, index2);
            String[] vars = varList.split(";");
            for (int i = 0; i < vars.length; ++i) {
                if (i > 0) {
                    result.append(";\n");
                }
                result.append("  ");
                result.append(vars[i]);
            }
            result.append("\n}");
            next = index2 + 2;
        }
        return result.toString();
    }
}

