/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsID;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentVariableSettingsQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentVariableSettingsQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.ui.componentdb.converters.ComponentVariableSettingsMap;
import com.raplix.rolloutexpress.ui.componentdb.converters.String2ComponentVariableSettingsMap;
import com.raplix.util.ArrayEdit;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.string.StringUtil;
import com.raplix.util.unicode.UnicodeFileReader;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;

public class ComponentSettingsBean {
    private String mMode = "";
    private String mSelectID = "";
    private int mUpdateCount = -1;
    private boolean mIsEditing = false;
    private boolean mIsPopup = false;
    public static final String NO_SELECT_SET = "";
    private String[] mVariableNames = new String[0];
    private String[] mVariablePrompts = new String[0];
    private String[] mDefaultValues = new String[0];
    private boolean[] mIsReadOnlyVariables = new boolean[0];
    private String[] mVariableSetNames = new String[0];
    private String[] mVariableSetIDs = new String[0];
    private String[] mSelectedVariableSetValues = new String[0];
    private boolean[] mSelectedVariableSetHighlights = new boolean[0];
    private ComponentVariableSettings[] mSettings = null;
    private Component mComponent = null;

    public String getMode() {
        return this.mMode;
    }

    public String getSelectID() {
        return this.mSelectID;
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    public boolean getIsEditing() {
        return this.mIsEditing;
    }

    public String[] getVariableNames() {
        return this.mVariableNames;
    }

    public String[] getVariablePrompts() {
        return this.mVariablePrompts;
    }

    public String[] getDefaultValues() {
        return this.mDefaultValues;
    }

    public boolean[] getIsReadOnlyVariables() {
        return this.mIsReadOnlyVariables;
    }

    public String[] getVariableSetNames() {
        return this.mVariableSetNames;
    }

    public String[] getVariableSetIDs() {
        return this.mVariableSetIDs;
    }

    public String getIsPopup() {
        return this.mIsPopup ? "true" : "false";
    }

    public String[] getSelectedVariableSetValues() {
        return this.mSelectedVariableSetValues;
    }

    public boolean[] getSelectedVariableSetHighlights() {
        return this.mSelectedVariableSetHighlights;
    }

    public int getSelectIDIndex() {
        for (int i = 0; i < this.mVariableSetIDs.length; ++i) {
            if (!this.mVariableSetIDs[i].equals(this.mSelectID)) continue;
            return i;
        }
        return -1;
    }

    public void setMode(String str) {
        this.mMode = str;
    }

    public void setSelectID(String str) {
        if (!this.mSelectID.equals(str)) {
            this.regenerateSelectedValueOutputArrays(this.getSettingsIndexFromID(str));
            this.mSelectID = str;
        }
    }

    public void setIsEditing(boolean val) {
        this.mIsEditing = val;
    }

    public void setIsPopup(String in) {
        this.mIsPopup = in != null && in.equals("true");
    }

    public void setSelectForName(String name) {
        for (int i = 0; i < this.mVariableSetNames.length; ++i) {
            if (!this.mVariableSetNames[i].equals(name)) continue;
            this.setSelectID(this.mVariableSetIDs[i]);
            break;
        }
    }

    public void loadSettings(String componentID) throws RaplixException {
        ComponentID cid = new ComponentID(componentID);
        SingleComponentQuery scq = cid.getByIDQuery();
        this.mComponent = scq.select();
        MultiComponentVariableSettingsQuery mcvsq = cid.getVariableSettingsQuery();
        this.mSettings = mcvsq.select();
        this.generateOutputArrays();
    }

    public void addNewSetting() throws RaplixException {
        ComponentVariableSettings cvs = new ComponentVariableSettings(this.mComponent.getID());
        cvs.setName(NO_SELECT_SET);
        this.insertNewCVS(cvs);
        this.generateOutputArrays();
    }

    public void addNewSettingCopy(String selectID) throws RaplixException {
        int settingsIndex = this.getSettingsIndexFromID(selectID);
        ComponentVariableSettings cvs = this.mSettings[settingsIndex];
        ComponentVariableSettings newCvs = new ComponentVariableSettings(this.mComponent.getID());
        newCvs.setName(NO_SELECT_SET);
        for (int i = 0; i < this.mVariableNames.length; ++i) {
            if (!cvs.containsOverrideVarValue(this.mVariableNames[i])) continue;
            newCvs.setOverrideVarValue(this.mVariableNames[i], cvs.getVarValue(this.mVariableNames[i]));
        }
        this.insertNewCVS(newCvs);
        this.generateOutputArrays();
    }

    public void updateVarSetting(String editID, String name, String[] values) {
        int settingsIndex = this.getSettingsIndexFromID(editID);
        ComponentVariableSettings cvs = this.mSettings[settingsIndex];
        cvs.setName(name);
        for (int i = 0; i < this.mVariableNames.length; ++i) {
            if (values[i] != null) {
                cvs.setOverrideVarValue(this.mVariableNames[i], values[i]);
                continue;
            }
            cvs.removeOverrideVarValue(this.mVariableNames[i]);
        }
        this.regenerateSelectedValueOutputArrays(settingsIndex);
    }

    public void saveVarSetting(String editID, String updateCount) throws RaplixException {
        int settingsIndex = this.getSettingsIndexFromID(editID);
        ComponentVariableSettings cvs = this.mSettings[settingsIndex];
        cvs.setUpdateCount(new Integer(updateCount));
        cvs.save();
        this.generateNameOutputArrays();
    }

    public void cancelSettingChanges(String editID) throws RaplixException {
        int settingsIndex = this.getSettingsIndexFromID(editID);
        ComponentVariableSettings cvs = this.mSettings[settingsIndex];
        if (cvs.getID() != null) {
            ComponentVariableSettingsID cvsID = cvs.getID();
            SingleComponentVariableSettingsQuery scvsq = cvsID.getByIDQuery();
            this.mSettings[settingsIndex] = scvsq.select();
            this.regenerateSelectedValueOutputArrays(settingsIndex);
        } else {
            this.removeCVS(settingsIndex);
            this.generateOutputArrays();
        }
    }

    public void deleteVarSetting(String editID) throws RaplixException {
        ComponentVariableSettings cvs;
        int settingsIndex = this.getSettingsIndexFromID(editID);
        if (settingsIndex == -1) {
            ComponentVariableSettingsID cvsID = new ComponentVariableSettingsID(editID);
            cvsID.delete();
        }
        if ((cvs = this.mSettings[settingsIndex]).getID() != null) {
            cvs.getID().delete();
        }
        this.removeCVS(settingsIndex);
        this.generateOutputArrays();
    }

    public void checkDeleteExistence(String editID) throws RaplixException {
        int settingsIndex = this.getSettingsIndexFromID(editID);
        if (settingsIndex == -1) {
            ComponentVariableSettingsID cvsID = new ComponentVariableSettingsID(editID);
            cvsID.delete();
        }
    }

    public void checkEditExistence(String editID) throws RaplixException {
        int settingsIndex = this.getSettingsIndexFromID(editID);
        if (settingsIndex == -1) {
            ComponentVariableSettingsID cvsID = new ComponentVariableSettingsID(editID);
            SingleComponentVariableSettingsQuery scvsq = cvsID.getByIDQuery();
            scvsq.select();
        }
    }

    public void saveUpdateCount(String editID) {
        int settingsIndex = this.getSettingsIndexFromID(editID);
        if (settingsIndex != -1) {
            ComponentVariableSettings cvs = this.mSettings[settingsIndex];
            this.mUpdateCount = cvs.getUpdateCount();
        }
    }

    public String[] importSettings(String importID) throws RaplixException {
        ComponentID cid = this.mComponent.getID();
        String[] importedSettingNames = cid.importVariableSettings(new ComponentID(importID));
        MultiComponentVariableSettingsQuery mcvsq = cid.getVariableSettingsQuery();
        this.mSettings = mcvsq.select();
        this.generateOutputArrays();
        return importedSettingNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] importSettings(File importFile) throws RaplixException {
        ComponentVariableSettingsMap varsetTable = null;
        try {
            UnicodeFileReader reader = null;
            try {
                reader = new UnicodeFileReader(importFile, "utf-8");
                StringWriter writer = new StringWriter();
                CopyUtil.copyText(reader, writer);
                varsetTable = String2ComponentVariableSettingsMap.convert(writer.toString());
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException ex) {
            throw new RaplixException(ex);
        }
        if (varsetTable != null) {
            ComponentID cid = this.mComponent.getID();
            String[] importedSettingNames = cid.importVariableSettings(varsetTable);
            MultiComponentVariableSettingsQuery mcvsq = cid.getVariableSettingsQuery();
            this.mSettings = mcvsq.select();
            this.generateOutputArrays();
            return importedSettingNames;
        }
        return null;
    }

    public void removeUnsavedNewSet() {
        this.removeCVS(0);
    }

    private void generateOutputArrays() {
        VarDecl[] compVars = this.mComponent.getVarList(CallSpec.PUBLIC);
        int numVars = compVars.length;
        this.mVariableNames = new String[numVars];
        this.mVariablePrompts = new String[numVars];
        this.mDefaultValues = new String[numVars];
        this.mIsReadOnlyVariables = new boolean[numVars];
        for (int i = 0; i < numVars; ++i) {
            this.mVariableNames[i] = compVars[i].getName();
            this.mVariablePrompts[i] = StringUtil.normalizeEmpty(compVars[i].getPrompt());
            this.mDefaultValues[i] = StringUtil.normalizeEmpty(compVars[i].getDefaultValue());
            this.mIsReadOnlyVariables[i] = false;
            if (!compVars[i].getModifier().equals(Modifier.FINAL)) continue;
            this.mIsReadOnlyVariables[i] = true;
        }
        this.generateNameOutputArrays();
        this.regenerateSelectedValueOutputArrays(0);
    }

    private void regenerateSelectedValueOutputArrays(int index) {
        if (index < 0 || index >= this.mSettings.length) {
            return;
        }
        String[] values = new String[this.mVariableNames.length];
        boolean[] highlights = new boolean[this.mVariableNames.length];
        ComponentVariableSettings cvs = this.mSettings[index];
        this.mVariableSetNames[index] = cvs.getName();
        for (int j = 0; j < this.mVariableNames.length; ++j) {
            if (cvs.containsOverrideVarValue(this.mVariableNames[j])) {
                values[j] = cvs.getVarValue(this.mVariableNames[j]);
                highlights[j] = true;
                continue;
            }
            values[j] = this.mDefaultValues[j];
            highlights[j] = false;
        }
        this.mSelectedVariableSetValues = values;
        this.mSelectedVariableSetHighlights = highlights;
    }

    private void generateNameOutputArrays() {
        this.mVariableSetNames = new String[this.mSettings.length];
        this.mVariableSetIDs = new String[this.mSettings.length];
        for (int i = 0; i < this.mSettings.length; ++i) {
            this.mVariableSetNames[i] = this.mSettings[i].getName();
            this.mVariableSetIDs[i] = this.mSettings[i].getID() != null ? this.mSettings[i].getID().toString() : NO_SELECT_SET;
        }
    }

    private void insertNewCVS(ComponentVariableSettings cvs) {
        Object[] newCvsArray = new ComponentVariableSettings[]{};
        newCvsArray = (ComponentVariableSettings[])ArrayEdit.add(newCvsArray, cvs);
        newCvsArray = (ComponentVariableSettings[])ArrayEdit.addMultiple(newCvsArray, this.mSettings);
        this.mSettings = newCvsArray;
    }

    private void removeCVS(int index) {
        this.mSettings = (ComponentVariableSettings[])ArrayEdit.removeElementAt(this.mSettings, index);
    }

    private int getSettingsIndexFromID(String cvsID) {
        for (int i = 0; i < this.mSettings.length; ++i) {
            if ((this.mSettings[i].getID() == null || !this.mSettings[i].getID().toString().equals(cvsID)) && (this.mSettings[i].getID() != null || !cvsID.equals(NO_SELECT_SET))) continue;
            return i;
        }
        return -1;
    }
}

