/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.Dependency;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentOrder;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiDependencyQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypesListBean;
import com.raplix.util.string.StringUtil;

public class ComponentRelationshipsBean
extends ServletListBean {
    private String mInstalledComponentID = "";
    private String mCaller = "";
    private String mComponentID = "";
    private String mComponentName = "";
    private String mComponentInstallPath = "";
    private boolean mIsSentinelTaskID = false;
    private String mPlanName = "";
    private String mPlanID = "";
    private String mTaskID = "";
    private String mGeneratedVarSettingID = "";
    private String mHostID = "";
    private String mHostName = "";
    private String mHostDescription = "";
    private String mHostType = "";
    private String mHostPhysicality = "";
    private String mTargetableInstCompName = null;
    private String mTargetableInstCompID = null;
    private String mTargetableHostName = null;
    private String mTargetableHostID = null;
    private String[] mDependsOnDependencyNames = new String[0];
    private String[] mDependsOnComponentIDs = new String[0];
    private String[] mDependsOnComponentNames = new String[0];
    private String[] mDependsOnComponentVersions = new String[0];
    private String[] mDependsOnInstalledComponentIDs = new String[0];
    private String[] mDependsOnTaskIDs = new String[0];
    private String[] mOthersDependDependencyNames = new String[0];
    private String[] mOthersDependComponentIDs = new String[0];
    private String[] mOthersDependComponentNames = new String[0];
    private String[] mOthersDependComponentVersions = new String[0];
    private String[] mOthersDependInstalledComponentIDs = new String[0];
    private String[] mOthersDependTaskIDs = new String[0];
    private String mPartOfComponentID = "";
    private String mPartOfComponentName = "";
    private String mPartOfInstalledComponentID = "";
    private String mPartOfTaskID = "";
    private String[] mRefCompIDs = new String[0];
    private String[] mRefCompNames = new String[0];
    private String[] mRefCompVersions = new String[0];
    private String[] mRefCompTypes = new String[0];
    private String[] mRefCompInstallPaths = new String[0];
    private String[] mRefCompInstalledDates = new String[0];
    private String[] mRefInstalledCompIDs = new String[0];
    private String[] mRefCompTaskIDs = new String[0];
    private String[] mRefCompInstalledByPlans = new String[0];
    private String[] mRefCompInstalledByUsers = new String[0];
    private String[] mRefCompPlanIDs = new String[0];
    private String[] mHostCompIDs = new String[0];
    private String[] mHostCompNames = new String[0];
    private String[] mHostCompVersions = new String[0];
    private String[] mHostCompTypes = new String[0];
    private String[] mHostCompInstallPaths = new String[0];
    private String[] mHostCompInstalledDates = new String[0];
    private String[] mHostInstalledCompIDs = new String[0];
    private String[] mHostCompTaskIDs = new String[0];
    private String[] mHostCompInstalledByPlans = new String[0];
    private String[] mHostCompInstalledByUsers = new String[0];
    private String[] mHostCompPlanIDs = new String[0];

    public String getID() {
        return this.mInstalledComponentID;
    }

    public String getCaller() {
        return this.mCaller;
    }

    public String getComponentID() {
        return this.mComponentID;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public String getComponentInstallPath() {
        return this.mComponentInstallPath;
    }

    public boolean getIsSentinelTaskID() {
        return this.mIsSentinelTaskID;
    }

    public String getPlanID() {
        return this.mPlanID;
    }

    public String getPlanName() {
        return this.mPlanName;
    }

    public String getTaskID() {
        return this.mTaskID;
    }

    public String getGeneratedVarSettingID() {
        return this.mGeneratedVarSettingID;
    }

    public String getHostID() {
        return this.mHostID;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public String getHostDescription() {
        return this.mHostDescription;
    }

    public String getHostType() {
        return this.mHostType;
    }

    public String getHostPhysicality() {
        return this.mHostPhysicality;
    }

    public String getTargetableInstCompName() {
        return this.mTargetableInstCompName;
    }

    public String getTargetableInstCompID() {
        return this.mTargetableInstCompID;
    }

    public String getTargetableHostName() {
        return this.mTargetableHostName;
    }

    public String getTargetableHostID() {
        return this.mTargetableHostID;
    }

    public String[] getDependsOnDependencyNames() {
        return this.mDependsOnDependencyNames;
    }

    public String[] getDependsOnComponentIDs() {
        return this.mDependsOnComponentIDs;
    }

    public String[] getDependsOnComponentNames() {
        return this.mDependsOnComponentNames;
    }

    public String[] getDependsOnComponentVersions() {
        return this.mDependsOnComponentVersions;
    }

    public String[] getDependsOnInstalledComponentIDs() {
        return this.mDependsOnInstalledComponentIDs;
    }

    public String[] getDependsOnTaskIDs() {
        return this.mDependsOnTaskIDs;
    }

    public String[] getOthersDependDependencyNames() {
        return this.mOthersDependDependencyNames;
    }

    public String[] getOthersDependComponentIDs() {
        return this.mOthersDependComponentIDs;
    }

    public String[] getOthersDependComponentNames() {
        return this.mOthersDependComponentNames;
    }

    public String[] getOthersDependComponentVersions() {
        return this.mOthersDependComponentVersions;
    }

    public String[] getOthersDependInstalledComponentIDs() {
        return this.mOthersDependInstalledComponentIDs;
    }

    public String[] getOthersDependTaskIDs() {
        return this.mOthersDependTaskIDs;
    }

    public String getPartOfComponentID() {
        return this.mPartOfComponentID;
    }

    public String getPartOfComponentName() {
        return this.mPartOfComponentName;
    }

    public String getPartOfInstalledComponentID() {
        return this.mPartOfInstalledComponentID;
    }

    public String getPartOfTaskID() {
        return this.mPartOfTaskID;
    }

    public String[] getRefCompIDs() {
        return this.mRefCompIDs;
    }

    public String[] getRefCompNames() {
        return this.mRefCompNames;
    }

    public String[] getRefCompVersions() {
        return this.mRefCompVersions;
    }

    public String[] getRefCompTypes() {
        return this.mRefCompTypes;
    }

    public String[] getRefCompInstallPaths() {
        return this.mRefCompInstallPaths;
    }

    public String[] getRefCompInstalledDates() {
        return this.mRefCompInstalledDates;
    }

    public String[] getRefInstalledCompIDs() {
        return this.mRefInstalledCompIDs;
    }

    public String[] getRefCompTaskIDs() {
        return this.mRefCompTaskIDs;
    }

    public String[] getRefCompInstalledByPlans() {
        return this.mRefCompInstalledByPlans;
    }

    public String[] getRefCompInstalledByUsers() {
        return this.mRefCompInstalledByUsers;
    }

    public String[] getRefCompPlanIDs() {
        return this.mRefCompPlanIDs;
    }

    public String[] getHostCompIDs() {
        return this.mHostCompIDs;
    }

    public String[] getHostCompNames() {
        return this.mHostCompNames;
    }

    public String[] getHostCompVersions() {
        return this.mHostCompVersions;
    }

    public String[] getHostCompTypes() {
        return this.mHostCompTypes;
    }

    public String[] getHostCompInstallPaths() {
        return this.mHostCompInstallPaths;
    }

    public String[] getHostCompInstalledDates() {
        return this.mHostCompInstalledDates;
    }

    public String[] getHostInstalledCompIDs() {
        return this.mHostInstalledCompIDs;
    }

    public String[] getHostCompTaskIDs() {
        return this.mHostCompTaskIDs;
    }

    public String[] getHostCompInstalledByPlans() {
        return this.mHostCompInstalledByPlans;
    }

    public String[] getHostCompInstalledByUsers() {
        return this.mHostCompInstalledByUsers;
    }

    public String[] getHostCompPlanIDs() {
        return this.mHostCompPlanIDs;
    }

    public void setCaller(String inValue) {
        this.mCaller = inValue;
    }

    public void setInstalledComponentID(String inValue) {
        this.mInstalledComponentID = inValue;
    }

    public void generateList() throws RaplixException {
        int i;
        InstalledComponentID icID = new InstalledComponentID(this.mInstalledComponentID);
        InstalledComponentBean bean = new InstalledComponentBean(icID);
        InstalledComponent ic = bean.getInstalledComponent();
        ComponentID cid = ic.getComponentID();
        SingleComponentQuery scq = cid.getByIDQuery();
        SummaryComponent sc = scq.selectSummaryView();
        this.mComponentID = cid.toString();
        this.mComponentName = sc.getFullName();
        this.mComponentInstallPath = bean.getComponentRAInstallPath();
        this.mIsSentinelTaskID = TaskID.TASK_SENTINEL_ID.equals(bean.getTaskID());
        this.mPlanName = bean.getExecutionPlan().getFullName();
        this.mPlanID = bean.getExecutionPlanID().toString();
        this.mTaskID = bean.getTaskID().toString();
        this.mGeneratedVarSettingID = bean.getGeneratedVariableSettingsID().toString();
        HostID hID = ic.getTargetID().getByIDQuery().selectSummaryView().getCurrentHostID();
        SummaryHost sh = hID.getByIDQuery().selectSummaryView();
        this.mHostID = hID.toString();
        this.mHostName = sh.getName();
        this.mHostDescription = sh.getDescription();
        this.mHostType = sh.getHostTypeID().getByIDQuery().selectSummaryView().getName();
        String string = this.mHostPhysicality = sh.isVirtual() ? "virtual" : "physical";
        if (sh.getInstalledComponentID() != null) {
            InstalledComponent targetComp = sh.getInstalledComponentID().getByIDQuery().select();
            this.mTargetableInstCompID = targetComp.getComponentID().toString();
            SingleComponentQuery tscq = targetComp.getComponentID().getByIDQuery();
            SummaryComponent targetableInstComp = tscq.selectSummaryView();
            this.mTargetableInstCompName = targetableInstComp.getFullName();
        }
        SummaryHost targetHost = null;
        try {
            targetHost = SingleHostQuery.byInstalledComponentID(icID).selectSummaryView();
            this.mTargetableHostName = targetHost.getName();
            this.mTargetableHostID = targetHost.getID().toString();
        }
        catch (NoResultsFoundException e) {
            // empty catch block
        }
        Dependency[] d = MultiDependencyQuery.byDependenciesCreatedBy(icID).select();
        this.mDependsOnDependencyNames = new String[d.length];
        this.mDependsOnComponentIDs = new String[d.length];
        this.mDependsOnComponentNames = new String[d.length];
        this.mDependsOnComponentVersions = new String[d.length];
        this.mDependsOnInstalledComponentIDs = new String[d.length];
        this.mDependsOnTaskIDs = new String[d.length];
        for (i = 0; i < d.length; ++i) {
            InstalledComponentID dependeeICompID = d[i].getDependeeInstalledComponentID();
            InstalledComponent dependeeIComp = dependeeICompID.getByIDQuery().select();
            ComponentID cID = dependeeIComp.getComponentID();
            SummaryComponent dsc = cID.getByIDQuery().selectSummaryView();
            this.mDependsOnDependencyNames[i] = d[i].getName();
            this.mDependsOnComponentIDs[i] = cID.toString();
            this.mDependsOnComponentNames[i] = dsc.getFullName();
            this.mDependsOnComponentVersions[i] = dsc.getVersionNumber().getAsString();
            this.mDependsOnInstalledComponentIDs[i] = dependeeICompID.toString();
            this.mDependsOnTaskIDs[i] = dependeeIComp.getTaskID().toString();
        }
        Dependency[] od = MultiDependencyQuery.byDependantsOf(icID).select();
        this.mOthersDependDependencyNames = new String[od.length];
        this.mOthersDependComponentIDs = new String[od.length];
        this.mOthersDependComponentNames = new String[od.length];
        this.mOthersDependComponentVersions = new String[od.length];
        this.mOthersDependInstalledComponentIDs = new String[od.length];
        this.mOthersDependTaskIDs = new String[od.length];
        for (i = 0; i < od.length; ++i) {
            InstalledComponentID dependantICompID = od[i].getDependantInstalledComponentID();
            InstalledComponent dependantIComp = dependantICompID.getByIDQuery().select();
            ComponentID cID = dependantIComp.getComponentID();
            SummaryComponent odsc = cID.getByIDQuery().selectSummaryView();
            this.mOthersDependDependencyNames[i] = od[i].getName();
            this.mOthersDependComponentIDs[i] = cID.toString();
            this.mOthersDependComponentNames[i] = odsc.getFullName();
            this.mOthersDependComponentVersions[i] = odsc.getVersionNumber().getAsString();
            this.mOthersDependInstalledComponentIDs[i] = dependantICompID.toString();
            this.mOthersDependTaskIDs[i] = dependantIComp.getTaskID().toString();
        }
        InstalledComponentID parentID = ic.getParentContainerID();
        if (parentID != null) {
            InstalledComponent parent = parentID.getByIDQuery().select();
            ComponentID parentComponentID = parent.getComponentID();
            this.mPartOfComponentID = parentComponentID.toString();
            this.mPartOfComponentName = parentComponentID.getByIDQuery().selectSummaryView().getFullName();
            this.mPartOfInstalledComponentID = parentID.toString();
            this.mPartOfTaskID = parent.getTaskID().toString();
        }
        MultiInstalledComponentQuery micq = MultiInstalledComponentQuery.byParentContainer(icID);
        InstalledComponentOrder sortOrder = InstalledComponentOrder.BY_DATE_ASC;
        this.prepQuery(micq, sortOrder);
        InstalledComponentBean[] installedComponents = micq.select();
        int size = installedComponents.length;
        this.mRefCompIDs = new String[size];
        this.mRefCompNames = new String[size];
        this.mRefCompVersions = new String[size];
        this.mRefCompTypes = new String[size];
        this.mRefCompInstallPaths = new String[size];
        this.mRefCompTaskIDs = new String[size];
        this.mRefCompInstalledDates = new String[size];
        this.mRefInstalledCompIDs = new String[size];
        this.mRefCompInstalledByPlans = new String[size];
        this.mRefCompInstalledByUsers = new String[size];
        this.mRefCompPlanIDs = new String[size];
        for (i = 0; i < size; ++i) {
            InstalledComponentBean icb = installedComponents[i];
            this.mRefCompIDs[i] = icb.getComponentID().toString();
            this.mRefCompNames[i] = icb.getComponent().getFullName();
            this.mRefCompVersions[i] = icb.getComponent().getVersionNumber().getAsString();
            this.mRefCompTypes[i] = ComponentTypesListBean.normalizeName(icb.getComponent().getExtendsTypeName());
            this.mRefCompInstallPaths[i] = StringUtil.normalizeEmpty(icb.getComponentRAInstallPath());
            this.mRefCompTaskIDs[i] = icb.getTaskID().toString();
            this.mRefCompInstalledDates[i] = Util.formatDate(icb.getDate());
            this.mRefInstalledCompIDs[i] = icb.getInstalledComponentID().toString();
            this.mRefCompInstalledByPlans[i] = icb.getExecutionPlan().getFullName();
            this.mRefCompInstalledByUsers[i] = icb.getUsername();
            this.mRefCompPlanIDs[i] = icb.getExecutionPlanID().toString();
        }
        if (targetHost != null) {
            MultiInstalledComponentQuery query = MultiInstalledComponentQuery.byHost(targetHost.getID(), TargetType.CURRENT);
            InstalledComponentBean[] hostComponents = query.select();
            size = hostComponents.length;
            this.mHostCompIDs = new String[size];
            this.mHostCompNames = new String[size];
            this.mHostCompVersions = new String[size];
            this.mHostCompTypes = new String[size];
            this.mHostCompInstallPaths = new String[size];
            this.mHostCompTaskIDs = new String[size];
            this.mHostCompInstalledDates = new String[size];
            this.mHostInstalledCompIDs = new String[size];
            this.mHostCompInstalledByPlans = new String[size];
            this.mHostCompInstalledByUsers = new String[size];
            this.mHostCompPlanIDs = new String[size];
            for (i = 0; i < size; ++i) {
                InstalledComponentBean icb = hostComponents[i];
                this.mHostCompIDs[i] = icb.getComponentID().toString();
                this.mHostCompNames[i] = icb.getComponent().getFullName();
                this.mHostCompVersions[i] = icb.getComponent().getVersionNumber().getAsString();
                this.mHostCompTypes[i] = ComponentTypesListBean.normalizeName(icb.getComponent().getExtendsTypeName());
                this.mHostCompInstallPaths[i] = StringUtil.normalizeEmpty(icb.getComponentRAInstallPath());
                this.mHostCompTaskIDs[i] = icb.getTaskID().toString();
                this.mHostCompInstalledDates[i] = Util.formatDate(icb.getDate());
                this.mHostInstalledCompIDs[i] = icb.getInstalledComponentID().toString();
                this.mHostCompInstalledByPlans[i] = icb.getExecutionPlan().getFullName();
                this.mHostCompInstalledByUsers[i] = icb.getUsername();
                this.mHostCompPlanIDs[i] = icb.getExecutionPlanID().toString();
            }
        }
    }
}

