/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.compx.ComponentDetailsBean;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypesListBean;
import java.util.Vector;

public class ComponentNode
extends UITreeNode {
    private String mID = "";
    private String mPath = "";
    private String mName = "";
    private String mComponentType = "";
    private String mVersion = "";
    private String mSource = "";
    private int mCriticalityLevel = 0;
    private ComponentRefDecl[] mResources = new ComponentRefDecl[0];
    private boolean mEditStyle = false;
    private String mPrefix = "";
    private String mSuffix = "";

    public ComponentNode(boolean editStyle) {
        this.mEditStyle = editStyle;
    }

    public void loadComponent(Component c) throws RaplixException {
        this.mType = c.isSimpleComponent() ? UITreeNodeType.LEAF : (c.getCompRefList(null).length > 0 ? UITreeNodeType.BRANCH_CLOSED : UITreeNodeType.BRANCH_EMPTY);
        this.mID = c.getObjectID().toString();
        this.mName = c.getName();
        this.mComponentType = ComponentTypesListBean.normalizeName(c.getExtendsType());
        this.mPath = c.getPath().getFullPathString();
        this.mVersion = c.getVersionNumber().getAsString();
        this.mSource = ComponentDetailsBean.generateComponentSource(c.getSourceInfo());
        SingleComponentQuery scq = SingleComponentQuery.byName(c.getPath(), c.getName(), null);
        SummaryComponent sc = scq.selectSummaryView();
        this.mCriticalityLevel = sc.getObjectID().equals(c.getObjectID()) ? 0 : 1;
        this.mResources = c.getCompRefList(null);
        this.preRenderSuffixes();
    }

    public void loadAbstractComponent(String typeName) throws RaplixException {
        this.mType = UITreeNodeType.BRANCH_EMPTY;
        this.mComponentType = typeName;
        this.mCriticalityLevel = 2;
        this.preRenderSuffixes();
    }

    public void preRenderSuffixes() {
        StringBuffer prefix = new StringBuffer();
        prefix.append("<tr>\n");
        prefix.append(Util.introStandardCell(this.mCriticalityLevel));
        if (this.mEditStyle) {
            prefix.append("<td class=\"tblListAct\" align=\"center\">&nbsp;</td>\n");
            prefix.append(Util.standardCell("&nbsp;", 0, "", this.mCriticalityLevel));
        }
        prefix.append(Util.standardCellStart(0, "nowrap", this.mCriticalityLevel));
        this.mPrefix = prefix.toString();
        StringBuffer suffix = new StringBuffer();
        suffix.append(Util.standardLink(UriUtil.componentDetailsURI(this.mID), "Show resource details", Util.preserveSpace(this.mPath + this.mName)));
        suffix.append(Util.standardCellEnd());
        suffix.append(Util.standardCell(this.mComponentType, 0, "", this.mCriticalityLevel));
        suffix.append(Util.standardCell(this.mVersion, 0, "align=\"center\"", this.mCriticalityLevel));
        suffix.append(Util.standardCell(this.mSource, 0, "nowrap", this.mCriticalityLevel));
        if (this.mEditStyle) {
            suffix.append(Util.standardCell("&nbsp;", 0, "nowrap", this.mCriticalityLevel));
            suffix.append("</tr>\n");
        }
        this.mSuffix = suffix.toString();
    }

    public String finishRender(StringBuffer sb, String path) {
        sb.insert(0, this.mPrefix);
        sb.append(this.mSuffix);
        return sb.toString();
    }

    public void finishOpen() {
        this.mChildren = new Vector();
        for (int i = 0; i < this.mResources.length; ++i) {
            SummaryComponent sc = this.mResources[i].getComponent();
            try {
                ComponentNode cn = new ComponentNode(this.mEditStyle);
                if (sc != null) {
                    Component c = sc.getID().getByIDQuery().select();
                    cn.loadComponent(c);
                } else {
                    cn.loadAbstractComponent(ComponentTypesListBean.normalizeName(this.mResources[i].getType()));
                }
                this.addChild(cn);
                continue;
            }
            catch (RaplixException raplixException) {
                // empty catch block
            }
        }
    }

    public void finishClose() {
        this.mChildren = new Vector();
    }

    protected String getJavascriptFunction() {
        return "sendComponentTree";
    }
}

