/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import [Lcom.raplix.rolloutexpress.ui.web.UITree;;
import [Ljava.lang.String;;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDescriptor;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceSelectorList;
import com.raplix.rolloutexpress.systemmodel.componentdb.TargetRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDescriptor;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDescriptorList;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.UITree;
import com.raplix.rolloutexpress.ui.web.UITreeList;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.categories.CategoriesBean;
import com.raplix.rolloutexpress.ui.web.compx.ComponentDetailsBean;
import com.raplix.rolloutexpress.ui.web.compx.ComponentNode;
import com.raplix.rolloutexpress.ui.web.compx.ComponentVariablesBean;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypesListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsListBean;
import com.raplix.rolloutexpress.ui.web.resources.ResourceDetailsBean;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.collections.Mapper;
import com.raplix.util.collections.TypedList;
import com.raplix.util.string.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class ComponentEditBean
extends ServletBean {
    private static final String LOCAL_NAME_PREFIX = "ref";
    private String mComponentID = null;
    private String mComponentName = "";
    private String mComponentFullName = "";
    private String mComponentFolderID = "";
    private String mComponentFolderPath = "";
    private String mComponentType = null;
    private String mComponentLabel = "";
    private String mComponentDescription = "";
    private String mComponentVersion = null;
    private String mComponentPlatform = "";
    private String mComponentSource = "";
    private String mComponentCheckInDate = null;
    private String mComponentCheckInBy = null;
    private String mCatNamesString = "";
    private String mPluginName = null;
    private boolean mWriteOnPlugin = true;
    private boolean mIsNewComponent = false;
    private boolean mIsSimpleComponent = false;
    private CategoryIDSet mCategoryIDSet = null;
    private String[] mComponentOptionsDescs = new String[0];
    private ResourceDetailsBean mResourceDetailsBean = null;
    private String mTargetableHostName = null;
    private String mTargetableHostTypeName = null;
    private boolean mTargetableHostVirtual = false;
    private String[] mResourceIDs = new String[0];
    private String[] mResourceFullNames = new String[0];
    private String[] mResourceVersions = new String[0];
    private String[] mResourceTypes = new String[0];
    private int[] mResourceTypeFamilies = new int[0];
    private String[] mResourceSources = new String[0];
    private String[] mResourceLocalNames = new String[0];
    private String[] mResourceInstallModes = new String[0];
    private String[][] mResourceVersionArrays = new String[0][0];
    private String[][] mVersionArrays = new String[0][0];
    private boolean[] mIsInheritedResources = new boolean[0];
    private boolean[] mIsReadOnlyResources = new boolean[0];
    private boolean[] mIsAbstractResources = new boolean[0];
    private boolean[] mIsNewResources = new boolean[0];
    private boolean[] mIsMostRecentResources = new boolean[0];
    private boolean[] mHasCheckinNewVersionResources = new boolean[0];
    private MultiCheckbox mResourceMCB = null;
    private UITree[] mResourceTrees = null;
    private boolean mIsTreeShowing = false;
    private boolean mIsAlreadyRefreshed = false;
    private boolean mIsAddVariablesPopupCase = false;
    private Vector mIndicesOfChangedResources = new Vector();
    private MultiCheckbox mNewVersionsMCB = null;
    private boolean mShowDetails = false;
    private boolean mIsReadOnlyResourceList = false;
    private String mResourceType = null;
    private String[][] mResourceVarNames = new String[0][0];
    private String[][] mResourceVarDefVals = new String[0][0];
    private String[][] mResourceVarOvrVals = new String[0][0];
    private MultiCheckbox[] mResourceVarsMCBs = null;
    private String[] mComponentVarName = new String[0];
    private String[] mComponentVarDefVal = new String[0];
    private String[] mComponentVarOvrVal = new String[0];
    private String[] mComponentPromptDefs = new String[0];
    private String[] mComponentPromptOvrs = new String[0];
    private boolean[] mIsComponentVarAbstract = new boolean[0];
    private boolean[] mIsComponentVarInherited = new boolean[0];
    private boolean[] mIsComponentVarReadOnly = new boolean[0];
    private MultiCheckbox mComponentVarsMCB = null;
    private MultiCheckbox mComponentVarsOvrValMCB = null;
    private String[] mTmpComponentVarOvrValChecks = new String[0];
    private HostSetsListBean mHostSetsListBean = null;
    private ComponentTypesListBean mComponentTypesListBean = null;
    private ComponentTypesListBean mResourceTypesListBean = null;
    private ComponentDescriptor mComponentDescriptor = null;
    private final UserManager mUserDBInterface;
    private final ResourceSubsystem mResourceSubsystem;

    public ComponentEditBean(UserManager um, ResourceSubsystem rs) {
        this.mUserDBInterface = um;
        this.mResourceSubsystem = rs;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public String getComponentFullName() {
        return this.mComponentFullName;
    }

    public String getComponentFolderID() {
        return this.mComponentFolderID;
    }

    public String getComponentFolderPath() {
        return this.mComponentFolderPath;
    }

    public String getComponentType() {
        return this.mComponentType;
    }

    public String getComponentLabel() {
        return this.mComponentLabel;
    }

    public String getComponentDescription() {
        return this.mComponentDescription;
    }

    public String getComponentVersion() {
        return this.mComponentVersion;
    }

    public String getComponentPlatform() {
        return this.mComponentPlatform;
    }

    public String getComponentSource() {
        return this.mComponentSource;
    }

    public String getComponentCheckInDate() {
        return this.mComponentCheckInDate;
    }

    public String getComponentCheckInBy() {
        return this.mComponentCheckInBy;
    }

    public String getCatNamesString() {
        return this.mCatNamesString;
    }

    public String getPluginName() {
        return this.mPluginName;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public boolean isNewComponent() {
        return this.mIsNewComponent;
    }

    public boolean isSimpleComponent() {
        return this.mIsSimpleComponent;
    }

    public void setComponentID(String inCID) {
        this.mComponentID = inCID;
    }

    public void setComponentName(String name) {
        this.mComponentName = name;
    }

    public void setComponentFullName(String name) {
        this.mComponentFullName = name;
    }

    public void setComponentType(String inComponentType) {
        this.mComponentType = inComponentType;
    }

    public void setComponentLabel(String label) {
        this.mComponentLabel = label;
    }

    public void setComponentDescription(String description) {
        this.mComponentDescription = description;
    }

    public void setIsNewComponent(boolean isNew) {
        this.mIsNewComponent = isNew;
    }

    public String[] getComponentOptionsDescs() {
        return this.mComponentOptionsDescs;
    }

    public ResourceDetailsBean getResourceDetailsBean() {
        return this.mResourceDetailsBean;
    }

    public String[] getResourceIDs() {
        return this.mResourceIDs;
    }

    public String[] getResourceFullNames() {
        return this.mResourceFullNames;
    }

    public String[] getResourceVersions() {
        return this.mResourceVersions;
    }

    public String[] getResourceTypes() {
        return this.mResourceTypes;
    }

    public int[] getResourceTypeFamilies() {
        return this.mResourceTypeFamilies;
    }

    public String[] getResourceSources() {
        return this.mResourceSources;
    }

    public String[] getResourceLocalNames() {
        return this.mResourceLocalNames;
    }

    public String[] getResourceInstallModes() {
        return this.mResourceInstallModes;
    }

    public String[] getResourceVersionArrays(int i) {
        return this.mResourceVersionArrays[i];
    }

    public String[] getVersionArrays(int i) {
        return this.mVersionArrays[i];
    }

    public boolean[] isInheritedResources() {
        return this.mIsInheritedResources;
    }

    public boolean[] isReadOnlyResources() {
        return this.mIsReadOnlyResources;
    }

    public boolean[] isAbstractResources() {
        return this.mIsAbstractResources;
    }

    public boolean[] isNewResources() {
        return this.mIsNewResources;
    }

    public boolean[] isMostRecentResources() {
        return this.mIsMostRecentResources;
    }

    public boolean[] getHasCheckinNewVersionResources() {
        return this.mHasCheckinNewVersionResources;
    }

    public MultiCheckbox getResourcesMCB() {
        return this.mResourceMCB;
    }

    public UITree[] getResourceTrees() {
        return this.mResourceTrees;
    }

    public boolean isTreeShowing() {
        return this.mIsTreeShowing;
    }

    public boolean getIsAddVariablesPopupCase() {
        return this.mIsAddVariablesPopupCase;
    }

    public MultiCheckbox getNewVersionsMCB() {
        return this.mNewVersionsMCB;
    }

    public void setResourceLocalNames(String[] inResourceLocalNames) {
        this.mResourceLocalNames = inResourceLocalNames;
    }

    public void setResourceInstallModes(String[] inResourceInstallModes) {
        this.mResourceInstallModes = inResourceInstallModes;
    }

    public void setIsTreeShowing(boolean isTreeShowing) {
        this.mIsTreeShowing = isTreeShowing;
    }

    public void setIsAddVariablesPopupCase(boolean inValue) {
        this.mIsAddVariablesPopupCase = inValue;
    }

    public boolean isDetailedView() {
        return this.mShowDetails;
    }

    public boolean isReadOnlyResourceList() {
        return this.mIsReadOnlyResourceList;
    }

    public String getResourceType() {
        return this.mResourceType;
    }

    public void setIsDetailedView(boolean showInstalled) {
        this.mShowDetails = showInstalled;
    }

    public String[] getResourceVarNames(int i) {
        return this.mResourceVarNames[i];
    }

    public String[] getResourceVarDefVals(int i) {
        return this.mResourceVarDefVals[i];
    }

    public String[] getResourceVarOvrVals(int i) {
        return this.mResourceVarOvrVals[i];
    }

    public MultiCheckbox[] getResourceVarsMCBs() {
        return this.mResourceVarsMCBs;
    }

    public void setResourceVarOvrVals(String[][] inResourceVarOvrVals) {
        this.mResourceVarOvrVals = inResourceVarOvrVals;
    }

    public String getTargetableHostName() {
        return this.mTargetableHostName;
    }

    public String getTargetableHostTypeName() {
        return this.mTargetableHostTypeName;
    }

    public boolean getTargetableHostVirtual() {
        return this.mTargetableHostVirtual;
    }

    public String[] getComponentVarName() {
        return this.mComponentVarName;
    }

    public String[] getComponentVarDefVal() {
        return this.mComponentVarDefVal;
    }

    public String[] getComponentVarOvrVal() {
        return this.mComponentVarOvrVal;
    }

    public String[] getComponentPromptDefs() {
        return this.mComponentPromptDefs;
    }

    public String[] getComponentPromptOvrs() {
        return this.mComponentPromptOvrs;
    }

    public boolean[] isComponentVarAbstract() {
        return this.mIsComponentVarAbstract;
    }

    public boolean[] isComponentVarInherited() {
        return this.mIsComponentVarInherited;
    }

    public boolean[] isComponentVarReadOnly() {
        return this.mIsComponentVarReadOnly;
    }

    public MultiCheckbox getComponentVarsMCB() {
        return this.mComponentVarsMCB;
    }

    public MultiCheckbox getComponentVarsOvrValMCB() {
        return this.mComponentVarsOvrValMCB;
    }

    public void setComponentVarOvrVal(String[] inComponentVarOvrVal) {
        this.mComponentVarOvrVal = inComponentVarOvrVal;
    }

    public void setComponentPromptOvrs(String[] inComponentPromptOvrs) {
        this.mComponentPromptOvrs = inComponentPromptOvrs;
    }

    public void setComponentVarOvrValChecked(String[] newComponentVarOvrValChecks) {
        this.mTmpComponentVarOvrValChecks = newComponentVarOvrValChecks;
    }

    public HostSetsListBean getHostSetsListBean() {
        return this.mHostSetsListBean;
    }

    public ComponentTypesListBean getComponentTypesListBean() {
        return this.mComponentTypesListBean;
    }

    public ComponentTypesListBean getResourceTypesListBean() {
        return this.mResourceTypesListBean;
    }

    public ComponentDescriptor getComponentDescriptor() {
        return this.mComponentDescriptor;
    }

    public String getID() {
        if (this.mComponentID == null) {
            return super.getID();
        }
        return this.mComponentID;
    }

    public static String[] getInstallModeValues() {
        return new String[]{InstallMode.TOPLEVEL.toString(), InstallMode.NESTED.toString()};
    }

    public static String[] getInstallModeLabels() {
        return new String[]{"top level", "nested"};
    }

    public void setComponentPlatform(String selectedPlatform) throws RaplixException {
        this.mComponentPlatform = selectedPlatform;
        HostSetID platHsID = HostSetsBean.getSummaryHostSetByName(this.mComponentPlatform).getID();
        this.mResourceTypesListBean.loadComponentTypes(platHsID);
    }

    public String getXML() throws PersistenceManagerException, RPCException {
        Component comp = this.mComponentDescriptor.generateComponent();
        comp.validate();
        return comp.writeToXML();
    }

    public void setComponentFolderID(String folderID) throws RaplixException {
        this.mComponentFolderID = folderID;
        this.mComponentFolderPath = ChangePathBean.folderIDtoFilePath(this.mComponentFolderID);
    }

    public void createNewComponent() throws RaplixException {
        this.mComponentDescriptor = ComponentDescriptor.create(this.mComponentType);
        this.mComponentDescriptor.setName(this.mComponentName);
        this.mComponentDescriptor.setPath(new FolderID(this.mComponentFolderID));
        this.mComponentDescriptor.setLabel(this.mComponentLabel);
        this.mComponentDescriptor.setDescription(this.mComponentDescription);
        this.loadHelperBeans();
        this.generateOutput();
        if (!this.mIsSimpleComponent) {
            this.loadUITrees();
        }
    }

    public void loadEdit() throws RaplixException {
        ComponentID cid = new ComponentID(this.mComponentID);
        this.mComponentDescriptor = ComponentDescriptor.create(cid);
        this.loadHelperBeans();
        this.generateOutput();
        if (!this.mIsSimpleComponent) {
            this.loadUITrees();
        }
    }

    public void generateOutput() throws RaplixException {
        this.mComponentName = this.mComponentDescriptor.getName();
        this.mComponentFullName = this.mComponentDescriptor.getFullName();
        this.mComponentFolderID = this.mComponentDescriptor.getPath().toString();
        this.mComponentFolderPath = Util.fullNameToPath(this.mComponentFullName);
        this.mComponentType = ComponentTypesListBean.normalizeName(this.mComponentDescriptor.getExtendsType());
        this.mComponentLabel = this.mComponentDescriptor.getLabel();
        this.mComponentDescription = this.mComponentDescriptor.getDescription();
        this.mIsSimpleComponent = this.mComponentDescriptor.isSimpleComponent();
        this.setComponentPlatform(this.mComponentDescriptor.getPlatform());
        Component currentComponent = this.mComponentDescriptor.getCurrentComponent();
        String resourceID = null;
        if (currentComponent != null) {
            this.mComponentVersion = currentComponent.getVersionNumber().getAsString();
            this.mComponentCheckInDate = Util.formatDate(currentComponent.getTimeStamp());
            this.mComponentCheckInBy = this.mUserDBInterface.getUser(currentComponent.getUserID()).getUsername();
            TargetRef targetHost = currentComponent.getTargetRef();
            if (targetHost != null) {
                this.mTargetableHostName = targetHost.getHostName();
                this.mTargetableHostTypeName = targetHost.getTypeName();
                this.mTargetableHostVirtual = targetHost.isVirtual();
            }
            this.mCategoryIDSet = currentComponent.getCategories();
            this.mCatNamesString = CategoriesBean.getCategoryNamesString(this.mCategoryIDSet);
            PluginID pluginID = currentComponent.getPluginID();
            if (pluginID != null) {
                this.mPluginName = pluginID.getByIDQuery().selectSummaryView().getName();
            }
            this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin(currentComponent);
            SourceInfo si = currentComponent.getSourceInfo();
            this.mComponentSource = ComponentDetailsBean.generateComponentSource(si);
            if (this.mIsSimpleComponent) {
                if (si != null) {
                    this.mComponentOptionsDescs = si.getVarDescriptions();
                }
                resourceID = currentComponent.getResource().getResourceID().toString();
            }
        }
        if (this.mIsSimpleComponent) {
            this.mResourceDetailsBean = new ResourceDetailsBean(this.mResourceSubsystem, this.mUserDBInterface);
            this.mResourceDetailsBean.loadResourceDetails(resourceID);
        } else {
            this.loadResources();
        }
        this.loadComponentVariables();
    }

    private void loadResources() throws RaplixException {
        ResourceSelectorList rsl = this.mComponentDescriptor.getResourceSelectors();
        if (!this.mIsAlreadyRefreshed) {
            rsl.refresh();
        }
        this.mIsAlreadyRefreshed = false;
        this.mIsReadOnlyResourceList = this.mComponentDescriptor.isReadOnlyResourceList();
        if (this.mComponentDescriptor.getResourceListType() != null && !this.mComponentDescriptor.getResourceListType().equals(ComponentType.ROOT)) {
            this.mResourceType = this.mComponentDescriptor.getResourceListType().getTypeName();
        }
        int numResources = rsl.size();
        this.mResourceIDs = new String[numResources];
        this.mResourceFullNames = new String[numResources];
        this.mResourceVersions = new String[numResources];
        this.mResourceTypes = new String[numResources];
        this.mResourceTypeFamilies = new int[numResources];
        this.mResourceSources = new String[numResources];
        this.mResourceLocalNames = new String[numResources];
        this.mResourceInstallModes = new String[numResources];
        this.mResourceVersionArrays = new String[numResources][];
        this.mVersionArrays = new String[numResources][];
        this.mIsAbstractResources = new boolean[numResources];
        this.mIsInheritedResources = new boolean[numResources];
        this.mIsReadOnlyResources = new boolean[numResources];
        this.mIsNewResources = new boolean[numResources];
        this.mIsMostRecentResources = new boolean[numResources];
        this.mHasCheckinNewVersionResources = new boolean[numResources];
        this.mResourceVarNames = new String[numResources][];
        this.mResourceVarDefVals = new String[numResources][];
        this.mResourceVarOvrVals = new String[numResources][];
        this.mResourceVarsMCBs = new MultiCheckbox[numResources];
        for (int i = 0; i < numResources; ++i) {
            Component[] allVersions;
            ResourceSelector rs = rsl.getSelector(i);
            Component c = rs.getCurrent();
            if (rs.getType().equals(ComponentType.ROOT)) {
                this.mResourceTypes[i] = ComponentTypesListBean.ANY_COMPONENT_TYPE;
                this.mResourceTypeFamilies[i] = 1;
            } else {
                this.mResourceTypes[i] = rs.getType().getTypeName();
                this.mResourceTypeFamilies[i] = 3;
            }
            this.mHasCheckinNewVersionResources[i] = false;
            if (c == null) {
                this.mResourceIDs[i] = "";
                this.mResourceFullNames[i] = "";
                this.mResourceVersions[i] = "";
                this.mResourceSources[i] = "";
                this.mIsAbstractResources[i] = true;
            } else {
                this.mResourceIDs[i] = c.getID().toString();
                this.mResourceFullNames[i] = c.getFullName();
                this.mResourceVersions[i] = c.getVersionNumber().getAsString();
                this.mResourceSources[i] = ComponentDetailsBean.generateComponentSource(c.getSourceInfo());
                this.mIsAbstractResources[i] = false;
                this.mHasCheckinNewVersionResources[i] = ComponentTypesListBean.hasCreateNewVersionCapability(c.getExtendsTypeName());
                this.mResourceTypes[i] = ComponentTypesListBean.normalizeName(c.getExtendsType());
            }
            this.mResourceLocalNames[i] = rs.getName();
            this.mResourceInstallModes[i] = rs.getInstallMode().toString();
            this.mIsInheritedResources[i] = rs.isInherited();
            this.mIsNewResources[i] = rs.isNew();
            this.mIsReadOnlyResources[i] = rs.isReadOnly();
            this.mIsMostRecentResources[i] = rs.getIndexOfCurrent() <= rs.getIndexOfLatest();
            if (this.mShowDetails) {
                StringBuffer checked = new StringBuffer("");
                if (!rs.isReadOnly()) {
                    VarDescriptorList vdl = rs.getCompVarOverrideList();
                    int numVarOverrides = vdl.size();
                    Vector<String> varNames = new Vector<String>();
                    Vector<String> varDefVals = new Vector<String>();
                    Vector<String> varOvrVals = new Vector<String>();
                    for (int j = 0; j < numVarOverrides; ++j) {
                        VarDescriptor vd = vdl.getVar(j);
                        if (vd.isReadOnly()) continue;
                        varNames.add(vd.getName());
                        varDefVals.add(vd.getDefaultValue());
                        if (vd.getOverrideValue() == null) {
                            varOvrVals.add(vd.getDefaultValue());
                            continue;
                        }
                        varOvrVals.add(vd.getOverrideValue());
                        if (!checked.toString().equals("")) {
                            checked.append(",");
                        }
                        checked.append(j);
                    }
                    int actNumVars = varNames.size();
                    this.mResourceVarNames[i] = new String[actNumVars];
                    this.mResourceVarDefVals[i] = new String[actNumVars];
                    this.mResourceVarOvrVals[i] = new String[actNumVars];
                    varNames.toArray(this.mResourceVarNames[i]);
                    varDefVals.toArray(this.mResourceVarDefVals[i]);
                    varOvrVals.toArray(this.mResourceVarOvrVals[i]);
                } else {
                    this.mResourceVarNames[i] = new String[0];
                    this.mResourceVarDefVals[i] = new String[0];
                    this.mResourceVarOvrVals[i] = new String[0];
                }
                this.mResourceVarsMCBs[i] = new MultiCheckbox(i + "varOverrideName", this.mResourceVarNames[i]);
                this.mResourceVarsMCBs[i].setSelected(checked.toString());
            }
            if ((allVersions = rs.getAll()) != null) {
                int numVersions = allVersions.length;
                this.mVersionArrays[i] = new String[numVersions];
                this.mResourceVersionArrays[i] = new String[numVersions];
                for (int j = 0; j < numVersions; ++j) {
                    String tmpVersionString;
                    this.mVersionArrays[i][j] = tmpVersionString = allVersions[j].getVersionNumber().getAsString();
                    this.mResourceVersionArrays[i][j] = j == rs.getIndexOfLastUsed() ? tmpVersionString + " &#149;" : tmpVersionString;
                }
                continue;
            }
            this.mVersionArrays[i] = new String[]{this.mResourceVersions[i]};
            this.mResourceVersionArrays[i] = new String[]{this.mResourceVersions[i]};
        }
        this.mResourceMCB = new MultiCheckbox("resourceID", this.mResourceIDs);
    }

    private void loadComponentVariables() {
        int i;
        VarDescriptorList vdl = this.mComponentDescriptor.getVarList();
        VarDescriptor[] vda = vdl.toVarArray();
        int numVariables = vda.length;
        this.mComponentVarName = new String[numVariables];
        this.mComponentVarDefVal = new String[numVariables];
        this.mComponentVarOvrVal = new String[numVariables];
        this.mComponentPromptDefs = new String[numVariables];
        this.mComponentPromptOvrs = new String[numVariables];
        this.mIsComponentVarAbstract = new boolean[numVariables];
        this.mIsComponentVarInherited = new boolean[numVariables];
        this.mIsComponentVarReadOnly = new boolean[numVariables];
        StringBuffer selected = new StringBuffer("");
        Vector<String> checkedIndices = new Vector<String>();
        for (i = 0; i < vda.length; ++i) {
            this.mComponentVarName[i] = vda[i].getName();
            this.mComponentVarDefVal[i] = StringUtil.normalizeEmpty(vda[i].getDefaultValue());
            this.mComponentPromptDefs[i] = StringUtil.normalizeEmpty(vda[i].getDefaultPrompt());
            this.mComponentVarOvrVal[i] = vda[i].getOverrideValue() == null ? StringUtil.normalizeEmpty(vda[i].getDefaultValue()) : StringUtil.normalizeEmpty(vda[i].getOverrideValue());
            this.mComponentPromptOvrs[i] = vda[i].getOverridePrompt() == null ? StringUtil.normalizeEmpty(vda[i].getDefaultPrompt()) : StringUtil.normalizeEmpty(vda[i].getOverridePrompt());
            this.mIsComponentVarAbstract[i] = vda[i].getDefaultValue() == null;
            this.mIsComponentVarInherited[i] = vda[i].isInherited();
            this.mIsComponentVarReadOnly[i] = vda[i].isReadOnly();
            if (vda[i].getOverrideValue() == null) continue;
            checkedIndices.add(new Integer(i).toString());
        }
        for (i = 0; i < checkedIndices.size(); ++i) {
            selected.append(checkedIndices.get(i));
            if (i >= checkedIndices.size() - 1) continue;
            selected.append(",");
        }
        this.mComponentVarsMCB = new MultiCheckbox("variableName", this.mComponentVarName);
        this.mComponentVarsOvrValMCB = new MultiCheckbox("componentVariableOverrideChecks", this.mComponentVarName);
        this.mComponentVarsOvrValMCB.setSelected(selected.toString());
    }

    private void loadHelperBeans() throws RaplixException {
        this.mHostSetsListBean = new HostSetsListBean();
        HostSetID platHsID = HostSetsBean.getSummaryHostSetByName(this.mComponentDescriptor.getPlatform()).getID();
        ComponentType ct = this.mComponentDescriptor.getExtendsType();
        if (ct.getTypeName() == null) {
            this.mHostSetsListBean.loadAllSupportedPlatforms(platHsID);
        } else {
            this.mHostSetsListBean.loadAllSupportedPlatforms(platHsID, ct);
        }
        this.mComponentTypesListBean = new ComponentTypesListBean();
        this.mComponentTypesListBean.loadComponentTypes();
        this.mResourceTypesListBean = new ComponentTypesListBean();
        this.mResourceTypesListBean.loadComponentTypes();
    }

    public void updateDescriptor() throws RaplixException {
        this.mComponentDescriptor.setName(this.mComponentName);
        this.mComponentDescriptor.setPath(new FolderID(this.mComponentFolderID));
        this.mComponentDescriptor.setLabel(this.mComponentLabel);
        this.mComponentDescriptor.setDescription(this.mComponentDescription);
        this.mComponentDescriptor.setPlatform(this.mComponentPlatform);
        if (!this.mIsSimpleComponent) {
            ResourceSelectorList rsl = this.mComponentDescriptor.getResourceSelectors();
            int numSelectors = rsl.size();
            for (int i = 0; i < numSelectors; ++i) {
                ResourceSelector currentSelector = rsl.getSelector(i);
                if (this.mResourceLocalNames[i] != null && currentSelector.isNew()) {
                    currentSelector.setName(this.mResourceLocalNames[i]);
                }
                if (this.mResourceInstallModes[i] != null && currentSelector.isNew()) {
                    if (this.mResourceInstallModes[i].equals(InstallMode.TOPLEVEL.toString())) {
                        currentSelector.setInstallMode(InstallMode.TOPLEVEL);
                    } else {
                        currentSelector.setInstallMode(InstallMode.NESTED);
                    }
                }
                if (!this.mShowDetails) continue;
                VarDescriptorList vdl = currentSelector.getCompVarOverrideList();
                if (currentSelector.isReadOnly()) continue;
                for (int j = 0; j < vdl.size(); ++j) {
                    VarDescriptor vd = vdl.getVar(j);
                    if (this.getResourceVarsMCBs()[i].getChecked(j)) {
                        if (this.mResourceVarOvrVals[i][j] == null) {
                            vd.setOverrideValue(vd.getDefaultValue());
                            continue;
                        }
                        if (vd.isReadOnly()) continue;
                        vd.setOverrideValue(this.mResourceVarOvrVals[i][j]);
                        continue;
                    }
                    vd.setOverrideValue(null);
                }
            }
        }
        VarDescriptorList vdl = this.mComponentDescriptor.getVarList();
        for (int i = 0; i < vdl.size(); ++i) {
            VarDescriptor vd = (VarDescriptor)vdl.get(i);
            if (vd.isReadOnly()) continue;
            if (this.mTmpComponentVarOvrValChecks[i] != null) {
                if (this.mComponentVarOvrVal[i] == null) {
                    vd.setOverrideValue(vd.getDefaultValue());
                } else {
                    vd.setOverrideValue(this.mComponentVarOvrVal[i]);
                }
                if (this.mComponentPromptOvrs[i] == null) {
                    vd.setOverridePrompt(vd.getDefaultPrompt());
                    continue;
                }
                vd.setOverridePrompt(this.mComponentPromptOvrs[i]);
                continue;
            }
            if (vd.getDefaultValue() == null) {
                vd.setOverrideValue(this.mComponentVarOvrVal[i]);
            } else {
                vd.setOverrideValue(null);
            }
            if (vd.getDefaultPrompt() == null) {
                vd.setOverridePrompt(this.mComponentPromptOvrs[i]);
                continue;
            }
            vd.setOverridePrompt(null);
        }
    }

    public void updateVersions(String[] selectedVersions) throws RaplixException {
        this.mIndicesOfChangedResources = new Vector();
        ResourceSelectorList rsl = this.mComponentDescriptor.getResourceSelectors();
        int numSelectors = rsl.size();
        for (int i = 0; i < numSelectors; ++i) {
            ResourceSelector rs = rsl.getSelector(i);
            if (selectedVersions[i] == null) continue;
            VersionNumber vn = new VersionNumber(selectedVersions[i]);
            int newIndex = rs.getIndexOfVersion(vn);
            if (rs.isReadOnly() || rs.getCurrent() == null || newIndex == -1 || newIndex == rs.getIndexOfCurrent()) continue;
            rs.setIndexOfCurrent(newIndex);
            this.updateUITree(i);
            this.mIndicesOfChangedResources.add(new Integer(i));
        }
    }

    public void addResources(String[] resourceIDs) throws RaplixException {
        ResourceSelectorList rsl = this.mComponentDescriptor.getResourceSelectors();
        HashSet<String> hs = new HashSet<String>();
        for (int k = 0; k < rsl.size(); ++k) {
            hs.add(rsl.getSelector(k).getName());
        }
        String localName = LOCAL_NAME_PREFIX + (rsl.size() + 1);
        int localNameIncrement = rsl.size() + 1;
        for (int i = 0; i < resourceIDs.length; ++i) {
            ComponentID cid = new ComponentID(resourceIDs[i]);
            int orgNumResources = rsl.size();
            ResourceSelector rs = this.mComponentDescriptor.addResource(cid);
            while (hs.contains(localName)) {
                localName = LOCAL_NAME_PREFIX + ++localNameIncrement;
            }
            hs.add(localName);
            rs.setName(localName);
            rsl.refresh();
            this.mIsAlreadyRefreshed = true;
            if (rsl.size() > orgNumResources) {
                this.addUITree(rsl);
                continue;
            }
            for (int j = 0; j < this.mIsAbstractResources.length; ++j) {
                if (!this.mIsAbstractResources[j] || (rs = rsl.getSelector(j)).getCurrent() == null) continue;
                this.updateUITree(j);
            }
        }
    }

    public void addResource(ComponentID cid, int index) throws RaplixException {
        ResourceSelectorList rsl = this.mComponentDescriptor.getResourceSelectors();
        ResourceSelector rs = rsl.getSelector(index);
        rs.reset(cid);
        rs.setIndexOfCurrent(rs.getIndexOfComponentID(cid));
        this.updateUITree(index);
    }

    public void removeResources(String[] positions) {
        int i;
        ResourceSelectorList rsl = this.mComponentDescriptor.getResourceSelectors();
        positions = ComponentEditBean.removeInheritedResources(positions, rsl);
        Vector<Object> selectors = new Vector<Object>();
        int[] indices = new int[positions.length];
        for (i = 0; i < positions.length; ++i) {
            int index = Integer.parseInt(positions[i]);
            selectors.add(rsl.get(index));
            indices[i] = index;
        }
        for (i = 0; i < selectors.size(); ++i) {
            rsl.remove(selectors.elementAt(i));
        }
        this.removeUITrees(indices);
    }

    public void moveResources(String[] indexes, String direction) {
        ResourceSelector rs;
        int i;
        ResourceSelectorList rsl = this.mComponentDescriptor.getResourceSelectors();
        String[] positions = ComponentEditBean.removeInheritedResources(indexes, rsl);
        for (i = 0; i < rsl.size() && (rs = rsl.getSelector(i)).isInherited(); ++i) {
        }
        if (i != rsl.size() - 1) {
            ComponentEditBean.move(rsl, positions, direction, i);
            this.moveUITrees(positions, direction, i);
        }
    }

    private static String[] removeInheritedResources(String[] indexes, ResourceSelectorList rsl) {
        int i;
        Vector<String> positions = new Vector<String>(Arrays.asList(indexes));
        Vector<String> removes = new Vector<String>();
        for (i = 0; i < positions.size(); ++i) {
            int p = new Integer(positions.elementAt(i));
            if (!rsl.getSelector(p).isInherited()) continue;
            removes.add(positions.get(i));
        }
        for (i = 0; i < removes.size(); ++i) {
            positions.remove(removes.get(i));
        }
        return positions.toArray(new String[0]);
    }

    private static void move(TypedList items, String[] positions, String direction, int top) {
        String currToken;
        int i;
        int TOP_OF_LIST = top;
        int size = items.size();
        int BOTTOM_OF_LIST = 0;
        if (size > 0) {
            BOTTOM_OF_LIST = size - 1;
        }
        int first = -1;
        int second = -1;
        int lastSeen = -1;
        if (direction.equals("up")) {
            for (i = 0; i < positions.length; ++i) {
                currToken = positions[i];
                second = new Integer(currToken);
                if (second == TOP_OF_LIST || second == lastSeen + 1) {
                    lastSeen = second;
                    continue;
                }
                if (second <= TOP_OF_LIST || second > BOTTOM_OF_LIST) continue;
                first = new Integer(currToken) - 1;
                items.swap(first, second);
            }
        }
        if (direction.equals("down")) {
            for (i = positions.length - 1; i >= 0; --i) {
                currToken = positions[i];
                first = new Integer(currToken);
                if (first == BOTTOM_OF_LIST || first == lastSeen - 1) {
                    lastSeen = first;
                    continue;
                }
                if (first >= BOTTOM_OF_LIST || first < 0) continue;
                second = new Integer(currToken) + 1;
                items.swap(first, second);
            }
        }
    }

    public void setResourcesToMostRecent(String[] positions) throws RaplixException {
        this.mIndicesOfChangedResources = new Vector();
        ResourceSelectorList selectors = this.mComponentDescriptor.getResourceSelectors();
        for (int i = 0; i < positions.length; ++i) {
            int selector = Integer.parseInt(positions[i]);
            ResourceSelector rs = selectors.getSelector(selector);
            int latest = rs.getIndexOfLatest();
            if (rs.isReadOnly() || rs.getCurrent() == null || latest == -1 || latest == rs.getIndexOfCurrent()) continue;
            rs.setIndexOfCurrent(latest);
            this.updateUITree(selector);
            this.mIndicesOfChangedResources.add(new Integer(i));
        }
    }

    public void updateChangedResources() throws RaplixException {
        int[] slots = (int[])CollectionUtil.mapClass(this.mIndicesOfChangedResources, [I.class);
        String[] resourceIDs = new String[slots.length];
        ResourceSelectorList rsl = this.mComponentDescriptor.getResourceSelectors();
        for (int i = 0; i < slots.length; ++i) {
            resourceIDs[i] = rsl.getSelector(slots[i]).getCurrent().getID().toString();
        }
        HashMap variableComponentMap = ComponentVariablesBean.extractVariables(this.mComponentDescriptor, resourceIDs, slots);
        String[] strSlots = new String[]{};
        try {
            strSlots = (String[])CollectionUtil.mapClass(this.mIndicesOfChangedResources, String;.class, new Mapper(){

                public void setMappedClass(Class cls) {
                }

                public Object map(Object element) {
                    return element.toString();
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
        this.mNewVersionsMCB = new MultiCheckbox("newVersionID", strSlots);
        this.mIsAddVariablesPopupCase = variableComponentMap.keySet().size() > 0;
    }

    public void addVariable(String newVariableName, String newVariableValue, String newVariableOvrPrompt) {
        if (newVariableName != null) {
            newVariableName = newVariableName.trim();
            VarDescriptorList vdl = this.mComponentDescriptor.getVarList();
            if (!newVariableName.equals("") && vdl.getVar(newVariableName) == null) {
                VarDescriptor vd = new VarDescriptor(newVariableName);
                vd.setOverrideValue(newVariableValue);
                vd.setOverridePrompt(newVariableOvrPrompt);
                vdl.add(vd);
            }
        }
    }

    public void addVariables(String[] newVariableNames, String[] newVariablesValues, String[] newVariablesPrompts) {
        for (int i = 0; i < newVariableNames.length; ++i) {
            this.addVariable(newVariableNames[i], newVariablesValues[i], newVariablesPrompts[i]);
        }
    }

    public void moveVariables(String[] indexes, String direction) {
        VarDescriptor vd;
        int i;
        VarDescriptorList vdl = this.mComponentDescriptor.getVarList();
        for (i = 0; i < vdl.size() && (vd = vdl.getVar(i)).isInherited(); ++i) {
        }
        if (i != vdl.size() - 1) {
            ComponentEditBean.move(vdl, indexes, direction, i);
        }
    }

    public void deleteVariables(String[] positions) {
        int i;
        Vector<Object> descriptors = new Vector<Object>();
        VarDescriptorList vdl = this.mComponentDescriptor.getVarList();
        for (i = 0; i < positions.length; ++i) {
            descriptors.add(vdl.get(new Integer(positions[i])));
        }
        for (i = 0; i < descriptors.size(); ++i) {
            vdl.remove(descriptors.elementAt(i));
        }
    }

    private void loadUITrees() throws RaplixException {
        ResourceSelectorList rsl = this.mComponentDescriptor.getResourceSelectors();
        int numResources = rsl.size();
        this.mResourceTrees = new UITree[numResources];
        for (int i = 0; i < numResources; ++i) {
            ResourceSelector rs = rsl.getSelector(i);
            this.mResourceTrees[i] = ComponentEditBean.getUITree(rs);
        }
    }

    private void addUITree(ResourceSelectorList rsl) throws RaplixException {
        Vector<UITree> treeList = new Vector<UITree>(Arrays.asList(this.mResourceTrees));
        ResourceSelector rs = rsl.getSelector(rsl.size() - 1);
        UITree newTree = ComponentEditBean.getUITree(rs);
        treeList.add(newTree);
        this.mResourceTrees = (UITree[])CollectionUtil.mapClass(treeList, UITree;.class);
    }

    private void removeUITrees(int[] rslIndices) {
        int i;
        Vector<UITree> treeList = new Vector<UITree>(Arrays.asList(this.mResourceTrees));
        Vector<UITree> removeList = new Vector<UITree>();
        for (i = 0; i < rslIndices.length; ++i) {
            removeList.add(treeList.get(rslIndices[i]));
        }
        for (i = 0; i < removeList.size(); ++i) {
            treeList.remove(removeList.get(i));
        }
        this.mResourceTrees = (UITree[])CollectionUtil.mapClass(treeList, UITree;.class);
    }

    private void updateUITree(int rslIndex) throws RaplixException {
        ResourceSelectorList rsl = this.mComponentDescriptor.getResourceSelectors();
        ResourceSelector rs = rsl.getSelector(rslIndex);
        this.mResourceTrees[rslIndex] = ComponentEditBean.getUITree(rs);
    }

    private void moveUITrees(String[] positions, String direction, int top) {
        Vector<UITree> treeList = new Vector<UITree>(Arrays.asList(this.mResourceTrees));
        UITreeList uitl = new UITreeList(treeList);
        ComponentEditBean.move(uitl, positions, direction, top);
        this.mResourceTrees = (UITree[])CollectionUtil.mapClass(uitl, UITree;.class);
    }

    private static UITree getUITree(ResourceSelector rs) throws RaplixException {
        UITree uit = new UITree();
        Component c = rs.getCurrent();
        if (c != null) {
            Component currSubComp = c.getID().getByIDQuery().select();
            ComponentNode node = new ComponentNode(true);
            node.setVisible(false);
            node.loadComponent(currSubComp);
            uit.setRoot(node);
        }
        return uit;
    }
}

