/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.LoggedOnServlet;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComponentDownloadAction
extends LoggedOnServlet
implements ActionModeConstants {
    private static final String MSG_ERROR_MAJOR = "error.components.download";

    public void executeServlet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String mode = request.getParameter("mode");
            String id = ComponentDownloadAction.assertGetParam(request, "id");
            ComponentID cid = new ComponentID(id);
            SingleComponentQuery scq = cid.getByIDQuery();
            Component c = scq.select();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Trying to retrieve component with id:" + cid, this);
            }
            if (mode == null || !mode.equals("filenameaddeddownload")) {
                String componentName = c.getName();
                String redirectAddress = "/ComponentDownload/" + Util.encodeURL(componentName) + "-" + c.getVersionNumber().getAsString() + ".xml?" + "id" + "=" + id + "&" + "mode" + "=" + "filenameaddeddownload";
                response.sendRedirect(redirectAddress);
                return;
            }
            response.setContentType("application/octet-stream; charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.print(c.writeToXML());
        }
        catch (RaplixException e) {
            ServletErrors errors = new ServletErrors();
            Logger.debug("Exception caught in ComponentDownloadAction: " + e.getMessage(), e, this);
            errors.setMajorErrorKey(MSG_ERROR_MAJOR);
            errors.addMinorError(e.getMessage());
            request.setAttribute("error.location", (Object)errors);
            this.forwardRequest(request, response, "/errorhome.jsp");
        }
    }
}

