/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import [Ljava.lang.String;;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.query.AutogenPlanRunHistoryBean;
import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RsrcCheckoutInfo;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSaveContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.TargetRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.UITree;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.categories.CategoriesBean;
import com.raplix.rolloutexpress.ui.web.compx.ComponentEditBean;
import com.raplix.rolloutexpress.ui.web.compx.ComponentNode;
import com.raplix.rolloutexpress.ui.web.compx.ComponentSettingsBean;
import com.raplix.rolloutexpress.ui.web.compx.ComponentVersionHistoryBean;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypesListBean;
import com.raplix.rolloutexpress.ui.web.resources.ResourceDetailsBean;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.string.StringUtil;
import java.util.Arrays;
import java.util.Vector;

public class ComponentDetailsBean
extends ServletBean {
    public static final String PROCEDURE_SEPARATOR = ":";
    public static final String PROCEDURE_NAME_SEPARATOR = ": ";
    public static final String INSTALL_BLOCK_TYPE = "install";
    public static final String UNINSTALL_BLOCK_TYPE = "uninstall";
    public static final String CALL_BLOCK_TYPE = "call";
    private String mComponentID = "";
    private String mComponentName = "";
    private String mComponentFullName = "";
    private String mComponentFolderID = "";
    private String mComponentFolderPath = "";
    private String mComponentType = "untyped";
    private String mComponentTypeID = "";
    private String mComponentLabel = "";
    private String mComponentDescription = "";
    private String mComponentVersion = "";
    private String mComponentPlatform = "";
    private String mComponentSource = null;
    private String mComponentCheckInDate = "";
    private String mComponentCheckInUser = "";
    private String mCatNamesString = "";
    private String mPluginName = null;
    private String mPluginID = null;
    private boolean mWriteOnPlugin = true;
    private boolean mExecuteOnFolder = true;
    private boolean mWriteOnFolder = true;
    private boolean mWriteOnAnyFolder = true;
    private boolean mCheckinCurrentOnFolder = true;
    private boolean mAutoRunOnFolder = true;
    private boolean mIsHiddenComponent = false;
    private boolean mIsSimpleComponent = false;
    private boolean mIsBrowsableComponent = false;
    private boolean mHasCheckinCurrent = false;
    private boolean mHasCreateNewVersion = false;
    private boolean mIsAbstractComponent = false;
    private CategoryIDSet mComponentCategoryIDSet = null;
    private int mDoneCount = 0;
    private String mDestination = "";
    private boolean mAllowsVariableSettings = false;
    private boolean mIsEditOperation = true;
    private boolean mIsDownloadContentsEnabled = true;
    private String[] mComponentOptionsDescs = new String[0];
    private ResourceDetailsBean mResourceDetailsBean = null;
    private String mTargetableHostName = null;
    private String mTargetableHostTypeName = null;
    private boolean mTargetableHostVirtual = false;
    private String[] mResourceIDs = new String[0];
    private String[] mResourceFullNames = new String[0];
    private String[] mResourceVersions = new String[0];
    private String[] mResourceTypes = new String[0];
    private String[] mResourceSources = new String[0];
    private Modifier[] mResourceModifiers = new Modifier[0];
    private boolean[] mIsMostRecentResources = new boolean[0];
    private UITree[] mResourceTrees = new UITree[0];
    private boolean mIsTreeShowing = false;
    private boolean mIsReadOnlyResourceList = false;
    private String[] mComponentVarName = new String[0];
    private String[] mComponentVarValue = new String[0];
    private String[] mComponentVarPrompt = new String[0];
    private boolean[] mIsComponentVarReadOnly = new boolean[0];
    private String[] mProcedureNames = new String[0];
    private String[] mProcedureDisplayNames = new String[0];
    private String[] mProcedureTypes = new String[0];
    private String[] mProcedureValues = new String[0];
    private boolean[] mIsProcedureRuns = new boolean[0];
    private boolean[] mIsReadOnlyProcedures = new boolean[0];
    private boolean mIsProcedureDisabled = true;
    private MultiCheckbox mProcedureMCB = new MultiCheckbox("procedureName", new String[0]);
    private String mXML = "";
    private String mLatestVersion = "";
    private String mNextMajorVersion = "";
    private String mNextMinorVersion = "";
    private String mPreviousFullName = "";
    private String mPreviousVersion = "";
    private String mMode = "";
    private Component mComponent = null;
    private Component mOldComponent = null;
    private ComponentID mPreviousID = null;
    private boolean mIsHidingPrevious = true;
    private boolean mIsMajorVersion = false;
    private boolean mIsNew = false;
    private final UserManager mUserDBInterface;
    private final ResourceSubsystem mResourceSubsystem;
    private final PlanInterface mPlanInterface;
    private ComponentVersionHistoryBean mVersionBean = null;
    private ComponentEditBean mEditBean = null;
    private ComponentSettingsBean mSettingsBean = null;

    public ComponentDetailsBean(UserManager um, ResourceSubsystem rs, PlanInterface pi) {
        this.mUserDBInterface = um;
        this.mResourceSubsystem = rs;
        this.mPlanInterface = pi;
    }

    public String getComponentID() {
        return this.mComponentID;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public String getComponentFullName() {
        return this.mComponentFullName;
    }

    public String getComponentFolderID() {
        return this.mComponentFolderID;
    }

    public String getComponentFolderPath() {
        return this.mComponentFolderPath;
    }

    public String getComponentType() {
        return this.mComponentType;
    }

    public String getComponentTypeID() {
        return this.mComponentTypeID;
    }

    public String getComponentLabel() {
        return this.mComponentLabel;
    }

    public String getDescription() {
        return this.mComponentDescription;
    }

    public String getVersion() {
        return this.mComponentVersion;
    }

    public String getPlatform() {
        return this.mComponentPlatform;
    }

    public String getComponentSource() {
        return this.mComponentSource;
    }

    public String getComponentCheckInDate() {
        return this.mComponentCheckInDate;
    }

    public String getCheckInBy() {
        return this.mComponentCheckInUser;
    }

    public String getCatNamesString() {
        return this.mCatNamesString;
    }

    public String getPluginName() {
        return this.mPluginName;
    }

    public String getPluginID() {
        return this.mPluginID;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public boolean getAutoRunOnFolder() {
        return this.mAutoRunOnFolder;
    }

    public boolean getCheckinCurrentOnFolder() {
        return this.mCheckinCurrentOnFolder;
    }

    public boolean getExecuteOnFolder() {
        return this.mExecuteOnFolder;
    }

    public boolean getWriteOnFolder() {
        return this.mWriteOnFolder;
    }

    public boolean getWriteOnAnyFolder() {
        return this.mWriteOnAnyFolder;
    }

    public boolean isHiddenComponent() {
        return this.mIsHiddenComponent;
    }

    public boolean isSimpleComponent() {
        return this.mIsSimpleComponent;
    }

    public boolean isBrowsableComponent() {
        return this.mIsBrowsableComponent;
    }

    public boolean getHasCheckinCurrent() {
        return this.mHasCheckinCurrent;
    }

    public boolean getHasCreateNewVersion() {
        return this.mHasCreateNewVersion;
    }

    public boolean isAbstractComponent() {
        return this.mIsAbstractComponent;
    }

    public CategoryIDSet getCategoryIDSet() {
        return this.mComponentCategoryIDSet;
    }

    public int getDoneCount() {
        return this.mDoneCount;
    }

    public String getDestination() {
        return this.mDestination;
    }

    public boolean getAllowsVariableSettings() {
        return this.mAllowsVariableSettings;
    }

    public boolean getIsEditOperation() {
        return this.mIsEditOperation;
    }

    public boolean getIsDownloadContentsEnabled() {
        return this.mIsDownloadContentsEnabled;
    }

    public void setComponentName(String name) {
        this.mComponentName = name;
    }

    public void setComponentFullName(String inComponentName) {
        this.mComponentFullName = inComponentName;
    }

    public void setComponentLabel(String inValue) {
        this.mComponentLabel = inValue;
    }

    public void setComponentDescription(String inValue) {
        this.mComponentDescription = inValue;
    }

    public void setComponentType(String inComponentType) {
        this.mComponentType = inComponentType;
    }

    public void setIsHiddenComponent(boolean val) {
        this.mIsHiddenComponent = val;
    }

    public void setDoneCount(int in) {
        this.mDoneCount = in;
    }

    public void setDestination(String inDestination) {
        this.mDestination = inDestination;
    }

    public void setWriteOnPlugin(boolean inWriteOnPlugin) {
        this.mWriteOnPlugin = inWriteOnPlugin;
    }

    public void setWriteOnFolder(boolean inWriteOnFolder) {
        this.mWriteOnFolder = inWriteOnFolder;
    }

    public void setIsEditOperation(boolean inIsEditOperation) {
        this.mIsEditOperation = inIsEditOperation;
    }

    public void setIsDownloadContentsEnabled(boolean inIsDownloadContentsEnabled) {
        this.mIsDownloadContentsEnabled = inIsDownloadContentsEnabled;
    }

    public String[] getComponentOptionsDescs() {
        return this.mComponentOptionsDescs;
    }

    public ResourceDetailsBean getResourceDetailsBean() {
        return this.mResourceDetailsBean;
    }

    public String[] getResourceIDs() {
        return this.mResourceIDs;
    }

    public String[] getResourceFullNames() {
        return this.mResourceFullNames;
    }

    public String[] getResourceVersions() {
        return this.mResourceVersions;
    }

    public String[] getResourceTypes() {
        return this.mResourceTypes;
    }

    public String[] getResourceSources() {
        return this.mResourceSources;
    }

    public Modifier[] getResourceModifiers() {
        return this.mResourceModifiers;
    }

    public boolean[] isMostRecentResources() {
        return this.mIsMostRecentResources;
    }

    public UITree[] getResourceTrees() {
        return this.mResourceTrees;
    }

    public boolean isTreeShowing() {
        return this.mIsTreeShowing;
    }

    public boolean getIsReadOnlyResourceList() {
        return this.mIsReadOnlyResourceList;
    }

    public void setIsTreeShowing(boolean isTreeShowing) {
        this.mIsTreeShowing = isTreeShowing;
    }

    public String getTargetableHostName() {
        return this.mTargetableHostName;
    }

    public String getTargetableHostTypeName() {
        return this.mTargetableHostTypeName;
    }

    public boolean getTargetableHostVirtual() {
        return this.mTargetableHostVirtual;
    }

    public String[] getComponentVarName() {
        return this.mComponentVarName;
    }

    public String[] getComponentVarValue() {
        return this.mComponentVarValue;
    }

    public String[] getComponentVarPrompt() {
        return this.mComponentVarPrompt;
    }

    public boolean[] isComponentVarReadOnly() {
        return this.mIsComponentVarReadOnly;
    }

    public String[] getProcedureNames() {
        return this.mProcedureNames;
    }

    public String[] getProcedureDisplayNames() {
        return this.mProcedureDisplayNames;
    }

    public String[] getProcedureTypes() {
        return this.mProcedureTypes;
    }

    public boolean[] isProcedureRuns() {
        return this.mIsProcedureRuns;
    }

    public boolean[] isReadOnlyProcedures() {
        return this.mIsReadOnlyProcedures;
    }

    public boolean isProcedureDisabled() {
        return this.mIsProcedureDisabled;
    }

    public MultiCheckbox getProcedureCheckboxes() {
        return this.mProcedureMCB;
    }

    public String getXML() {
        return this.mXML;
    }

    public String getNextMajorVersion() {
        return this.mNextMajorVersion;
    }

    public String getNextMinorVersion() {
        return this.mNextMinorVersion;
    }

    public String getPreviousName() {
        return this.mPreviousFullName;
    }

    public String getPreviousVersion() {
        return this.mPreviousVersion;
    }

    public String getMode() {
        return this.mMode;
    }

    public boolean getIsHidingPrevious() {
        return this.mIsHidingPrevious;
    }

    public boolean getIsMajorVersion() {
        return this.mIsMajorVersion;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public void setXML(String xml) {
        this.mXML = xml;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void setIsHidingPrevious(boolean ihp) {
        this.mIsHidingPrevious = ihp;
    }

    public void setIsMajorVersion(boolean imv) {
        this.mIsMajorVersion = imv;
    }

    public void setIsNew(boolean b) {
        this.mIsNew = b;
    }

    public String getID() {
        if (this.getComponentID() != null && !this.getComponentID().equals("")) {
            return this.getComponentID();
        }
        return super.getID();
    }

    public ComponentVersionHistoryBean getVersionHistoryBean() {
        if (this.mVersionBean == null) {
            this.mVersionBean = new ComponentVersionHistoryBean(this.mUserDBInterface);
        }
        return this.mVersionBean;
    }

    public ComponentEditBean getEditBean() {
        if (this.mEditBean == null) {
            this.mEditBean = new ComponentEditBean(this.mUserDBInterface, this.mResourceSubsystem);
        }
        return this.mEditBean;
    }

    public ComponentSettingsBean getSettingsBean() throws RaplixException {
        if (this.mSettingsBean == null) {
            this.mSettingsBean = new ComponentSettingsBean();
            if (this.mComponent != null) {
                this.mSettingsBean.loadSettings(this.mComponentID);
                this.mSettingsBean.setSelectID("");
                this.mSettingsBean.setIsEditing(false);
                this.mSettingsBean.setMode("display");
            }
        }
        return this.mSettingsBean;
    }

    public void setComponentFolderID(String folderID) throws RaplixException {
        this.mComponentFolderID = folderID;
        this.mComponentFolderPath = ChangePathBean.folderIDtoFilePath(this.mComponentFolderID);
    }

    public void loadDetails(String componentID) throws RaplixException {
        this.detailsLoader(componentID, true);
    }

    public void loadMinimalDetails(String componentID) throws RaplixException {
        this.detailsLoader(componentID, false);
    }

    private void detailsLoader(String stringComponentID, boolean loadFully) throws RaplixException {
        RsrcCheckoutInfo mRsrcCheckoutInfo;
        ComponentID cid = new ComponentID(stringComponentID);
        SingleComponentQuery scq = cid.getByIDQuery();
        this.mComponent = scq.select();
        this.generateOutputFields();
        this.mIsDownloadContentsEnabled = true;
        if (!(this.mComponent.getResource() == null || (mRsrcCheckoutInfo = this.mResourceSubsystem.getCheckoutInfo(this.mComponent.getResource().getResourceID())).getNumFilesAllowsGuiCheckout() && mRsrcCheckoutInfo.getDataSizeAllowsGuiCheckout())) {
            this.mIsDownloadContentsEnabled = false;
        }
        if (loadFully) {
            if (this.mComponent.getResource() != null) {
                this.mResourceDetailsBean = new ResourceDetailsBean(this.mResourceSubsystem, this.mUserDBInterface);
                this.mResourceDetailsBean.loadResourceDetails(this.mComponent.getResource().getResourceID().toString());
            }
            if (!this.mComponent.isSimpleComponent()) {
                this.loadResources();
            }
            this.loadVariables();
            this.loadProcedures();
        }
    }

    private void loadResources() throws RaplixException {
        this.mIsReadOnlyResourceList = this.mComponent.getCompRefListModifier().equals(Modifier.FINAL);
        ComponentRefDecl[] crda = this.mComponent.getCompRefList(null);
        if (crda != null) {
            int numResources = crda.length;
            this.mResourceIDs = new String[numResources];
            this.mResourceFullNames = new String[numResources];
            this.mResourceVersions = new String[numResources];
            this.mResourceTypes = new String[numResources];
            this.mResourceSources = new String[numResources];
            this.mResourceModifiers = new Modifier[numResources];
            this.mIsMostRecentResources = new boolean[numResources];
            this.mResourceTrees = new UITree[numResources];
            for (int i = 0; i < numResources; ++i) {
                SummaryComponent latestComp;
                this.mResourceTypes[i] = crda[i].getType().equals(ComponentType.ROOT) ? ComponentTypesListBean.ANY_COMPONENT_TYPE : crda[i].getType().getTypeName();
                this.mResourceModifiers[i] = crda[i].getModifier();
                SummaryComponent currComp = crda[i].getComponent();
                if (currComp == null) {
                    this.mResourceIDs[i] = "";
                    this.mResourceFullNames[i] = "";
                    this.mResourceVersions[i] = "";
                    this.mResourceSources[i] = "";
                    this.mIsMostRecentResources[i] = false;
                    this.mResourceTrees[i] = new UITree();
                    continue;
                }
                this.mResourceIDs[i] = currComp.getID().toString();
                this.mResourceFullNames[i] = currComp.getFullName();
                this.mResourceVersions[i] = currComp.getVersionNumber().getAsString();
                SourceInfo si = currComp.getSourceInfo();
                this.mResourceSources[i] = ComponentDetailsBean.generateComponentSource(si);
                this.mResourceTrees[i] = new UITree();
                Component currSubComp = currComp.getID().getByIDQuery().select();
                ComponentNode node = new ComponentNode(false);
                node.setVisible(false);
                node.loadComponent(currSubComp);
                this.mResourceTrees[i].setRoot(node);
                int currVersion = currComp.getVersionNumber().getSingleVersionNumber();
                try {
                    latestComp = SingleComponentQuery.byName(currComp.getPath(), currComp.getName(), null).selectSummaryView();
                }
                catch (RaplixException re) {
                    latestComp = currComp;
                }
                int latestVersion = latestComp.getVersionNumber().getSingleVersionNumber();
                this.mIsMostRecentResources[i] = latestVersion <= currVersion;
                this.mResourceTypes[i] = ComponentTypesListBean.normalizeName(currComp.getExtendsTypeName());
            }
        }
    }

    private void loadVariables() {
        VarDecl[] vda = this.mComponent.getVarList(null);
        int numVariables = vda.length;
        this.mComponentVarName = new String[numVariables];
        this.mComponentVarValue = new String[numVariables];
        this.mComponentVarPrompt = new String[numVariables];
        this.mIsComponentVarReadOnly = new boolean[numVariables];
        for (int i = 0; i < numVariables; ++i) {
            this.mComponentVarName[i] = vda[i].getName();
            this.mComponentVarValue[i] = StringUtil.normalizeEmpty(vda[i].getDefaultValue());
            this.mComponentVarPrompt[i] = StringUtil.normalizeEmpty(vda[i].getPrompt());
            if (!vda[i].getModifier().equals(Modifier.FINAL)) continue;
            this.mIsComponentVarReadOnly[i] = true;
        }
    }

    private void loadProcedures() throws RaplixException {
        NamedBlock[] il = this.mComponent.getInstallList(CallSpec.PUBLIC);
        NamedBlock[] ul = this.mComponent.getUninstallList(CallSpec.PUBLIC);
        NamedBlock[] cl = this.mComponent.getControlList(CallSpec.PUBLIC);
        Vector names = new Vector();
        Vector types = new Vector();
        Vector isReadOnlys = new Vector();
        this.namedBlockHelper(il, names, types, isReadOnlys, INSTALL_BLOCK_TYPE);
        this.namedBlockHelper(ul, names, types, isReadOnlys, UNINSTALL_BLOCK_TYPE);
        this.namedBlockHelper(cl, names, types, isReadOnlys, CALL_BLOCK_TYPE);
        this.mProcedureNames = (String[])CollectionUtil.mapClass(names, String;.class);
        this.mProcedureTypes = (String[])CollectionUtil.mapClass(types, String;.class);
        this.mIsReadOnlyProcedures = (boolean[])CollectionUtil.mapClass(isReadOnlys, [Z.class);
        int numProcedures = this.mProcedureNames.length;
        this.mProcedureValues = new String[numProcedures];
        this.mProcedureDisplayNames = new String[numProcedures];
        for (int i = 0; i < numProcedures; ++i) {
            this.mProcedureValues[i] = this.mProcedureNames[i] + PROCEDURE_SEPARATOR + this.mProcedureTypes[i];
            this.mProcedureDisplayNames[i] = this.mProcedureTypes[i].equals(INSTALL_BLOCK_TYPE) || this.mProcedureTypes[i].equals(UNINSTALL_BLOCK_TYPE) ? this.mProcedureTypes[i] + PROCEDURE_NAME_SEPARATOR + this.mProcedureNames[i] : this.mProcedureNames[i];
        }
        this.proceduresHaveRunHistories();
        this.componentInstalledCheck();
        this.mProcedureMCB = new MultiCheckbox("procedureName", this.mProcedureValues);
    }

    public void renameComponent(String newName) throws RaplixException {
        ComponentID componentID = new ComponentID(this.mComponentID);
        componentID.move(newName, null);
    }

    public void moveComponent(String newPathID) throws RaplixException {
        ComponentID componentID = new ComponentID(this.mComponentID);
        componentID.move(null, new FolderID(newPathID));
    }

    public void updateVisibility(String id, boolean isHiddenVal) throws RaplixException {
        Visibility v = isHiddenVal ? Visibility.HIDDEN : Visibility.VISIBLE;
        ComponentID cid = new ComponentID(id);
        cid.updateVisibility(v);
        if (this.mComponentID != null && this.mComponentID.equals(id)) {
            this.mIsHiddenComponent = isHiddenVal;
        }
    }

    public void updateCategories(String id, String[] catIDs, boolean replaceExisting, boolean allVersions) throws RaplixException {
        int numCatIDs = catIDs.length;
        CategoryID[] categoryIDs = new CategoryID[numCatIDs];
        for (int i = 0; i < numCatIDs; ++i) {
            categoryIDs[i] = new CategoryID(catIDs[i]);
        }
        CategoryIDSet catIDSet = new CategoryIDSet(Arrays.asList(categoryIDs));
        CategoryUpdateContext ctx = new CategoryUpdateContext(catIDSet);
        ctx.setReplaceExisting(replaceExisting);
        ctx.setAllVersions(allVersions);
        ComponentID componentID = new ComponentID(id);
        componentID.updateCategories(ctx);
        this.mComponentCategoryIDSet = catIDSet;
    }

    public void createComponentXML() throws RaplixException {
        this.mComponent = new Component();
        this.mComponent.setName(this.mComponentName);
        if (!this.mComponentType.equals("untyped")) {
            this.mComponent.setExtendsType(ComponentType.create(this.mComponentType));
        }
        this.mComponent.setPath(new FolderID(this.mComponentFolderID));
        this.mComponent.setLabel(this.mComponentLabel);
        this.mComponent.setDescription(this.mComponentDescription);
        this.mXML = this.mComponent.writeToXML();
    }

    public String verifyComponentXML() throws RaplixException {
        SummaryComponent latestComponent;
        Component c = new Component();
        c.readFromXML(this.mXML);
        String name = c.getName();
        this.mComponentType = ComponentTypesListBean.normalizeName(c.getExtendsType());
        this.mComponentPlatform = c.getPlatform();
        this.mComponentLabel = c.getLabel();
        this.mComponentDescription = c.getDescription();
        try {
            SingleComponentQuery scq = SingleComponentQuery.byName(new FolderID(this.mComponentFolderID), this.mComponentName, null);
            latestComponent = scq.selectSummaryView();
            this.mLatestVersion = latestComponent.getVersionNumber().getAsString();
        }
        catch (NoResultsFoundException ex) {
            latestComponent = c;
            this.mLatestVersion = null;
        }
        this.mNextMinorVersion = latestComponent.getVersionNumber().nextMinorVersionNumber().getAsString();
        this.mNextMajorVersion = latestComponent.getVersionNumber().nextMajorVersionNumber().getAsString();
        if (this.mIsNew) {
            this.mPreviousFullName = "";
            this.mPreviousVersion = "";
            this.mPreviousID = null;
        } else {
            this.mPreviousFullName = this.mComponent.getName();
            this.mPreviousVersion = this.mComponent.getVersionNumber().getAsString();
            this.mPreviousID = this.mComponent.getID();
        }
        return name;
    }

    public void checkinComponent() throws RaplixException {
        if (this.mMode.equals("checkinas")) {
            this.mComponent = this.mComponent.getDataClone();
        } else if (this.mIsNew) {
            this.mComponent = new Component();
        }
        this.mComponent.readFromXML(this.mXML);
        this.mComponent.setName(this.mComponentName);
        this.mComponent.setPath(new FolderID(this.mComponentFolderID));
        VersionNumber version = null;
        if (!this.mMode.equals("checkinas") && !this.mIsNew) {
            version = new VersionNumber(this.mLatestVersion);
        }
        ComponentSaveContext ctx = new ComponentSaveContext();
        ctx.setLatestVersion(version);
        ctx.setSaveAsNewMajor(this.mIsMajorVersion);
        if (this.mIsHidingPrevious) {
            ctx.setHideObjectID(this.mPreviousID);
        }
        if (!this.mMode.equals("checkinas") && !this.mIsNew) {
            ctx.setImportSettingsFromID(this.mPreviousID);
        }
        this.mComponent.save(ctx);
        this.mComponentID = this.mComponent.getID().toString();
    }

    public void checkpointState() {
        this.mOldComponent = this.mComponent;
    }

    public void rollbackState() throws RaplixException {
        this.mComponent = this.mOldComponent;
        this.generateOutputFields();
        this.mOldComponent = null;
    }

    private void generateOutputFields() throws RaplixException {
        PluginID pluginID;
        if (this.mComponent.getID() != null) {
            this.mComponentID = this.mComponent.getID().toString();
        }
        this.mComponentName = this.mComponent.getName();
        this.mComponentFullName = this.mComponent.getFullName();
        this.mComponentFolderID = this.mComponent.getPath().toString();
        this.mComponentFolderPath = Util.fullNameToPath(this.mComponentFullName);
        this.mComponentType = ComponentTypesListBean.normalizeName(this.mComponent.getExtendsType());
        if (this.mComponent.getExtendsType().getComponentTypeRef() != null) {
            this.mComponentTypeID = this.mComponent.getExtendsType().getComponentTypeRef().getID().toString();
        }
        this.mIsBrowsableComponent = ComponentTypesListBean.isBrowsableComponentType(this.mComponentType);
        this.mHasCheckinCurrent = ComponentTypesListBean.hasCheckinCurrentCapability(this.mComponentType, this.mComponent.getSourceInfo());
        this.mHasCreateNewVersion = ComponentTypesListBean.hasCreateNewVersionCapability(this.mComponentType);
        if (this.mComponent.getModifier().equals(Modifier.ABSTRACT)) {
            this.mIsAbstractComponent = true;
        }
        this.mComponentDescription = this.mComponent.getDescription();
        if (this.mComponent.getVersionNumber() != null) {
            this.mComponentVersion = this.mComponent.getVersionNumber().getAsString();
        }
        this.mComponentPlatform = this.mComponent.getPlatform();
        this.mComponentLabel = this.mComponent.getLabel();
        this.mComponentCategoryIDSet = this.mComponent.getCategories();
        this.mCatNamesString = CategoriesBean.getCategoryNamesString(this.mComponentCategoryIDSet);
        TargetRef targetHost = this.mComponent.getTargetRef();
        if (targetHost != null) {
            this.mTargetableHostName = targetHost.getHostName();
            this.mTargetableHostTypeName = targetHost.getTypeName();
            this.mTargetableHostVirtual = targetHost.isVirtual();
        }
        if ((pluginID = this.mComponent.getPluginID()) != null) {
            this.mPluginID = pluginID.toString();
            this.mPluginName = pluginID.getByIDQuery().selectSummaryView().getName();
        }
        this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin(this.mComponent);
        this.mExecuteOnFolder = PermissionChecker.hasExecuteOnFolder(this.mComponent.getPath());
        this.mWriteOnFolder = PermissionChecker.hasWriteOnFolder(this.mComponent.getPath());
        this.mWriteOnAnyFolder = PermissionChecker.hasWriteOnAnyFolder();
        this.mCheckinCurrentOnFolder = PermissionChecker.hasCheckinCurrentOnFolder(this.mComponent.getPath());
        this.mAutoRunOnFolder = PermissionChecker.hasAutoRunOnFolder(this.mComponent.getPath());
        this.mXML = this.mComponent.writeToXML();
        this.mComponentCheckInDate = Util.formatDate(this.mComponent.getTimeStamp());
        if (this.mComponent.getUserID() != null) {
            this.mComponentCheckInUser = this.mUserDBInterface.getUser(this.mComponent.getUserID()).getUsername();
        }
        this.mIsHiddenComponent = this.mComponent.getVisibility().equals(Visibility.HIDDEN);
        this.mIsSimpleComponent = this.mComponent.isSimpleComponent();
        SourceInfo si = this.mComponent.getSourceInfo();
        this.mComponentSource = ComponentDetailsBean.generateComponentSource(si);
        if (this.mIsSimpleComponent && si != null) {
            this.mComponentOptionsDescs = si.getVarDescriptions();
        }
        this.mAllowsVariableSettings = ComponentDetailsBean.allowVariableSets(this.mComponent);
    }

    private void namedBlockHelper(NamedBlock[] nba, Vector names, Vector types, Vector isReadOnlys, String type) {
        for (int i = 0; i < nba.length; ++i) {
            names.add(nba[i].getName());
            types.add(type);
            if (nba[i].getDeclaringComponent().getID().equals(this.mComponent.getID())) {
                isReadOnlys.add(Boolean.FALSE);
                continue;
            }
            isReadOnlys.add(Boolean.TRUE);
        }
    }

    private void componentInstalledCheck() throws RaplixException {
        MultiInstalledComponentQuery installedComponentsQuery = MultiInstalledComponentQuery.byTopLevelComp(this.mComponent.getID());
        this.mIsProcedureDisabled = installedComponentsQuery.select().length == 0;
    }

    private void proceduresHaveRunHistories() throws RaplixException {
        ComponentID cid = new ComponentID(this.mComponentID);
        AutogenPlanRunHistoryBean[] aprhb = this.mPlanInterface.queryAutogenRunHistory(cid);
        this.mIsProcedureRuns = new boolean[this.mProcedureNames.length];
        Arrays.fill(this.mIsProcedureRuns, false);
        for (int i = 0; i < aprhb.length; ++i) {
            for (int j = 0; j < this.mProcedureNames.length; ++j) {
                if (!aprhb[i].getProcedureName().equals(this.mProcedureNames[j]) || this.mIsProcedureRuns[j] || NamedBlockType.FACTORY.get(this.mProcedureTypes[j]) != aprhb[i].getProcedureType()) continue;
                this.mIsProcedureRuns[j] = true;
            }
        }
    }

    public static String generateComponentSource(SourceInfo inSi) throws RaplixException {
        StringBuffer sb = new StringBuffer("");
        if (inSi != null) {
            HostID hid = inSi.getHost();
            String sp = inSi.getBrowseLocation();
            if (hid != null) {
                SingleHostQuery shq = hid.getByIDQuery();
                SummaryHost sh = shq.selectSummaryView();
                sb.append(sh.getName());
            }
            if (sp != null) {
                if (hid != null) {
                    sb.append(PROCEDURE_NAME_SEPARATOR);
                }
                sb.append(sp);
            }
        }
        return sb.toString();
    }

    private static boolean allowVariableSets(SummaryComponent sc) {
        boolean returnVal = false;
        try {
            ComponentVariableSettings.validateComponent(sc);
            returnVal = true;
        }
        catch (ComponentDBException componentDBException) {
            // empty catch block
        }
        return returnVal;
    }

    public void setIncrComponentUpdateCount() throws RaplixException {
        ComponentID compId = this.mComponent.getID();
        if (compId != null) {
            Component component = compId.getByIDQuery().select();
            this.mComponent.setUpdateCount(component.getUpdateCount());
        }
    }
}

