/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.compx;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.ui.web.StandardObjectDeleteNode;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypesListBean;

public class ComponentDeleteNode
extends StandardObjectDeleteNode {
    private static final int DELETE_CONFIRM_COLSPAN = 5;
    private String mComponentType = "";
    private String mVersion = "";
    private String mLabel = "";

    public ComponentDeleteNode(DeleteSessionCandidate candidate) throws RaplixException {
        super(candidate);
        SummaryComponent component = (SummaryComponent)this.getObject(candidate);
        this.mName = component.getFullName();
        this.mComponentType = ComponentTypesListBean.normalizeName(component.getExtendsTypeName());
        this.mVersion = component.getVersionNumber().getAsString();
        this.mLabel = component.getLabel();
        this.preRender();
    }

    public int getDeleteConfirmColspan() {
        return 5;
    }

    public String getDeleteContext() {
        return "componentDelete";
    }

    public StandardObject getObject(DeleteSessionCandidate candidate) throws RaplixException {
        ComponentID componentID = (ComponentID)candidate.getParent().getObjectID();
        return componentID.getByIDQuery().selectSummaryView();
    }

    public void preRender() {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String viewURI = UriUtil.componentDetailsURI(this.mObjectID.toString());
        String toolTip = "Show component details";
        String nameLink = Util.standardLink(viewURI, toolTip, Util.preserveSpace(this.mName), "name=\"nameLink-" + this.mObjectID + "\"");
        String typeLink = Util.standardLink(viewURI, toolTip, this.mComponentType);
        String verLink = Util.standardLink(viewURI, toolTip, this.mVersion);
        String labelLink = Util.standardLink(viewURI, toolTip, this.mLabel);
        String descLink = Util.standardLink(viewURI, toolTip, this.mDescription);
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(typeLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(verLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(labelLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(descLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }
}

