/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.categories;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotSavedQueryException;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletSessionBroker;
import com.raplix.rolloutexpress.ui.web.UIActionListServlet;
import com.raplix.rolloutexpress.ui.web.categories.CategoriesBean;
import javax.servlet.http.HttpServletRequest;

public class CategoriesHandleAction
extends UIActionListServlet
implements ActionModeConstants {
    private static final String CAT_ERRORMSG_LIST = "error.categories.list";
    private static final String CAT_ERRORMSG_ADD = "error.categories.add";
    private static final String CAT_ERRORMSG_EDIT = "error.categories.edit";
    private static final String CAT_ERRORMSG_SAVE = "error.categories.save";
    private static final String CAT_ERRORMSG_UPDATECOUNT = "error.categories.updateCount";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null || mode.equals("")) {
            mode = "list";
        }
        if (mode.equals("list")) {
            this.handleList(servletInfo, request);
        } else if (mode.equals("create")) {
            this.handleCreate(servletInfo, request);
        } else if (mode.equals("edit")) {
            this.handleEdit(servletInfo, request);
        } else if (mode.equals("save")) {
            this.handleSave(servletInfo, request);
        } else {
            throw new IllegalArgumentException("Invalid Mode: " + mode);
        }
    }

    public void handleList(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        CategoriesBean cb = (CategoriesBean)servletInfo.getBean();
        cb.generateUnpaginatedList();
        String redirectURI = CategoriesHandleAction.assertGetParam(request, "redirecturi");
        String itemMCID = CategoriesHandleAction.assertGetParam(request, "categoryItemID");
        cb.setRedirectURI(redirectURI);
        cb.setCategoryItemID(itemMCID);
        this.updateCategoryMC(cb, request);
        servletInfo.setDestPage(this.getDefaultPage());
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    public void handleCreate(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        CategoriesBean cb = (CategoriesBean)servletInfo.getBean();
        String name = CategoriesHandleAction.assertGetParam(request, "name");
        String description = CategoriesHandleAction.assertGetParam(request, "description");
        String redirectURI = CategoriesHandleAction.assertGetParam(request, "redirecturi");
        String itemMCID = CategoriesHandleAction.assertGetParam(request, "categoryItemID");
        cb.generateUnpaginatedList();
        cb.createCategory(name, description);
        cb.setIsNew(true);
        cb.setMode("edit");
        cb.setCategoryItemID(itemMCID);
        cb.setRedirectURI(redirectURI);
        this.updateCategoryMC(cb, request);
        servletInfo.setDestPage(this.getDefaultPage());
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    public void handleEdit(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        CategoriesBean cb = (CategoriesBean)servletInfo.getBean();
        String id = CategoriesHandleAction.assertGetParam(request, "id");
        String redirectURI = CategoriesHandleAction.assertGetParam(request, "redirecturi");
        String itemMCID = CategoriesHandleAction.assertGetParam(request, "categoryItemID");
        cb.generateUnpaginatedList();
        cb.loadCategory(id);
        cb.setIsNew(false);
        cb.setMode("edit");
        cb.setCategoryItemID(itemMCID);
        cb.setRedirectURI(redirectURI);
        this.updateCategoryMC(cb, request);
        servletInfo.setDestPage(this.getDefaultPage());
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    public void handleSave(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        CategoriesBean cb = (CategoriesBean)servletInfo.getBean();
        String id = CategoriesHandleAction.assertGetParam(request, "id");
        String name = CategoriesHandleAction.assertGetParam(request, "categoryName");
        String description = CategoriesHandleAction.assertGetParam(request, "categoryDescription");
        String redirectURI = CategoriesHandleAction.assertGetParam(request, "redirecturi");
        String itemMCID = CategoriesHandleAction.assertGetParam(request, "categoryItemID");
        boolean isNew = request.getParameter("isNew") != null;
        int updateCount = Integer.parseInt(CategoriesHandleAction.assertGetParam(request, "updateCount"));
        cb.setCategoryID(id);
        cb.setCategoryName(name);
        cb.setCategoryDescription(description);
        cb.setIsNew(isNew);
        cb.setUpdateCount(updateCount);
        cb.setCategoryItemID(itemMCID);
        cb.setRedirectURI(redirectURI);
        try {
            cb.saveCategory();
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(CAT_ERRORMSG_SAVE);
            if (re instanceof ObjectNotSavedQueryException) {
                servletInfo.getErrors().addMinorErrorKey(CAT_ERRORMSG_UPDATECOUNT);
            } else {
                servletInfo.getErrors().addMinorError(re);
            }
            cb.generateUnpaginatedList();
            if (cb.getIsNew()) {
                cb.createCategory(name, description);
            }
            cb.setMode("edit");
            this.updateCategoryMC(cb, request);
            servletInfo.setDestPage("/categories/categoriesPicker.jsp");
            servletInfo.setShouldRedirect(false);
            servletInfo.setSaveInSession(false);
            return;
        }
        cb.generateUnpaginatedList();
        this.updateCategoryMC(cb, request);
        servletInfo.setDestPage(this.getDefaultPage());
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void updateCategoryMC(CategoriesBean cb, HttpServletRequest request) {
        String mode = request.getParameter("mode");
        if (mode == null || mode.equals("")) {
            mode = "list";
        }
        String categoryMCID = CategoriesHandleAction.assertGetParam(request, "categoryID");
        String selectedCats = request.getParameter("selected");
        MultiCheckbox incoming = (MultiCheckbox)request.getSession().getAttribute(categoryMCID);
        if (mode.equals("create") || mode.equals("edit")) {
            incoming.setSelected(selectedCats);
        }
        MultiCheckbox categoryMC = cb.getMultiCheckbox();
        categoryMC.setSelected(incoming);
        ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
        ssb.put(categoryMC.getID(), categoryMC);
    }

    public ServletBean createBean(HttpServletRequest request) {
        return new CategoriesBean();
    }

    public String getDefaultPage() {
        return "/categories/categoriesPicker.jsp";
    }

    public String getMajorError(HttpServletRequest request) {
        String mode = request.getParameter("mode");
        if (mode.equals("list")) {
            return CAT_ERRORMSG_LIST;
        }
        if (mode.equals("create")) {
            return CAT_ERRORMSG_ADD;
        }
        if (mode.equals("edit")) {
            return CAT_ERRORMSG_EDIT;
        }
        if (mode.equals("save")) {
            return CAT_ERRORMSG_SAVE;
        }
        throw new IllegalArgumentException("Invalid Mode: " + mode);
    }
}

