/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.categories;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.catdb.Category;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryOrder;
import com.raplix.rolloutexpress.systemmodel.catdb.MultiCategoryQuery;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.util.ArrayEdit;
import com.raplix.util.message.MessageManager;

public class CategoriesBean
extends ServletListBean {
    public static final String LABEL_UNCATEGORIZED = MessageManager.messageAsString("ui.cat.label.uncategorized");
    private static final String LABEL_ALLCATEGORIES = MessageManager.messageAsString("ui.cat.label.allcategories");
    private static final String LABEL_NOTCATEGORIZED = MessageManager.messageAsString("ui.cat.label.notcategorized");
    private static final String LABEL_SYSTEM = MessageManager.messageAsString("ui.cat.label.system");
    private String[] mCategoryIDs = new String[0];
    private String[] mCategoryNames = new String[0];
    private String[] mCategoryDescriptions = new String[0];
    private String mCategoryItemID = "";
    private String[] mCategoryItemIDs = new String[0];
    private String mRedirectURI = "";
    private boolean mIsReplaceExisting = false;
    private boolean mIsAllVersions = false;
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private String mCategoryID = "";
    private String mCategoryName = "";
    private String mCategoryDescription = "";
    private String mMode = "";
    private boolean mIsNew = false;
    private int mUpdateCount = 0;

    public String[] getCategoryIDs() {
        return this.mCategoryIDs;
    }

    public String[] getCategoryNames() {
        return this.mCategoryNames;
    }

    public String[] getCategoryDescriptions() {
        return this.mCategoryDescriptions;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public boolean getIsAllVersions() {
        return this.mIsAllVersions;
    }

    public boolean getIsReplaceExisting() {
        return this.mIsReplaceExisting;
    }

    public String getReplaceExisting() {
        return String.valueOf(this.mIsReplaceExisting);
    }

    public String getRedirectURI() {
        return this.mRedirectURI;
    }

    public String getCategoryItemID() {
        return this.mCategoryItemID;
    }

    public String[] getCategoryItemIDs() {
        return this.mCategoryItemIDs;
    }

    public String getCategoryID() {
        return this.mCategoryID;
    }

    public String getCategoryName() {
        return this.mCategoryName;
    }

    public String getCategoryDescription() {
        return this.mCategoryDescription;
    }

    public String getMode() {
        return this.mMode;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    public void setCategoryID(String id) {
        this.mCategoryID = id;
    }

    public void setCategoryName(String name) {
        this.mCategoryName = name;
    }

    public void setCategoryDescription(String desc) {
        this.mCategoryDescription = desc;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void setIsNew(boolean isNew) {
        this.mIsNew = isNew;
    }

    public void setUpdateCount(int updateCount) {
        this.mUpdateCount = updateCount;
    }

    public void setMultiCheckbox(MultiCheckbox mc) {
        this.mMultiCheckbox = mc;
    }

    public void setIsReplaceExisting(boolean replace) {
        this.mIsReplaceExisting = replace;
    }

    public void setIsAllVersions(boolean allVersions) {
        this.mIsAllVersions = allVersions;
    }

    public void setRedirectURI(String uri) {
        this.mRedirectURI = uri;
    }

    public void setCategoryItemID(String itemID) {
        this.mCategoryItemID = itemID;
    }

    public void setCategoryItemIDs(String[] itemIDs) {
        this.mCategoryItemIDs = itemIDs;
    }

    protected void generateList() throws RaplixException {
        MultiCategoryQuery query = MultiCategoryQuery.all();
        this.prepQuery(query, CategoryOrder.BY_NAME_ASC);
        this.generateOutputArrays(query.select());
    }

    protected void generateUnpaginatedList() throws RaplixException {
        MultiCategoryQuery query = MultiCategoryQuery.all();
        query.setObjectOrder(CategoryOrder.BY_NAME_ASC);
        this.generateOutputArrays(query.select());
    }

    private void generateOutputArrays(Category[] categories) {
        int numCategories = categories.length;
        this.mCategoryIDs = new String[numCategories];
        this.mCategoryNames = new String[numCategories];
        this.mCategoryDescriptions = new String[numCategories];
        for (int i = 0; i < numCategories; ++i) {
            this.mCategoryIDs[i] = categories[i].getID().toString();
            this.mCategoryNames[i] = categories[i].getName();
            this.mCategoryDescriptions[i] = categories[i].getDescription();
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mCategoryIDs);
    }

    public void loadCategory(String id) throws RaplixException {
        Category category = new CategoryID(id).getByIDQuery().select();
        this.mCategoryID = id;
        this.mCategoryName = category.getName();
        this.mCategoryDescription = category.getDescription();
        this.mUpdateCount = category.getUpdateCount();
    }

    public void createCategory(String name, String description) {
        this.mCategoryName = name;
        this.mCategoryDescription = description;
        this.mIsNew = true;
        this.mCategoryIDs = (String[])ArrayEdit.prepend(this.mCategoryIDs, "", true);
        this.mCategoryNames = (String[])ArrayEdit.prepend(this.mCategoryNames, this.mCategoryName, true);
        this.mCategoryDescriptions = (String[])ArrayEdit.prepend(this.mCategoryDescriptions, this.mCategoryDescription, true);
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mCategoryIDs);
    }

    public void saveCategory() throws RaplixException {
        Category category = this.mIsNew ? new Category() : new CategoryID(this.mCategoryID).getByIDQuery().select();
        category.setName(this.mCategoryName);
        category.setDescription(this.mCategoryDescription);
        category.setUpdateCount(this.mUpdateCount);
        category.save();
    }

    public void loadCategoryFilters() throws RaplixException {
        MultiCategoryQuery query = MultiCategoryQuery.all();
        query.setObjectOrder(CategoryOrder.BY_NAME_ASC);
        this.generateOutputArrays(query.select());
        this.mCategoryIDs = (String[])ArrayEdit.prepend(this.mCategoryIDs, Category.NO_CATEGORY_ID.toString(), true);
        this.mCategoryNames = (String[])ArrayEdit.prepend(this.mCategoryNames, LABEL_NOTCATEGORIZED, true);
        this.mCategoryDescriptions = (String[])ArrayEdit.prepend(this.mCategoryDescriptions, "", true);
        this.mCategoryIDs = (String[])ArrayEdit.prepend(this.mCategoryIDs, Category.ANY_CATEGORY_ID.toString(), true);
        this.mCategoryNames = (String[])ArrayEdit.prepend(this.mCategoryNames, LABEL_ALLCATEGORIES, true);
        this.mCategoryDescriptions = (String[])ArrayEdit.prepend(this.mCategoryDescriptions, "", true);
    }

    public static String getCategoryNamesString(CategoryIDSet catIDSet) throws RaplixException {
        if (catIDSet == null || catIDSet.toArray().length == 0) {
            return LABEL_UNCATEGORIZED;
        }
        MultiCategoryQuery query = catIDSet.getByIDsQuery();
        Category[] categories = query.select();
        int numCommas = categories.length - 1;
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < numCommas; ++i) {
            sb.append(categories[i].getName());
            sb.append(", ");
        }
        sb.append(categories[numCommas].getName());
        return sb.toString();
    }
}

