/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.categories;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotSavedQueryException;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionListServlet;
import com.raplix.rolloutexpress.ui.web.categories.CategoriesBean;
import javax.servlet.http.HttpServletRequest;

public class CategoriesAction
extends UIActionListServlet
implements ActionModeConstants {
    private static final String CAT_ERRORMSG_LIST = "error.categories.list";
    private static final String CAT_ERRORMSG_ADD = "error.categories.add";
    private static final String CAT_ERRORMSG_EDIT = "error.categories.edit";
    private static final String CAT_ERRORMSG_SAVE = "error.categories.save";
    private static final String CAT_ERRORMSG_UPDATECOUNT = "error.categories.updateCount";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null || mode.equals("")) {
            mode = "list";
        }
        if (mode.equals("list")) {
            this.handleList(servletInfo, request);
        } else if (mode.equals("add")) {
            this.handleCreate(servletInfo, request);
        } else if (mode.equals("edit")) {
            this.handleEdit(servletInfo, request);
        } else if (mode.equals("save")) {
            this.handleSave(servletInfo, request);
        } else {
            throw new IllegalArgumentException("Invalid Mode: " + mode);
        }
    }

    public void handleList(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        String minorErrorKey;
        CategoriesBean cb = (CategoriesBean)servletInfo.getBean();
        String majorErrorKey = request.getParameter("majorErrorKey");
        if (majorErrorKey != null) {
            servletInfo.getErrors().setMajorErrorKey(majorErrorKey);
        }
        if ((minorErrorKey = request.getParameter("minorErrorKey")) != null) {
            servletInfo.getErrors().addMinorErrorKey(minorErrorKey);
        }
        this.loadListParameters(request, cb);
        cb.generateList();
        servletInfo.setDestPage("/categories/categories.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    public void handleCreate(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        CategoriesBean cb = (CategoriesBean)servletInfo.getBean();
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        this.loadListParameters(request, cb);
        cb.generateList();
        cb.createCategory(name, description);
        cb.setIsNew(true);
        cb.setMode("edit");
        servletInfo.setDestPage("/categories/categories.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    public void handleEdit(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        CategoriesBean cb = (CategoriesBean)servletInfo.getBean();
        String id = CategoriesAction.assertGetParam(request, "id");
        this.loadListParameters(request, cb);
        cb.generateList();
        cb.loadCategory(id);
        cb.setIsNew(false);
        cb.setMode("edit");
        servletInfo.setDestPage("/categories/categories.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    public void handleSave(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        CategoriesBean cb = (CategoriesBean)servletInfo.getBean();
        String id = CategoriesAction.assertGetParam(request, "id");
        String name = request.getParameter("categoryName");
        String description = request.getParameter("categoryDescription");
        boolean isNew = request.getParameter("isNew") != null;
        int updateCount = Integer.parseInt(CategoriesAction.assertGetParam(request, "updateCount"));
        cb.setCategoryID(id);
        cb.setCategoryName(name);
        cb.setCategoryDescription(description);
        cb.setIsNew(isNew);
        cb.setUpdateCount(updateCount);
        try {
            cb.saveCategory();
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(CAT_ERRORMSG_SAVE);
            if (re instanceof ObjectNotSavedQueryException) {
                servletInfo.getErrors().addMinorErrorKey(CAT_ERRORMSG_UPDATECOUNT);
            } else {
                servletInfo.getErrors().addMinorError(re);
            }
            cb.generateList();
            if (cb.getIsNew()) {
                cb.createCategory(name, description);
            }
            cb.setMode("edit");
            servletInfo.setDestPage("/categories/categories.jsp");
            servletInfo.setShouldRedirect(false);
            servletInfo.setSaveInSession(false);
            return;
        }
        this.loadListParameters(request, cb);
        cb.generateList();
        servletInfo.setDestPage("/categories/categories.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    public ServletBean createBean(HttpServletRequest request) {
        return new CategoriesBean();
    }

    public String getDefaultPage() {
        return "/categories/categories.jsp";
    }

    public String getMajorError(HttpServletRequest request) {
        String mode = request.getParameter("mode");
        if (mode.equals("list")) {
            return CAT_ERRORMSG_LIST;
        }
        if (mode.equals("add")) {
            return CAT_ERRORMSG_ADD;
        }
        if (mode.equals("edit")) {
            return CAT_ERRORMSG_EDIT;
        }
        if (mode.equals("save")) {
            return CAT_ERRORMSG_SAVE;
        }
        throw new IllegalArgumentException("Invalid Mode: " + mode);
    }
}

