/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.WebUIApplicationInterface;
import com.raplix.rolloutexpress.config.VariableSettingsManager;
import com.raplix.rolloutexpress.difference.DifferenceInterface;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBInterface;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.rule.RuleMetaDataManager;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.ContextException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportServices;
import com.raplix.rolloutexpress.node.NodeAdminSubsystem;
import com.raplix.rolloutexpress.node.NodeManagementServices;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBManager;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBAdmin;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.UIContextServices;
import com.raplix.rolloutexpress.ui.web.ROXServlet;
import com.raplix.rolloutexpress.ui.web.StringConstants;
import com.raplix.rolloutexpress.ui.web.WebServerSubsystem;
import com.raplix.util.logger.Logger;
import java.util.Hashtable;

public class WebUIApplication
extends Application
implements StringConstants,
WebUIApplicationInterface {
    public static final String APP_OVERRIDE_VALUE = "OverriddenValue";
    protected WebServerSubsystem mWebServerSubsystem;
    protected NetSubsystem mNetSubsystem = NetSubsystem.createNetSubsystemForClient(this);
    protected RemoteUserDBSubsystem mUserDBSubsystem;
    protected RoxAddress mServerAddress;
    protected UIContextServices mUIContextServices;
    protected PlanInterface mPlanInterface;
    protected DifferenceDBInterface mDifferenceDBInterface;
    protected DifferenceInterface mDifferenceInterface;
    protected NotificationRPCInterface mNotificationInterface;
    protected UserDBAdmin mUserDBAdmin;
    protected SessionManager mSessionManager;
    protected ResourceSubsystem mResourceSubsystem = new ResourceSubsystem(this);
    protected RuleMetaDataManager mRuleMetaDataManager;
    protected TransportServices mTransportServices;
    protected VariableSettingsManager mVariableSettingsManager;
    protected InstallDBManager mInstallDBManager;
    protected NodeManagementServices mNodeManagementServices;

    public WebUIApplication(String[] inCommandLineArgs) throws ConfigurationException {
        super(inCommandLineArgs);
        this.mUserDBSubsystem = new RemoteUserDBSubsystem(this);
        ConnectionSetupAttribute[] clientConns = this.mNetSubsystem.getClientConnAttributes();
        Logger.debug("Number of client connections: " + clientConns.length, this);
        if (clientConns.length <= 0) {
            throw new ConfigurationException("Unable to parse address for server");
        }
        String serverAddress = clientConns[0].getAddress();
        int serverPort = clientConns[0].getPort();
        Logger.debug("Connecting to Server: " + serverAddress + ":" + serverPort, this);
        RPCManager manager = this.mNetSubsystem.getRPC();
        this.mUIContextServices = new UIContextServices();
        try {
            manager.getContextManager().activateServices(this.mUIContextServices);
        }
        catch (ContextException ex) {
            Logger.error(ex.toString(), ex, this);
            throw new ConfigurationException("Unable to parse address for server");
        }
        try {
            this.mServerAddress = new RoxAddress(serverAddress, serverPort);
        }
        catch (TransportException te) {
            throw new ConfigurationException("Unable to parse address for server");
        }
        try {
            this.mPlanInterface = (PlanInterface)this.mNetSubsystem.getRPC().getService(this.mServerAddress, PlanInterface.class);
            if (this.mPlanInterface == null) {
                throw new ConfigurationException("Problem connecting to the server");
            }
            this.mDifferenceDBInterface = (DifferenceDBInterface)this.mNetSubsystem.getRPC().getService(this.mServerAddress, DifferenceDBInterface.class);
            if (this.mDifferenceDBInterface == null) {
                throw new ConfigurationException("Problem connecting to the server");
            }
            this.mDifferenceInterface = (DifferenceInterface)this.mNetSubsystem.getRPC().getService(this.mServerAddress, DifferenceInterface.class);
            if (this.mDifferenceInterface == null) {
                throw new ConfigurationException("Problem connecting to the server");
            }
            this.mNotificationInterface = (NotificationRPCInterface)this.mNetSubsystem.getRPC().getService(this.mServerAddress, NotificationRPCInterface.class);
            if (this.mNotificationInterface == null) {
                throw new ConfigurationException("Problem connecting to the server");
            }
            this.mRuleMetaDataManager = (RuleMetaDataManager)this.mNetSubsystem.getRPC().getService(this.mServerAddress, RuleMetaDataManager.class);
            if (this.mRuleMetaDataManager == null) {
                throw new ConfigurationException("Problem connecting to the server");
            }
            this.mTransportServices = (TransportServices)this.mNetSubsystem.getRPC().getService(this.mServerAddress, TransportServices.class);
            if (this.mTransportServices == null) {
                throw new ConfigurationException("Problem connecting to the server");
            }
            this.mVariableSettingsManager = (VariableSettingsManager)this.mNetSubsystem.getRPC().getService(this.mServerAddress, VariableSettingsManager.class);
            if (this.mVariableSettingsManager == null) {
                throw new ConfigurationException("Problem connecting to the server");
            }
            this.mInstallDBManager = (InstallDBManager)this.mNetSubsystem.getRPC().getService(this.mServerAddress, InstallDBManager.class);
            if (this.mInstallDBManager == null) {
                throw new ConfigurationException("Problem connecting to the server");
            }
            this.mNodeManagementServices = (NodeManagementServices)this.mNetSubsystem.getRPC().getService(this.mServerAddress, NodeManagementServices.class);
            if (this.mNodeManagementServices == null) {
                throw new ConfigurationException("Problem connecting to the server");
            }
            this.mUserDBAdmin = this.mUserDBSubsystem.getUserDBAdmin(this.mServerAddress);
            if (this.mUserDBAdmin == null) {
                throw new ConfigurationException("Problem connecting to the server");
            }
            this.mSessionManager = this.mUserDBSubsystem.getSessionManager(this.mServerAddress);
            if (this.mSessionManager == null) {
                throw new ConfigurationException("Problem connecting to the server");
            }
        }
        catch (RPCException te) {
            te.printStackTrace();
            throw new ConfigurationException("Problem connecting to the server");
        }
        catch (ClassCastException te) {
            throw new ConfigurationException("Problem connecting to the server");
        }
        Logger.debug("Create WebServerSubsystem, and register with servlet", this);
        this.mWebServerSubsystem = new WebServerSubsystem(this);
        ROXServlet.setApplication(this);
        Logger.debug("Set ROXServlet application", this);
        Logger.debug("Finished initialization of ROX WebUIApplication", this);
    }

    protected String getUsageString() {
        return "WebUIApplication";
    }

    protected String getVersionString() {
        return "RoxVersions.MS_VERSION";
    }

    public String getRoxVersionString() {
        return this.getVersionString();
    }

    protected void shutdown() throws RaplixShutdownException {
        this.mWebServerSubsystem.shutdown();
        this.mNetSubsystem.shutdown();
    }

    public String overrideConfiguration(String inConfigurationTag) {
        return super.overrideConfiguration(inConfigurationTag);
    }

    protected void buildConfigurationFilesForSubsystems(Hashtable inTable) throws ConfigurationException {
        Subsystem.addConfigurationForSubsystem(inTable, WebServerSubsystem.class);
    }

    protected void exitProcess(int inExitCode) {
    }

    public WebServerSubsystem getWebServerSubsystem() {
        return this.mWebServerSubsystem;
    }

    public NetSubsystem getNetSubsystem() {
        return this.mNetSubsystem;
    }

    public PlanInterface getPlanInterface() {
        return this.mPlanInterface;
    }

    public DifferenceDBInterface getDifferenceDBInterface() {
        return this.mDifferenceDBInterface;
    }

    public DifferenceInterface getDifferenceInterface() {
        return this.mDifferenceInterface;
    }

    public NotificationRPCInterface getNotificationInterface() {
        return this.mNotificationInterface;
    }

    public UserManager getUserManager() {
        return this.mUserDBAdmin.getUserManager();
    }

    public GroupManager getUserGroupManager() {
        return this.mUserDBAdmin.getGroupManager();
    }

    public PermissionManager getUserPermissionManager() {
        return this.mUserDBAdmin.getPermissionManager();
    }

    public SessionManager getUserSessionManager() {
        return this.mSessionManager;
    }

    public RuleMetaDataManager getRuleMetaDataManager() {
        return this.mRuleMetaDataManager;
    }

    public TransportServices getTransportServices() {
        return this.mTransportServices;
    }

    public VariableSettingsManager getVariableSettingsManager() {
        return this.mVariableSettingsManager;
    }

    public InstallDBManager getInstallDBManager() {
        return this.mInstallDBManager;
    }

    public NodeManagementServices getNodeManagementServices() {
        return this.mNodeManagementServices;
    }

    public NodeAdminSubsystem getNodeAdminSubsystem() {
        return null;
    }

    public UIContextServices getUIContextServices() {
        return this.mUIContextServices;
    }

    public ResourceSubsystem getResourceSubsystem() {
        return this.mResourceSubsystem;
    }

    public static void main(String[] args) {
        try {
            WebUIApplication mApp = new WebUIApplication(args);
            mApp.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

