/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.RequiredConfiguration;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.raplix.rolloutexpress.ui.web.PackageInfo;
import com.raplix.rolloutexpress.ui.web.StringConstants;
import com.raplix.rolloutexpress.ui.web.TomcatThread;
import com.raplix.rolloutexpress.ui.web.custom.CustomNavbar;
import com.raplix.rolloutexpress.ui.web.custom.PluginEventsHandler;
import com.raplix.rolloutexpress.ui.web.users.LoginConfigurationBean;
import com.raplix.util.DOMElementEnumeration;
import com.raplix.util.file.XMLUtil;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WebServerSubsystem
extends Subsystem
implements StringConstants {
    public static final String CONFIG_PREFIX = "webserver";
    public static final String CONFIG_VARNAME_TOMCAT_HOME = "TomcatHome";
    public static final String CUSTOM_DIR = "custom";
    public static final String TASKS_DIR = "tasks";
    public static final String IMAGES_DIR = "images";
    private static final String NAVBAR_FILE = "navbarFile";
    private static final String NAVBAR_FILE_VALUE = File.separator + "navbar" + File.separator + "navbar.xml";
    private static final String NAVBAR_FILE_VERSION = "1.0";
    public static final String DEFAULT_CONFIG_TOMCAT_HOME = ".";
    private static final String ATTR_VERSION = "version";
    private int mRefreshNavbarCount;
    private CustomNavbar mNavbar;
    private TomcatThread mTomcatThread;
    private String mTasksDir;
    private Node mRootNavbarNode;

    public WebServerSubsystem(Application inApplication) throws ConfigurationException {
        block9: {
            super(inApplication);
            this.mRefreshNavbarCount = 0;
            this.mTasksDir = this.mApplication.getHomeDirAbsPath() + File.separator + CUSTOM_DIR + File.separator + TASKS_DIR + File.separator;
            String name = this.getConfigurationAsString(NAVBAR_FILE);
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(this.mApplication.getHomeDirAbsPath() + File.separator + CUSTOM_DIR + name);
            }
            catch (FileNotFoundException e) {
                PackageInfo.throwConfigNotFound(name);
            }
            this.mRootNavbarNode = XMLUtil.parse(new InputSource(stream)).getFirstChild();
            String version = this.mRootNavbarNode.getAttributes().getNamedItem(ATTR_VERSION).getNodeValue();
            if (!NAVBAR_FILE_VERSION.equals(version)) {
                PackageInfo.throwVersionMismatch(NAVBAR_FILE_VERSION, version);
            }
            this.refreshNavbar();
            try {
                stream.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                PluginEventsHandler peh = new PluginEventsHandler(this);
                PluginDBSubsystem pdbs = inApplication.getPluginDBSubsystem();
                pdbs.registerPluginEventListener(peh);
                LoginConfigurationBean lcb = new LoginConfigurationBean();
                LoginConfigurationBean.init(this);
            }
            catch (UnsupportedSubsystemException use) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("UnsupportedSubsystemException thrown;", use, this);
                }
            }
            catch (RaplixException re) {
                if (!Logger.isDebugEnabled(this)) break block9;
                Logger.debug("RaplixException thrown;", re, this);
            }
        }
        this.mTomcatThread = new TomcatThread(this.getConfigTomcatHome());
        this.mTomcatThread.start();
    }

    public WebServerSubsystem() {
        this.mRefreshNavbarCount = 0;
    }

    public void shutdown() throws RaplixShutdownException {
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        if (this.mApplication == null) {
            return null;
        }
        return new DefaultConfiguration[]{new RequiredConfiguration(CONFIG_VARNAME_TOMCAT_HOME, "This is a required variable that denotes the location of Tomcat"), new DefaultConfiguration(NAVBAR_FILE, NAVBAR_FILE_VALUE, "Navbar configuration file")};
    }

    public String getConfigTomcatHome() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_TOMCAT_HOME);
    }

    protected String getConfigurationPropertyPrefix() {
        return CONFIG_PREFIX;
    }

    public CustomNavbar getNavbar() {
        return this.mNavbar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNavbar() {
        WebServerSubsystem webServerSubsystem = this;
        synchronized (webServerSubsystem) {
            DOMElementEnumeration e = new DOMElementEnumeration(this.mRootNavbarNode);
            this.mNavbar = new CustomNavbar(e.nextElement());
            ++this.mRefreshNavbarCount;
        }
    }

    public int getRefreshNavbarCount() {
        return this.mRefreshNavbarCount;
    }

    public String getTasksDir() {
        return this.mTasksDir;
    }
}

