/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.string.StringUtil;
import java.util.Date;

public class VersionHistoryInfoBean
extends ServletBean {
    private final UserManager mUserDBInterface;
    private String[] mResourceIDs = new String[0];
    private String[] mResourceVersionNumber = new String[0];
    private String[] mResourceCheckInDates = new String[0];
    private String[] mResourceCheckInUsers = new String[0];
    private String[] mResourceCheckInUserIDs = new String[0];
    private int mObjectCount = -1;
    private boolean mIsInitialized = false;

    public VersionHistoryInfoBean(UserManager userDBInterface) {
        this.mUserDBInterface = userDBInterface;
        this.mResourceIDs = new String[0];
        this.mResourceVersionNumber = new String[0];
        this.mResourceCheckInDates = new String[0];
        this.mResourceCheckInUsers = new String[0];
        this.mResourceCheckInUserIDs = new String[0];
        this.mIsInitialized = false;
        this.mObjectCount = 0;
    }

    public void initArrays(int numObjects) {
        this.mResourceIDs = new String[numObjects];
        this.mResourceVersionNumber = new String[numObjects];
        this.mResourceCheckInDates = new String[numObjects];
        this.mResourceCheckInUsers = new String[numObjects];
        this.mResourceCheckInUserIDs = new String[numObjects];
        this.mObjectCount = 0;
        this.mIsInitialized = true;
    }

    public void addObjectVersion(ObjectID id, String version, Date checkInDate, UserID checkInUserID) throws RaplixException {
        if (!this.mIsInitialized || this.mObjectCount == this.mResourceIDs.length) {
            throw new RuntimeException("tried to call VersionHistoryBean without initializing or with full array");
        }
        String sVersion = "";
        String sCheckInDate = "";
        String sCheckInUser = "";
        String sCheckInUserID = "";
        if (version != null) {
            sVersion = version;
        }
        if (checkInDate != null) {
            sCheckInDate = Util.formatDate(checkInDate);
        }
        if (checkInUserID != null) {
            User user = this.mUserDBInterface.getUser(checkInUserID);
            sCheckInUser = StringUtil.normalizeEmpty(user.getUsername());
            sCheckInUserID = checkInUserID.toString();
        }
        this.mResourceIDs[this.mObjectCount] = id.toString();
        this.mResourceVersionNumber[this.mObjectCount] = sVersion;
        this.mResourceCheckInDates[this.mObjectCount] = sCheckInDate;
        this.mResourceCheckInUsers[this.mObjectCount] = sCheckInUser;
        this.mResourceCheckInUserIDs[this.mObjectCount] = sCheckInUserID;
        ++this.mObjectCount;
    }

    public void addObjectVersion(ObjectID id, VersionNumber version, Date checkInDate, UserID checkInUser) throws RaplixException {
        String sVersion = "";
        if (version != null) {
            sVersion = version.getAsString();
        }
        this.addObjectVersion(id, sVersion, checkInDate, checkInUser);
    }

    public String[] getIDs() {
        return this.mResourceIDs;
    }

    public String[] getVersions() {
        return this.mResourceVersionNumber;
    }

    public String[] getCheckInTimes() {
        return this.mResourceCheckInDates;
    }

    public String[] getCheckInUsers() {
        return this.mResourceCheckInUsers;
    }

    public String[] getCheckInUserIDs() {
        return this.mResourceCheckInUserIDs;
    }
}

