/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.rule.RuleID;
import com.raplix.rolloutexpress.executor.StepStatus;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.Severity;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.DeleteConfirmNode;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.UIError;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.util.Link;
import com.raplix.rolloutexpress.ui.web.util.LinkContext;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.Replace;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.struts.util.MessageResources;

public class Util {
    public static final int CRITICALITY_LEVEL_NORMAL = 0;
    public static final int CRITICALITY_LEVEL_WARNING = 1;
    public static final int CRITICALITY_LEVEL_ERROR = 2;
    public static final int CRITICALITY_LEVEL_PFERROR = 3;
    public static final int CRITICALITY_LEVEL_ACTIONS = 4;
    public static final int CRITICALITY_LEVEL_HIDDEN = 5;
    public static final int CRITICALITY_LEVEL_DISABLED = 6;
    public static final int CRITICALITY_LEVEL_BOLD = 7;
    public static final int CRITICALITY_LEVEL_WHITE = 8;
    public static final String MSG_STATUS_OK = "plan.stepDetails.status.ok";
    public static final String MSG_STATUS_ERROR = "plan.stepDetails.status.error";
    public static final String MSG_STATUS_PFERROR = "plan.stepDetails.status.preflighterror";
    public static final String MSG_STATUS_PREVSTEPERROR = "plan.stepDetails.status.priorerror";
    public static final String MSG_STATUS_WARNING = "plan.stepDetails.status.warning";
    public static final String MSG_STATUS_CANCELLED = "plan.stepDetails.status.cancelled";
    public static final String MSG_PERMISSION_HEADER = "permission.header";
    public static final String MSG_PERMISSION_PLUGIN = "permission.msg.plugin";
    public static final String MSG_PERMISSION_PLUGIN_SHORT = "permission.msg.plugin.short";
    public static final String MSG_COMPONENT = "permission.component";
    public static final String MSG_COMPONENTS = "permission.components";
    public static final String MSG_COMPONENT_TYPE = "permission.componenttype";
    public static final String MSG_FOLDER = "permission.folder";
    public static final String MSG_FOLDERS = "permission.folders";
    public static final String MSG_HOST_SEARCH = "permission.hostsearch";
    public static final String MSG_HOST_SET = "permission.hostset";
    public static final String MSG_HOST_TYPE = "permission.hosttype";
    public static final String MSG_PLAN = "permission.plan";
    public static final String MSG_PLANS = "permission.plans";
    public static final String MSG_SYSTEM_SERVICE = "permission.systemservice";
    public static final String MSG_CHECKED_IN = "permission.checkedin";
    public static final String MSG_DELETED = "permission.deleted";
    public static final String MSG_EDITED = "permission.edited";
    public static final String MSG_RENAMED = "permission.renamed";
    public static final String MSG_MOVED = "permission.moved";
    public static final String MSG_SAVED = "permission.saved";
    public static final String MSG_PERMISSION_SYSTEM = "permission.system";
    public static final String MSG_PERMISSION_ADMIN = "permission.admin";
    public static final String MSG_PERMISSION_WRITE = "permission.write";
    public static final String MSG_PERMISSION_CHECKIN_CURRENT = "permission.checkincurrent";
    public static final String MSG_PERMISSION_AUTORUN = "permission.autorun";
    public static final String MSG_PERMISSION_EXECUTE = "permission.execute";
    public static final String MSG_PERMISSION_EXECUTE_SYSTEM_FOLDER = "permission.execute.system.folder";
    private static final String MSG_INUSE_PLAN = "ui.delete.inuse.plan";
    private static final String MSG_INUSE_COMPONENT = "ui.delete.inuse.component";
    private static final String MSG_INUSE_COMPONENTTYPE = "ui.delete.inuse.componenttype";
    private static final String MSG_INUSE_SYSTEMSERVICE = "ui.delete.inuse.systemservice";
    private static final String MSG_INUSE_HOST = "ui.delete.inuse.host";
    private static final String MSG_INUSE_HOSTSET = "ui.delete.inuse.hostset";
    private static final String MSG_INUSE_HOSTTYPE = "ui.delete.inuse.hosttype";
    private static final String MSG_INUSE_HOSTSEARCH = "ui.delete.inuse.hostsearch";
    private static final String MSG_INUSE_COMPARISON = "ui.delete.inuse.comparison";
    private static final String MSG_INUSE_SNAPSHOT = "ui.delete.inuse.snapshot";
    private static final String MSG_INUSE_USERGROUP = "ui.delete.inuse.usergroup";
    private static final String MSG_INUSE_NOTRULE = "ui.delete.inuse.notrule";
    private static final String MSG_INUSE_PLUGIN = "ui.delete.inuse.plugin";

    public static String escapeHTML(String inSrc) {
        if (inSrc == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer(inSrc.length());
        for (int i = 0; i < inSrc.length(); ++i) {
            char ch = inSrc.charAt(i);
            if (ch == '<') {
                ret.append("&lt;");
                continue;
            }
            if (ch == '>') {
                ret.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                ret.append("&quot;");
                continue;
            }
            if (ch == '&') {
                ret.append("&amp;");
                continue;
            }
            ret.append(ch);
        }
        return ret.toString();
    }

    public static String escapeJavascript(String inSrc) {
        if (inSrc == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer(inSrc.length());
        for (int i = 0; i < inSrc.length(); ++i) {
            char ch = inSrc.charAt(i);
            if (ch == '\n') {
                ret.append("\\n");
                continue;
            }
            if (ch == '\"') {
                ret.append("\\\"");
                continue;
            }
            if (ch == '\'') {
                ret.append("\\'");
                continue;
            }
            if (ch == '\\') {
                ret.append("\\\\");
                continue;
            }
            ret.append(ch);
        }
        return ret.toString();
    }

    public static String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            if (Logger.isDebugEnabled(Util.class)) {
                Logger.debug("Bad url characters", uee, Util.class);
            }
            return null;
        }
    }

    public static String emitJavaScriptArray(String arrayName, String[] inArray) {
        StringBuffer sb = new StringBuffer("");
        sb.append("var ");
        sb.append(arrayName);
        sb.append(" = new Array(");
        for (int i = 0; i < inArray.length; ++i) {
            sb.append("\"");
            sb.append(Util.escapeJavascript(inArray[i]));
            sb.append("\"");
            if (i + 1 >= inArray.length) continue;
            sb.append(", ");
        }
        sb.append(");");
        return sb.toString();
    }

    public static String preserveSpace(String inSrc) {
        return Replace.replace(inSrc, ' ', "&nbsp;");
    }

    public static String escapeNewlines(String inSrc) {
        return Replace.replace(inSrc, '\n', "\\n");
    }

    public static String escapeBackslashes(String inSrc) {
        return Replace.replace(inSrc, '\\', "\\\\");
    }

    public static String wrap(String lineIn, int wrapWidth) {
        StringBuffer sb = new StringBuffer(lineIn);
        Util.wrapHelper(sb, 0, wrapWidth);
        return sb.toString();
    }

    private static void wrapHelper(StringBuffer sb, int start, int wrapWidth) {
        String WRAPPER = "\n";
        if (sb.length() - start <= wrapWidth) {
            return;
        }
        String part = sb.substring(start, start + wrapWidth);
        int spaceIndx = part.lastIndexOf(WRAPPER);
        if (spaceIndx != -1) {
            if (Logger.isDebugEnabled(Util.class)) {
                Logger.debug("space found at " + spaceIndx + ". Old start was " + start + ".  Sb is " + sb.toString(), Util.class);
            }
            Util.wrapHelper(sb, start + spaceIndx + WRAPPER.length(), wrapWidth);
            return;
        }
        int slashIndx = part.lastIndexOf("/");
        int dashIndx = part.lastIndexOf("-");
        int underscoreIndx = part.lastIndexOf("_");
        int periodIndx = part.lastIndexOf(".");
        int largestIndx = 0;
        if (slashIndx > largestIndx) {
            largestIndx = slashIndx;
        }
        if (dashIndx > largestIndx) {
            largestIndx = dashIndx;
        }
        if (underscoreIndx > largestIndx) {
            largestIndx = underscoreIndx;
        }
        if (periodIndx > largestIndx) {
            largestIndx = periodIndx;
        }
        int offset = 0;
        if (largestIndx == 0) {
            offset = start + wrapWidth;
            sb.insert(offset, WRAPPER);
            Util.wrapHelper(sb, offset + WRAPPER.length(), wrapWidth);
        } else {
            offset = start + largestIndx;
            sb.insert(offset + WRAPPER.length(), WRAPPER);
            Util.wrapHelper(sb, offset + WRAPPER.length() + 1, wrapWidth);
        }
    }

    public static int indexOf(String id, String[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (!id.equals(ids[i])) continue;
            return i;
        }
        return -1;
    }

    public static String commaSeparated(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return Util.commaSeparated((String[])obj);
    }

    public static String commaSeparated(String[] a) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            sb.append(a[i]);
            if (i >= a.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String[] arrayifyCommaSemiSeparated(String s) {
        int i = 0;
        if (s == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(s, " ,;");
        String[] a = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            a[i] = st.nextToken();
            ++i;
        }
        return a;
    }

    public static String[] arrayifyCommaSeparated(String s) {
        int i = 0;
        if (s == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(s, " ,");
        String[] a = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            a[i] = st.nextToken();
            ++i;
        }
        return a;
    }

    public static String[] arrayifyByNewline(String s) {
        int i = 0;
        if (s == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(s, "\n");
        String[] a = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            a[i] = st.nextToken();
            ++i;
        }
        return a;
    }

    public static String pluringular(String count, String a, String b) {
        if ("1".equals(count)) {
            return count + "&nbsp;" + a;
        }
        return count + "&nbsp;" + b;
    }

    public static String fullNameToPath(String fullName) {
        int sepNdx = fullName.lastIndexOf("/");
        String path = sepNdx == -1 ? "/" : fullName.substring(0, sepNdx + 1);
        return path;
    }

    public static String fullNameToShortName(String fullName) {
        int sepNdx = fullName.lastIndexOf("/");
        if (sepNdx != -1) {
            fullName = fullName.substring(sepNdx + 1);
        }
        return fullName;
    }

    public static String multiCheckboxSize(MultiCheckbox mc) {
        return "<input type=\"hidden\" name=\"" + mc.getName() + "_size" + "\" value=\"" + mc.getSize() + "\">";
    }

    public static String staticCheckbox(String prefix, boolean checked, String suffix) {
        return Util.dynamicCheckbox(prefix, -1, checked, suffix);
    }

    public static String dynamicCheckbox(String prefix, int index, boolean checked) {
        return Util.dynamicCheckbox(prefix, index, checked, "");
    }

    public static String dynamicCheckbox(MultiCheckbox mc, int index) {
        return Util.dynamicCheckbox(mc, index, "");
    }

    public static String dynamicCheckbox(MultiCheckbox mc, int index, String suffix) {
        return Util.dynamicCheckbox(mc.getName(), index, mc.getChecked(index), "value=\"" + Util.escapeHTML(mc.getValue(index)) + "\" " + suffix);
    }

    public static String dynamicCheckbox(String prefix, int index, boolean checked, String suffix) {
        StringBuffer sb = new StringBuffer("<input type=checkbox name=\"");
        sb.append(prefix);
        if (index >= 0) {
            sb.append(index);
        }
        sb.append("\" ");
        if (checked) {
            sb.append("checked ");
        }
        sb.append(suffix);
        sb.append(">");
        return sb.toString();
    }

    public static String dynamicRadio(MultiCheckbox mc, int index) {
        return Util.dynamicRadio(mc.getName(), Util.escapeHTML(mc.getValue(index)), "");
    }

    public static String dynamicRadio(String name, String value, String checkedValue) {
        return Util.dynamicRadio(name, value, checkedValue, "");
    }

    public static String dynamicRadio(String name, String value, String checkedValue, String suffix) {
        StringBuffer sb = new StringBuffer("<input type=\"radio\" name=\"");
        sb.append(name);
        sb.append("\" ");
        sb.append("value=\"");
        sb.append(value);
        sb.append("\" ");
        if (value.equals(checkedValue)) {
            sb.append("checked=\"checked\" ");
        }
        sb.append(suffix);
        sb.append(">");
        return sb.toString();
    }

    public static String dynamicHidden(String prefix, int index, String value) {
        StringBuffer sb = new StringBuffer("<input type=\"hidden\" name=\"");
        sb.append(prefix);
        sb.append(index);
        sb.append("\"");
        sb.append(" value=\"");
        sb.append(value);
        sb.append("\">");
        return sb.toString();
    }

    public static String dynamicText(String prefix, int index, String value, int size) {
        return Util.dynamicText(prefix, index, value, size, "");
    }

    public static String staticText(String name, String value, int size, String suffix) {
        return Util.dynamicText(name, -1, value, size, suffix);
    }

    public static String dynamicText(String prefix, int index, String value, int size, String suffix) {
        StringBuffer sb = new StringBuffer("<input type=\"text\" name=\"");
        sb.append(prefix);
        if (index >= 0) {
            sb.append(index);
        }
        sb.append("\"");
        sb.append(" value=\"");
        sb.append(value);
        sb.append("\" size=\"");
        sb.append(size);
        sb.append("\" ");
        sb.append(suffix);
        sb.append(">");
        return sb.toString();
    }

    public static String dynamicPassword(String prefix, int index, String value, int size, String suffix) {
        StringBuffer sb = new StringBuffer("<input type=\"password\" name=\"");
        sb.append(prefix);
        if (index >= 0) {
            sb.append(index);
        }
        sb.append("\"");
        sb.append(" value=\"");
        sb.append(value);
        sb.append("\" size=\"");
        sb.append(size);
        sb.append("\" ");
        sb.append(suffix);
        sb.append(">");
        return sb.toString();
    }

    public static String dynamicSingleSelect(String prefix, int index, String[] values, String value, String[] labels) {
        return Util.dynamicSingleSelect(prefix, index, values, value, labels, "");
    }

    public static String staticSingleSelect(String name, String[] values, String value, String[] labels, String suffix) {
        return Util.dynamicSingleSelect(name, -1, values, value, labels, suffix);
    }

    public static String staticList(String[] values, int colspan) {
        return Util.staticList(values, "colspan=" + colspan);
    }

    public static String staticList(String[] values, String suffix) {
        StringBuffer sb = new StringBuffer("<td ");
        sb.append(suffix);
        sb.append(">");
        for (int i = 0; i < values.length; ++i) {
            sb.append(values[i]);
            if (i == values.length - 1) continue;
            sb.append("<br>");
        }
        sb.append("</td>");
        return sb.toString();
    }

    public static String dynamicSingleSelect(String prefix, int index, String[] values, String value, String[] labels, String suffix) {
        boolean foundSelected = false;
        StringBuffer sb = new StringBuffer("<select name=\"");
        sb.append(prefix);
        if (index >= 0) {
            sb.append(index);
        }
        sb.append("\" ");
        sb.append(suffix);
        sb.append(">\n");
        if (values != null && labels != null && values.length == labels.length) {
            for (int i = 0; i < values.length; ++i) {
                sb.append("<option value=\"");
                sb.append(values[i]);
                sb.append("\"");
                if (value != null && value.equals(values[i]) && !foundSelected) {
                    foundSelected = true;
                    sb.append(" selected");
                }
                sb.append(">");
                sb.append(labels[i]);
                sb.append("</option>\n");
            }
        }
        sb.append("</select>");
        return sb.toString();
    }

    public static String tableHeaderRow(String name1, String name2) {
        return Util.tableHeaderRow(new String[]{name1, name2});
    }

    public static String tableHeaderRow(String name1, String name2, String name3) {
        return Util.tableHeaderRow(new String[]{name1, name2, name3});
    }

    public static String tableHeaderRow(String name1, String name2, String name3, String name4) {
        return Util.tableHeaderRow(new String[]{name1, name2, name3, name4});
    }

    public static String tableHeaderRow(String name1, String name2, String name3, String name4, String name5) {
        return Util.tableHeaderRow(new String[]{name1, name2, name3, name4, name5});
    }

    public static String tableHeaderRow(String name1, String name2, String name3, String name4, String name5, String name6) {
        return Util.tableHeaderRow(new String[]{name1, name2, name3, name4, name5, name6});
    }

    public static String tableHeaderRow(String name1, String name2, String name3, String name4, String name5, String name6, String name7) {
        return Util.tableHeaderRow(new String[]{name1, name2, name3, name4, name5, name6, name7});
    }

    public static String tableHeaderRow(String name1, String name2, String name3, String name4, String name5, String name6, String name7, String name8) {
        return Util.tableHeaderRow(new String[]{name1, name2, name3, name4, name5, name6, name7, name8});
    }

    public static String tableHeaderRow(String[] columnNames) {
        int numColumns = columnNames.length;
        if (numColumns < 2) {
            return "";
        }
        --numColumns;
        StringBuffer sb = new StringBuffer("");
        sb.append("<tr>\n");
        sb.append(Util.introCell());
        for (int i = 0; i < numColumns; ++i) {
            sb.append(Util.tableHeaderCell(columnNames[i]));
        }
        sb.append(Util.tableHeaderCell(columnNames[numColumns], "align=\"center\""));
        sb.append("</tr>\n");
        return sb.toString();
    }

    public static String tableHeaderCell(String name) {
        return Util.tableHeaderCell(name, "");
    }

    public static String tableHeaderCell(String name, String suffix) {
        return "<td class=\"tblHead\" nowrap " + suffix + ">" + (name.equals("") ? "&nbsp;" : name) + "</td>\n";
    }

    public static String findShowAllLink(String captionName, String prefix, String findAction, String showAllAction, ServletListBean bean) {
        StringBuffer sb = new StringBuffer("");
        sb.append(prefix);
        sb.append(Util.actionLink(findAction + ";sendForm();void(0);", "find " + captionName + " matching these criteria", "find"));
        if (bean.getIsFindFiltered().equals("true")) {
            sb.append("&nbsp;|&nbsp;");
            sb.append(Util.actionLink(showAllAction + ";sendForm();void(0);", "Show all " + captionName, "show all"));
        }
        return sb.toString();
    }

    public static String findShowAllLink(String captionName, ServletListBean bean) {
        return Util.findShowAllLink(captionName, "&nbsp;|&nbsp;", "javascript:setFind('true')", "javascript:setFind('false')", bean);
    }

    public static String sortableTableHeaderCell(ServletListBean bean, String columnHeader, String sortOrder) {
        return Util.sortableTableHeaderCell(bean.getSortName(), columnHeader, sortOrder, "", "");
    }

    public static String sortableTableHeaderCell(String sortName, String columnHeader, String sortOrder, String mode, String tdSuffix) {
        String sortAscImage = "raplixPouch/sortUp.gif";
        String sortDescImage = "raplixPouch/sortDown.gif";
        if (sortName.equals(sortOrder + "+")) {
            sortAscImage = "raplixPouch/sortedUp.gif";
        } else if (sortName.equals(sortOrder + "-")) {
            sortDescImage = "raplixPouch/sortedDown.gif";
        }
        String ascUri = "javascript: setSort('" + sortOrder + "+');sendForm('" + mode + "');void(0);";
        String descUri = "javascript: setSort('" + sortOrder + "-');sendForm('" + mode + "');void(0);";
        StringBuffer sb = new StringBuffer("");
        if (!columnHeader.equals("")) {
            sb.append("<td class=\"tblHead\" ");
            sb.append(tdSuffix);
            sb.append(" nowrap>");
            sb.append(columnHeader);
            sb.append("&nbsp;");
        } else {
            sb.append("<td class=\"tblFrame\" align=center nowrap>");
        }
        sb.append(Util.standardImageLink(ascUri, "Sort in ascending order", sortAscImage));
        sb.append(Util.standardImageLink(descUri, "Sort in descending order", sortDescImage));
        sb.append("</td>\n");
        return sb.toString();
    }

    public static String tableOneRowFooterRow(int cols) {
        return "<tr>\n<td class=\"tblFrame\" colspan=\"" + new Integer(cols + 1) + "\"><img src=\"raplixPouch/spacer.gif\" height=\"1\" width=\"30\"></td>\n</tr>\n";
    }

    public static String emptyTableFootnoteRow(int cols, String text) {
        StringBuffer foo = new StringBuffer();
        foo.append("<tr>");
        foo.append("<td class=\"tblLeftCol\" align=\"center\"><img height=\"8\" width=\"1\" src=\"raplixPouch/spacer.gif\"></td>");
        foo.append("<td class=\"tblActionsBot\" nowrap align=\"right\" colspan=\"");
        foo.append(++cols);
        foo.append("\">");
        foo.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        foo.append("<tr><td nowrap>");
        foo.append(text);
        foo.append("</td></tr>");
        foo.append("</table>");
        foo.append("</td>");
        foo.append("</tr>");
        return foo.toString();
    }

    public static String tablePaginationRow(int cols, ServletListBean bean, String suffixSingular, String suffixPlural) {
        return Util.tablePaginationRow(cols, bean, suffixSingular, suffixPlural, null);
    }

    public static String tablePaginationRow(int cols, ServletListBean bean, String suffixSingular, String suffixPlural, String filterName) {
        return "<tr>\n<td class=\"tblLeftCol\" rowspan=\"" + (bean.getShowHidden() ? 2 : 1) + "\"><img height=\"8\" width=\"1\" src=\"raplixPouch/spacer.gif\"></td>" + "<td class=\"tblActionsBot\" colspan=\"" + cols + "\" nowrap align=\"right\">\n" + Util.tablePagination(bean, suffixSingular, suffixPlural, filterName) + "\n</td>\n</tr>\n" + Util.indicatesHiddenRow(cols, suffixSingular, bean.getCanBeHidden() && bean.getShowHidden());
    }

    public static String tableBulkPaginationRows(int cols, int checkboxCount, ServletListBean bean, String suffixSingular, String suffixPlural, String[] uris, String[] toolTips, String[] linkTexts, boolean[] dimmeds) {
        return Util.tableBulkPaginationRows(cols, checkboxCount, bean, suffixSingular, suffixPlural, uris, toolTips, linkTexts, dimmeds, null);
    }

    public static String tableBulkPaginationRows(int cols, int checkboxCount, ServletListBean bean, String suffixSingular, String suffixPlural, String[] uris, String[] toolTips, String[] linkTexts, boolean[] dimmeds, String filterName) {
        return "<tr>\n<td class=\"tblLeftCol\" rowspan=\"2\"><img height=\"8\" width=\"1\" src=\"raplixPouch/spacer.gif\"></td>" + Util.allCheckboxCell(checkboxCount) + "<td class=\"tblActionsBot\" colspan=\"" + cols + "\" nowrap align=\"right\">\n" + Util.tablePagination(bean, suffixSingular, suffixPlural, filterName) + "\n</td>\n</tr>\n" + (bean.getCanBeHidden() && bean.getShowHidden() ? Util.indicatesHiddenRow(cols + 1, suffixSingular, bean.getShowHidden()) : "<tr><td class=\"tblActionsBot\" nowrap colspan=\"" + cols + "\"></td>") + Util.tableBulkActionRow(cols + 1, checkboxCount, suffixPlural, uris, toolTips, linkTexts, dimmeds);
    }

    public static String tableBulkPaginationRows(int cols, int checkboxCount, ServletListBean bean, LinkContext lc, Link[] links, String filterName) {
        String singular = lc.getObjectType().toStringSingular();
        String plural = lc.getObjectType().toStringPlural();
        return "<tr>\n<td class=\"tblLeftCol\" rowspan=\"2\"><img height=\"8\" width=\"1\" src=\"raplixPouch/spacer.gif\"></td>" + Util.allCheckboxCell(checkboxCount) + "<td class=\"tblActionsBot\" colspan=\"" + cols + "\" nowrap align=\"right\">\n" + Util.tablePagination(bean, singular, plural, filterName) + "\n</td>\n</tr>\n" + (bean.getCanBeHidden() && bean.getShowHidden() ? Util.indicatesHiddenRow(cols + 1, singular, bean.getShowHidden()) : "<tr><td class=\"tblActionsBot\" nowrap colspan=\"" + cols + "\"></td>") + Util.tableBulkActionRow(cols + 1, checkboxCount, plural, links);
    }

    public static String tableBulkActionRow(int cols, int checkboxCount, String suffixPlural, String[] uris, String[] toolTips, String[] linkNames, boolean[] dimmeds) {
        if (checkboxCount > 0) {
            StringBuffer buf = new StringBuffer("");
            for (int i = 0; i < uris.length; ++i) {
                if (i > 0) {
                    buf.append(" | ");
                }
                if (dimmeds[i]) {
                    buf.append(Util.dimmedLink(uris[i], toolTips[i], linkNames[i]));
                    continue;
                }
                buf.append(Util.standardLink(uris[i], toolTips[i], linkNames[i]));
            }
            return "<tr>\n" + Util.introStandardCell() + "<td class=\"tblListAct\" colspan=\"" + cols + "\"><img height=\"8\" width=\"1\" src=\"raplixPouch/spacer.gif\"> actions for checked " + suffixPlural + ": " + buf + "</td>\n</tr>";
        }
        return "";
    }

    public static String tableBulkActionRow(int cols, int checkboxCount, String suffixPlural, Link[] links) {
        if (checkboxCount > 0) {
            StringBuffer buf = new StringBuffer("");
            for (int i = 0; i < links.length; ++i) {
                if (i > 0) {
                    buf.append(" | ");
                }
                buf.append(links[i].renderAsText());
            }
            return "<tr>\n" + Util.introStandardCell() + "<td class=\"tblListAct\" colspan=\"" + cols + "\"><img height=\"8\" width=\"1\" src=\"raplixPouch/spacer.gif\"> actions for checked " + suffixPlural + ": " + buf + "</td>\n</tr>";
        }
        return "";
    }

    public static String allCheckboxCell(int checkboxCount) {
        if (checkboxCount > 0) {
            return "<td align=\"center\" class=\"tblListAct\" rowspan=\"2\">" + Util.standardLink("javascript: toggleAll('bulk')", "check/un-check all items", "all") + "</td>";
        }
        return "<td class=\"tblActionsBot\" rowspan=\"2\">&nbsp;</td>";
    }

    private static String link(String uri, String caption, String name, String extra) {
        if ("".equals(name)) {
            return "&nbsp;";
        }
        return "<a href=\"" + uri + "\" title= \"" + caption + "\" onMouseOver=\"return setStatus('" + caption + "')\" onMouseOut=\"return setStatus('')\" onDblClick=\"return false;\" " + extra + ">" + name + "</a>";
    }

    public static String standardLink(String uri, String caption, String name) {
        return Util.standardLink(uri, caption, name, null);
    }

    public static String standardLink(String uri, String caption, String name, String extra) {
        return Util.link(uri, caption, name, "target=\"_top\"" + (extra == null ? "" : " " + extra));
    }

    public static String standardLinkUntargeted(String uri, String caption, String name) {
        return Util.standardLinkUntargeted(uri, caption, name, null);
    }

    public static String standardLinkUntargeted(String uri, String caption, String name, String extra) {
        return Util.link(uri, caption, name, extra == null ? "" : extra);
    }

    public static String actionLink(String uri, String caption, String name) {
        return Util.actionLink(uri, caption, name, null);
    }

    public static String actionLink(String uri, String caption, String name, String extra) {
        return Util.link(uri, caption, name, "class=\"bdyActions\"" + (extra == null ? "" : " " + extra));
    }

    public static String actionLinkTargeted(String uri, String caption, String name) {
        return Util.actionLinkTargeted(uri, caption, name, null);
    }

    public static String actionLinkTargeted(String uri, String caption, String name, String extra) {
        return Util.link(uri, caption, name, "class=\"bdyActions\" target=\"_top\"" + (extra == null ? "" : " " + extra));
    }

    public static String dimmedLink(String uri, String caption, String name) {
        return Util.dimmedLink(uri, caption, name, null);
    }

    public static String dimmedLink(String uri, String caption, String name, String extra) {
        return Util.link(uri, caption, name, "class=\"tblActionsDis\" target=\"_top\"" + (extra == null ? "" : " " + extra));
    }

    public static String dimmedActionLink(String uri, String caption, String name) {
        return Util.dimmedActionLink(uri, caption, name, null);
    }

    public static String dimmedActionLink(String uri, String caption, String name, String extra) {
        return Util.link(uri, caption, name, "class=\"bdyActionsDis\" target=\"_top\"" + (extra == null ? "" : " " + extra));
    }

    public static String standardImageLink(String uri, String caption, String image) {
        return "<a href=\"" + uri + "\" title=\"" + caption + "\" onMouseOver=\"return setStatus('" + caption + "')\" onMouseOut=\"return setStatus('')\" onDblClick=\"return false;\"><img src=\"" + image + "\" align=\"top\" alt=\"" + caption + "\" border=\"0\"></a>";
    }

    public static String standardButton(String uri, String caption, String name) {
        return Util.standardButton(uri, caption, name, null);
    }

    public static String standardButton(String uri, String caption, String name, String extra) {
        return Util.standardButton(uri, caption, name, false, extra);
    }

    public static String standardButton(String uri, String caption, String name, boolean dimmed) {
        return Util.standardButton(uri, caption, name, dimmed, null);
    }

    public static String standardButton(String uri, String caption, String name, boolean dimmed, String extra) {
        if ("".equals(name)) {
            return "&nbsp;";
        }
        return "<td class=\"" + (dimmed ? "btnCellDis" : "btnCell") + "\" nowrap><a href=\"" + uri + "\" title= \"" + caption + "\" onMouseOver=\"return setStatus('" + caption + "')\" onMouseOut=\"return setStatus('')\" onDblClick=\"return false;\" target=\"_top\"" + (extra == null ? "" : " " + extra) + ">" + name + "</a></td>\n<td><img src=\"raplixPouch/spacer.gif\" width=\"8\" height=\"8\"></td>\n";
    }

    public static String standardButtonUntargeted(String uri, String caption, String name) {
        return Util.standardButtonUntargeted(uri, caption, name, null);
    }

    public static String standardButtonUntargeted(String uri, String caption, String name, String extra) {
        return Util.standardButtonUntargeted(uri, caption, name, false, extra);
    }

    public static String standardButtonUntargeted(String uri, String caption, String name, boolean dimmed) {
        return Util.standardButtonUntargeted(uri, caption, name, dimmed, null);
    }

    public static String standardButtonUntargeted(String uri, String caption, String name, boolean dimmed, String extra) {
        if ("".equals(name)) {
            return "&nbsp;";
        }
        return "<td class=\"" + (dimmed ? "btnCellDis" : "btnCell") + "\" nowrap><a href=\"" + uri + "\" title= \"" + caption + "\" onMouseOver=\"return setStatus('" + caption + "')\" onMouseOut=\"return setStatus('')\" onDblClick=\"return false;\"" + (extra == null ? "" : " " + extra) + ">" + name + "</a></td>\n<td><img src=\"raplixPouch/spacer.gif\" width=\"8\" height=\"8\"></td>\n";
    }

    public static String disabledButton(String userName, String keyWhat, String keyButtonLabel) {
        return Util.standardButton(Util.disabledURI(userName, keyWhat), Util.disabledText(userName, keyWhat), ApplicationResources.getMessage(keyButtonLabel), true);
    }

    public static String disabledURI(String userName, String keyWhat) {
        String body = Util.disabledText(userName, keyWhat);
        return "javascript:warningPopup('" + ApplicationResources.getMessage(MSG_PERMISSION_HEADER) + "', '" + body + "'); void(0);";
    }

    public static String disabledText(String userName, String keyWhat) {
        String body = ApplicationResources.getMessage(keyWhat, userName);
        return body;
    }

    public static String pluginDisabledButton(String keyWhat, String keyAction, String keyButtonLabel) {
        return Util.standardButton(Util.pluginDisabledURI(keyWhat, keyAction), Util.pluginDisabledText(keyWhat, keyAction), ApplicationResources.getMessage(keyButtonLabel), true);
    }

    public static String pluginDisabledURI(String keyWhat, String keyAction) {
        String body = Util.pluginDisabledText(keyWhat, keyAction);
        return "javascript:warningPopup('" + ApplicationResources.getMessage(MSG_PERMISSION_HEADER) + "', '" + body + "'); void(0);";
    }

    public static String pluginDisabledText(String keyWhat, String keyAction) {
        String body = ApplicationResources.getMessage(MSG_PERMISSION_PLUGIN, ApplicationResources.getMessage(keyWhat), ApplicationResources.getMessage(keyAction));
        return body;
    }

    public static String taskDoneButton(String uri, String caption, String name) {
        return "<td><img src=\"raplixPouch/pfDoneLeft.jpg\" width=\"10\" height=\"16\"></td>\n<td background=\"raplixPouch/pfDoneMid.jpg\" class=\"btn\">" + Util.standardLink(uri, caption, name) + "</td>\n<td><img src=\"raplixPouch/pfDoneRight.jpg\" width=\"7\" height=\"16\"></td>";
    }

    public static String taskProgressButton(String s) {
        return "<td><img src=\"raplixPouch/pfProgLeft.jpg\" width=\"10\" height=\"16\"></td>" + s + "\n<td><img src=\"raplixPouch/pfProgRight.jpg\" width=\"7\" height=\"16\"></td>";
    }

    public static String taskProgressButtonLabel(String s) {
        return "<td background=\"raplixPouch/pfProgMid.jpg\" class=\"btn\">" + s + "</td>";
    }

    public static String taskProgressButtonImage(String s) {
        return "<td background=\"raplixPouch/pfProgMid.jpg\">" + s + "</td>";
    }

    public static String taskDimButton(String s) {
        return "<td><img src=\"raplixPouch/pfDisLeft.jpg\" width=\"10\" height=\"16\"></td>\n<td background=\"raplixPouch/pfDisMid.jpg\" class=\"btn\">" + s + "</td>\n<td><img src=\"raplixPouch/pfDisRight.jpg\" width=\"7\" height=\"16\"></td>";
    }

    public static String taskDimButton(String uri, String caption, String name) {
        return "<td><img src=\"raplixPouch/pfDisLeft.jpg\" width=\"10\" height=\"16\"></td>\n<td background=\"raplixPouch/pfDisMid.jpg\" class=\"btn\">" + Util.standardLink(uri, caption, name) + "</td>\n<td><img src=\"raplixPouch/pfDisRight.jpg\" width=\"7\" height=\"16\"></td>";
    }

    public static String introCell(String suffix) {
        return "<td class=\"tblFrame\" align=\"center\" width=\"1\" " + suffix + "><img height=\"8\" width=\"1\" src=\"raplixPouch/spacer.gif\"></td>";
    }

    public static String introCell() {
        return Util.introCell("");
    }

    public static String introStandardCell() {
        return Util.introStandardCell(false);
    }

    public static String introStandardCell(boolean isError) {
        return Util.introStandardCell(isError ? 2 : 0);
    }

    public static String topRowCell(String contents) {
        return Util.topRowCell(contents, "");
    }

    public static String topRowCell(String contents, String suffix) {
        return "<td class=\"tblTopRow\" " + suffix + ">" + contents + "</td>";
    }

    public static String introStandardCell(int criticalityLevel) {
        return Util.introStandardCell("", criticalityLevel);
    }

    public static String introStandardCell(String suffix, int criticalityLevel) {
        String cellClass = "";
        switch (criticalityLevel) {
            case 6: {
                cellClass = "tblLeftColDef";
                break;
            }
            case 5: {
                cellClass = "tblLeftColRetire";
                break;
            }
            case 2: {
                cellClass = "tblLeftColError";
                break;
            }
            case 1: {
                cellClass = "tblLeftColWarn";
                break;
            }
            case 3: {
                cellClass = "tblLeftColPFError";
                break;
            }
            default: {
                cellClass = "tblLeftCol";
            }
        }
        return "<td class=\"" + cellClass + "\" align=\"center\" width=\"0\" " + suffix + "><img height=\"8\" width=\"1\" src=\"raplixPouch/spacer.gif\"></td>";
    }

    public static String standardCell(String s, int i) {
        return Util.standardCell(s, i, false);
    }

    public static String standardCell(String s, int i, String suffix) {
        return Util.standardCell(s, i, suffix, false);
    }

    public static String standardCell(String s, int i, boolean isError) {
        return Util.standardCell(s, i, "", isError);
    }

    public static String standardCell(String s, int i, String suffix, boolean isError) {
        return Util.standardCell(s, i, suffix, isError ? 2 : 0);
    }

    public static String standardCell(String s, int i, String suffix, int criticality_level) {
        String temp = s;
        if ("".equals(temp)) {
            temp = "&nbsp;";
        }
        return Util.standardCellStart(i, suffix, criticality_level) + temp + "</td>";
    }

    public static String standardCellStart(int i, String suffix, int criticality_level) {
        String cellClass = "";
        switch (criticality_level) {
            case 7: {
                cellClass = "bdyBold";
                break;
            }
            case 6: {
                cellClass = "tblRowDef";
                break;
            }
            case 5: {
                cellClass = "tblRowRetire";
                break;
            }
            case 4: {
                cellClass = "tblActions";
                break;
            }
            case 2: {
                cellClass = "tblRowError";
                break;
            }
            case 3: {
                cellClass = "tblRowPFError";
                break;
            }
            case 1: {
                cellClass = "tblRowWarn";
                break;
            }
            case 8: {
                cellClass = "tblTopRow";
                break;
            }
            default: {
                cellClass = i % 2 == 0 ? "tblRow" : "tblRowAlt";
            }
        }
        return "<td class=\"" + cellClass + "\" " + suffix + ">";
    }

    public static String standardCellEnd() {
        return "</td>";
    }

    public static String boldCell(String cellContents) {
        return Util.standardCellStart(0, "nowrap", 7) + cellContents + Util.standardCellEnd();
    }

    public static String standardCellCentered(String s, int i) {
        return Util.standardCellCentered(s, i, false);
    }

    public static String standardCellCentered(String s, int i, boolean isError) {
        return Util.standardCellCentered(s, i, isError ? 2 : 0);
    }

    public static String standardCellCentered(String s, int i, int criticality_level) {
        String temp = s;
        if ("".equals(temp)) {
            temp = "&nbsp;";
        }
        String cellClass = "";
        switch (criticality_level) {
            case 6: {
                cellClass = "tblRowDef";
                break;
            }
            case 2: {
                cellClass = "tblRowError";
                break;
            }
            case 3: {
                cellClass = "tblRowPFError";
                break;
            }
            case 1: {
                cellClass = "tblRowWarn";
                break;
            }
            default: {
                cellClass = i % 2 == 0 ? "tblRow" : "tblRowAlt";
            }
        }
        return "<td class=\"" + cellClass + "\" align=\"center\">" + temp + "</td>";
    }

    public static String standardCellNowrap(String s, int i) {
        return Util.standardCellNowrap(s, i, false);
    }

    public static String standardCellNowrap(String s, int i, boolean isError) {
        String temp = s;
        if ("".equals(temp)) {
            temp = "&nbsp;";
        }
        if (isError) {
            return "<td class=\"tblRowError\" nowrap>" + temp + "</td>";
        }
        if (i % 2 == 0) {
            return "<td class=\"tblRow\" nowrap>" + temp + "</td>";
        }
        return "<td class=\"tblRowAlt\" nowrap>" + temp + "</td>";
    }

    public static String actionCell(String s) {
        return Util.actionCell(s, false);
    }

    public static String actionCell(String s, boolean isError) {
        return Util.actionCell(s, 0, "align=\"center\"", isError ? 2 : 0);
    }

    public static String actionCell(String s, int i, String suffix, int criticality_level) {
        String temp = s;
        if ("".equals(temp)) {
            temp = "&nbsp;";
        }
        String cellClass = "";
        switch (criticality_level) {
            case 6: {
                cellClass = "tblActionsDef";
                break;
            }
            case 5: {
                cellClass = "tblActionsRetire";
                break;
            }
            case 2: {
                cellClass = "tblActionsError";
                break;
            }
            case 3: {
                cellClass = "tblActionsPFError";
                break;
            }
            case 1: {
                cellClass = "tblActionsWarn";
                break;
            }
            default: {
                cellClass = i % 2 == 0 ? "tblActions" : "tblActionsAlt";
            }
        }
        return "<td class=\"" + cellClass + "\" nowrap " + suffix + ">" + temp + "</td>";
    }

    public static String standardFormHeaderRow() {
        return "<tr>\n<td class=\"label\" nowrap>&nbsp;</td>\n<td class=\"labelSepNorm\">&nbsp;</td>\n<td>&nbsp;</td></tr>";
    }

    public static String doubleFormHeaderRow() {
        return "<tr>\n<td class=\"label\" nowrap>&nbsp;</td>\n<td class=\"labelSepNorm\">&nbsp;</td>\n<td>&nbsp;</td>\n<td class=\"label\">&nbsp;</td>\n<td class=\"labelSepNorm\">&nbsp;</td>\n<td>&nbsp;</td>\n</tr>";
    }

    public static String standardFormSpacerRow() {
        return "<tr>\n<td colspan=\"3\">&nbsp;</td>\n</tr>";
    }

    public static String doubleFormSpacerRow() {
        return "<tr>\n<td colspan=\"6\">&nbsp;</td>\n</tr>";
    }

    public static String formLabel(String s) {
        return "<td class=\"label\" nowrap>" + s + ":</td><td class=\"labelSepNorm\">&nbsp;</td>";
    }

    public static String formLabelAlignedTop(String s) {
        return "<td class=\"label\" valign=\"top\" nowrap>" + s + ":</td><td class=\"labelSepNorm\" valign=\"top\">&nbsp;</td>";
    }

    public static String formSeparator(String s) {
        return "<br>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tr>\n<td><img src=\"raplixPouch/spacer.gif\"></td>\n<td class=\"sepBody\" nowrap background=\"raplixPouch/tabCapC.gif\">" + s + "</td>\n<td><img src=\"raplixPouch/tabCapR.gif\"></td>\n</tr>\n</table>\n";
    }

    public static String formSeparatorStart(String s) {
        return "<br>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tr>\n<td><img src=\"raplixPouch/spacer.gif\"></td>\n<td class=\"sepBody\" nowrap background=\"raplixPouch/tabCapC.gif\">" + s + "</td>\n<td><img src=\"raplixPouch/tabCapR.gif\"></td>\n";
    }

    public static String formSeparatorEnd() {
        return "</tr>\n</table>\n";
    }

    public static String smallProgressImage() {
        return "<img src=\"raplixPouch/babyProg.gif\" width=\"15\" height=\"6\" border=\"0\" alt=\"Progress of running plan or preflight\">";
    }

    public static String lockImage(String altMessage) {
        return "<img src=\"raplixPouch/lock.gif\" border=\"0\" alt=\"" + altMessage + "\">";
    }

    public static String imageNameForStep(String stepType) {
        if (stepType.equalsIgnoreCase("deployResource")) {
            return "raplixPouch/install.gif";
        }
        if (stepType.equalsIgnoreCase("call")) {
            return "raplixPouch/native.gif";
        }
        if (stepType.equalsIgnoreCase("execNative")) {
            return "raplixPouch/native.gif";
        }
        if (stepType.equalsIgnoreCase("execJava")) {
            return "raplixPouch/native.gif";
        }
        if (stepType.equalsIgnoreCase("install")) {
            return "raplixPouch/install.gif";
        }
        if (stepType.equalsIgnoreCase("processTest")) {
            return "raplixPouch/verify.gif";
        }
        if (stepType.equalsIgnoreCase("sendCustomEvent")) {
            return "raplixPouch/notification.gif";
        }
        if (stepType.equalsIgnoreCase("uninstall")) {
            return "raplixPouch/uninstall.gif";
        }
        if (stepType.equalsIgnoreCase("urlTest")) {
            return "raplixPouch/verify.gif";
        }
        if (stepType.equalsIgnoreCase("execSubplan")) {
            return "raplixPouch/subplan.gif";
        }
        if (stepType.equalsIgnoreCase("checkDependency")) {
            return "raplixPouch/machine.gif";
        }
        if (stepType.equalsIgnoreCase("pause")) {
            return "raplixPouch/sync.gif";
        }
        if (stepType.equalsIgnoreCase("createSnapshot")) {
            return "raplixPouch/snap.gif";
        }
        if (stepType.equalsIgnoreCase("inlineSubplan")) {
            return "raplixPouch/subplan.gif";
        }
        if (stepType.equalsIgnoreCase("addFile")) {
            return "raplixPouch/snap.gif";
        }
        if (stepType.equalsIgnoreCase("addResource")) {
            return "raplixPouch/snap.gif";
        }
        if (stepType.equalsIgnoreCase("addResource")) {
            return "raplixPouch/snap.gif";
        }
        if (stepType.equalsIgnoreCase("transform")) {
            return "raplixPouch/native.gif";
        }
        if (stepType.equalsIgnoreCase("CheckHostConnectivity")) {
            return "raplixPouch/rox.gif";
        }
        if (stepType.equalsIgnoreCase("CheckHostPermissions")) {
            return "raplixPouch/rox.gif";
        }
        if (stepType.equalsIgnoreCase("LockHost")) {
            return "raplixPouch/rox.gif";
        }
        if (stepType.equalsIgnoreCase("UnlockHost")) {
            return "raplixPouch/rox.gif";
        }
        if (stepType.equalsIgnoreCase("AcquireHost")) {
            return "raplixPouch/rox.gif";
        }
        if (stepType.equalsIgnoreCase("deploySystemServices")) {
            return "raplixPouch/rox.gif";
        }
        if (stepType.equalsIgnoreCase("retarget")) {
            return "raplixPouch/rox.gif";
        }
        if (stepType.equalsIgnoreCase("reboot")) {
            return "raplixPouch/native.gif";
        }
        if (stepType.equalsIgnoreCase("if")) {
            return "raplixPouch/native.gif";
        }
        if (stepType.equalsIgnoreCase("try")) {
            return "raplixPouch/native.gif";
        }
        if (stepType.equalsIgnoreCase("raise")) {
            return "raplixPouch/native.gif";
        }
        if (stepType.equalsIgnoreCase("dynamicContainer")) {
            return "raplixPouch/native.gif";
        }
        if (stepType.equalsIgnoreCase("createDependency")) {
            return "raplixPouch/native.gif";
        }
        if (stepType.equalsIgnoreCase("assign")) {
            return "raplixPouch/native.gif";
        }
        if (stepType.equalsIgnoreCase("return")) {
            return "raplixPouch/native.gif";
        }
        return "raplixPouch/spacer.gif";
    }

    public static String getLabelForStepStatus(StepStatus stepStatus) {
        String status = stepStatus.toString();
        if (status.equals(StepStatus.NOT_STARTED.toString())) {
            return "";
        }
        if (status.equals(StepStatus.COMPLETE.toString())) {
            return ApplicationResources.getMessage(MSG_STATUS_OK);
        }
        if (status.equals(StepStatus.PREFLIGHT_RUNNING.toString())) {
            return "";
        }
        if (status.equals(StepStatus.DEPLOYMENT_RUNNING.toString())) {
            return "";
        }
        if (status.equals(StepStatus.INCOMPLETE_ERROR.toString())) {
            return ApplicationResources.getMessage(MSG_STATUS_ERROR);
        }
        if (status.equals(StepStatus.INCOMPLETE_ABORT.toString())) {
            return ApplicationResources.getMessage(MSG_STATUS_CANCELLED);
        }
        if (status.equals(StepStatus.COMPLETE_WARNING.toString())) {
            return ApplicationResources.getMessage(MSG_STATUS_WARNING);
        }
        if (status.equals(StepStatus.PREFLIGHT_ERROR.toString())) {
            return ApplicationResources.getMessage(MSG_STATUS_PFERROR);
        }
        if (status.equals(StepStatus.PRIOR_ERROR.toString())) {
            return ApplicationResources.getMessage(MSG_STATUS_PREVSTEPERROR);
        }
        return "[" + status + "]";
    }

    public static String saveMessage(String what) {
        MessageResources messages = ApplicationResources.getMessageResources();
        return Util.headingMessage(messages.getMessage("util.prompt.saveas.head", (Object)what)) + Util.standardMessage(messages.getMessage("util.prompt.saveas.msg", (Object)what));
    }

    public static String headingMessage(String s) {
        return "<br><span class=\"msgHead\">" + s + "</span>\n";
    }

    public static String standardMessage(String s) {
        return "<br>\n<span class=\"msg\">" + s + "</span>\n";
    }

    public static String displayErrors(ServletErrors errors) {
        StringBuffer sb = new StringBuffer("");
        if (errors == null || errors.getIsEmpty()) {
            return "";
        }
        boolean singleSpace = true;
        if (errors.getMajorError() != null && errors.getMajorError().length() > 0) {
            sb.append("<br>");
            sb.append("<span class=\"msgHeadError\">");
            sb.append(Util.escapeHTML(errors.getMajorError()));
            sb.append("</span>");
            singleSpace = false;
        }
        if (errors.getMinorErrors() != null && errors.getMinorErrors().length > 0) {
            UIError[] mes = errors.getMinorErrors();
            UIError currentError = null;
            Severity currentSeverity = null;
            String styleSheet = "";
            for (int i = 0; i < mes.length; ++i) {
                currentError = mes[i];
                currentSeverity = currentError.getSeverity();
                if (currentSeverity.equals(Severity.ERROR)) {
                    styleSheet = "Error";
                } else if (currentSeverity.equals(Severity.WARN)) {
                    styleSheet = "Warn";
                } else if (currentSeverity.equals(Severity.INFO)) {
                    styleSheet = "Info";
                } else if (currentSeverity.equals(Severity.DEBUG)) {
                    styleSheet = "Debug";
                } else {
                    styleSheet = "Error";
                    if (Logger.isDebugEnabled(class$com$raplix$rolloutexpress$ui$web$Util == null ? Util.class$("com.raplix.rolloutexpress.ui.web.Util") : class$com$raplix$rolloutexpress$ui$web$Util)) {
                        Logger.debug("Unhandled severity: " + currentSeverity, class$com$raplix$rolloutexpress$ui$web$Util == null ? Util.class$("com.raplix.rolloutexpress.ui.web.Util") : class$com$raplix$rolloutexpress$ui$web$Util);
                    }
                }
                if (singleSpace) {
                    sb.append("<br>");
                } else {
                    sb.append("<br><br>");
                }
                singleSpace = false;
                if (!currentError.getMessageBody().equals("")) {
                    sb.append("<span class=\"msgHead");
                    sb.append(styleSheet);
                    sb.append("\">");
                    sb.append(currentError.getMessageHeader());
                    sb.append("</span><br><span class=\"msg");
                    sb.append(styleSheet);
                    sb.append("\">");
                    sb.append(currentError.getMessageBody());
                    sb.append("</span>");
                    continue;
                }
                sb.append("<span class=\"msgHead");
                sb.append(styleSheet);
                sb.append("\">");
                sb.append(currentError.getMessageHeader());
                sb.append("</span>");
            }
        }
        return sb.toString();
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy h:mm a");
        return sdf.format(date);
    }

    public static String indicatesHiddenCell(int cols, String what) {
        return Util.indicatesHiddenCell(cols, what, true);
    }

    public static String indicatesHiddenCell(int cols, String what, boolean showHidden) {
        if (showHidden) {
            return "<td nowrap colspan=\"" + cols + "\"><span class=\"tblLeftColRetire\">&nbsp;</span><span class=\"tblRowRetire\">\nindicates " + what + " is hidden&nbsp;</span></td>\n";
        }
        return "";
    }

    public static String indicatesHiddenRow(int cols, String what, boolean showHidden) {
        if (showHidden) {
            return "<tr>" + Util.indicatesHiddenCell(cols, what, showHidden) + "</tr>";
        }
        return "";
    }

    public static String showHiddenCheckbox(String what, boolean showHidden) {
        return "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\n<tr>\n<td width=\"100%\" align=\"center\">&nbsp;</td>\n" + Util.showHiddenCells(what, showHidden) + "</tr>\n</table>";
    }

    public static String showFlatViewCheckbox(boolean inFlatView) {
        return "<td>" + Util.staticCheckbox("flatView", inFlatView, "onClick = \"sendForm(); void(0);\"") + "</td>\n<td nowrap>show flat view</td>";
    }

    public static String showHiddenCells(String what, boolean showHidden) {
        return Util.showHiddenCells(what, showHidden, true);
    }

    public static String showHiddenCells(String what, boolean showHidden, boolean enabled) {
        String suffix = "onClick = \"sendForm(); void(0);\"";
        String label = "<td nowrap>show hidden " + what + "</td>";
        if (!enabled) {
            suffix = suffix + " class=\"disabled\" disabled";
            label = "<td nowrap class=\"bdyActionsDis\">show hidden " + what + "</td>";
        }
        return "<td>" + Util.staticCheckbox("showHidden", showHidden, suffix) + "</td>\n" + label;
    }

    public static String versionedHideShow(String url, boolean isHidden) {
        return Util.versionedHideShow(url, isHidden, "version");
    }

    public static String versionedHideShow(String url, boolean isHidden, String descriptor) {
        return "<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\">\n<tr>\n<td>" + (isHidden ? "hidden" : "not hidden") + "</td>\n<td width=\"10\">&nbsp; </td>\n<td class=\"bdyActions\">" + Util.standardLink(url, (isHidden ? "Un-hide this " : "Hide this ") + descriptor, (isHidden ? "un-hide this " : "hide this ") + descriptor) + "</td>\n</tr>\n</table>\n";
    }

    public static String versionedHideShow(String url, boolean isHidden, LinkContext lc) {
        return Util.versionedHideShow(url, isHidden, "version", lc);
    }

    public static String versionedHideShow(String url, boolean isHidden, String descriptor, LinkContext lc) {
        Link link = Link.simpleLink(url, (isHidden ? "Un-hide this " : "Hide this ") + descriptor, (isHidden ? "un-hide this " : "hide this ") + descriptor, LinkContext.WRITE_ON_FOLDER, true, lc);
        return "<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\">\n<tr>\n<td>" + (isHidden ? "hidden" : "not hidden") + "</td>\n<td width=\"10\">&nbsp; </td>\n<td class=\"bdyActions\">" + link.renderAsText() + "</td>\n</tr>\n</table>\n";
    }

    public static String nonversionedHideShow(boolean isHidden) {
        return "<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\">\n<tr>\n<td>" + Util.staticCheckbox("isHidden", isHidden, "") + "</td>\n<td>" + "hidden" + "</td>\n</tr>\n</table>\n";
    }

    public static String nonversionedHideShowConfirm(boolean isHidden) {
        return "<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\"><tr><td>" + (isHidden ? "hidden" : "not hidden") + "</td></tr></table>\n";
    }

    public static String categoryFilterAndShowHiddenCheckbox(String what, String category, String[] categoryIDs, String[] categoryNames, boolean showHidden) {
        return Util.categoryFilterAndShowHiddenCheckbox(what, category, categoryIDs, categoryNames, "sendForm(); return true;", showHidden);
    }

    public static String categoryFilterAndShowHiddenCheckbox(String what, String category, String[] categoryIDs, String[] categoryNames, String onChangeAction, boolean showHidden) {
        StringBuffer buf = new StringBuffer("");
        buf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\n<tr>\n");
        buf.append("<td width=\"100%\" align=\"center\">");
        buf.append(Util.categoryFilter(what, category, categoryIDs, categoryNames, onChangeAction));
        buf.append("</td>\n");
        buf.append(Util.showHiddenCells(what, showHidden));
        buf.append("</tr>\n</table>");
        return buf.toString();
    }

    public static String folderedBreadCrumb(String folderID, String what, String section, String[] pathFolderNames, String[] pathFolderIDs) {
        StringBuffer buf = new StringBuffer("");
        buf.append("breadCrumbLink(\"" + section + "\", ");
        buf.append("\"View " + what + "\", ");
        buf.append("\"" + what + "\"); ");
        buf.append("document.write(\" &gt; \");");
        int numFolders = pathFolderNames.length;
        for (int i = 0; i < numFolders; ++i) {
            if (folderID.equals(pathFolderIDs[i])) {
                buf.append("document.write(\"<span>" + pathFolderNames[i] + "</span>\");");
                continue;
            }
            buf.append("breadCrumbLink(\"javascript:changeFolder('" + pathFolderIDs[i] + "'); void(0);\",");
            buf.append("\"View " + what + " in this folder\",");
            buf.append("\"" + pathFolderNames[i] + "\");");
            buf.append("document.write(\" / \");");
        }
        return buf.toString();
    }

    public static String currentFolderDetailsRow(String folderID, String folderPath, boolean flatView, boolean writeOnFolder, boolean autoRunOnFolder, boolean checkInCurrentOnFolder, String executeHostSets, String deleteHistoryHostSets) {
        StringBuffer buf = new StringBuffer("");
        buf.append("<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\">\n");
        buf.append("<tr>\n");
        buf.append(Util.formLabel("folder"));
        buf.append("<td nowrap class=\"bdyBold\">" + Util.preserveSpace(folderPath) + "</td>");
        buf.append("<td nowrap width=\"30\">&nbsp;</td>");
        buf.append("<td nowrap>");
        buf.append(Util.standardLink(UriUtil.folderDetailsURI(folderID), "show folder details", "details"));
        buf.append("&nbsp;|&nbsp;");
        buf.append(Util.standardLink(UriUtil.changePathURI(false, "navigate", ""), "change folder", "change folder..."));
        buf.append("</td>");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append(Util.formLabel("your permissions"));
        if (flatView) {
            buf.append("<td colspan=\"4\" class=\"bdyActionsDis\">");
            buf.append("Not applicable in flat view");
            buf.append("</td>");
            buf.append("</tr>\n");
        } else {
            buf.append("<td colspan=\"4\">");
            buf.append("edit: " + (writeOnFolder ? "yes" : "no"));
            buf.append("<img src=\"raplixPouch/spacer.gif\" height=\"8\" width=\"20\">");
            buf.append("run component procedures: " + (autoRunOnFolder ? "yes" : "no"));
            buf.append("<img src=\"raplixPouch/spacer.gif\" height=\"8\" width=\"20\">");
            buf.append("configure: " + (checkInCurrentOnFolder ? "yes" : "no"));
            buf.append("<img src=\"raplixPouch/spacer.gif\" height=\"8\" width=\"20\">");
            buf.append("allow on host set: " + executeHostSets);
            buf.append("</td>\n");
            buf.append("</tr>\n");
            buf.append("</tr>");
            buf.append("<td>");
            buf.append("<img src=\"raplixPouch/spacer.gif\" height=\"8\" width=\"20\">");
            buf.append("</td>\n");
            buf.append("<td colspan=\"4\">");
            buf.append("<img src=\"raplixPouch/spacer.gif\" height=\"8\" width=\"3\">");
            buf.append("delete run history on host sets: " + deleteHistoryHostSets);
            buf.append("</td>");
            buf.append("</tr>");
        }
        buf.append("</tr>\n");
        buf.append("</table>");
        return buf.toString();
    }

    public static String folderedObjectsTopRow(String what, String category, String[] categoryIDs, String[] categoryNames, String selectedPage, boolean showHidden, boolean inFlatView) {
        boolean displayFlatViewCheckbox = true;
        boolean displayShowHiddenCheckbox = true;
        boolean isCategoryEnabled = true;
        boolean isHiddenEnabled = true;
        if (selectedPage.equals("/Folders")) {
            isCategoryEnabled = false;
            isHiddenEnabled = false;
        }
        return Util.folderedObjectsTopRow(what, category, categoryIDs, categoryNames, isCategoryEnabled, selectedPage, "setFind('false');sendForm();return true;", displayShowHiddenCheckbox, showHidden, isHiddenEnabled, displayFlatViewCheckbox, inFlatView);
    }

    public static String folderedObjectsTopRow(String what, String category, String[] categoryIDs, String[] categoryNames, String selectedPage, String onChangeAction, boolean displayShowHidden, boolean showHidden, boolean displayFlatView, boolean inFlatView) {
        boolean isCategoryEnabled = true;
        boolean isHiddenEnabled = true;
        return Util.folderedObjectsTopRow(what, category, categoryIDs, categoryNames, isCategoryEnabled, selectedPage, onChangeAction, displayShowHidden, showHidden, isHiddenEnabled, displayFlatView, inFlatView);
    }

    public static String folderedObjectsTopRow(String what, String category, String[] categoryIDs, String[] categoryNames, boolean isCategoryEnabled, String selectedPage, String onChangeAction, boolean displayShowHidden, boolean showHidden, boolean isHiddenEnabled, boolean displayFlatView, boolean inFlatView) {
        StringBuffer buf = new StringBuffer("");
        buf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\n<tr>\n<td width=\"100%\">\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tr>\n<td class=\"sepBody\"> show :</td>\n<td width=\"5\">&nbsp;</td>\n<td>");
        if (!selectedPage.equals("")) {
            buf.append(Util.folderedObjectsSelect(selectedPage));
        } else {
            buf.append(what);
        }
        buf.append("</td>");
        buf.append("<td width=\"5\">&nbsp;</td>");
        String suffix = "onChange =\"" + onChangeAction + "\"";
        if (isCategoryEnabled) {
            buf.append("<td>show category:</td>");
        } else {
            buf.append("<td class=\"bdyActionsDis\">show category:</td>");
            suffix = "onChange =\"" + onChangeAction + "\"" + " disabled class=\"disabled\"";
        }
        buf.append("<td width=\"5\">&nbsp;</td><td>");
        buf.append(Util.staticSingleSelect("category", categoryIDs, category, categoryNames, suffix));
        buf.append("</td><td width=\"5\">&nbsp;</td>");
        if (displayFlatView) {
            buf.append(Util.showFlatViewCheckbox(inFlatView));
        }
        buf.append("</tr>\n</table>\n</td>\n<td><img src=\"raplixPouch/spacer.gif\" height=\"8\" width=\"30\"></td>\n");
        if (displayShowHidden) {
            buf.append(Util.showHiddenCells(what, showHidden, isHiddenEnabled));
        }
        buf.append("</tr></table>");
        return buf.toString();
    }

    private static String folderedObjectsSelect(String selectedPage) {
        StringBuffer sb = new StringBuffer("");
        sb.append("<select onChange=\"top.location.href = document.mainForm.pageChooser[document.mainForm.pageChooser.selectedIndex].value;\" name=\"pageChooser\">\n");
        sb.append("<option value=\"/Components\"");
        if (selectedPage.equals("/Components")) {
            sb.append(" selected");
        }
        sb.append(">components</option>\n");
        sb.append("<option value=\"/Plans\"");
        if (selectedPage.equals("/Plans")) {
            sb.append(" selected");
        }
        sb.append(">plans</option>\n");
        sb.append("<option value=\"/Folders\"");
        if (selectedPage.equals("/Folders")) {
            sb.append(" selected");
        }
        sb.append(">folders</option>\n");
        sb.append("</select>");
        return sb.toString();
    }

    public static String categoryFilter(String what, String category, String[] categoryIDs, String[] categoryNames) {
        return Util.categoryFilter(what, category, categoryIDs, categoryNames, "sendForm(); return true;");
    }

    public static String categoryFilter(String what, String category, String[] categoryIDs, String[] categoryNames, String onChangeAction) {
        StringBuffer buf = new StringBuffer("");
        buf.append("<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\" align=\"center\">\n<tr>\n");
        buf.append(Util.categoryFilterCells(what, category, categoryIDs, categoryNames, onChangeAction));
        buf.append("</tr>\n</table>");
        return buf.toString();
    }

    private static String categoryFilterCells(String what, String category, String[] categoryIDs, String[] categoryNames, String onChangeAction) {
        return Util.formLabel("show " + what + " in category") + "<td>" + Util.staticSingleSelect("category", categoryIDs, category, categoryNames, "onChange =\"" + onChangeAction + "\"") + "</td>";
    }

    public static String categoryNames(String url, String catNames) {
        StringBuffer buf = new StringBuffer("");
        buf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tr>\n<td>");
        buf.append(catNames);
        buf.append("</td>\n<td width=\"10\">&nbsp; </td>\n");
        buf.append("<td class=\"bdyActions\">");
        buf.append(Util.standardLink(url, "Apply categories from list", "apply categories..."));
        buf.append("</td>\n</tr>\n</table>\n");
        return buf.toString();
    }

    public static String categoryNames(String url, String catNames, LinkContext lc) {
        Link link = Link.simpleLink(url, "Apply categories from list", "apply categories...", LinkContext.WRITE_ON_FOLDER, true, lc);
        StringBuffer buf = new StringBuffer("");
        buf.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tr>\n<td>");
        buf.append(catNames);
        buf.append("</td>\n<td width=\"10\">&nbsp; </td>\n");
        buf.append("<td class=\"bdyActions\">");
        buf.append(link.renderAsText());
        buf.append("</td>\n</tr>\n</table>\n");
        return buf.toString();
    }

    public static String createPageURL(int currentPage) {
        if (currentPage <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer("javascript: ");
        sb.append("document.mainForm.");
        sb.append("currentPage");
        sb.append(".value = '");
        sb.append(currentPage);
        sb.append("'; sendForm(); void(0);");
        return sb.toString();
    }

    public static String tablePagination(int pageCount, int currentPage, int firstPos, int lastPos, int totalItemCount, boolean showHidden, String isFindFiltered, String suffixSingular, String suffixPlural, String filterName) {
        if (pageCount <= 0 || currentPage <= 0 || firstPos <= 0 || lastPos <= 0 || totalItemCount <= 0 || suffixSingular == null || suffixPlural == null) {
            StringBuffer sb = new StringBuffer("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n<tr><td nowrap>");
            if (isFindFiltered.equals("true")) {
                sb.append("no ");
                sb.append(suffixPlural);
                sb.append(" were found");
            } else if (filterName == null) {
                sb.append("there are no ");
                sb.append(suffixPlural);
                sb.append(" defined");
            } else {
                sb.append("no ");
                sb.append(suffixPlural);
                sb.append(" were found with filter \"");
                sb.append(filterName);
                sb.append("\"");
            }
            sb.append("</td></tr>\n</table>");
            return sb.toString();
        }
        int NUMBERPAGESDISPLAYED = 10;
        int remainderResult = -1;
        int startPageIndex = -1;
        int endPageIndex = -1;
        StringBuffer sb = new StringBuffer("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n<tr>\n<td nowrap>showing&nbsp;");
        sb.append(firstPos);
        sb.append("-");
        sb.append(lastPos);
        sb.append("&nbsp;of&nbsp;");
        sb.append(Util.pluringular(Integer.toString(totalItemCount), suffixSingular, suffixPlural));
        if (filterName != null) {
            sb.append("&nbsp;found&nbsp;with&nbsp;filter&nbsp\"");
            sb.append(filterName);
            sb.append("\"");
        } else if (isFindFiltered.equals("true")) {
            sb.append("&nbsp;found");
        }
        sb.append("</td>");
        if (currentPage == 1) {
            sb.append("\n<td><img border=\"0\" height=\"8\" src=\"raplixPouch/spacer.gif\" width=\"20\"><img src=\"raplixPouch/prevListDis.gif\" alt=\"Already showing first page\" border=\"0\" width=\"11\" height=\"11\"><img src=\"raplixPouch/spacer.gif\" width=\"8\" height=\"8\"></td>");
        } else {
            sb.append("\n<td><img border=\"0\" height=\"8\" src=\"raplixPouch/spacer.gif\" width=\"20\">");
            sb.append(Util.standardLink(Util.createPageURL(currentPage - 1), "Show previous page", "<img src=\"raplixPouch/prevList.gif\" alt=\"Show previous page\" border=\"0\" width=\"11\" height=\"11\">"));
            sb.append("<img src=\"raplixPouch/spacer.gif\" width=\"8\" height=\"8\"></td>");
        }
        sb.append("\n<td nowrap>page");
        remainderResult = currentPage % 10;
        startPageIndex = remainderResult == 0 ? currentPage - 9 : currentPage - remainderResult + 1;
        endPageIndex = startPageIndex + 9;
        if (currentPage > 10) {
            sb.append("&nbsp;");
            sb.append(Util.standardLink(Util.createPageURL(startPageIndex - 1), "Show previous set of pages", "..."));
        }
        for (int currentIndex = startPageIndex; currentIndex <= endPageIndex && currentIndex <= pageCount; ++currentIndex) {
            if (currentIndex == currentPage) {
                sb.append("&nbsp;" + currentIndex);
                continue;
            }
            sb.append("&nbsp;");
            sb.append(Util.standardLink(Util.createPageURL(currentIndex), "Show this page", Integer.toString(currentIndex)));
        }
        if (endPageIndex < pageCount) {
            sb.append("&nbsp;");
            sb.append(Util.standardLink(Util.createPageURL(endPageIndex + 1), "Show next set of pages", "..."));
        }
        sb.append("</td>");
        if (currentPage == pageCount) {
            sb.append("\n<td><img src=\"raplixPouch/spacer.gif\" width=\"8\" height=\"8\"><img src=\"raplixPouch/nextListDis.gif\" alt=\"Already showing last page\" border=\"0\" width=\"11\" height=\"11\"></td>");
        } else {
            sb.append("\n<td><img src=\"raplixPouch/spacer.gif\" width=\"8\" height=\"8\">");
            sb.append(Util.standardLink(Util.createPageURL(currentPage + 1), "Show next page", "<img src=\"raplixPouch/nextList.gif\" alt=\"Show next page\" border=\"0\" width=\"11\" height=\"11\">"));
            sb.append("</td>");
        }
        sb.append("\n</tr>\n</table>");
        return sb.toString();
    }

    public static String tablePagination(ServletListBean bean, String suffixSingular, String suffixPlural, String filterName) {
        return Util.tablePagination(bean.getPageCount(), bean.getCurrentPage(), bean.getFirstPos(), bean.getLastPos(), bean.getTotalItemCount(), bean.getShowHidden(), bean.getIsFindFiltered(), suffixSingular, suffixPlural, filterName);
    }

    public static String preflightLiveURI(String id) {
        return "/PlanRunResults?id=" + id + "&" + "phase" + "=" + "preflightlive";
    }

    public static String preflightResultsURI(String id) {
        return "/PlanRunResults?id=" + id + "&" + "mode" + "=" + "render" + "&" + "phase" + "=" + "preflightresults";
    }

    public static String runLiveURI(String id) {
        return "/PlanRunResults?id=" + id + "&" + "phase" + "=" + "runlive";
    }

    public static String runResultsURI(String id) {
        return "/PlanRunResults?id=" + id + "&" + "mode" + "=" + "render" + "&" + "phase" + "=" + "runresults";
    }

    public static String runProgressOrDetailsURI(String id) {
        return "/PlanRunLink?id=" + id + "&" + "mode" + "=" + "planprogressordetails";
    }

    public static String getInUseMessage(UsingObject blocker) {
        String name = blocker.getName();
        String inUseMsg = null;
        ObjectID blockerID = blocker.getObjectID();
        ROXMessage rm = null;
        if (blockerID instanceof DifferenceSettingsID) {
            rm = new ROXMessage(MSG_INUSE_COMPARISON, name);
        } else if (blockerID instanceof ComponentID) {
            SummaryComponent sc = (SummaryComponent)blocker;
            name = sc.getFullName();
            String version = sc.getVersionNumber().getAsString();
            rm = new ROXMessage(MSG_INUSE_COMPONENT, name, version);
        } else if (blockerID instanceof ComponentTypeRefID) {
            rm = new ROXMessage(MSG_INUSE_COMPONENTTYPE, name);
        } else if (blockerID instanceof SystemServiceRefID) {
            rm = new ROXMessage(MSG_INUSE_SYSTEMSERVICE, name);
        } else if (blocker.getObjectID() instanceof HostID) {
            rm = new ROXMessage(MSG_INUSE_HOST, name);
        } else if (blockerID instanceof HostSetID) {
            rm = new ROXMessage(MSG_INUSE_HOSTSET, name);
        } else if (blockerID instanceof HostSearchID) {
            rm = new ROXMessage(MSG_INUSE_HOSTSEARCH, name);
        } else if (blockerID instanceof HostTypeID) {
            rm = new ROXMessage(MSG_INUSE_HOSTTYPE, name);
        } else if (blockerID instanceof SnapshotID) {
            rm = new ROXMessage(MSG_INUSE_SNAPSHOT, name);
        } else if (blockerID instanceof ExecutionPlanID) {
            SummaryExecutionPlan sep = (SummaryExecutionPlan)blocker;
            name = sep.getFullName();
            String version = sep.getVersionNumber().getAsString();
            rm = new ROXMessage(MSG_INUSE_PLAN, name, version);
        } else if (blockerID instanceof GroupID) {
            rm = new ROXMessage(MSG_INUSE_USERGROUP, name);
        } else if (blockerID instanceof RuleID) {
            rm = new ROXMessage(MSG_INUSE_NOTRULE, name);
        } else if (blockerID instanceof PluginID) {
            rm = new ROXMessage(MSG_INUSE_PLUGIN, name);
        } else {
            inUseMsg = blocker.getName();
            if (Logger.isErrorEnabled(DeleteConfirmNode.class)) {
                Logger.error("Unhandled UsingObject '" + blocker.getClass().getName() + "'", DeleteConfirmNode.class);
            }
            return inUseMsg;
        }
        inUseMsg = rm.getMessageString();
        return inUseMsg;
    }

    public static String divStart(String id, boolean isVisible) {
        return Util.divStart(id, isVisible, "");
    }

    public static String divStart(String id, boolean isVisible, String suffix) {
        StringBuffer sb = new StringBuffer();
        sb.append("<div id=\"" + id + "\" style=\"display:");
        if (isVisible) {
            sb.append("inline");
        } else {
            sb.append("none");
        }
        sb.append("\" " + suffix + ">");
        return sb.toString();
    }

    public static String divEnd() {
        return "</div>";
    }

    public static String hostSets2String(HostSetIDSet hostsetIDs) throws RaplixException {
        if (hostsetIDs == null || hostsetIDs.isEmpty()) {
            return "";
        }
        StringBuffer bf = new StringBuffer();
        SummaryHostSet[] hostSets = hostsetIDs.getByIDsQuery().selectSummaryView();
        for (int i = 0; i < hostSets.length; ++i) {
            bf.append(hostSets[i].getName());
            if (i == hostSets.length - 1) continue;
            bf.append(", ");
        }
        return bf.toString();
    }
}

