/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.userdb.ClearSessionVarsException;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.UsersBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.users.LoginConfigurationBean;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.security.AccessControlException;
import javax.servlet.http.HttpServletRequest;

public class UsersHandleAction
extends UIActionServlet
implements ActionModeConstants {
    private static final String MSG_ERROR_CREATE = "error.users.create";
    private static final String MSG_ERROR_EDIT = "error.users.edit";
    private static final String MSG_ERROR_CANCEL = "error.users.cancel";
    private static final String MSG_ERROR_SAVE_MAJOR = "error.users.save.major";
    private static final String MSG_ERROR_SAVE_PASSWORDS_DIFF = "error.users.save.diffPasswords";
    private static final String MSG_ERROR_SAVE_PASSWORDS_NONE = "error.users.save.noPasswords";
    private static final String MSG_ERROR_SAVE_SESSION_VARIABLES_MAJOR = "error.users.sessionvariables.major";
    private static final String MSG_ERROR_LOGIN_INVALID_MAJOR = "error.users.logininvalid.major";
    private static final String MSG_ERROR_LOGIN_INVALID_MINOR = "error.users.logininvalid.minor";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = UsersHandleAction.assertGetParam(request, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through UsersHandleAction: " + mode, this);
        }
        if (mode.equals("add")) {
            this.handleAdd(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("saveas")) {
            this.handleSaveAs(request, servletInfo);
        } else if (mode.equals("saveconfirmed")) {
            this.handleSaveAsConfirmed(request, servletInfo);
        } else if (mode.equals("refresh")) {
            this.handleRefresh(request, servletInfo);
        } else if (mode.equals("cancelsave")) {
            this.handleNotConfirmed(request, servletInfo);
        } else if (mode.equals("updategroups")) {
            this.handleUpdateGroups(request, servletInfo);
        } else if (mode.equals("renderbottom")) {
            servletInfo.setDestPage("/userDetailsBottom.jsp");
            servletInfo.setShouldRedirect(false);
        } else if (mode.equals("rendertop")) {
            servletInfo.setDestPage("/userDetailsTop.jsp");
            servletInfo.setShouldRedirect(false);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to UsersHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        UsersBean ub;
        String mode = UsersHandleAction.assertGetParam(request, "mode");
        if (mode.equals("add") || mode.equals("edit")) {
            UserManager userMgr = UsersHandleAction.getApplication().getUserManager();
            GroupManager uGroupMgr = UsersHandleAction.getApplication().getUserGroupManager();
            PermissionManager uPermMgr = UsersHandleAction.getApplication().getUserPermissionManager();
            SessionManager uSessionMgr = UsersHandleAction.getApplication().getUserSessionManager();
            ub = new UsersBean(userMgr, uGroupMgr, uPermMgr, uSessionMgr);
        } else {
            String id = request.getParameter("id");
            ub = (UsersBean)request.getSession().getAttribute(id);
            if (ub == null) {
                throw new IllegalArgumentException("Expected Bean not found.");
            }
        }
        return ub;
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = UsersHandleAction.assertGetParam(inRequest, "mode");
        if (mode.equals("add")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("saveas")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("saveconfirmed")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("updategroups")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("renderbottom")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("rendertop")) {
            return MSG_ERROR_EDIT;
        }
        throw new IllegalArgumentException("Unknown mode passed to UsersHandleAction.");
    }

    public String getDefaultPage() {
        return "/users.jsp";
    }

    protected void handleSaveAsConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UsersBean ub = (UsersBean)servletInfo.getBean();
        String password1 = UsersHandleAction.assertGetParam(request, "password1");
        String password2 = UsersHandleAction.assertGetParam(request, "password2");
        ub.setIsNew(true);
        this.readFromRequest(request, ub);
        if (ub.getConfigurationIsInternal()) {
            ub.setPassword(password1, password2);
        } else {
            ub.setNoPassword();
        }
        if (this.checkSaveErrorCases(ub, servletInfo.getErrors())) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            ub.setMode("saveas");
            servletInfo.setDestPage("/userConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        ub.setSaveOverride(request.getParameter("saveOverride") != null);
        try {
            ub.persistCopy(ub.getName(), ub.getSaveOverride());
        }
        catch (ClearSessionVarsException c) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_SESSION_VARIABLES_MAJOR);
            servletInfo.getErrors().addMinorErrorKey(c.getMessage());
            ub.setMode("edit");
            ub.setSaveOverride(true);
            servletInfo.setDestPage("/userDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (UserDBException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(e.getMessage());
            ub.setMode("saveas");
            servletInfo.setDestPage("/userConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(this.getMajorError(request));
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            ub.setMode("saveas");
            servletInfo.setDestPage("/userConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/redirect.jsp");
        request.setAttribute("url", (Object)"/Users");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UsersBean ub = (UsersBean)servletInfo.getBean();
        ub.resetEventFlags();
        String password1 = UsersHandleAction.assertGetParam(request, "password1");
        String password2 = UsersHandleAction.assertGetParam(request, "password2");
        String newGroupIDs = UsersHandleAction.assertGetParam(request, "newGroupIDs");
        String[] newGrpIDArray = Util.arrayifyCommaSeparated(newGroupIDs);
        this.readFromRequest(request, ub);
        if (ub.getConfigurationIsInternal()) {
            ub.setPassword(password1, password2);
        } else {
            ub.setNoPassword();
        }
        ub.setIsHidden(request.getParameter("isHidden") != null);
        ub.setIsActive(request.getParameter("isDeactivated") == null);
        ub.setGroupIDs(newGrpIDArray);
        ub.setSaveOverride(request.getParameter("saveOverride") != null);
        if (this.checkSaveErrorCases(ub, servletInfo.getErrors())) {
            String newGroupNames = UsersHandleAction.assertGetParam(request, "newGroupNames");
            String[] newGrpNamesArray = Util.arrayifyCommaSeparated(newGroupNames);
            ub.loadGroupNamesAndIDs(newGrpNamesArray, newGrpIDArray);
            ub.updateOtherGroups(newGrpNamesArray, newGrpIDArray);
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            ub.setMode("edit");
            servletInfo.setDestPage("/userDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        try {
            if (ub.getIsNew()) {
                ub.persist(ub.getName(), ub.getSaveOverride());
            } else {
                ub.persist(null, ub.getSaveOverride());
            }
        }
        catch (ClearSessionVarsException c) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_SESSION_VARIABLES_MAJOR);
            servletInfo.getErrors().addMinorErrorKey(c.getMessage());
            ub.setMode("edit");
            ub.setSaveOverride(true);
            servletInfo.setDestPage("/userDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (UserDBException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(e.getMessage());
            ub.setMode("edit");
            servletInfo.setDestPage("/userDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(this.getMajorError(request));
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            ub.setMode("edit");
            servletInfo.setDestPage("/userDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/redirect.jsp");
        request.setAttribute("url", (Object)"/Users");
        servletInfo.setShouldRedirect(false);
    }

    private void handleSaveAs(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UsersBean ub = (UsersBean)servletInfo.getBean();
        ub.resetEventFlags();
        ub.setMode("saveas");
        String newGroupIDs = UsersHandleAction.assertGetParam(request, "newGroupIDs");
        String isHiddenS = UsersHandleAction.assertGetParam(request, "isHidden");
        String isDeactiveS = UsersHandleAction.assertGetParam(request, "isDeactivated");
        boolean isHiddenB = !StringUtil.isEmpty(isHiddenS);
        boolean isDeactiveB = !StringUtil.isEmpty(isDeactiveS);
        this.readFromRequest(request, ub);
        String[] newGrpIDArray = Util.arrayifyCommaSeparated(newGroupIDs);
        ub.setGroupIDs(newGrpIDArray);
        ub.loadGroupNames(newGrpIDArray);
        ub.setIsHidden(isHiddenB);
        ub.setIsActive(!isDeactiveB);
        if (this.checkSaveErrorCases(ub, servletInfo.getErrors())) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            ub.setMode("edit");
            servletInfo.setDestPage("/userDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/userConfirm.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleCancel(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.setDestPage("/redirect.jsp");
        request.setAttribute("url", (Object)"/Users");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleNotConfirmed(HttpServletRequest request, ServletInfo servletInfo) {
        UsersBean ub = (UsersBean)servletInfo.getBean();
        ub.setIsNew(false);
        ub.reloadOldUser();
        servletInfo.setDestPage("/userDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UsersBean ub = (UsersBean)servletInfo.getBean();
        this.readFromRequest(request, ub);
        String password1 = UsersHandleAction.assertGetParam(request, "password1");
        String password2 = UsersHandleAction.assertGetParam(request, "password2");
        if (ub.getConfigurationIsInternal()) {
            ub.setPassword(password1, password2);
        } else {
            ub.setNoPassword();
        }
        String newGroupIDs = UsersHandleAction.assertGetParam(request, "newGroupIDs");
        String[] newGrpIDArray = Util.arrayifyCommaSeparated(newGroupIDs);
        ub.setGroupIDs(newGrpIDArray);
        ub.loadGroupPermissions(newGrpIDArray);
        ub.setIsHidden(request.getParameter("isHidden") != null);
        ub.setIsActive(request.getParameter("isDeactivated") == null);
        ub.setMode("edit");
        servletInfo.setDestPage("/userDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleAdd(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UsersBean ub = (UsersBean)servletInfo.getBean();
        ub.loadUsersArray();
        String name = request.getParameter("name");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("we are adding a user:" + name, this);
        }
        ub.createUser(name);
        ub.setIsNew(true);
        ub.setMode("add");
        servletInfo.setDestPage("/userDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UsersBean ub = (UsersBean)servletInfo.getBean();
        ub.resetEventFlags();
        ub.loadUsersArray();
        String id = request.getParameter("id");
        ub.loadSingleUser(id);
        ub.setMode("edit");
        String userID = ub.getUserID().toString();
        UserManager userMgr = UsersHandleAction.getApplication().getUserManager();
        ub.setIsAdmin(userID.equals(userMgr.getAdminUserID().toString()));
        if (ub.getIsError()) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_LOGIN_INVALID_MAJOR);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_LOGIN_INVALID_MINOR, ub.getConfiguration());
        }
        servletInfo.setDestPage("/userDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleUpdateGroups(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UsersBean ub = (UsersBean)servletInfo.getBean();
        String name = UsersHandleAction.assertGetParam(request, "name");
        String newGroupIDs = UsersHandleAction.assertGetParam(request, "newGroupIDs");
        String[] newGrpIDArray = Util.arrayifyCommaSeparated(newGroupIDs);
        ub.setName(name);
        ub.setGroupIDs(newGrpIDArray);
        ub.loadGroupNames(newGrpIDArray);
        ub.updateOtherGroups(ub.getGroupNames(), newGrpIDArray);
        ub.loadGroupPermissions(newGrpIDArray);
        ub.setMode("updategroups");
        ub.setUpdateGroups(true);
        servletInfo.setDestPage("/userDetailsTop.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private boolean checkSaveErrorCases(UsersBean ub, ServletErrors errors) {
        boolean hasErrors = false;
        if (ub.getPasswordError() != 0) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("in checkSaveErrorCases, we got error code:" + ub.getPasswordError(), this);
            }
            hasErrors = true;
            switch (ub.getPasswordError()) {
                case 2: {
                    errors.addMinorErrorKey(MSG_ERROR_SAVE_PASSWORDS_DIFF);
                    break;
                }
                default: {
                    errors.addMinorErrorKey(MSG_ERROR_SAVE_PASSWORDS_NONE);
                }
            }
        }
        return hasErrors;
    }

    private void readFromRequest(HttpServletRequest request, UsersBean ub) {
        ub.setName(UsersHandleAction.assertGetParam(request, "name"));
        String loginConfig = UsersHandleAction.assertGetParam(request, "configuration");
        ub.setConfiguration(loginConfig);
        boolean isLoginValid = LoginConfigurationBean.isLoginConfigurationValid(loginConfig);
        ub.setConfigurationIsInternal(isLoginValid && LoginConfigurationBean.isLoginConfigurationInternal(loginConfig));
        ub.setIsError(false);
    }
}

