/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.DifferencePermission;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.MultiGroupQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.MultiUserQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsBean;
import com.raplix.rolloutexpress.ui.web.users.LoginConfigurationBean;
import com.raplix.util.ArrayEdit;
import com.raplix.util.logger.Logger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class UsersBean
extends ServletBean {
    private UserManager mUserMgr = null;
    private GroupManager mGroupMgr = null;
    private PermissionManager mPermMgr = null;
    private SessionManager mSessionMgr = null;
    public static final int NO_ERROR = 0;
    public static final int ERROR_PASSWORD_NOT_SET = 1;
    public static final int ERROR_PASSWORD_MISMATCH = 2;
    public static final String INTERNAL_LOGIN_PREFIX = "* ";
    private User mUser = null;
    private User mOldUser = null;
    private String[] mUserNames = new String[0];
    private String[] mUserIDs = new String[0];
    private boolean[] mIsHiddens = new boolean[0];
    private boolean[] mIsActives = new boolean[0];
    private boolean[] mIsErrors = new boolean[0];
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private boolean mShowHidden = false;
    private String[] mConfigurationNames = new String[0];
    private String[] mConfigurationValues = new String[0];
    private boolean[] mConfigurationIsInternals = new boolean[0];
    private String mConfiguration = "";
    private boolean mIsAdmin = false;
    private boolean mConfigurationIsInternal = true;
    private boolean mSaveOverride = false;
    private String[] mMemGroupNames = new String[0];
    private String[] mMemGroupIDs = new String[0];
    private String[] mOtherMemGrpNames = new String[0];
    private String[] mOtherMemGrpIDs = new String[0];
    private String[] mPermissions = new String[0];
    private String mPermissionsString = "";
    private String mMode = "";
    private boolean mIsNew = false;
    private String mTmpName = "";
    private String mTmpID = "";
    private String mTmpPassword = "";
    private boolean mTmpPasswordSet = false;
    private boolean mIsHidden = false;
    private boolean mIsActive = true;
    private boolean mIsError = false;
    private int mTmpPasswordError = 0;
    private boolean mUpdateGroups = false;
    private boolean mUserHasAdminWrite = true;
    private String[] mBasicPermissionNames = new String[0];
    private PermissionID[] mBasicPermissionReadIDs = new PermissionID[0];
    private PermissionID[] mBasicPermissionWriteIDs = new PermissionID[0];
    private boolean[] mBasicPermissionReads = new boolean[0];
    private boolean[] mBasicPermissionWrites = new boolean[0];
    private String[] mRunPermissionNames = new String[0];
    private PermissionID[] mRunPermissionReadIDs = new PermissionID[0];
    private PermissionID[] mRunPermissionWriteIDs = new PermissionID[0];
    private boolean[] mRunPermissionReads = new boolean[0];
    private boolean[] mRunPermissionWrites = new boolean[0];
    private boolean[] mRunPermissionRuns = new boolean[0];
    private String[] mRunPermissionsRunValues = new String[0];
    private PermissionID mAllHostsRunDiffPermissionID = null;

    public UsersBean(UserManager userMgr, GroupManager groupMgr, PermissionManager permMgr, SessionManager sessionMgr) {
        this.mUserMgr = userMgr;
        this.mGroupMgr = groupMgr;
        this.mPermMgr = permMgr;
        this.mSessionMgr = sessionMgr;
        this.loadPermissionLookaheads();
    }

    public void loadUsersArray() throws RaplixException {
        MultiUserQuery muq = MultiUserQuery.all();
        muq.setVisibilityFilter(this.mShowHidden ? null : Visibility.VISIBLE);
        User[] inUsers = muq.select();
        this.loadLoginConfigurations();
        String adminID = this.mUserMgr.getAdminUserID().toString();
        this.mUserNames = new String[inUsers.length];
        this.mUserIDs = new String[inUsers.length];
        this.mIsHiddens = new boolean[inUsers.length];
        this.mIsActives = new boolean[inUsers.length];
        this.mIsErrors = new boolean[inUsers.length];
        for (int i = 0; i < inUsers.length; ++i) {
            this.mUserIDs[i] = inUsers[i].getUserID().toString();
            this.mUserNames[i] = inUsers[i].getUsername();
            this.mIsHiddens[i] = inUsers[i].getVisibility().equals(Visibility.HIDDEN);
            this.mIsActives[i] = inUsers[i].getActive();
            this.mIsErrors[i] = this.mUserIDs[i].equals(adminID) ? false : !LoginConfigurationBean.isLoginConfigurationValid(inUsers[i].getLoginConfiguration());
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mUserIDs);
    }

    public void createUser(String name) throws RaplixException {
        this.mUser = this.mUserMgr.newUser(name);
        this.mTmpName = name;
        UserID uid = UserID.generateUserID();
        this.mTmpID = uid.toString();
        this.mTmpPasswordSet = false;
        this.mMemGroupNames = new String[0];
        this.mMemGroupIDs = new String[0];
        this.loadBasicPermissionNamesAndIDs();
        this.loadRunPermissionNamesAndIDs();
        this.loadPermissionAccessValues(uid);
        this.loadPermissionsString();
        this.updateOtherGroups(this.mMemGroupNames, this.mMemGroupIDs);
        if (this.getConfigurationNames().length > 0) {
            this.mUser.setLoginConfiguration(this.getConfigurationValues()[0]);
            this.mConfigurationIsInternal = this.getConfigurationIsInternals()[0];
        }
    }

    public void loadSingleUser(String inUserID) throws RaplixException {
        this.mUser = this.mUserMgr.getUser(new UserID(inUserID));
        this.setIsNew(false);
        this.mTmpName = this.mUser.getUsername();
        this.mTmpID = this.mUser.getUserID().toString();
        this.mIsHidden = this.mUser.getVisibility().equals(Visibility.HIDDEN);
        this.mIsActive = this.mUser.getActive();
        this.mConfiguration = this.mUser.getLoginConfiguration();
        if (LoginConfigurationBean.isLoginConfigurationValid(this.mConfiguration)) {
            this.mIsError = false;
        } else {
            this.mIsError = true;
            this.updateLoginConfigurations(this.mConfiguration);
        }
        this.mConfigurationIsInternal = LoginConfigurationBean.isLoginConfigurationInternal(this.mConfiguration);
        if (this.mConfigurationIsInternal) {
            String localPass = this.mUser.getPassword().toString();
            this.mTmpPasswordSet = localPass != null;
        } else {
            this.mTmpPassword = null;
            this.mTmpPasswordSet = true;
        }
        Vector<String> setGrpNameVector = new Vector<String>();
        Vector<String> setGrpIDVector = new Vector<String>();
        Vector setPermissionVector = new Vector();
        Group[] tmpGrps = this.mUser.getGroups();
        for (int i = 0; i < tmpGrps.length; ++i) {
            setGrpNameVector.add(tmpGrps[i].getName());
            setGrpIDVector.add(tmpGrps[i].getGroupID().toString());
        }
        this.loadBasicPermissionNamesAndIDs();
        this.loadRunPermissionNamesAndIDs();
        this.loadPermissionAccessValues(this.mUser.getUserID());
        this.mMemGroupNames = setGrpNameVector.toArray(new String[0]);
        this.mMemGroupIDs = setGrpIDVector.toArray(new String[0]);
        this.mPermissions = setPermissionVector.toArray(new String[0]);
        this.loadPermissionsString();
        this.updateOtherGroups(this.mMemGroupNames, this.mMemGroupIDs);
    }

    public void updateLoginConfigurations(String s) {
        this.mConfigurationValues = (String[])ArrayEdit.add(this.mConfigurationValues, new String(s));
        this.mConfigurationNames = (String[])ArrayEdit.add(this.mConfigurationNames, new String(s));
        boolean[] localInternals = new boolean[this.mConfigurationIsInternals.length + 1];
        System.arraycopy(this.mConfigurationIsInternals, 0, localInternals, 0, this.mConfigurationIsInternals.length);
        localInternals[this.mConfigurationIsInternals.length] = false;
        this.mConfigurationIsInternals = localInternals;
    }

    public void loadGroupPermissions(String[] inGroupIDs) throws RaplixException {
        GroupID registeredGroupID = this.mGroupMgr.getRegisteredGroupID();
        inGroupIDs = (String[])ArrayEdit.add(inGroupIDs, registeredGroupID.toString());
        Hashtable<PermissionID, Permission> hPerms = new Hashtable<PermissionID, Permission>();
        for (int i = 0; i < inGroupIDs.length; ++i) {
            Permission[] tmpPerm = this.mGroupMgr.getGrantedPermissions(new GroupID(inGroupIDs[i]));
            for (int j = 0; j < tmpPerm.length; ++j) {
                if (hPerms.contains(tmpPerm[j].getPermissionID())) continue;
                hPerms.put(tmpPerm[j].getPermissionID(), tmpPerm[j]);
            }
        }
        Collection cPerms = hPerms.values();
        Permission[] aPerms = cPerms.toArray(new Permission[0]);
        this.loadPermissionAccessValues(aPerms);
        this.loadPermissionsString();
    }

    public void reloadOldUser() {
        if (this.mOldUser != null) {
            this.mUser = this.mOldUser;
        }
    }

    public void persist(String name, boolean saveOverride) throws RaplixException {
        if (name != null) {
            this.mUser = this.mUserMgr.newUser(name);
        }
        this.copySettingsIntoUser();
        this.mUser.save(saveOverride);
    }

    public void persistCopy(String inUser, boolean saveOverride) throws RaplixException {
        this.mOldUser = this.mUser;
        this.mUser = this.mUserMgr.newUser(inUser);
        this.copySettingsIntoUser();
        this.mUser.save(saveOverride);
    }

    private void copySettingsIntoUser() throws RaplixException {
        if (this.mUser != null) {
            if (this.mTmpPasswordSet) {
                this.mUser.setPassword(this.mTmpPassword);
            }
            this.mUser.setActive(this.mIsActive);
            this.mUser.setVisibility(this.mIsHidden ? Visibility.HIDDEN : Visibility.VISIBLE);
            Group[] setGroups = new Group[this.mMemGroupIDs.length];
            for (int i = 0; i < this.mMemGroupIDs.length; ++i) {
                GroupID tgrpID = new GroupID(this.mMemGroupIDs[i]);
                setGroups[i] = this.mGroupMgr.getGroup(tgrpID);
            }
            this.mUser.setGroups(setGroups);
            this.mUser.setLoginConfiguration(this.mConfiguration);
        }
    }

    public void updateOtherGroups(String[] mMemGroupNames, String[] mMemGroupIDs) throws RaplixException {
        MultiGroupQuery mgq = MultiGroupQuery.all();
        Group[] allGroups = mgq.select();
        Hashtable<String, String> currentGroupHash = new Hashtable<String, String>();
        for (int i = 0; i < mMemGroupIDs.length; ++i) {
            currentGroupHash.put(mMemGroupIDs[i], mMemGroupNames[i]);
            if (!Logger.isDebugEnabled(this)) continue;
            Logger.debug("put current group in hash:" + mMemGroupNames[i], this);
        }
        Vector<String> vOtherGroupNames = new Vector<String>();
        Vector<String> vOtherGroupIDs = new Vector<String>();
        for (int i = 0; i < allGroups.length; ++i) {
            String sGroupID = allGroups[i].getGroupID().toString();
            if (currentGroupHash.containsKey(sGroupID)) continue;
            vOtherGroupIDs.addElement(sGroupID);
            String name = allGroups[i].getName();
            vOtherGroupNames.addElement(name);
            Logger.debug("updateOtherGroups, name:" + name, this);
        }
        this.mOtherMemGrpIDs = vOtherGroupIDs.toArray(new String[0]);
        this.mOtherMemGrpNames = vOtherGroupNames.toArray(new String[0]);
    }

    private void loadPermissionsString() {
        int i;
        int LEN_NAME = 25;
        int LEN_WRITE = 6;
        int LEN_RUN = 7;
        StringBuffer permissionsBuffer = new StringBuffer();
        for (i = 0; i < this.mRunPermissionNames.length; ++i) {
            this.padToBuffer(permissionsBuffer, this.mRunPermissionNames[i], LEN_NAME);
            if (this.mRunPermissionWrites[i]) {
                this.padToBuffer(permissionsBuffer, "write", LEN_WRITE);
            } else {
                this.padToBuffer(permissionsBuffer, "  -  ", LEN_WRITE);
            }
            if (this.mRunPermissionRuns[i]) {
                this.padToBuffer(permissionsBuffer, "run on", LEN_RUN);
            } else {
                this.padToBuffer(permissionsBuffer, "  -  ", LEN_RUN);
            }
            permissionsBuffer.append(this.mRunPermissionsRunValues[i]);
            permissionsBuffer.append("\n");
        }
        for (i = 0; i < this.mBasicPermissionNames.length; ++i) {
            this.padToBuffer(permissionsBuffer, this.mBasicPermissionNames[i], LEN_NAME);
            if (this.mBasicPermissionWrites[i]) {
                this.padToBuffer(permissionsBuffer, "write", LEN_WRITE);
            } else {
                this.padToBuffer(permissionsBuffer, "  -  ", LEN_WRITE);
            }
            permissionsBuffer.append("\n");
        }
        this.mPermissionsString = permissionsBuffer.toString();
    }

    private void padToBuffer(StringBuffer inBuffer, String inString, int inPadLength) {
        if (inString == null) {
            inString = "";
        }
        if (inString.length() > inPadLength) {
            inBuffer.append(inString.substring(0, inPadLength));
        } else {
            inBuffer.append(inString);
            for (int i = 0; i < inPadLength - inString.length(); ++i) {
                inBuffer.append(" ");
            }
        }
    }

    public void loadBasicPermissionNamesAndIDs() throws RaplixException {
        Vector<PermissionID> basicReadPermissions = new Vector<PermissionID>();
        Vector<PermissionID> basicWritePermissions = new Vector<PermissionID>();
        Vector<String> basicPermissionNames = new Vector<String>();
        basicReadPermissions.addElement(this.mPermMgr.getHostReadPermissionID());
        basicWritePermissions.addElement(this.mPermMgr.getHostWritePermissionID());
        basicPermissionNames.addElement(ApplicationResources.getMessage("label.usergroups.permissions.hosts"));
        basicReadPermissions.addElement(this.mPermMgr.getRuleReadPermissionID());
        basicWritePermissions.addElement(this.mPermMgr.getRuleWritePermissionID());
        basicPermissionNames.addElement(ApplicationResources.getMessage("label.usergroups.permissions.rules"));
        basicReadPermissions.addElement(this.mPermMgr.getUserDBReadPermissionID());
        basicWritePermissions.addElement(this.mPermMgr.getUserDBWritePermissionID());
        basicPermissionNames.addElement(ApplicationResources.getMessage("label.usergroups.permissions.userdb"));
        this.mBasicPermissionNames = basicPermissionNames.toArray(new String[0]);
        this.mBasicPermissionReadIDs = basicReadPermissions.toArray(new PermissionID[0]);
        this.mBasicPermissionWriteIDs = basicWritePermissions.toArray(new PermissionID[0]);
    }

    public void loadRunPermissionNamesAndIDs() throws RaplixException {
        Vector<PermissionID> runReadPermissions = new Vector<PermissionID>();
        Vector<PermissionID> runWritePermissions = new Vector<PermissionID>();
        Vector<String> runPermissionNames = new Vector<String>();
        runReadPermissions.addElement(this.mPermMgr.getDiffReadPermissionID());
        runWritePermissions.addElement(this.mPermMgr.getDiffWritePermissionID());
        runPermissionNames.addElement(ApplicationResources.getMessage("label.usergroups.permissions.comparisons"));
        this.mRunPermissionNames = runPermissionNames.toArray(new String[0]);
        this.mRunPermissionReadIDs = runReadPermissions.toArray(new PermissionID[0]);
        this.mRunPermissionWriteIDs = runWritePermissions.toArray(new PermissionID[0]);
        this.mAllHostsRunDiffPermissionID = this.mPermMgr.getAllHostsRunDiffPermissionID();
    }

    public void loadPermissionAccessValues(UserID inUserID) throws RaplixException {
        Permission[] tGroupPermissions = this.mPermMgr.getPermissionsByUser(inUserID);
        this.loadPermissionAccessValues(tGroupPermissions);
    }

    private void loadPermissionAccessValues(Permission[] inPermissions) throws RaplixException {
        int i;
        int basicPermsLength = this.mBasicPermissionNames.length;
        this.mBasicPermissionReads = new boolean[basicPermsLength];
        this.mBasicPermissionWrites = new boolean[basicPermsLength];
        int runPermsLength = this.mRunPermissionNames.length;
        this.mRunPermissionReads = new boolean[runPermsLength];
        this.mRunPermissionWrites = new boolean[runPermsLength];
        this.mRunPermissionsRunValues = new String[runPermsLength];
        this.mRunPermissionRuns = new boolean[runPermsLength];
        HashSet<PermissionID> hashset = new HashSet<PermissionID>();
        String diffPermissionClassName = DifferencePermission.class.getName();
        Vector<Permission> diffPermissions = new Vector<Permission>();
        for (i = 0; i < inPermissions.length; ++i) {
            hashset.add(inPermissions[i].getPermissionID());
            if (!inPermissions[i].getClassName().equals(diffPermissionClassName)) continue;
            diffPermissions.addElement(inPermissions[i]);
        }
        for (i = 0; i < this.mBasicPermissionReadIDs.length; ++i) {
            this.mBasicPermissionReads[i] = hashset.contains(this.mBasicPermissionReadIDs[i]);
            this.mBasicPermissionWrites[i] = hashset.contains(this.mBasicPermissionWriteIDs[i]);
        }
        for (i = 0; i < this.mRunPermissionReadIDs.length; ++i) {
            this.mRunPermissionReads[i] = hashset.contains(this.mRunPermissionReadIDs[i]);
            this.mRunPermissionWrites[i] = hashset.contains(this.mRunPermissionWriteIDs[i]);
        }
        Permission[] arrDiffPermissions = diffPermissions.toArray(new Permission[0]);
        this.mRunPermissionsRunValues[0] = this.getHostSetNamesFromPermissions(arrDiffPermissions);
        this.mRunPermissionRuns[0] = arrDiffPermissions.length != 0;
    }

    void resetEventFlags() {
        this.mUpdateGroups = false;
        this.mTmpPasswordError = 0;
        this.mTmpPasswordSet = false;
    }

    private String getHostSetNamesFromPermissions(Permission[] inPermissions) throws RaplixException {
        if (inPermissions.length == 0) {
            return "-";
        }
        StringBuffer sBuffer = new StringBuffer("");
        for (int i = 0; i < inPermissions.length; ++i) {
            if (this.isUniversalDiffPermission(inPermissions[i].getPermissionID())) {
                return "universal set";
            }
            String permName = inPermissions[i].getName();
            String hostSetID = permName.substring("hostset:".length());
            HostSetID id = new HostSetID(hostSetID);
            String hostSetName = HostSetsBean.getSummaryHostSetByID(id).getName();
            if (i != 0) {
                sBuffer.append(", ");
            }
            sBuffer.append(hostSetName);
        }
        return sBuffer.toString();
    }

    private boolean isUniversalDiffPermission(PermissionID permID) {
        return this.mAllHostsRunDiffPermissionID.equals(permID);
    }

    void loadGroupNames(String[] groupIDs) throws RaplixException {
        this.mMemGroupNames = new String[groupIDs.length];
        for (int i = 0; i < groupIDs.length; ++i) {
            Group tmpGroup = this.mGroupMgr.getGroup(new GroupID(groupIDs[i]));
            this.mMemGroupNames[i] = tmpGroup.getName();
        }
    }

    public void loadGroupNamesAndIDs(String[] inGroupNames, String[] inGroupIDs) {
        this.mMemGroupIDs = inGroupIDs;
        this.mMemGroupNames = inGroupNames;
    }

    public void loadLoginConfigurations() throws RaplixException {
        int hSize = LoginConfigurationBean.getLoginConfigurations().length;
        this.mConfigurationNames = new String[hSize];
        this.mConfigurationValues = new String[hSize];
        this.mConfigurationIsInternals = new boolean[hSize];
        for (int k = 0; k < hSize; ++k) {
            this.mConfigurationValues[k] = LoginConfigurationBean.getLoginConfigurations()[k];
            this.mConfigurationIsInternals[k] = LoginConfigurationBean.isLoginConfigurationInternal(this.mConfigurationValues[k]);
            this.mConfigurationNames[k] = this.mConfigurationIsInternals[k] ? INTERNAL_LOGIN_PREFIX + this.mConfigurationValues[k] : this.mConfigurationValues[k];
        }
    }

    public void activateUsers(String[] ids) throws RaplixException {
        for (int i = 0; i < ids.length; ++i) {
            User user = this.mUserMgr.getUser(new UserID(ids[i]));
            user.setActive(true);
            user.save(false);
        }
    }

    public void deactivateUsers(String[] ids) throws RaplixException {
        for (int i = 0; i < ids.length; ++i) {
            User user = this.mUserMgr.getUser(new UserID(ids[i]));
            user.setActive(false);
            user.save(false);
        }
    }

    private void loadPermissionLookaheads() {
        this.mUserHasAdminWrite = PermissionChecker.hasWriteOnUsers();
    }

    public void setName(String inName) {
        this.mTmpName = inName;
    }

    public void setUsername(String inName) {
        this.setName(inName);
    }

    public void setUserID(String inID) {
        this.mTmpID = inID;
    }

    public void setShowHidden(boolean showHidden) {
        this.mShowHidden = showHidden;
    }

    public void setIsHidden(boolean isHidden) {
        this.mIsHidden = isHidden;
    }

    public void setIsActive(boolean isActive) {
        this.mIsActive = isActive;
    }

    public void setIsError(boolean isError) {
        this.mIsError = isError;
    }

    public void setConfiguration(String configuration) {
        this.mConfiguration = configuration;
    }

    public void setSaveOverride(boolean saveOverride) {
        this.mSaveOverride = saveOverride;
    }

    public void setIsAdmin(boolean isAdmin) {
        this.mIsAdmin = isAdmin;
    }

    public void setConfigurationIsInternal(boolean configurationIsInternal) {
        this.mConfigurationIsInternal = configurationIsInternal;
    }

    public int setPassword(String passwd1, String passwd2) {
        this.mTmpPasswordError = 0;
        if (!passwd1.equals("") && passwd1.equals(passwd2)) {
            this.mTmpPassword = passwd1;
            this.mTmpPasswordSet = true;
            this.mTmpPasswordError = 0;
        } else if (!passwd1.equals(passwd2)) {
            this.mTmpPasswordSet = false;
            this.mTmpPasswordError = 2;
        } else if (passwd1.equals("")) {
            this.mTmpPasswordSet = false;
            if (this.getIsNew()) {
                this.mTmpPasswordError = 1;
            }
        }
        return this.mTmpPasswordError;
    }

    public void setNoPassword() {
        this.mTmpPasswordSet = true;
        this.mTmpPassword = null;
        this.mTmpPasswordError = 0;
    }

    public void setMode(String inMode) {
        this.mMode = inMode;
    }

    public void setIsNew(boolean isNew) {
        this.mIsNew = isNew;
    }

    public void setGroupIDs(String[] inGroups) {
        this.mMemGroupIDs = inGroups;
    }

    public UserManager getUserManager() {
        return this.mUserMgr;
    }

    public GroupManager getGroupManager() {
        return this.mGroupMgr;
    }

    public PermissionManager getPermissionsManager() {
        return this.mPermMgr;
    }

    public boolean getPasswordSet() {
        return this.mTmpPasswordSet;
    }

    public int getPasswordError() {
        return this.mTmpPasswordError;
    }

    public boolean getUpdateGroups() {
        return this.mUpdateGroups;
    }

    public void setUpdateGroups(boolean inUpdateGroups) {
        this.mUpdateGroups = inUpdateGroups;
    }

    public String[] getUserIDs() {
        return this.mUserIDs;
    }

    public String getUserName() {
        return this.mTmpName;
    }

    public String getName() {
        return this.mTmpName;
    }

    public String getUserID() {
        return this.mTmpID;
    }

    public String[] getUserNames() {
        return this.mUserNames;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public String[] getNothing() {
        return new String[0];
    }

    public String[] getGroupIDs() {
        return this.mMemGroupIDs;
    }

    public String[] getGroupNames() {
        return this.mMemGroupNames;
    }

    public String[] getOtherGroupNames() {
        return this.mOtherMemGrpNames;
    }

    public String[] getOtherGroupIDs() {
        return this.mOtherMemGrpIDs;
    }

    public String[] getPermissions() {
        return this.mPermissions;
    }

    public String getPermissionsAsString() {
        return this.mPermissionsString;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public boolean getShowHidden() {
        return this.mShowHidden;
    }

    public String getMode() {
        return this.mMode;
    }

    public String[] getBasicPermissionNames() {
        return this.mBasicPermissionNames;
    }

    public boolean[] getBasicPermissionReads() {
        return this.mBasicPermissionReads;
    }

    public boolean[] getBasicPermissionWrites() {
        return this.mBasicPermissionWrites;
    }

    public boolean getUserHasAdminWrite() {
        return this.mUserHasAdminWrite;
    }

    public String[] getRunPermissionNames() {
        return this.mRunPermissionNames;
    }

    public boolean[] getRunPermissionReads() {
        return this.mRunPermissionReads;
    }

    public boolean[] getRunPermissionWrites() {
        return this.mRunPermissionWrites;
    }

    public boolean[] getRunPermissionRuns() {
        return this.mRunPermissionRuns;
    }

    public String[] getRunPermissionsRunValues() {
        return this.mRunPermissionsRunValues;
    }

    public String[] getConfigurationNames() {
        return this.mConfigurationNames;
    }

    public boolean[] getConfigurationIsInternals() {
        return this.mConfigurationIsInternals;
    }

    public String getConfiguration() {
        return this.mConfiguration;
    }

    public boolean getSaveOverride() {
        return this.mSaveOverride;
    }

    public String[] getConfigurationValues() {
        return this.mConfigurationValues;
    }

    public boolean getIsAdmin() {
        return this.mIsAdmin;
    }

    public boolean getConfigurationIsInternal() {
        return this.mConfigurationIsInternal;
    }

    public boolean getIsHidden() {
        return this.mIsHidden;
    }

    public boolean[] getIsHiddens() {
        return this.mIsHiddens;
    }

    public boolean getIsActive() {
        return this.mIsActive;
    }

    public boolean[] getIsActives() {
        return this.mIsActives;
    }

    public boolean getIsError() {
        return this.mIsError;
    }

    public boolean[] getIsErrors() {
        return this.mIsErrors;
    }
}

