/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.Preference;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletPreferenceBroker;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.UsersBean;
import java.security.AccessControlException;
import javax.servlet.http.HttpServletRequest;

public final class UsersAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR = "error.users.list";
    public static final String MSG_ERROR_ACTIVATE = "error.users.activate.major";
    public static final String MSG_ERROR_DEACTIVATE = "error.users.deactivate.major";
    public static final String MSG_ERROR_NOSELECTION = "error.users.noselection";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null || mode.equals("")) {
            mode = "list";
        }
        if (mode.equals("activate")) {
            this.handleActivate(request, servletInfo);
        } else if (mode.equals("deactivate")) {
            this.handleDeactivate(request, servletInfo);
        } else {
            this.handleList(request, servletInfo);
        }
    }

    private void handleList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UsersBean ub = (UsersBean)servletInfo.getBean();
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        ub.setShowHidden(spb.trackBoolean(Preference.SHOW_HIDDEN_GLOBAL, request));
        ub.loadUsersArray();
        servletInfo.setDestPage("/users.jsp");
        servletInfo.setSaveInSession(false);
    }

    private void handleActivate(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UsersBean ub = (UsersBean)servletInfo.getBean();
        MultiCheckbox in = new MultiCheckbox("bulk", request);
        String[] ids = in.getSelected();
        if (ids.length == 0) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_ACTIVATE);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NOSELECTION);
            this.handleList(request, servletInfo);
            return;
        }
        try {
            ub.activateUsers(ids);
        }
        catch (AccessControlException ace) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_ACTIVATE);
            servletInfo.getErrors().addMinorError(this.ACExToString(ace));
        }
        servletInfo.setSaveInSession(false);
        this.handleList(request, servletInfo);
    }

    private void handleDeactivate(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UsersBean ub = (UsersBean)servletInfo.getBean();
        MultiCheckbox in = new MultiCheckbox("bulk", request);
        String[] ids = in.getSelected();
        if (ids.length == 0) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_DEACTIVATE);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NOSELECTION);
            this.handleList(request, servletInfo);
            return;
        }
        try {
            ub.deactivateUsers(ids);
        }
        catch (UserDBException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_DEACTIVATE);
            servletInfo.getErrors().addMinorError(e.getMessage());
            servletInfo.setSaveInSession(false);
            this.handleList(request, servletInfo);
            return;
        }
        catch (AccessControlException ace) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_DEACTIVATE);
            servletInfo.getErrors().addMinorError(this.ACExToString(ace));
        }
        servletInfo.setSaveInSession(false);
        this.handleList(request, servletInfo);
    }

    public ServletBean createBean(HttpServletRequest request) {
        UserManager userMgr = UsersAction.getApplication().getUserManager();
        GroupManager uGroupMgr = UsersAction.getApplication().getUserGroupManager();
        PermissionManager uPermMgr = UsersAction.getApplication().getUserPermissionManager();
        SessionManager uSessionMgr = UsersAction.getApplication().getUserSessionManager();
        UsersBean ub = new UsersBean(userMgr, uGroupMgr, uPermMgr, uSessionMgr);
        return ub;
    }

    public String getDefaultPage() {
        return "/users.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        return MSG_ERROR;
    }
}

