/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotFoundQueryException;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.MultiGroupQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.UserGroupsBean;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;
import javax.servlet.http.HttpServletRequest;

public class UserGroupsHandleAction
extends UIActionServlet
implements ActionModeConstants {
    private static final String MSG_ERROR_CREATE = "error.users.create";
    private static final String MSG_ERROR_EDIT = "error.users.edit";
    private static final String MSG_ERROR_CANCEL = "error.users.cancel";
    private static final String MSG_ERROR_SAVE_MAJOR = "error.userGroups.save.major";
    private static final String MSG_ERROR_REMOVE_MEMBER = "error.userGroups.removeMember";
    private static final String MSG_ERROR_ADD_MEMBER = "error.userGroups.addMember";
    private static final String MSG_ERROR_CHANGE_MEMBER = "error.userGroups.changeMember";
    private static final String MSG_ERROR_SAVE_DELETED_OBJECT = "error.userGroups.save.deletedObject";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = UserGroupsHandleAction.assertGetParam(request, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through UserGroupsHandleAction::doUIAction = " + mode, this);
        }
        if (mode.equals("highlight")) {
            this.handleHighlight(request, servletInfo);
        } else if (mode.equals("add")) {
            this.handleAdd(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("addmember")) {
            this.handleAddMember(request, servletInfo);
        } else if (mode.equals("removemember")) {
            this.handleRemoveMember(request, servletInfo);
        } else if (mode.equals("changemember")) {
            this.handleChangeMember(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("saveas")) {
            this.handleSaveAs(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else if (mode.equals("saveconfirmed")) {
            this.handleSaveAsConfirmed(request, servletInfo);
        } else if (mode.equals("notconfirmed")) {
            this.handleNotConfirmed(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to UserGroupsHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        UserGroupsBean ugb;
        String mode = UserGroupsHandleAction.assertGetParam(request, "mode");
        if (mode.equals("add") || mode.equals("edit") || mode.equals("delete")) {
            UserManager userMgr = UserGroupsHandleAction.getApplication().getUserManager();
            GroupManager uGroupMgr = UserGroupsHandleAction.getApplication().getUserGroupManager();
            PermissionManager uPermMgr = UserGroupsHandleAction.getApplication().getUserPermissionManager();
            ugb = new UserGroupsBean(userMgr, uGroupMgr, uPermMgr);
        } else {
            String id = request.getParameter("id");
            ugb = (UserGroupsBean)request.getSession().getAttribute(id);
            if (ugb == null) {
                throw new IllegalArgumentException("Expected Bean not found.");
            }
        }
        return ugb;
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = UserGroupsHandleAction.assertGetParam(inRequest, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Error mode is: " + mode, this);
        }
        if (mode.equals("highlight")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("add")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("addmember")) {
            return MSG_ERROR_ADD_MEMBER;
        }
        if (mode.equals("removemember")) {
            return MSG_ERROR_REMOVE_MEMBER;
        }
        if (mode.equals("changemember")) {
            return MSG_ERROR_CHANGE_MEMBER;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("saveas")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("saveconfirmed")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("notconfirmed")) {
            return MSG_ERROR_CANCEL;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to UserGroupsHandleAction.");
    }

    public String getDefaultPage() {
        return "/userGroupDetails.jsp";
    }

    protected void handleSaveAsConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UserGroupsBean bean = (UserGroupsBean)servletInfo.getBean();
        bean.setName(request.getParameter("name"));
        try {
            bean.persistCopy();
        }
        catch (UserDBException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(e.getMessage());
            bean.setMode("saveas");
            servletInfo.setDestPage("/userGroupConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(this.getMajorError(request));
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            bean.setMode("saveas");
            servletInfo.setDestPage("/userGroupConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/UserGroups");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UserGroupsBean bean = (UserGroupsBean)servletInfo.getBean();
        this.persistNameAndDescriptionAndPermissions(request, bean);
        String saveOverride = request.getParameter("saveOverride");
        boolean isSaveOverride = false;
        if (saveOverride != null) {
            bean.setSaveOverride(false);
            isSaveOverride = true;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("save override: " + isSaveOverride, this);
        }
        try {
            if (!isSaveOverride) {
                bean.persist();
            } else {
                bean.persistCopy();
            }
        }
        catch (UserDBException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            Throwable nested = e.nestedException();
            if (nested != null && nested instanceof ObjectNotFoundQueryException && !isSaveOverride) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("nested: true", this);
                }
                servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_SAVE_DELETED_OBJECT);
                bean.setSaveOverride(true);
            } else {
                servletInfo.getErrors().addMinorError(e.getMessage());
            }
            bean.setMode("edit");
            servletInfo.setDestPage("/userGroupDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(this.getMajorError(request));
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            bean.setMode("edit");
            servletInfo.setDestPage("/userGroupDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/UserGroups");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleChangeMember(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UserGroupsBean bean = (UserGroupsBean)servletInfo.getBean();
        this.persistNameAndDescriptionAndPermissions(request, bean);
        String removeIdxStr = bean.getChangeIndex();
        int removeIdx = Integer.parseInt(removeIdxStr);
        bean.removeMember(removeIdx);
        bean.setEditIndex("-1");
        String memberType = UserGroupsHandleAction.assertGetParam(request, "changeMemberType");
        String newMember = null;
        if (memberType.equals("User")) {
            newMember = UserGroupsHandleAction.assertGetParam(request, "changeUserValue");
        } else if (memberType.equals("User Group")) {
            newMember = UserGroupsHandleAction.assertGetParam(request, "changeGroupValue");
        }
        bean.clearHighlighted();
        bean.saveChangedMember(memberType, newMember);
        servletInfo.setDestPage("/userGroupDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleSaveAs(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UserGroupsBean bean = (UserGroupsBean)servletInfo.getBean();
        bean.setMode("saveas");
        String oldName = bean.getName();
        this.persistNameAndDescriptionAndPermissions(request, bean);
        bean.loadPermissionsString();
        bean.setNewNameFlag(oldName, bean.getName());
        servletInfo.setDestPage("/userGroupConfirm.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleRemoveMember(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UserGroupsBean bean = (UserGroupsBean)servletInfo.getBean();
        this.persistNameAndDescriptionAndPermissions(request, bean);
        String removeIdxStr = UserGroupsHandleAction.assertGetParam(request, "editIndex");
        int removeIdx = Integer.parseInt(removeIdxStr);
        bean.clearHighlighted();
        bean.removeMember(removeIdx);
        servletInfo.setDestPage("/userGroupDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleHighlight(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UserGroupsBean bean = (UserGroupsBean)servletInfo.getBean();
        this.persistNameAndDescriptionAndPermissions(request, bean);
        String changeIdxStr = UserGroupsHandleAction.assertGetParam(request, "editIndex");
        int changeIdx = Integer.parseInt(changeIdxStr);
        bean.loadHighlightedMemberUsers(changeIdx);
        servletInfo.setDestPage("/userGroupDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleAddMember(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UserGroupsBean bean = (UserGroupsBean)servletInfo.getBean();
        String memberType = UserGroupsHandleAction.assertGetParam(request, "newMemberType");
        String newMember = null;
        bean.clearHighlighted();
        if (memberType.equals("User")) {
            newMember = UserGroupsHandleAction.assertGetParam(request, "newUserValue");
        } else if (memberType.equals("User Group")) {
            newMember = UserGroupsHandleAction.assertGetParam(request, "newGroupValue");
        }
        bean.saveAddedMember(memberType, newMember);
        this.persistNameAndDescriptionAndPermissions(request, bean);
        servletInfo.setDestPage("/userGroupDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleCancel(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.setDestPage("/UserGroups");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleNotConfirmed(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.setDestPage("/userGroupDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleAdd(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UserGroupsBean bean = (UserGroupsBean)servletInfo.getBean();
        this.loadUserGroups(bean);
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        bean.createUserGroup(name, description);
        bean.setMode("add");
        bean.setIsNew(true);
        servletInfo.setDestPage("/userGroupDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        UserGroupsBean bean = (UserGroupsBean)servletInfo.getBean();
        this.loadUserGroups(bean);
        String id = request.getParameter("id");
        bean.loadSingleUserGroup(id);
        bean.setMode("edit");
        servletInfo.setDestPage("/userGroupDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void loadUserGroups(UserGroupsBean inBean) throws RaplixException {
        MultiGroupQuery mgq = MultiGroupQuery.all();
        Group[] allGroups = mgq.select();
        inBean.loadUserGroupsArray(allGroups);
        inBean.loadBasicPermissionNamesAndIDs();
        inBean.loadRunPermissionNamesAndIDs();
    }

    protected void persistChangedMembers(HttpServletRequest request, UserGroupsBean bean) {
        int changeIndex = -1;
        try {
            changeIndex = Integer.parseInt(request.getParameter("editIndex"));
        }
        catch (NumberFormatException e) {
            changeIndex = -1;
        }
        if (changeIndex != -1) {
            String cMType = request.getParameter("changeMemberType");
            String cMUserVal = request.getParameter("changeUserValue");
            String cMUserGroupVal = request.getParameter("changeGroupValue");
            bean.setChangedMembers(cMType, cMUserVal, cMUserGroupVal);
        }
    }

    protected void persistNewMembers(HttpServletRequest request, UserGroupsBean bean) {
        String cMType = request.getParameter("newMemberType");
        String cMUserVal = request.getParameter("newUserValue");
        String cMUserGroupVal = request.getParameter("newGroupValue");
        bean.setNewMembers(cMType, cMUserVal, cMUserGroupVal);
    }

    protected void persistNameAndDescriptionAndPermissions(HttpServletRequest request, UserGroupsBean bean) throws RaplixException {
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        int basicPermsLength = bean.getBasicPermissionNames().length;
        boolean[] basicPermissionReads = this.grantedPermissions(request, "basicPermissionReads", basicPermsLength);
        boolean[] basicPermissionWrites = this.grantedPermissions(request, "basicPermissionWrites", basicPermsLength);
        int runnablePermsLength = bean.getRunnablePermissionNames().length;
        boolean[] runPermissionReads = this.grantedPermissions(request, "runnablePermissionReads", runnablePermsLength);
        boolean[] runPermissionWrites = this.grantedPermissions(request, "runnablePermissionWrites", runnablePermsLength);
        String[] runHostSetIDs = new String[runnablePermsLength];
        String[] selectedHostSetIDs = new String[runnablePermsLength];
        String[] selectedHostSetNames = new String[runnablePermsLength];
        boolean[] cbxStates = new boolean[runnablePermsLength];
        for (int i = 0; i < runnablePermsLength; ++i) {
            String pVal;
            selectedHostSetIDs[i] = pVal = request.getParameter("runnableHostSetPermissionIDs" + i);
            selectedHostSetNames[i] = pVal != null ? bean.getHostSetRunStringFromID(pVal) : null;
            cbxStates[i] = request.getParameter("runnablePermissionRuns" + i) != null;
            String string = runHostSetIDs[i] = cbxStates[i] ? pVal : null;
            if (!Logger.isDebugEnabled(this)) continue;
            Logger.debug("pVal name:" + runHostSetIDs[i], this);
        }
        bean.setName(name);
        bean.setDescription(description);
        bean.setBasicPermissionReads(basicPermissionReads);
        bean.setBasicPermissionWrites(basicPermissionWrites);
        bean.setRunnablePermissionReads(runPermissionReads);
        bean.setRunnablePermissionWrites(runPermissionWrites);
        bean.setRunPermissionRuns(runHostSetIDs);
        bean.setRunnablePermissionHostSetIDs(selectedHostSetIDs);
        bean.setRunnablePermissionHostSetNames(selectedHostSetNames);
        bean.setRunnablePermissionRuns(cbxStates);
    }

    private boolean[] grantedPermissions(HttpServletRequest request, String inParam, int numPermissions) {
        boolean[] grantedPermissions = new boolean[numPermissions];
        for (int i = 0; i < numPermissions; ++i) {
            String pVal = request.getParameter(inParam + i);
            grantedPermissions[i] = pVal != null && (pVal.equals("true") || pVal.equals("on") || pVal.equals("checked"));
        }
        return grantedPermissions;
    }
}

