/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidateStatus;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.ui.web.DeleteConfirmNode;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.string.StringUtil;

public class UserGroupsDeleteNode
extends UITreeNode {
    private static final int DELETE_CONFIRM_COLSPAN = 2;
    private GroupID mGroupID = null;
    private String mName = "";
    private String mDescription = "";
    private boolean mIsUndeletable = false;
    private int mRowLevel = 0;
    private String mPrologue = "";
    private String mContents = "";

    public UserGroupsDeleteNode(DeleteSessionCandidate candidate, GroupManager groupManager) throws RaplixException {
        this.mType = UITreeNodeType.LEAF;
        DeleteSessionCandidateStatus status = candidate.getStatus();
        this.mIsUndeletable = status.equals(DeleteSessionCandidateStatus.IN_USE) || status.equals(DeleteSessionCandidateStatus.NOT_DELETABLE);
        GroupID groupID = (GroupID)candidate.getParent().getObjectID();
        Group group = groupManager.getGroup(groupID);
        this.mGroupID = groupID;
        this.mName = group.getName();
        this.mDescription = StringUtil.normalizeEmpty(group.getDescription());
        this.preRender();
    }

    public void getDescendents(DeleteSessionCandidate candidate) {
        if (this.mIsUndeletable) {
            PersistenceManagerException pme = (PersistenceManagerException)candidate.getException();
            String errMsg = pme.getMessage();
            DeleteConfirmNode confirmNode = new DeleteConfirmNode(errMsg, 2, 2);
            this.addChild(confirmNode);
            if (pme instanceof ObjectInUseException) {
                UsingObject[] blockers = ((ObjectInUseException)pme).getUsingObjects();
                for (int j = 0; j < blockers.length; ++j) {
                    DeleteConfirmNode blockerNode = new DeleteConfirmNode(blockers[j], 2, 2);
                    confirmNode.addChild(blockerNode);
                }
            }
        }
    }

    public void preRender() {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String editURI = UriUtil.groupEditURI(this.mGroupID.toString());
        String toolTip = "Show user group details";
        String nameLink = Util.standardLink(editURI, toolTip, this.mName, "name=\"nameLink-" + this.mGroupID + "\"");
        String descLink = Util.standardLink(editURI, toolTip, Util.escapeHTML(this.mDescription));
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(descLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }

    public void addChild(UITreeNode node) {
        this.mChildren.add(node);
        node.setTree(this.mTree);
        this.mType = UITreeNodeType.BRANCH_CLOSED;
    }

    public String finishRender(StringBuffer sb, String path) {
        String rowspanStr = "rowspan=\"" + this.getVisibleChildCount() + "\"";
        this.mPrologue = "<tr>\n" + Util.introStandardCell(rowspanStr, this.mRowLevel) + Util.standardCellStart(0, "nowrap", this.mRowLevel);
        return this.mPrologue + sb + this.mContents;
    }

    public void finishOpen() {
    }

    public void finishClose() {
    }

    protected String getJavascriptFunction() {
        return "sendTree";
    }
}

