/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.DifferencePermission;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupOrder;
import com.raplix.rolloutexpress.systemmodel.userdb.MultiGroupQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsListBean;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.struts.util.MessageResources;

public class UserGroupsBean
extends ServletListBean {
    private static final GroupOrder DEFAULT_SORT_ORDER = GroupOrder.BY_NAME_ASC;
    public static final String TYPE_GROUP = "User Group";
    public static final String TYPE_USER = "User";
    public static final String UNIVERSAL_SET = "universal_set";
    private static final String SYSTEM_GROUP = "system";
    private Group mGroup = null;
    private String[] mGroupIDs = new String[0];
    private String[] mGroupNames = new String[0];
    private String[] mGroupDescriptions = new String[0];
    private boolean[] mIsSystemGroups = new boolean[0];
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private Vector mMemberTypes = new Vector();
    private Vector mMemberValues = new Vector();
    private Vector mMemberIDs = new Vector();
    private String mNewMemberType = "User";
    private String mNewMemberUserName = "";
    private String mNewMemberUserGroupID = "";
    private int mEditIndex = -1;
    private String mChangeMemberType = "User";
    private String mChangeMemberUserID = "";
    private String mChangeMemberUserGroupID = "";
    private String[] mCurrentUserNames = new String[0];
    private String[] mCurrentlyHighlightedUsers = new String[0];
    private HashSet mCurrentUsersSet = new HashSet();
    private String mPermissionsString = "";
    private Permission[] mPermissions = new Permission[0];
    private String[] mBasicPermissionNames = new String[0];
    private boolean[] mBasicPermissionReads = new boolean[0];
    private boolean[] mBasicPermissionWrites = new boolean[0];
    private PermissionID[] mBasicPermissionReadIDs = new PermissionID[0];
    private PermissionID[] mBasicPermissionWriteIDs = new PermissionID[0];
    private boolean mUserHasAdminWrite = true;
    private PermissionID mHostReadPermissionID = null;
    private PermissionID mHostWritePermissionID = null;
    private String[] mRunnablePermissionNames = new String[0];
    private boolean[] mRunnablePermissionReads = new boolean[0];
    private boolean[] mRunnablePermissionWrites = new boolean[0];
    private boolean[] mRunnablePermissionRuns = new boolean[0];
    private PermissionID[] mRunnablePermissionReadIDs = new PermissionID[0];
    private PermissionID[] mRunnablePermissionWriteIDs = new PermissionID[0];
    private String[] mRunSelectedHostSets = new String[0];
    private String[] mRunPermissionClassNames = new String[0];
    private PermissionID[] mUniversalPermissionIDs = new PermissionID[0];
    private String[] mAllHostSetNames = new String[0];
    private String[] mAllHostSetIDs = new String[0];
    private String[] mRunnablePermissionHostSetIDs = new String[0];
    private String[] mRunnablePermissionHostSetNames = new String[0];
    private String mMode = "";
    private boolean mIsNew = false;
    private boolean mIsNewGroupName = false;
    private String[] mUserNames = new String[0];
    private String[] mUserIDs = new String[0];
    private User[] mChildUsers = new User[0];
    private Group[] mChildGroups = new Group[0];
    private boolean mSaveOverride = false;
    private String mTmpName = "";
    private String mTmpDesc = "";
    private GroupID mTmpID = null;
    private String mTmpType = "";
    private UserManager mUserMgr = null;
    private GroupManager mGroupMgr = null;
    private PermissionManager mPermMgr = null;
    private MessageResources mMessages = null;
    private static String ERRORKEY_PERMISSION_NOT_FOUND = "htmlui.users.permission.notfound";

    public UserGroupsBean(UserManager userMgr, GroupManager groupMgr, PermissionManager permMgr) {
        this.mUserMgr = userMgr;
        this.mGroupMgr = groupMgr;
        this.mPermMgr = permMgr;
        this.mMessages = ApplicationResources.getMessageResources();
        this.loadPermissionLookaheads();
    }

    public String[] getIDs() {
        return this.mGroupIDs;
    }

    public String[] getGroupIDs() {
        return this.getIDs();
    }

    public String[] getNames() {
        return this.mGroupNames;
    }

    public String[] getGroupNames() {
        return this.getNames();
    }

    public String[] getGroupDescriptions() {
        return this.mGroupDescriptions;
    }

    public boolean[] getIsSystemGroups() {
        return this.mIsSystemGroups;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public void setNewNameFlag(String oldName, String newName) {
        if (oldName.equals(newName)) {
            this.setIsNewGroupName(false);
        } else {
            this.setIsNewGroupName(true);
        }
    }

    public void setIsNewGroupName(boolean in) {
        this.mIsNewGroupName = in;
    }

    public void setEditIndex(String editIndex) {
        this.mEditIndex = Integer.parseInt(editIndex);
    }

    public void setName(String inName) {
        this.mTmpName = inName;
    }

    public void setDescription(String inDescription) {
        this.mTmpDesc = inDescription;
    }

    public void setID() {
        this.mTmpID = GroupID.generateGroupID();
    }

    public void setID(String inID) {
        this.mTmpID = new GroupID(inID);
    }

    public void setNewMemberType(String inNewMemberType) {
        this.mNewMemberType = inNewMemberType;
    }

    public void setMode(String inMode) {
        this.mMode = inMode;
    }

    public void setIsNew(boolean isNew) {
        this.mIsNew = isNew;
    }

    public void setSaveOverride(boolean saveOverride) {
        this.mSaveOverride = saveOverride;
    }

    public void setType(String inType) {
        this.mTmpType = inType;
    }

    public boolean getIsNewGroupName() {
        return this.mIsNewGroupName;
    }

    public boolean getUserHasAdminWrite() {
        return this.mUserHasAdminWrite;
    }

    public UserManager getUserManager() {
        return this.mUserMgr;
    }

    public GroupManager getGroupManager() {
        return this.mGroupMgr;
    }

    public String[] getUserNames() {
        return this.mUserNames;
    }

    public String[] getUserIDs() {
        return this.mUserIDs;
    }

    public PermissionManager getPermissionsManager() {
        return this.mPermMgr;
    }

    public int getNumberUserDefinedGroups() {
        int groupCount = 0;
        int numGroups = this.mGroupIDs.length;
        for (int i = 0; i < numGroups; ++i) {
            if (this.mIsSystemGroups[i]) continue;
            ++groupCount;
        }
        return groupCount;
    }

    public String[] getBasicPermissionNames() {
        return this.mBasicPermissionNames;
    }

    public boolean[] getBasicPermissionReads() {
        return this.mBasicPermissionReads;
    }

    public boolean[] getBasicPermissionWrites() {
        return this.mBasicPermissionWrites;
    }

    public String[] getRunnablePermissionNames() {
        return this.mRunnablePermissionNames;
    }

    public boolean[] getRunnablePermissionReads() {
        return this.mRunnablePermissionReads;
    }

    public boolean[] getRunnablePermissionWrites() {
        return this.mRunnablePermissionWrites;
    }

    public boolean[] getRunnablePermissionRuns() {
        return this.mRunnablePermissionRuns;
    }

    public String[] getRunnablePermissionHostSetIDs() {
        return this.mRunnablePermissionHostSetIDs;
    }

    public String[] getRunnablePermissionHostSetNames() {
        return this.mRunnablePermissionHostSetNames;
    }

    public String getPermissionsAsString() {
        return this.mPermissionsString;
    }

    public String[] getAllHostSetNames() {
        return this.mAllHostSetNames;
    }

    public String[] getAllHostSetIDs() {
        return this.mAllHostSetIDs;
    }

    public String getName() {
        return this.mTmpName;
    }

    public boolean getIsSystemGroup() {
        return SYSTEM_GROUP.equals(this.mTmpType);
    }

    public String getDescription() {
        return this.mTmpDesc;
    }

    public String getID() {
        if (this.mTmpID != null) {
            return this.mTmpID.toString();
        }
        return super.getID();
    }

    public String[] getMemberTypes() {
        return this.mMemberTypes.toArray(new String[0]);
    }

    public String[] getMemberValues() {
        return this.mMemberValues.toArray(new String[0]);
    }

    public String[] getMemberIDs() {
        return this.mMemberIDs.toArray(new String[0]);
    }

    public String[] getCurrentUserNames() {
        return this.mCurrentUserNames;
    }

    public String[] getCurrentlyHighlightedUsers() {
        return this.mCurrentlyHighlightedUsers;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public boolean getSaveOverride() {
        return this.mSaveOverride;
    }

    public String getMode() {
        return this.mMode;
    }

    public String getChangeIndex() {
        return Integer.toString(this.mEditIndex);
    }

    public String getChangeMemberType() {
        return this.mChangeMemberType;
    }

    public String getChangeUserValue() {
        return this.mChangeMemberUserID;
    }

    public String getChangeGroupValue() {
        return this.mChangeMemberUserGroupID;
    }

    public String getNewMemberType() {
        return this.mNewMemberType;
    }

    public String getNewUserValue() {
        return this.mNewMemberUserName;
    }

    public String getNewGroupValue() {
        return this.mNewMemberUserGroupID;
    }

    public void addUserToCurrentMembers(User[] newUserArray) throws UserDBException, RPCException {
        for (int i = 0; i < newUserArray.length; ++i) {
            this.mCurrentUsersSet.add(newUserArray[i].getUsername());
        }
    }

    public void generateCurrentMembers() {
        this.mCurrentUserNames = this.mCurrentUsersSet.toArray(new String[0]);
    }

    public void generateList() throws RaplixException {
        MultiGroupQuery mgq = MultiGroupQuery.all();
        this.prepQuery(mgq, this.getSortOrderByName(this.getSortName()));
        this.generateOutputArrays(mgq.select());
    }

    private void generateOutputArrays(Group[] groups) {
        int numGroup = groups.length;
        this.mGroupNames = new String[numGroup];
        this.mGroupIDs = new String[numGroup];
        this.mGroupDescriptions = new String[numGroup];
        this.mIsSystemGroups = new boolean[numGroup];
        for (int i = 0; i < numGroup; ++i) {
            Group g = groups[i];
            this.mGroupIDs[i] = g.getGroupID().toString();
            this.mGroupNames[i] = g.getName();
            String groupDescription = g.getDescription();
            this.mGroupDescriptions[i] = groupDescription == null ? "" : groupDescription;
            this.mIsSystemGroups[i] = SYSTEM_GROUP.equals(g.getType());
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mGroupIDs);
    }

    public void loadUserGroupsArray(Group[] inGroup) throws UserDBException, RPCException {
        int arrayLen = inGroup.length;
        this.mGroupNames = new String[arrayLen];
        this.mGroupIDs = new String[arrayLen];
        for (int i = 0; i < arrayLen; ++i) {
            this.mGroupIDs[i] = inGroup[i].getGroupID().toString();
            this.mGroupNames[i] = inGroup[i].getName();
        }
        User[] allUsers = this.mUserMgr.getAllUsers();
        arrayLen = allUsers.length;
        this.mUserNames = new String[arrayLen];
        this.mUserIDs = new String[arrayLen];
        for (int j = 0; j < arrayLen; ++j) {
            this.mUserIDs[j] = allUsers[j].getUserID().toString();
            this.mUserNames[j] = allUsers[j].getUsername();
        }
        this.setAcceptInput(true);
    }

    public void loadRunPermissionNamesAndIDs() throws UserDBException, RPCException {
        Vector<PermissionID> runnableReadPermissions = new Vector<PermissionID>();
        Vector<PermissionID> runnableWritePermissions = new Vector<PermissionID>();
        Vector<String> runPermissionNames = new Vector<String>();
        Vector<Boolean> runPermissionReads = new Vector<Boolean>();
        Vector<Boolean> runPermissionRuns = new Vector<Boolean>();
        Vector<Boolean> runPermissionWrites = new Vector<Boolean>();
        Vector<String> runPermissionHostSetIDs = new Vector<String>();
        Vector<String> runPermissionClassNames = new Vector<String>();
        Vector<PermissionID> universalPermissionIDs = new Vector<PermissionID>();
        runnableReadPermissions.addElement(this.mPermMgr.getDiffReadPermissionID());
        runnableWritePermissions.addElement(this.mPermMgr.getDiffWritePermissionID());
        runPermissionNames.addElement(this.mMessages.getMessage("label.usergroups.permissions.comparisons"));
        runPermissionReads.addElement(Boolean.FALSE);
        runPermissionRuns.addElement(Boolean.FALSE);
        runPermissionWrites.addElement(Boolean.FALSE);
        runPermissionHostSetIDs.addElement("");
        runPermissionClassNames.addElement(DifferencePermission.class.getName());
        universalPermissionIDs.addElement(this.mPermMgr.getAllHostsRunDiffPermissionID());
        this.mRunnablePermissionReadIDs = runnableReadPermissions.toArray(new PermissionID[0]);
        this.mRunnablePermissionWriteIDs = runnableWritePermissions.toArray(new PermissionID[0]);
        this.mRunnablePermissionNames = runPermissionNames.toArray(new String[0]);
        this.mRunnablePermissionReads = (boolean[])CollectionUtil.mapClass(runPermissionReads, [Z.class);
        this.mRunnablePermissionRuns = (boolean[])CollectionUtil.mapClass(runPermissionRuns, [Z.class);
        this.mRunnablePermissionWrites = (boolean[])CollectionUtil.mapClass(runPermissionWrites, [Z.class);
        this.mRunnablePermissionHostSetIDs = runPermissionHostSetIDs.toArray(new String[0]);
        this.mRunPermissionClassNames = runPermissionClassNames.toArray(new String[0]);
        this.mUniversalPermissionIDs = universalPermissionIDs.toArray(new PermissionID[0]);
    }

    public void loadHostSetsArray() throws RaplixException {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.mRunnablePermissionHostSetIDs.length; ++i) {
            if (this.mRunnablePermissionHostSetIDs[i].equals(UNIVERSAL_SET)) continue;
            v.add(this.mRunnablePermissionHostSetIDs[i]);
        }
        HostSetsListBean hslb = new HostSetsListBean();
        hslb.loadAllHostSetsPlusExtras(v.toArray(new String[0]));
        int arrayLen = hslb.getNames().length;
        this.mAllHostSetNames = new String[arrayLen + 1];
        this.mAllHostSetIDs = new String[arrayLen + 1];
        this.mAllHostSetNames[0] = "universal set";
        this.mAllHostSetIDs[0] = UNIVERSAL_SET;
        for (int i = 0; i < arrayLen; ++i) {
            this.mAllHostSetNames[i + 1] = hslb.getNames()[i];
            this.mAllHostSetIDs[i + 1] = hslb.getIDs()[i];
        }
        this.setAcceptInput(true);
    }

    public void loadBasicPermissionNamesAndIDs() throws UserDBException, RPCException {
        Vector<PermissionID> basicReadPermissionIDs = new Vector<PermissionID>();
        Vector<PermissionID> basicWritePermissionIDs = new Vector<PermissionID>();
        Vector<String> basicPermissionNames = new Vector<String>();
        Vector<Boolean> basicPermissionReads = new Vector<Boolean>();
        Vector<Boolean> basicPermissionWrites = new Vector<Boolean>();
        this.mHostReadPermissionID = this.mPermMgr.getHostReadPermissionID();
        this.mHostWritePermissionID = this.mPermMgr.getHostWritePermissionID();
        basicReadPermissionIDs.addElement(this.mHostReadPermissionID);
        basicWritePermissionIDs.addElement(this.mHostWritePermissionID);
        basicPermissionNames.addElement(this.mMessages.getMessage("label.usergroups.permissions.hosts"));
        basicPermissionReads.addElement(Boolean.FALSE);
        basicPermissionWrites.addElement(Boolean.FALSE);
        basicReadPermissionIDs.addElement(this.mPermMgr.getRuleReadPermissionID());
        basicWritePermissionIDs.addElement(this.mPermMgr.getRuleWritePermissionID());
        basicPermissionNames.addElement(this.mMessages.getMessage("label.usergroups.permissions.rules"));
        basicPermissionReads.addElement(Boolean.FALSE);
        basicPermissionWrites.addElement(Boolean.FALSE);
        basicReadPermissionIDs.addElement(this.mPermMgr.getUserDBReadPermissionID());
        basicWritePermissionIDs.addElement(this.mPermMgr.getUserDBWritePermissionID());
        basicPermissionNames.addElement(this.mMessages.getMessage("label.usergroups.permissions.userdb"));
        basicPermissionReads.addElement(Boolean.FALSE);
        basicPermissionWrites.addElement(Boolean.FALSE);
        this.mBasicPermissionNames = basicPermissionNames.toArray(new String[0]);
        this.mBasicPermissionReads = (boolean[])CollectionUtil.mapClass(basicPermissionReads, [Z.class);
        this.mBasicPermissionReadIDs = basicReadPermissionIDs.toArray(new PermissionID[0]);
        this.mBasicPermissionWrites = (boolean[])CollectionUtil.mapClass(basicPermissionWrites, [Z.class);
        this.mBasicPermissionWriteIDs = basicWritePermissionIDs.toArray(new PermissionID[0]);
    }

    public void loadPermissionAccessValues(GroupID inUserGroupID) throws RaplixException {
        int basicPermsLength = this.mBasicPermissionNames.length;
        this.mBasicPermissionReads = new boolean[basicPermsLength];
        this.mBasicPermissionWrites = new boolean[basicPermsLength];
        int runnablePermsLength = this.mRunnablePermissionNames.length;
        this.mRunnablePermissionReads = new boolean[runnablePermsLength];
        this.mRunnablePermissionWrites = new boolean[runnablePermsLength];
        Permission[] tGroupPermissions = this.mGroupMgr.getGrantedPermissions(inUserGroupID);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("loadBasicPermissionAccessValues:loaded " + tGroupPermissions.length + " permissions", this);
        }
        String diffPermissionClassName = DifferencePermission.class.getName();
        HashSet<PermissionID> hashset = new HashSet<PermissionID>();
        Permission diffPermission = null;
        for (int i = 0; i < tGroupPermissions.length; ++i) {
            hashset.add(tGroupPermissions[i].getPermissionID());
            if (!tGroupPermissions[i].getClassName().equals(diffPermissionClassName)) continue;
            diffPermission = tGroupPermissions[i];
        }
        this.mRunnablePermissionRuns = new boolean[runnablePermsLength];
        this.mRunnablePermissionHostSetIDs = new String[runnablePermsLength];
        this.mRunnablePermissionHostSetNames = new String[runnablePermsLength];
        this.mRunnablePermissionHostSetIDs[0] = this.getHostSetIDFromPermission(diffPermission);
        this.mRunnablePermissionHostSetNames[0] = this.getHostSetRunStringFromID(this.mRunnablePermissionHostSetIDs[0]);
        this.setRunPermissionRuns(this.mRunnablePermissionHostSetIDs);
        this.loadHostSetsArray();
        this.mRunnablePermissionRuns[0] = diffPermission != null;
        this.populatePermissionGrantedArray(hashset, this.mBasicPermissionReadIDs, this.mBasicPermissionReads);
        this.populatePermissionGrantedArray(hashset, this.mBasicPermissionWriteIDs, this.mBasicPermissionWrites);
        this.populatePermissionGrantedArray(hashset, this.mRunnablePermissionReadIDs, this.mRunnablePermissionReads);
        this.populatePermissionGrantedArray(hashset, this.mRunnablePermissionWriteIDs, this.mRunnablePermissionWrites);
    }

    private void populatePermissionGrantedArray(HashSet inGrantedPermissionsSet, PermissionID[] inPermissionIDs, boolean[] inPermissionsGranted) {
        for (int i = 0; i < inPermissionIDs.length; ++i) {
            inPermissionsGranted[i] = inGrantedPermissionsSet.contains(inPermissionIDs[i]);
        }
    }

    private String getHostSetIDFromPermission(Permission perm) {
        if (perm == null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("getHostSetIDFromPermission: permission is null", this);
            }
            return UNIVERSAL_SET;
        }
        if (this.isUniversalDiffPermission(perm.getPermissionID())) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("getHostSetIDFromPermission: permission is universal permission", this);
            }
            return UNIVERSAL_SET;
        }
        String permName = perm.getName();
        String hostSetID = permName.substring("hostset:".length());
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("getHostSetIDFromPermission:perm:" + permName + ", hostSetID:" + hostSetID, this);
        }
        return hostSetID;
    }

    private boolean isUniversalDiffPermission(PermissionID permID) {
        return this.mPermMgr.getAllHostsRunDiffPermissionID().equals(permID);
    }

    public void createUserGroup(String name, String description) throws RaplixException {
        this.mGroup = this.mGroupMgr.newGroup();
        this.setName(name);
        this.setDescription(description);
        this.setID();
        this.loadPermissionAccessValues(this.mTmpID);
    }

    public void initializeCurrentMemberSet() {
        this.mCurrentUsersSet = new HashSet();
    }

    public void loadSingleUserGroup(String inUserGroupID) throws RaplixException {
        GroupID inGroupID = new GroupID(inUserGroupID);
        this.mGroup = this.mGroupMgr.getGroup(inGroupID);
        this.setIsNew(false);
        this.setAcceptInput(true);
        this.setIsNewGroupName(false);
        Group[] subUserGroups = this.mGroup.getChildGroups();
        User[] subUsers = this.mGroup.getUsers();
        this.mMemberTypes = new Vector();
        this.mMemberValues = new Vector();
        this.mMemberIDs = new Vector();
        for (int i = 0; i < subUserGroups.length; ++i) {
            this.mMemberTypes.add(TYPE_GROUP);
            this.mMemberIDs.add(subUserGroups[i].getGroupID().toString());
            this.mMemberValues.add(subUserGroups[i].getName());
        }
        for (int j = 0; j < subUsers.length; ++j) {
            this.mMemberTypes.add(TYPE_USER);
            this.mMemberValues.add(subUsers[j].getUsername());
            this.mMemberIDs.add(subUsers[j].getUserID().toString());
        }
        this.setName(this.mGroup.getName());
        this.setDescription(this.mGroup.getDescription());
        this.setID(this.mGroup.getGroupID().toString());
        this.setType(this.mGroup.getType());
        User[] memberUsers = this.mGroupMgr.getGroupMembers(inGroupID);
        this.loadFirstMemberUsers(memberUsers);
        this.loadPermissionAccessValues(inGroupID);
    }

    public void loadFirstMemberUsers(User[] inUsers) throws UserDBException, RPCException {
        this.mCurrentUserNames = new String[inUsers.length];
        String uname = "";
        for (int k = 0; k < inUsers.length; ++k) {
            uname = inUsers[k].getUsername();
            this.mCurrentUsersSet.add(uname);
            this.mCurrentUserNames[k] = uname;
        }
        this.mCurrentlyHighlightedUsers = new String[0];
    }

    private void loadMemberUsers() throws UserDBException, RPCException {
        Hashtable<UserID, User> hMemberUsers = new Hashtable<UserID, User>();
        int tmpMemberLen = this.mMemberIDs.size();
        for (int i = 0; i < tmpMemberLen; ++i) {
            String id = (String)this.mMemberIDs.elementAt(i);
            String type = (String)this.mMemberTypes.elementAt(i);
            if (type.equals(TYPE_GROUP)) {
                GroupID tGroupID = new GroupID(id);
                User[] tmpUsers = this.mGroupMgr.getGroupMembers(tGroupID);
                for (int j = 0; j < tmpUsers.length; ++j) {
                    hMemberUsers.put(tmpUsers[j].getUserID(), tmpUsers[j]);
                }
                continue;
            }
            UserID tUserID = new UserID(id);
            if (hMemberUsers.containsKey(tUserID)) continue;
            User tUser = this.mUserMgr.getUser(tUserID);
            hMemberUsers.put(tUserID, tUser);
        }
        Collection cUsers = hMemberUsers.values();
        User[] tmpUsers = cUsers.toArray(new User[0]);
        this.initializeCurrentMemberSet();
        this.loadFirstMemberUsers(tmpUsers);
    }

    public void saveAddedMember(String newMemberType, String newMemberValue) throws RaplixException {
        if (!this.mMemberIDs.contains(newMemberValue)) {
            this.mMemberTypes.add(newMemberType);
            this.mMemberIDs.add(newMemberValue);
            if (newMemberType.equals(TYPE_USER)) {
                User tmpUser = this.mUserMgr.getUser(new UserID(newMemberValue));
                this.mMemberValues.add(tmpUser.getUsername());
                User[] tmpUserArray = new User[]{tmpUser};
                this.addUserToCurrentMembers(tmpUserArray);
            } else if (newMemberType.equals(TYPE_GROUP)) {
                GroupID grpID = new GroupID(newMemberValue);
                this.mMemberValues.add(this.mGroupMgr.getGroup(grpID).getName());
                User[] tmpUserArray = this.mGroupMgr.getGroupMembers(grpID);
                this.addUserToCurrentMembers(tmpUserArray);
            }
            this.generateCurrentMembers();
        }
        this.mNewMemberType = TYPE_USER;
        this.mNewMemberUserName = "";
        this.mNewMemberUserGroupID = "";
    }

    public void saveChangedMember(String newMemberType, String newMemberValue) throws RPCException, UserDBException {
        this.mMemberTypes.add(newMemberType);
        this.mMemberIDs.add(newMemberValue);
        if (newMemberType.equals(TYPE_USER)) {
            this.mMemberValues.add(this.mUserMgr.getUser(new UserID(newMemberValue)).getUsername());
        } else if (newMemberType.equals(TYPE_GROUP)) {
            this.mMemberValues.add(this.mGroupMgr.getGroup(new GroupID(newMemberValue)).getName());
        }
        this.mChangeMemberType = TYPE_USER;
        this.mChangeMemberUserID = "";
        this.mChangeMemberUserGroupID = "";
        this.loadMemberUsers();
    }

    public void persist() throws RPCException, UserDBException, RaplixException {
        this.mGroup.setName(this.mTmpName);
        this.mGroup.setDescription(this.mTmpDesc);
        this.persistUsersAndGroups();
        this.persistPermissions();
        this.mGroup.setUsers(this.mChildUsers);
        this.mGroup.setChildGroups(this.mChildGroups);
        this.mGroup.setPermissions(this.mPermissions);
        this.mGroup.save();
    }

    public void persistCopy() throws RPCException, UserDBException, RaplixException {
        Group tmpUserGroup = this.mGroupMgr.newGroup();
        tmpUserGroup.setName(this.mTmpName);
        tmpUserGroup.setDescription(this.getDescription());
        this.persistUsersAndGroups();
        tmpUserGroup.setUsers(this.mChildUsers);
        tmpUserGroup.setChildGroups(this.mChildGroups);
        this.persistUsersAndGroups();
        this.persistPermissions();
        tmpUserGroup.setPermissions(this.mPermissions);
        tmpUserGroup.save();
        this.mGroup = tmpUserGroup;
    }

    public void persistUsersAndGroups() throws UserDBException, RPCException {
        this.mChildUsers = new User[0];
        this.mChildGroups = new Group[0];
        Vector<User> childUsers = new Vector<User>();
        Vector<Group> childGroups = new Vector<Group>();
        int numMemberElements = this.mMemberTypes.size();
        String memType = "";
        String memID = "";
        for (int i = 0; i < numMemberElements; ++i) {
            memType = (String)this.mMemberTypes.get(i);
            memID = (String)this.mMemberIDs.get(i);
            if (memType.equals(TYPE_USER)) {
                childUsers.add(this.mUserMgr.getUser(new UserID(memID)));
                continue;
            }
            if (memType.equals(TYPE_GROUP)) {
                childGroups.add(this.mGroupMgr.getGroup(new GroupID(memID)));
                continue;
            }
            Logger.debug("Type other than Group or User found in mMemberType Vector", this);
        }
        this.mChildUsers = childUsers.toArray(new User[0]);
        this.mChildGroups = childGroups.toArray(new Group[0]);
    }

    public void persistPermissions() throws UserDBException, RPCException, RaplixException {
        int i;
        Vector<PermissionID> vPermissions = new Vector<PermissionID>();
        this.addPermissionsToVector(vPermissions, this.mBasicPermissionReads, this.mBasicPermissionReadIDs);
        this.addPermissionsToVector(vPermissions, this.mBasicPermissionWrites, this.mBasicPermissionWriteIDs);
        this.addPermissionsToVector(vPermissions, this.mRunnablePermissionReads, this.mRunnablePermissionReadIDs);
        this.addPermissionsToVector(vPermissions, this.mRunnablePermissionWrites, this.mRunnablePermissionWriteIDs);
        if (vPermissions.contains(this.mHostWritePermissionID)) {
            vPermissions.add(this.mPermMgr.getHostTypeWritePermissionID());
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("persistPermissions: added HostTypeWritePermission", this);
            }
        } else if (Logger.isDebugEnabled(this)) {
            Logger.debug("persistPermissions: didn't add HostTypeWritePermission", this);
        }
        if (vPermissions.contains(this.mHostReadPermissionID)) {
            vPermissions.add(this.mPermMgr.getHostTypeReadPermissionID());
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("persistPermissions: added HostTypeReadPermission", this);
            }
        } else if (Logger.isDebugEnabled(this)) {
            Logger.debug("persistPermissions: didn't add HostTypeReadPermission", this);
        }
        for (i = 0; i < this.mRunSelectedHostSets.length; ++i) {
            Permission[] tmpPerms;
            String tSelectedHostSet = this.mRunSelectedHostSets[i];
            if (tSelectedHostSet == null) continue;
            if (tSelectedHostSet.equals(UNIVERSAL_SET)) {
                vPermissions.add(this.mUniversalPermissionIDs[i]);
                if (!Logger.isDebugEnabled(this)) continue;
                Logger.debug("added universal permission privileges for run permission:" + i, this);
                continue;
            }
            String tPermName = "hostset:" + tSelectedHostSet;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("adding permission[" + i + "]:" + tPermName, this);
            }
            if ((tmpPerms = this.mPermMgr.getPermissionsByCriteria(tPermName, this.mRunPermissionClassNames[i], null)).length == 0) {
                Object[] errParams = new String[]{tPermName, this.mRunPermissionClassNames[i]};
                throw new RaplixException(ERRORKEY_PERMISSION_NOT_FOUND, errParams);
            }
            vPermissions.add(tmpPerms[0].getPermissionID());
        }
        this.mPermissions = new Permission[vPermissions.size()];
        for (i = 0; i < vPermissions.size(); ++i) {
            PermissionID pID = (PermissionID)vPermissions.elementAt(i);
            this.mPermissions[i] = this.mPermMgr.getPermission(pID);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("persistPermissions: number of permissions:" + this.mPermissions.length, this);
        }
    }

    private void addPermissionsToVector(Vector permissionsVector, boolean[] permissionsGranted, PermissionID[] ids) {
        for (int i = 0; i < permissionsGranted.length; ++i) {
            if (!permissionsGranted[i]) continue;
            permissionsVector.addElement(ids[i]);
            if (!Logger.isDebugEnabled(this)) continue;
            this.debugValue(ids[i].toString(), "permission[" + i + "]:" + ids[i]);
        }
    }

    public void setChangedMembers(String cMemberType, String cMUserVal, String cMGroupVal) {
        this.mChangeMemberType = cMemberType;
        this.mChangeMemberUserID = cMUserVal;
        this.mChangeMemberUserGroupID = cMGroupVal;
    }

    public void setBasicPermissionReads(boolean[] inBasicPermissionReads) {
        this.mBasicPermissionReads = inBasicPermissionReads;
    }

    public void setBasicPermissionWrites(boolean[] inBasicPermissionWrites) {
        this.mBasicPermissionWrites = inBasicPermissionWrites;
    }

    public void setRunnablePermissionReads(boolean[] inRunnablePermissionReads) {
        this.mRunnablePermissionReads = inRunnablePermissionReads;
    }

    public void setRunnablePermissionWrites(boolean[] inRunnablePermissionWrites) {
        this.mRunnablePermissionWrites = inRunnablePermissionWrites;
    }

    public void setRunnablePermissionRuns(boolean[] inRunnablePermissionRuns) {
        this.mRunnablePermissionRuns = inRunnablePermissionRuns;
    }

    public void setRunPermissionRuns(String[] inRunHostSetIDs) {
        this.mRunSelectedHostSets = inRunHostSetIDs;
    }

    public void setRunnablePermissionHostSetIDs(String[] inRunnablePermissionHostSetIDs) {
        this.mRunnablePermissionHostSetIDs = inRunnablePermissionHostSetIDs;
    }

    public void setRunnablePermissionHostSetNames(String[] inRunnablePermissionHostSetNames) {
        this.mRunnablePermissionHostSetNames = inRunnablePermissionHostSetNames;
    }

    public void setNewMembers(String cMemberType, String cMUserVal, String cMGroupVal) {
        this.mNewMemberType = cMemberType;
        this.mNewMemberUserName = cMUserVal;
        this.mNewMemberUserGroupID = cMGroupVal;
    }

    public void removeMember(int removeIdx) throws RaplixException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("About to remove " + this.mMemberTypes.elementAt(removeIdx) + " with name: " + this.mMemberValues.elementAt(removeIdx), this);
        }
        this.mMemberIDs.removeElementAt(removeIdx);
        this.mMemberTypes.removeElementAt(removeIdx);
        this.mMemberValues.removeElementAt(removeIdx);
        this.initializeCurrentMemberSet();
        for (int i = 0; i < this.mMemberIDs.size(); ++i) {
            User[] tmpUserArray;
            if (this.mMemberTypes.elementAt(i).equals(TYPE_USER)) {
                tmpUserArray = new User[]{this.mUserMgr.getUser(new UserID((String)this.mMemberIDs.elementAt(i)))};
                this.addUserToCurrentMembers(tmpUserArray);
                continue;
            }
            if (!this.mMemberTypes.elementAt(i).equals(TYPE_GROUP)) continue;
            tmpUserArray = this.mGroupMgr.getGroupMembers(new GroupID((String)this.mMemberIDs.elementAt(i)));
            this.addUserToCurrentMembers(tmpUserArray);
        }
        this.generateCurrentMembers();
    }

    public void loadPermissionsString() throws RaplixException {
        int i;
        int arrayLen = this.mRunnablePermissionHostSetIDs.length;
        String[] tmpRunPermissionsRunValues = new String[arrayLen];
        for (int i2 = 0; i2 < arrayLen; ++i2) {
            tmpRunPermissionsRunValues[i2] = this.getHostSetRunStringFromID(this.mRunSelectedHostSets[i2]);
        }
        int LEN_NAME = 25;
        int LEN_WRITE = 6;
        StringBuffer permissionsBuffer = new StringBuffer();
        for (i = 0; i < this.mRunnablePermissionNames.length; ++i) {
            this.padToBuffer(permissionsBuffer, this.mRunnablePermissionNames[i], LEN_NAME);
            if (this.mRunnablePermissionWrites[i]) {
                this.padToBuffer(permissionsBuffer, "write", LEN_WRITE);
            } else {
                this.padToBuffer(permissionsBuffer, "  -  ", LEN_WRITE);
            }
            permissionsBuffer.append(tmpRunPermissionsRunValues[i]);
            permissionsBuffer.append("\n");
        }
        for (i = 0; i < this.mBasicPermissionNames.length; ++i) {
            this.padToBuffer(permissionsBuffer, this.mBasicPermissionNames[i], LEN_NAME);
            if (this.mBasicPermissionWrites[i]) {
                this.padToBuffer(permissionsBuffer, "write", LEN_WRITE);
            } else {
                this.padToBuffer(permissionsBuffer, "  -  ", LEN_WRITE);
            }
            permissionsBuffer.append("\n");
        }
        this.mPermissionsString = permissionsBuffer.toString();
    }

    private void padToBuffer(StringBuffer inBuffer, String inString, int inPadLength) {
        if (inString == null) {
            inString = "";
        }
        if (inString.length() > inPadLength) {
            inBuffer.append(inString.substring(0, inPadLength));
        } else {
            inBuffer.append(inString);
            for (int i = 0; i < inPadLength - inString.length(); ++i) {
                inBuffer.append(" ");
            }
        }
    }

    public String getHostSetRunStringFromID(String inHostSetID) throws RaplixException {
        if (inHostSetID == null) {
            return "-";
        }
        if (inHostSetID.equals(UNIVERSAL_SET)) {
            return "run on universal set";
        }
        String hostSetName = HostSetsBean.getSummaryHostSetByID(inHostSetID).getName();
        return "run on " + hostSetName;
    }

    public void loadHighlightedMemberUsers(int inGroupIndex) throws RaplixException {
        Vector<String> tmpVector = new Vector<String>();
        String sGroupID = (String)this.mMemberIDs.elementAt(inGroupIndex);
        Group tmpGp = this.mGroupMgr.getGroup(new GroupID(sGroupID));
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("retrieved group:" + tmpGp.getName(), this);
        }
        if (tmpGp != null) {
            User[] memberUsers = this.mGroupMgr.getGroupMembers(tmpGp.getGroupID());
            for (int k = 0; k < memberUsers.length; ++k) {
                tmpVector.add(memberUsers[k].getUsername());
            }
        } else if (Logger.isDebugEnabled(this)) {
            Logger.debug("Didn't get back a UserGroup", this);
        }
        this.mCurrentlyHighlightedUsers = tmpVector.toArray(new String[0]);
    }

    public void debugObject(String inStage) {
        block4: {
            try {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Starting SystemUserGroupsBean dump for stage: " + inStage, this);
                }
                this.debugValue(this.getMode(), "getMode");
                this.debugArray(this.getUserNames(), "getUserNames");
                this.debugArray(this.getGroupDescriptions(), "getDescriptions");
                this.debugArray(this.getIDs(), "getIDs");
                this.debugArray(this.getGroupNames(), "getGroupNames");
                this.debugArray(this.getGroupIDs(), "getGroupIDs");
                this.debugArray(this.getMemberTypes(), "getMemberTypes");
                this.debugValue(this.getName(), "getName");
                this.debugValue(this.getDescription(), "getDescription");
                this.debugValue(this.getID(), "getID");
                this.debugArray(this.getMemberTypes(), "getMemberTypes");
                this.debugArray(this.getMemberValues(), "getMemberValues");
                this.debugArray(this.getCurrentUserNames(), "getCurrentUserNames");
                this.debugArray(this.getCurrentlyHighlightedUsers(), "getCurrentlyHighLightedUsers");
                this.debugValue("BOOLEAN " + this.getIsNew(), "getIsNew");
                this.debugValue("BOOLEAN " + this.getAcceptInput(), "getAcceptInput");
                this.debugValue(this.getChangeUserValue(), "getChangeUserValue");
                this.debugValue(this.getChangeGroupValue(), "getChangeGroupValue");
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Ending SystemUserGroupBean dump for stage: " + inStage, this);
                }
            }
            catch (Exception e) {
                if (!Logger.isDebugEnabled(this)) break block4;
                Logger.debug("Exception in debugObject(): " + e.toString(), this);
            }
        }
    }

    public void debugValue(String value, String label) {
        if (value != null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug(label + ": " + value, this);
            }
        } else if (Logger.isDebugEnabled(this)) {
            Logger.debug(label + " has null value", this);
        }
    }

    public void debugArray(String[] inArray, String inLabel) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Printing Array: " + inLabel, this);
        }
        if (inArray == null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("inLabel is a null array", this);
            }
            return;
        }
        for (int i = 0; i < inArray.length; ++i) {
            if (!Logger.isDebugEnabled(this)) continue;
            Logger.debug(inLabel + "[" + i + "]" + inArray[i], this);
        }
    }

    void clearHighlighted() {
        this.mCurrentlyHighlightedUsers = new String[0];
    }

    protected ObjectOrder getSortOrderByName(String sortName) {
        return (GroupOrder)super.getSortOrderByName(GroupOrder.FACTORY, sortName);
    }

    public ObjectOrder getDefaultSortOrder() {
        return DEFAULT_SORT_ORDER;
    }

    private void loadPermissionLookaheads() {
        this.mUserHasAdminWrite = PermissionChecker.hasWriteOnUsers();
    }

    public static String getGroupName(GroupID groupID) throws RaplixException {
        GroupIDSet idSet = new GroupIDSet();
        idSet.add(groupID);
        Group[] groups = idSet.getByIDsQuery().select();
        Group group = groups[0];
        return group.getName();
    }

    public static String[] getUserGroupIDs() throws RaplixException {
        Group[] groups = MultiGroupQuery.all().select();
        String[] groupIDs = new String[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            groupIDs[i] = groups[i].getGroupID().toString();
        }
        return groupIDs;
    }

    public static String[] getUserGroupNames() throws RaplixException {
        Group[] groups = MultiGroupQuery.all().select();
        String[] groupNames = new String[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            groupNames[i] = groups[i].getName();
        }
        return groupNames;
    }
}

