/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.ui.web.UITree;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.rolloutexpress.ui.web.Util;
import java.util.Vector;

public abstract class UITreeNode {
    protected Vector mChildren = new Vector();
    protected UITree mTree = null;
    protected boolean mVisible = true;
    protected UITreeNodeType mType = UITreeNodeType.BRANCH_CLOSED;
    private static String INDENT = "<img height=\"8\" width=\"18\" src=\"raplixPouch/spacer.gif\" border=\"0\">";
    private static String LEAF_ICON = "<img src=\"raplixPouch/leaf.gif\" border=\"0\">";
    private static String BRANCH_CLOSED_ICON = "<img src=\"raplixPouch/plus.gif\" border=\"0\">";
    private static String BRANCH_OPEN_ICON = "<img src=\"raplixPouch/minus.gif\" border=\"0\">";
    private static String BRANCH_EMPTY_ICON = "<img src=\"raplixPouch/empty.gif\" border=\"0\">";

    public UITreeNode(UITreeNodeType type) {
        this.mType = type;
    }

    public UITreeNode() {
    }

    public UITreeNodeType getType() {
        return this.mType;
    }

    public Vector getChildren() {
        return this.mChildren;
    }

    public void setVisible(boolean visible) {
        this.mVisible = visible;
    }

    public void setTree(UITree tree) {
        this.mTree = tree;
    }

    public void addChild(UITreeNode node) {
        this.mChildren.add(node);
        node.setTree(this.mTree);
    }

    public void removeChild(UITreeNode node) {
        this.mChildren.remove(node);
    }

    public int getVisibleChildCount() {
        int count = 0;
        if (this.mVisible) {
            count = 1;
        }
        if (this.mType.equals(UITreeNodeType.BRANCH_OPEN)) {
            for (int i = 0; i < this.mChildren.size(); ++i) {
                UITreeNode child = (UITreeNode)this.mChildren.elementAt(i);
                count += child.getVisibleChildCount();
            }
        }
        return count;
    }

    public String traverse(int depth, String path) {
        StringBuffer sb = new StringBuffer(this.render(depth, path));
        if (this.mType.equals(UITreeNodeType.BRANCH_OPEN)) {
            for (int i = 0; i < this.mChildren.size(); ++i) {
                UITreeNode child = (UITreeNode)this.mChildren.elementAt(i);
                sb.append(child.traverse(depth + 1, path + UITree.PATH_SEPARATOR_STRING + new Integer(i).toString()));
            }
        }
        return sb.toString();
    }

    protected String getIndent() {
        return INDENT;
    }

    protected String getLeafIcon() {
        return LEAF_ICON;
    }

    protected String getBranchClosedIcon() {
        return BRANCH_CLOSED_ICON;
    }

    protected String getBranchOpenIcon() {
        return BRANCH_OPEN_ICON;
    }

    protected String getBranchEmptyIcon() {
        return BRANCH_EMPTY_ICON;
    }

    public StringBuffer coreRender(int depth, String path) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append(this.getIndent());
        }
        if (this.mType == UITreeNodeType.LEAF) {
            sb.append(this.getLeafIcon());
        } else if (this.mType == UITreeNodeType.BRANCH_CLOSED) {
            sb.append(Util.standardLinkUntargeted("javascript:" + this.getJavascriptFunction() + "('" + this.mTree.getID() + "', '" + "open" + "', '" + path + "'); void(0);", "Expand", this.getBranchClosedIcon()));
        } else if (this.mType == UITreeNodeType.BRANCH_OPEN) {
            sb.append(Util.standardLinkUntargeted("javascript:" + this.getJavascriptFunction() + "('" + this.mTree.getID() + "', '" + "close" + "', '" + path + "'); void(0);", "Collapse", this.getBranchOpenIcon()));
        } else if (this.mType == UITreeNodeType.BRANCH_EMPTY) {
            sb.append(this.getBranchEmptyIcon());
        }
        return sb;
    }

    public String render(int depth, String path) {
        if (!this.mVisible) {
            return "";
        }
        StringBuffer sb = this.coreRender(depth, path);
        return this.finishRender(sb, path);
    }

    public abstract String finishRender(StringBuffer var1, String var2);

    public void open() {
        this.mType = UITreeNodeType.BRANCH_OPEN;
        this.finishOpen();
    }

    public abstract void finishOpen();

    public void close() {
        this.mType = UITreeNodeType.BRANCH_CLOSED;
        this.finishClose();
    }

    public abstract void finishClose();

    protected abstract String getJavascriptFunction();
}

