/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.UIActionException;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.util.string.CSVUtil;
import javax.servlet.http.HttpServletRequest;

public class UITree
extends ServletBean {
    public static char PATH_QUALIFIER = (char)34;
    public static String PATH_SEPARATOR_STRING = ".";
    public static char PATH_SEPARATOR = (char)46;
    public static String PATH_ROOT_STRING = "0";
    private static final String MSG_PATH_PARSE_FAILED = "ui.web.uitree.PATH_PARSE_FAILED";
    private static final String MSG_NO_SUCH_PATH = "ui.web.uitree.NO_SUCH_PATH";
    private UITreeNode mRoot = null;
    private UITreeNode mMarkedNode = null;

    public UITreeNode getMarkedNode() {
        return this.mMarkedNode;
    }

    public void setMarkedNode(UITreeNode markedNode) {
        this.mMarkedNode = markedNode;
    }

    public void setRoot(UITreeNode node) {
        this.mRoot = node;
        node.setTree(this);
    }

    public UITreeNode getRoot() {
        return this.mRoot;
    }

    public String traverse() {
        return this.traverse(0);
    }

    public String traverse(int depth) {
        if (this.mRoot == null) {
            return "";
        }
        return this.mRoot.traverse(depth, "0");
    }

    public String rootIcon() {
        if (this.mRoot == null) {
            return "";
        }
        return this.mRoot.coreRender(0, "0").toString();
    }

    public void handleRequest(HttpServletRequest request) throws UIActionException {
        String treeAction = request.getParameter("treeAction");
        String treePath = request.getParameter("treePath");
        if (treeAction.equals("open")) {
            this.open(treePath);
        } else if (treeAction.equals("close")) {
            this.close(treePath);
        }
    }

    public void open(String path) throws UIActionException {
        UITreeNode node = this.findNode(path);
        node.open();
    }

    public void close(String path) throws UIActionException {
        UITreeNode node = this.findNode(path);
        node.close();
    }

    public UITreeNode findNode(String path) throws UIActionException {
        String[] paths = CSVUtil.split(PATH_QUALIFIER, PATH_SEPARATOR, path);
        UITreeNode node = this.mRoot;
        for (int i = 1; i < paths.length; ++i) {
            int index = 0;
            try {
                index = Integer.parseInt(paths[i]);
            }
            catch (NumberFormatException nfe) {
                throw new UIActionException(MSG_PATH_PARSE_FAILED);
            }
            if (index < 0 || index >= node.getChildren().size()) {
                throw new UIActionException(MSG_NO_SUCH_PATH);
            }
            node = (UITreeNode)node.getChildren().elementAt(index);
        }
        return node;
    }

    public void fullExpandPath(String path) throws UIActionException {
        StringBuffer fullTreePath = new StringBuffer("");
        String[] treePaths = CSVUtil.split('\"', '.', path);
        for (int i = 0; i < treePaths.length; ++i) {
            fullTreePath.append(treePaths[i]);
            UITreeNode node = this.findNode(fullTreePath.toString());
            if (node.getType() != UITreeNodeType.BRANCH_OPEN) {
                this.open(fullTreePath.toString());
            }
            fullTreePath.append(".");
        }
    }
}

