/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.folderdb.CachedFolderTreeNode;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.string.CSVUtil;
import java.util.Hashtable;
import java.util.Vector;

public class UIFolderNode
extends UITreeNode {
    public static String FOLDER_JAVASCRIPT_FUNCTION = "sendFolderTree";
    private CachedFolderTreeNode mCachedFolder = null;
    private String mFolderID = "";
    private String mPath = "";
    private UIFolderNode mParent = null;

    public UIFolderNode(UITreeNodeType type, FolderID folderID) {
        super(type);
        this.mFolderID = folderID.toString();
        this.mPath = folderID.getFullPathString();
    }

    protected String getJavascriptFunction() {
        return FOLDER_JAVASCRIPT_FUNCTION;
    }

    public UIFolderNode getParent() {
        return this.mParent;
    }

    public void setParent(UIFolderNode parent) {
        this.mParent = parent;
    }

    private CachedFolderTreeNode getCachedFolder() {
        return this.mCachedFolder;
    }

    private void setCachedFolder(CachedFolderTreeNode cachedFolder) {
        this.mCachedFolder = cachedFolder;
    }

    public void remakeTree() {
        try {
            SummaryFolder folder = new FolderID(this.mFolderID).getByIDQuery().selectSummaryView();
            this.mCachedFolder = new CachedFolderTreeNode(folder);
            this.mCachedFolder.retrieveChildren();
        }
        catch (PersistenceManagerException e) {
        }
        catch (RaplixException raplixException) {
            // empty catch block
        }
        this.refresh(true);
    }

    public void refresh(boolean recurse) {
        this.finishOpen();
        if (recurse && this.mType == UITreeNodeType.BRANCH_OPEN) {
            for (int i = 0; i < this.mChildren.size(); ++i) {
                UIFolderNode child = (UIFolderNode)this.mChildren.elementAt(i);
                child.refresh(recurse);
            }
        }
    }

    public String finishRender(StringBuffer sb, String path) {
        String[] paths = CSVUtil.split('\"', '/', this.mPath);
        StringBuffer linkValue = new StringBuffer("");
        String nodeName = paths[paths.length - 2];
        if (nodeName.equals("")) {
            nodeName = "[top]";
        }
        if (this == this.mTree.getMarkedNode()) {
            nodeName = "<B>" + nodeName + "</B>";
        }
        linkValue.append("javascript:");
        linkValue.append(this.getJavascriptFunction() + "('" + this.mTree.getID() + "','" + "select" + "'" + ",'" + path + "');");
        linkValue.append("void(0);");
        sb.append(Util.standardLink(linkValue.toString(), "Select", "<img src=\"raplixPouch/dir.gif\" border=\"0\">" + Util.preserveSpace(nodeName)));
        sb.append("<BR>\n");
        return sb.toString();
    }

    public void finishOpen() {
        UIFolderNode oldNode;
        int i;
        Vector newChildren = this.createNewChildren();
        Hashtable<String, UIFolderNode> oldHash = new Hashtable<String, UIFolderNode>();
        for (i = 0; i < this.mChildren.size(); ++i) {
            oldNode = (UIFolderNode)this.mChildren.elementAt(i);
            oldHash.put(oldNode.toString(), oldNode);
        }
        for (i = 0; i < newChildren.size(); ++i) {
            UIFolderNode newNode = (UIFolderNode)newChildren.elementAt(i);
            oldNode = (UIFolderNode)oldHash.get(newNode.toString());
            if (oldNode == null) continue;
            oldNode.setCachedFolder(newNode.getCachedFolder());
            newChildren.setElementAt(oldNode, i);
        }
        this.mChildren = newChildren;
        if (this.mChildren.size() == 0) {
            this.mType = UITreeNodeType.BRANCH_EMPTY;
        } else if (this.mType == UITreeNodeType.BRANCH_EMPTY && this.mChildren.size() > 0) {
            this.mType = UITreeNodeType.BRANCH_CLOSED;
        }
    }

    private Vector createNewChildren() {
        Vector<UIFolderNode> newChildren = new Vector<UIFolderNode>();
        CachedFolderTreeNode[] children = this.mCachedFolder.getChildren();
        for (int i = 0; i < children.length; ++i) {
            UIFolderNode child = children[i].getChildren().length == 0 ? new UIFolderNode(UITreeNodeType.BRANCH_EMPTY, children[i].getFolder().getID()) : new UIFolderNode(UITreeNodeType.BRANCH_CLOSED, children[i].getFolder().getID());
            child.setCachedFolder(children[i]);
            child.setParent(this);
            child.setTree(this.mTree);
            newChildren.addElement(child);
        }
        return newChildren;
    }

    public void finishClose() {
        this.mChildren = new Vector();
    }

    public String toString() {
        return this.mPath;
    }
}

