/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.message.Severity;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.string.Replace;
import java.util.Comparator;

public class UIError {
    public static final String MINOR_ERROR_DELIMITER = "|";
    public static final Severity DEFAULT_SEVERITY = Severity.ERROR;
    private String mMessageHeader = "";
    private String mMessageBody = "";
    private Severity mSeverity = DEFAULT_SEVERITY;
    public static final Comparator SEVERITY_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            UIError uie1 = (UIError)o1;
            UIError uie2 = (UIError)o2;
            return uie2.getSeverity().compareTo(uie1.getSeverity());
        }
    };

    public UIError() {
        this.setMessageHeader("");
        this.setMessageBody("");
        this.setSeverity(DEFAULT_SEVERITY);
    }

    public UIError(String message, Severity severity) {
        String messageHeader = "";
        String messageBody = "";
        if (message == null) {
            messageHeader = "(message missing)";
        } else {
            int index = (message = Replace.replace(Util.escapeHTML(message), '\n', "<br>")).indexOf(MINOR_ERROR_DELIMITER);
            if (index != -1) {
                messageHeader = message.substring(0, index);
                messageBody = message.substring(index + 1);
            } else {
                messageHeader = message;
            }
        }
        this.setMessageHeader(messageHeader);
        this.setMessageBody(messageBody);
        this.setSeverity(severity);
    }

    public String getMessageHeader() {
        return this.mMessageHeader;
    }

    public String getMessageBody() {
        return this.mMessageBody;
    }

    public Severity getSeverity() {
        return this.mSeverity;
    }

    private void setMessageHeader(String inMessageHeader) {
        this.mMessageHeader = inMessageHeader;
    }

    private void setMessageBody(String inMessageBody) {
        this.mMessageBody = inMessageBody;
    }

    private void setSeverity(Severity inSeverity) {
        if (inSeverity != null) {
            this.mSeverity = inSeverity;
        }
    }
}

