/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.ui.web.LoggedOnServlet;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletSessionBroker;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.security.AccessControlException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class UIActionServlet
extends LoggedOnServlet {
    protected static final String MSG_RAPLIX_EXCEPTION = "ui.web.RAPLIX_EXCEPTION";
    private static final String MSG_ACCESS_CONTROL_EXCEPTION = "ui.web.ACCESS_CONTROL_EXCEPTION";

    public void executeServlet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletInfo servletInfo = new ServletInfo(this.createBean(request), this.getDefaultPage());
        try {
            ServletBean bean = servletInfo.getBean();
            bean.setAcceptInput(true);
            this.doUIAction(request, servletInfo);
        }
        catch (RaplixException re) {
            this.handleException(request, servletInfo, re.getMessage());
            Logger.error(ROXMessageManager.messageAsString(MSG_RAPLIX_EXCEPTION) + re.getMessage(), re, this);
        }
        catch (AccessControlException ace) {
            this.handleException(request, servletInfo, this.ACExToString(ace));
            Logger.error(ROXMessageManager.messageAsString(MSG_ACCESS_CONTROL_EXCEPTION) + this.ACExToString(ace), ace, this);
        }
        this.displayPage(request, response, servletInfo);
    }

    protected void handleException(HttpServletRequest request, ServletInfo servletInfo, String localizedMessage) {
        ServletErrors errors = servletInfo.getErrors();
        ServletBean bean = servletInfo.getBean();
        bean.setAcceptInput(false);
        errors.setMajorErrorKey(this.getMajorError(request));
        errors.addMinorError(localizedMessage);
    }

    public abstract void doUIAction(HttpServletRequest var1, ServletInfo var2) throws RaplixException;

    public abstract ServletBean createBean(HttpServletRequest var1);

    public abstract String getDefaultPage();

    public abstract String getMajorError(HttpServletRequest var1);

    protected void displayPage(HttpServletRequest request, HttpServletResponse response, ServletInfo servletInfo) throws IOException {
        ServletBean bean = servletInfo.getBean();
        String id = bean.getID();
        if (servletInfo.getSaveInSession()) {
            HttpSession session = request.getSession();
            ServletSessionBroker ssb = ServletSessionBroker.getBroker(session);
            ssb.put(id, bean);
        } else {
            request.setAttribute(id, (Object)bean);
        }
        request.setAttribute("request.beanid", (Object)id);
        String destPage = servletInfo.getDestPage();
        request.setAttribute("error.location", (Object)servletInfo.getErrors());
        if (servletInfo.getShouldRedirect()) {
            response.sendRedirect(destPage);
        } else {
            this.forwardRequest(request, response, destPage);
        }
    }
}

