/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.systemmodel.catdb.Category;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.ui.web.Preference;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.ServletPreferenceBroker;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public abstract class UIActionListServlet
extends UIActionServlet {
    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        ServletListBean slb = (ServletListBean)servletInfo.getBean();
        this.loadListParameters(request, slb);
        slb.generateList();
        servletInfo.setDestPage(this.getDefaultPage());
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    protected void loadListParameters(HttpServletRequest request, ServletListBean slb) {
        int page = 1;
        if (request.getParameter("currentPage") != null) {
            try {
                page = Integer.parseInt(request.getParameter("currentPage"));
            }
            catch (NumberFormatException nfe) {
                page = 1;
            }
            if (page < 1) {
                page = 1;
            }
        }
        slb.setCurrentPage(page);
        String sortName = "";
        if (request.getParameter("sortName") != null) {
            sortName = request.getParameter("sortName");
        } else {
            try {
                sortName = slb.getDefaultSortOrder().getName();
            }
            catch (NullPointerException e) {
                sortName = "";
            }
        }
        slb.setSortName(sortName);
        this.setAllFilters(request, slb);
    }

    protected void setAllFilters(HttpServletRequest request, ServletListBean bean) {
        String isFindFiltered = request.getParameter("isFindFiltered");
        if (isFindFiltered != null) {
            bean.setIsFindFiltered(isFindFiltered);
            if (isFindFiltered.equals("true")) {
                this.setDefaultFindFilters(request, bean);
                this.setAdditionalFindFilters(request, bean);
            }
        }
        this.setDefaultFilters(request, bean);
        this.setAdditionalFilters(request, bean);
    }

    protected void setDefaultFilters(HttpServletRequest request, ServletListBean bean) {
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String catID = spb.trackString(Preference.CATEGORY, request);
        CategoryID filterID = new CategoryID(catID);
        if (!catID.equals(Category.NO_CATEGORY_ID.toString()) && !catID.equals(Category.ANY_CATEGORY_ID.toString())) {
            try {
                filterID.getByIDQuery().select();
            }
            catch (RaplixException re) {
                filterID = ServletListBean.DEFAULT_CATEGORY_FILTER;
                spb.setString(Preference.CATEGORY, filterID.toString());
            }
        }
        bean.setCategoryFilter(filterID);
        boolean showHidden = spb.trackBoolean(Preference.SHOW_HIDDEN_GLOBAL, request);
        bean.setShowHidden(showHidden);
    }

    protected void setDefaultFindFilters(HttpServletRequest request, ServletListBean bean) {
        String findName = request.getParameter("name");
        String findDescription = request.getParameter("description");
        if (findName != null) {
            bean.setFindName(findName);
        }
        if (findDescription != null) {
            bean.setFindDescription(findDescription);
        }
    }

    protected void handleException(HttpServletRequest request, ServletInfo servletInfo, String localizedMessage) {
        ServletErrors errors = servletInfo.getErrors();
        ServletListBean slb = (ServletListBean)servletInfo.getBean();
        try {
            this.loadListParameters(request, slb);
            slb.generateList();
        }
        catch (RaplixException re) {
            Logger.error(ROXMessageManager.messageAsString("ui.web.RAPLIX_EXCEPTION") + re.getMessage(), re, this);
        }
        slb.setAcceptInput(false);
        errors.setMajorErrorKey(this.getMajorError(request));
        errors.addMinorError(localizedMessage);
    }

    protected void setAdditionalFindFilters(HttpServletRequest request, ServletListBean bean) {
    }

    protected void setAdditionalFilters(HttpServletRequest request, ServletListBean bean) {
    }
}

