/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.ui.web.StringConstants;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.SafeThread;
import java.io.File;
import java.io.IOException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Catalina;

public class TomcatThread
extends SafeThread
implements StringConstants {
    protected String mTomcatHome;
    protected Exception mCaughtException;
    protected Catalina mServer;
    protected static final String SERVER_CONFIG_DIR = File.separator + "conf" + File.separator + "server.xml";
    protected static final String THREAD_NAME = "ROXTomcatThread";
    protected static final String VAR_TOMCAT_CONFIG = "-config";
    protected static final String VAR_TOMCAT_STOP = "-stop";
    protected static final String START_ARGUMENT = "start";

    public TomcatThread(String inTomcatHome) {
        super(THREAD_NAME);
        this.mTomcatHome = inTomcatHome;
    }

    public void run() {
        try {
            File homeFile = new File(this.mTomcatHome);
            this.mTomcatHome = homeFile.getCanonicalPath();
        }
        catch (IOException ex) {
            Logger.error("Error while running Tomcat" + ex, this);
            System.out.println("Error while running Tomcat" + ex);
            ex.printStackTrace();
        }
        try {
            System.setProperty("catalina.home", this.mTomcatHome);
            System.setProperty("catalina.base", this.mTomcatHome);
            String[] args = new String[]{VAR_TOMCAT_CONFIG, this.mTomcatHome + SERVER_CONFIG_DIR, START_ARGUMENT};
            this.mServer = new Catalina();
            this.mServer.setParentClassLoader(this.getClass().getClassLoader());
            this.mServer.process(args);
        }
        catch (RuntimeException ex) {
            Logger.error("Error while running Tomcat" + ex, this);
            System.out.println("Error while running Tomcat" + ex);
            ex.printStackTrace();
        }
    }

    public void stopTomcat() throws LifecycleException {
        String[] args = new String[]{VAR_TOMCAT_CONFIG, this.mTomcatHome + SERVER_CONFIG_DIR, VAR_TOMCAT_STOP};
        this.mServer.process(args);
    }
}

