/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.ROXStepFailedEvent;
import com.raplix.rolloutexpress.event.ROXTaskFailedEvent;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.TaskStatusBean;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.data.TaskStatusInfo;
import java.util.Vector;

public class TaskInfoBean
extends ServletListBean {
    protected static final String MSG_TASK_ERROR = "error.plans.errors_encountered";
    private static final String MSG_RUNTYPE_ACTUAL = "planRunHistory.runType.plan";
    private static final String MSG_RUNTYPE_PREFLIGHT = "planRunHistory.runType.preflight";
    protected String mPlanID = "";
    protected String mPlanName = "";
    protected String mPlanDescription = "";
    protected String mPlanVersion = "";
    protected String mPlanCheckedInDate = "";
    protected String mPlanCheckedInUserName = "";
    protected String mTaskID = "";
    protected boolean mIsPreflightOnly = false;
    protected boolean mIsDeploymentEnabled = false;
    protected String mDetailedStatus = "";
    protected boolean mIsHistory = false;
    protected boolean mIsPreflightComplete = false;
    protected boolean mCancelling = false;
    protected boolean mIsUserTaskOwner = true;
    private boolean mIsDeleteHistoryEnabled = false;
    protected final PlanInterface mPlanInterface;
    protected final UserManager mUserDBInterface;

    public TaskInfoBean(PlanInterface planInterface, UserManager userMgr) {
        this.mPlanInterface = planInterface;
        this.mUserDBInterface = userMgr;
    }

    public String getID() {
        if (this.mTaskID != null && !this.mTaskID.equals("")) {
            return this.mTaskID;
        }
        return super.getID();
    }

    public String getPlanID() {
        return this.mPlanID;
    }

    public String getPlanName() {
        return this.mPlanName;
    }

    public String getPlanDescription() {
        return this.mPlanDescription;
    }

    public String getPlanVersion() {
        return this.mPlanVersion;
    }

    public String getPlanCheckedInDate() {
        return this.mPlanCheckedInDate;
    }

    public String getPlanCheckedInUserName() {
        return this.mPlanCheckedInUserName;
    }

    public String getTaskID() {
        return this.mTaskID;
    }

    public boolean getIsPreflightOnly() {
        return this.mIsPreflightOnly;
    }

    public boolean getIsDeploymentEnabled() {
        return this.mIsDeploymentEnabled;
    }

    public boolean getIsHistory() {
        return this.mIsHistory;
    }

    public boolean getIsPreflightComplete() {
        return this.mIsPreflightComplete;
    }

    public String getDetailedStatus() {
        return this.mDetailedStatus;
    }

    public boolean getCancelling() {
        return this.mCancelling;
    }

    public boolean getIsUserTaskOwner() {
        return this.mIsUserTaskOwner;
    }

    public boolean isDeleteHistoryEnabled() {
        return this.mIsDeleteHistoryEnabled;
    }

    public void setTaskID(String taskID) {
        this.mTaskID = taskID;
    }

    public void setCancelling(boolean cancelling) {
        this.mCancelling = cancelling;
    }

    public void loadTaskInfo(String taskID, ServletErrors errors, String phase) throws RaplixException {
        this.mTaskID = taskID;
        TaskInfo info = this.mPlanInterface.getTaskInfoForTaskID(new TaskID(this.mTaskID));
        ExecutionPlan plan = info.getCompiledPlan().getTopLevelPlan();
        this.mPlanID = plan.getID().toString();
        this.mPlanName = plan.getFullName();
        this.mPlanDescription = plan.getDescription();
        this.mPlanVersion = plan.getVersionNumber().getAsString();
        this.mPlanCheckedInDate = Util.formatDate(plan.getTimeStamp());
        this.mPlanCheckedInUserName = this.mUserDBInterface.getUser(plan.getUserID()).getUsername();
        this.mIsPreflightOnly = TaskExecutor.isPreflightRunLevel(info.getRunLevel());
        this.mIsUserTaskOwner = PermissionChecker.hasTaskOwnerPermission(info);
        FolderID folderID = plan.getPath();
        this.mIsDeleteHistoryEnabled = PermissionChecker.hasDeleteHistoryOnFolder(folderID);
        TaskStatusBean tsb = this.mPlanInterface.taskStatusQuery(new TaskID(this.mTaskID));
        TaskStatusInfo tsi = new TaskStatusInfo(tsb);
        if (this.mIsPreflightOnly) {
            tsi.setRunType(ApplicationResources.getMessage(MSG_RUNTYPE_PREFLIGHT));
        } else {
            tsi.setRunType(ApplicationResources.getMessage(MSG_RUNTYPE_ACTUAL));
        }
        tsi.setRunningUser(this.mUserDBInterface.getUser(info.getRoxUser()).getUsername());
        tsi.setCancelling(this.mCancelling);
        this.mIsDeploymentEnabled = tsi.getIsDeploymentEnabled();
        this.mDetailedStatus = tsi.getDetailedStatus(info);
        if (tsi.getCancelMessage() != null) {
            errors.setMajorError(tsi.getCancelMessage());
        }
        this.addFailureMessages(tsb, errors, phase);
        this.mIsHistory = tsi.isCompletedOK() || tsi.isFailed();
        this.mIsPreflightComplete = tsi.getIsPreflightComplete();
    }

    private void addFailureMessages(TaskStatusBean tsb, ServletErrors errors, String phase) throws RaplixException {
        int i;
        if (phase.equals("")) {
            return;
        }
        Vector warnings = new Vector();
        Vector failures = new Vector();
        boolean isDeployment = phase.equals("runlive") || phase.equals("runresults");
        tsb.getErrorsAndWarnings(isDeployment ? RunLevel.ACTUAL : RunLevel.PREFLIGHT, warnings, failures);
        if (failures.size() > 0 || warnings.size() > 0) {
            errors.setMajorErrorKey(MSG_TASK_ERROR);
        }
        for (i = 0; i < failures.size(); ++i) {
            this.processEvent(failures.get(i), errors);
        }
        for (i = 0; i < warnings.size(); ++i) {
            this.processEvent(warnings.get(i), errors);
        }
    }

    private void processEvent(Object event, ServletErrors errors) {
        if (event instanceof ROXTaskFailedEvent) {
            ROXTaskFailedEvent rtfe = (ROXTaskFailedEvent)event;
            errors.addMinorError(rtfe.getExceptionDescription());
        } else if (event instanceof ROXStepFailedEvent) {
            ROXStepFailedEvent rtse = (ROXStepFailedEvent)event;
            errors.addMinorError(rtse.getExceptionDescription());
        }
    }

    protected void generateList() throws RaplixException {
    }
}

